/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.doacaodeclaracao;

import java.util.ArrayList;
import java.util.List;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.ValidadorNaoNuloIRPF;
import serpro.ppgd.irpf.ValorPositivo;
import serpro.ppgd.irpf.doacaodeclaracao.ColecaoEstatutoIdoso;
import serpro.ppgd.irpf.gui.doacaodiretamentedeclaracao.PainelDadosDDD;
import serpro.ppgd.irpf.tabelas.CadastroTabelasIRPF;
import serpro.ppgd.irpf.tabelas.TabelaAliquotasIRPF;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.CNPJ;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorDefault;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.Valor;

public class EstatutoIdoso
extends ObjetoNegocio
implements ObjetoFicha {
    public static final String TIPO_FUNDO_NACIONAL = "N";
    public static final String TIPO_FUNDO_ESTADUAL_DISTRITAL = "E";
    public static final String TIPO_FUNDO_MUNICIPAL = "M";
    public static final String TIPO_FUNDO_VAZIO = "V";
    public static final String NOME_FICHA = "Doa\u00e7\u00f5es Diretamente na Declara\u00e7\u00e3o - Pessoa Idosa";
    private static final String PROP_CNPJ_FUNDO = "CNPJ do Fundo";
    private Alfa tipoFundo = new Alfa((ObjetoNegocio)this, "Tipo do Fundo", 1);
    private Codigo uf = new Codigo((ObjetoNegocio)this, "UF", new ArrayList());
    private Codigo municipio = new Codigo((ObjetoNegocio)this, "Munic\u00edpio", new ArrayList());
    private Alfa nomeMunicipio = new Alfa((ObjetoNegocio)this, "Nome do Munic\u00edpio");
    private Valor valor = new ValorPositivo(this, "Valor");
    private CNPJ cnpjFundo = new CNPJ((ObjetoNegocio)this, "CNPJ do Fundo");
    private Alfa dvNumeroReferencia = new Alfa((ObjetoNegocio)this, "DV do N\u00famero de Refer\u00eancia");

    public EstatutoIdoso(ColecaoEstatutoIdoso colecao) {
        this.setFicha(NOME_FICHA);
        this.adicionarValidadores(colecao);
        this.adicionarObservadores();
    }

    private void adicionarValidadores(final ColecaoEstatutoIdoso colecao) {
        this.tipoFundo.addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3){

            @Override
            public RetornoValidacao validarImplementado() {
                this.setMensagemValidacao(MensagemUtil.getMensagem("msg_validador_nao_nulo", new String[]{this.getInformacao().getNomeCampo()}));
                if (this.getInformacao().isVazio() || this.getInformacao().naoFormatado().equals(EstatutoIdoso.TIPO_FUNDO_VAZIO)) {
                    return new RetornoValidacao(this.getMensagemValidacao(), this.getSeveridade());
                }
                return null;
            }
        });
        this.uf.setColunaFiltro(1);
        this.uf.addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3){

            @Override
            public RetornoValidacao validarImplementado() {
                if (EstatutoIdoso.this.tipoFundo.naoFormatado().equals(EstatutoIdoso.TIPO_FUNDO_ESTADUAL_DISTRITAL) || EstatutoIdoso.this.tipoFundo.naoFormatado().equals(EstatutoIdoso.TIPO_FUNDO_MUNICIPAL)) {
                    return super.validarImplementado();
                }
                return null;
            }
        });
        this.municipio.addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3){

            @Override
            public RetornoValidacao validarImplementado() {
                if (EstatutoIdoso.this.tipoFundo.naoFormatado().equals(EstatutoIdoso.TIPO_FUNDO_MUNICIPAL)) {
                    if (EstatutoIdoso.this.municipio.getIndiceElementoTabela() == -1) {
                        EstatutoIdoso.this.municipio.clear();
                    }
                    return super.validarImplementado();
                }
                return null;
            }
        });
        this.valor.addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3));
        this.valor.addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                this.setMensagemValidacao(MensagemUtil.getMensagem("doacoes_diretamente_dec_limite_minimo", new String[]{TabelaAliquotasIRPF.ConstantesAliquotas.valorMinIAP.getValor().formatado()}));
                if (EstatutoIdoso.this.valor.comparacao("<", TabelaAliquotasIRPF.ConstantesAliquotas.valorMinIAP.getValor())) {
                    return new RetornoValidacao(this.getMensagemValidacao(), this.getSeveridade());
                }
                return null;
            }
        });
        this.municipio.addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                this.setMensagemValidacao(MensagemUtil.getMensagem("doacoes_diretamente_dec_mais_de_uma_doacao_mesmo_fundo"));
                if (EstatutoIdoso.this.tipoFundo.naoFormatado().equals(EstatutoIdoso.TIPO_FUNDO_MUNICIPAL)) {
                    for (ObjetoNegocio objetoNegocio : colecao.itens()) {
                        if (EstatutoIdoso.this == objetoNegocio || !((EstatutoIdoso)objetoNegocio).getTipoFundo().naoFormatado().equals(EstatutoIdoso.TIPO_FUNDO_MUNICIPAL) || !EstatutoIdoso.this.municipio.naoFormatado().equals(((EstatutoIdoso)objetoNegocio).getMunicipio().naoFormatado())) continue;
                        return new RetornoValidacao(this.getMensagemValidacao(), this.getSeveridade());
                    }
                }
                return null;
            }
        });
        this.uf.addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                this.setMensagemValidacao(MensagemUtil.getMensagem("doacoes_diretamente_dec_mais_de_uma_doacao_mesmo_fundo"));
                if (EstatutoIdoso.this.tipoFundo.naoFormatado().equals(EstatutoIdoso.TIPO_FUNDO_ESTADUAL_DISTRITAL)) {
                    for (ObjetoNegocio objetoNegocio : colecao.itens()) {
                        if (EstatutoIdoso.this == objetoNegocio || !((EstatutoIdoso)objetoNegocio).getTipoFundo().naoFormatado().equals(EstatutoIdoso.TIPO_FUNDO_ESTADUAL_DISTRITAL) || !EstatutoIdoso.this.uf.naoFormatado().equals(((EstatutoIdoso)objetoNegocio).getUf().naoFormatado())) continue;
                        return new RetornoValidacao(this.getMensagemValidacao(), this.getSeveridade());
                    }
                }
                return null;
            }
        });
        this.tipoFundo.addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                this.setMensagemValidacao(MensagemUtil.getMensagem("doacoes_diretamente_dec_mais_de_uma_doacao_mesmo_fundo"));
                if (EstatutoIdoso.this.tipoFundo.naoFormatado().equals(EstatutoIdoso.TIPO_FUNDO_NACIONAL)) {
                    for (ObjetoNegocio objetoNegocio : colecao.itens()) {
                        if (EstatutoIdoso.this == objetoNegocio || !EstatutoIdoso.this.cnpjFundo.naoFormatado().equals(((EstatutoIdoso)objetoNegocio).getCnpjFundo().naoFormatado()) || !((EstatutoIdoso)objetoNegocio).getTipoFundo().naoFormatado().equals(EstatutoIdoso.TIPO_FUNDO_NACIONAL)) continue;
                        return new RetornoValidacao(this.getMensagemValidacao(), this.getSeveridade());
                    }
                }
                return null;
            }
        });
    }

    private void adicionarObservadores() {
        this.tipoFundo.addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                if (valorNovo.toString().equals(EstatutoIdoso.TIPO_FUNDO_VAZIO)) {
                    EstatutoIdoso.this.municipio.clear();
                    EstatutoIdoso.this.uf.clear();
                    EstatutoIdoso.this.municipio.setReadOnly(true);
                    EstatutoIdoso.this.uf.setReadOnly(true);
                    EstatutoIdoso.this.cnpjFundo.clear();
                } else if (valorNovo.toString().equals(EstatutoIdoso.TIPO_FUNDO_NACIONAL)) {
                    EstatutoIdoso.this.municipio.clear();
                    EstatutoIdoso.this.uf.clear();
                    EstatutoIdoso.this.municipio.setReadOnly(true);
                    EstatutoIdoso.this.uf.setReadOnly(true);
                    EstatutoIdoso.this.cnpjFundo.setConteudo(CadastroTabelasIRPF.getCnpjEstatutoIdosoNacional());
                } else if (valorNovo.toString().equals(EstatutoIdoso.TIPO_FUNDO_ESTADUAL_DISTRITAL)) {
                    EstatutoIdoso.this.municipio.clear();
                    EstatutoIdoso.this.municipio.setReadOnly(true);
                    EstatutoIdoso.this.uf.clear();
                    EstatutoIdoso.this.uf.setReadOnly(false);
                    EstatutoIdoso.this.cnpjFundo.clear();
                } else if (valorNovo.toString().equals(EstatutoIdoso.TIPO_FUNDO_MUNICIPAL)) {
                    EstatutoIdoso.this.uf.clear();
                    EstatutoIdoso.this.uf.setReadOnly(false);
                    EstatutoIdoso.this.municipio.setReadOnly(false);
                    EstatutoIdoso.this.cnpjFundo.clear();
                }
            }
        });
        this.tipoFundo.addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                if (EstatutoIdoso.this.tipoFundo.isVazio() || EstatutoIdoso.this.tipoFundo.naoFormatado().equals(EstatutoIdoso.TIPO_FUNDO_NACIONAL)) {
                    EstatutoIdoso.this.uf.setColecaoElementoTabela(new ArrayList());
                } else if (EstatutoIdoso.this.tipoFundo.naoFormatado().equals(EstatutoIdoso.TIPO_FUNDO_ESTADUAL_DISTRITAL)) {
                    EstatutoIdoso.this.uf.setColecaoElementoTabela(CadastroTabelasIRPF.recuperarUFsIdosoEstadual());
                } else {
                    EstatutoIdoso.this.uf.setColecaoElementoTabela(CadastroTabelasIRPF.recuperarUFsIdoso());
                }
            }
        });
        this.uf.addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                if (EstatutoIdoso.this.uf.isVazio()) {
                    EstatutoIdoso.this.municipio.setColecaoElementoTabela(new ArrayList());
                } else {
                    String strUf = EstatutoIdoso.this.uf.getConteudoAtual(0);
                    EstatutoIdoso.this.municipio.setColecaoElementoTabela(CadastroTabelasIRPF.recuperarMunicipiosIdoso(strUf));
                }
            }
        });
        this.uf.addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                if (EstatutoIdoso.this.tipoFundo.naoFormatado().equals(EstatutoIdoso.TIPO_FUNDO_ESTADUAL_DISTRITAL)) {
                    EstatutoIdoso.this.cnpjFundo.setConteudo(EstatutoIdoso.this.uf.getConteudoAtual(2));
                }
            }
        });
        this.municipio.addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                if (EstatutoIdoso.this.tipoFundo.naoFormatado().equals(EstatutoIdoso.TIPO_FUNDO_MUNICIPAL)) {
                    EstatutoIdoso.this.cnpjFundo.setConteudo(EstatutoIdoso.this.municipio.getConteudoAtual(0));
                    EstatutoIdoso.this.nomeMunicipio.setConteudo(EstatutoIdoso.this.municipio.getConteudoAtual(3));
                } else {
                    EstatutoIdoso.this.nomeMunicipio.clear();
                }
            }
        });
        this.cnpjFundo.addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                if (nomePropriedade.equals(EstatutoIdoso.PROP_CNPJ_FUNDO)) {
                    if (valorNovo != null && !valorNovo.toString().trim().isEmpty() && valorNovo.toString().trim().length() == 14) {
                        EstatutoIdoso.this.dvNumeroReferencia.setConteudo(EstatutoIdoso.this.calcularDvNumeroReferencia(valorNovo.toString()));
                    } else {
                        EstatutoIdoso.this.dvNumeroReferencia.clear();
                    }
                }
            }
        });
    }

    private String calcularDvNumeroReferencia(String cnpj) {
        String cnpjAoContrario = new StringBuilder(cnpj).reverse().toString();
        String dv1 = null;
        String dv2 = null;
        int soma = 0;
        int peso = 2;
        for (int i = 0; i < cnpjAoContrario.length(); ++i) {
            soma += peso * Integer.parseInt(Character.toString(cnpjAoContrario.charAt(i)));
            ++peso;
        }
        int resto = soma % 11;
        dv1 = resto == 0 ? "1" : (resto == 1 ? "0" : String.valueOf(11 - resto));
        String base = dv1 + cnpjAoContrario;
        soma = 0;
        peso = 2;
        for (int i = 0; i < base.length(); ++i) {
            soma += peso * Integer.parseInt(Character.toString(base.charAt(i)));
            ++peso;
        }
        resto = soma % 11;
        dv2 = resto == 0 ? "1" : (resto == 1 ? "0" : String.valueOf(11 - resto));
        return dv1 + dv2;
    }

    protected List<Informacao> recuperarListaCamposPendencia() {
        List campos = super.recuperarListaCamposPendencia();
        campos.add(this.tipoFundo);
        campos.add(this.uf);
        campos.add(this.municipio);
        campos.add(this.valor);
        campos.add(this.cnpjFundo);
        return campos;
    }

    public boolean isVazio() {
        return (this.tipoFundo.isVazio() || this.tipoFundo.naoFormatado().equals(TIPO_FUNDO_VAZIO)) && this.uf.isVazio() && this.municipio.isVazio() && this.valor.isVazio();
    }

    public Alfa getTipoFundo() {
        return this.tipoFundo;
    }

    public Codigo getUf() {
        return this.uf;
    }

    public Codigo getMunicipio() {
        return this.municipio;
    }

    public Valor getValor() {
        return this.valor;
    }

    public CNPJ getCnpjFundo() {
        return this.cnpjFundo;
    }

    public Alfa getNomeMunicipio() {
        return this.nomeMunicipio;
    }

    public Alfa getDvNumeroReferencia() {
        return this.dvNumeroReferencia;
    }

    public String getClasseFicha() {
        return PainelDadosDDD.class.getName();
    }

    public String getNomeAba() {
        return "Pessoa Idosa";
    }

    public String getTituloFichaDashboard() {
        return "Doa\u00e7\u00f5es Diretamente na Declara\u00e7\u00e3o";
    }

    public EstatutoIdoso obterCopia() {
        EstatutoIdoso copia = new EstatutoIdoso(IRPFFacade.getInstancia().getDeclaracao().getColecaoEstatutoIdoso());
        copia.getTipoFundo().setConteudo(this.getTipoFundo());
        copia.getUf().setConteudo(this.getUf());
        copia.getMunicipio().setConteudo(this.getMunicipio());
        copia.getNomeMunicipio().setConteudo(this.getNomeMunicipio());
        copia.getValor().setConteudo(this.getValor());
        copia.getCnpjFundo().setConteudo(this.getCnpjFundo());
        copia.getDvNumeroReferencia().setConteudo(this.getDvNumeroReferencia());
        return copia;
    }
}

