/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.doacoes;

import java.util.List;
import serpro.ppgd.cacheni.CacheNI;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.ValidadorNaoNuloIRPF;
import serpro.ppgd.irpf.ValorPositivo;
import serpro.ppgd.irpf.gui.doacoes.PainelDoacoesLista;
import serpro.ppgd.irpf.tabelas.CadastroTabelasIRPF;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.irpf.util.ObjetoComChaveIRPF;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.NI;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorDefault;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.Valor;
import serpro.ppgd.negocio.util.UtilitariosString;
import serpro.ppgd.negocio.util.Validador;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorCodigo;

public class Doacao
extends ObjetoNegocio
implements ObjetoComChaveIRPF,
ObjetoFicha {
    public static final String DOACAO_ESTATCRIANCA = "40";
    public static final String DOACAO_CULTURA = "41";
    public static final String DOACAO_AUDIOVISUAIS = "42";
    public static final String DOACAO_DESPORTO = "43";
    public static final String DOACAO_ESTATIDOSO = "44";
    public static final String DOACAO_PRONAS = "45";
    public static final String DOACAO_PRONON = "46";
    public static final String DOACAO_RECICLAGEM = "47";
    public static final String DOACAO_ESPECIE = "80";
    public static final String DOACAO_BENS = "81";
    public static final String DOACAO_OUTROS = "99";
    public static final String NOME_CODIGO = "C\u00f3digo";
    private Codigo codigo = new Codigo((ObjetoNegocio)this, "C\u00f3digo", CadastroTabelasIRPF.recuperarTipoDoacoes());
    private Alfa nomeBeneficiario = new Alfa((ObjetoNegocio)this, "Nome do Benefici\u00e1rio", 60);
    private NI niBeneficiario = new NI((ObjetoNegocio)this, "CPF/CNPJ do Beneficiario");
    private ValorPositivo valorPago = new ValorPositivo(this, "Valor Pago");
    private ValorPositivo parcelaNaoDedutivel = new ValorPositivo(this, "Parcela N\u00e3o Dedut\u00edvel/Valor Reembolsado");
    private Alfa indice = new Alfa((ObjetoNegocio)this, "\u00cdndice");
    protected transient IdentificadorDeclaracao identificadorDeclaracao = null;

    public Doacao(final DeclaracaoIRPF dec) {
        this.identificadorDeclaracao = dec.getIdentificadorDeclaracao();
        CacheNI.getInstancia().registrarNINome(this.niBeneficiario, this.nomeBeneficiario);
        this.getCodigo().setColunaFiltro(1);
        this.getCodigo().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                if (valorNovo != null && !valorNovo.toString().trim().equals("") && !Integer.valueOf(valorNovo.toString()).equals(-1)) {
                    Doacao.this.nomeBeneficiario.setNomeCampo(MensagemUtil.getMensagem("nome_cod_beneficiario_" + valorNovo));
                    Doacao.this.nomeBeneficiario.setNomeCampoCurto(MensagemUtil.getMensagem("nome_cod_beneficiario_" + valorNovo));
                    Doacao.this.niBeneficiario.setNomeCampo(MensagemUtil.getMensagem("cpf_cnpj_cod_beneficiario_" + valorNovo));
                    Doacao.this.niBeneficiario.setNomeCampoCurto(MensagemUtil.getMensagem("cpf_cnpj_cod_beneficiario_" + valorNovo));
                }
                if ((Doacao.DOACAO_CULTURA.equals(valorAntigo) || Doacao.DOACAO_OUTROS.equals(valorAntigo)) && !Doacao.DOACAO_CULTURA.equals(valorNovo) && !Doacao.DOACAO_OUTROS.equals(valorNovo)) {
                    Doacao.this.parcelaNaoDedutivel.clear();
                }
            }
        });
        this.getCodigo().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3, MensagemUtil.getMensagem("doacao_codigo_invalido")){

            @Override
            public RetornoValidacao validarImplementado() {
                if (this.getInformacao().isVazio()) {
                    this.setMensagemValidacao(MensagemUtil.getMensagem("doacao_codigo_branco"));
                }
                return super.validarImplementado();
            }
        });
        this.getCodigo().addValidador((ValidadorIf)new ValidadorCodigo(3, MensagemUtil.getMensagem("doacao_codigo_invalido")));
        this.getNomeBeneficiario().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(2){

            @Override
            public RetornoValidacao validarImplementado() {
                super.setMensagemValidacao(MensagemUtil.getMensagem("pagamento_beneficiario_branco", new String[]{this.getInformacao().getNomeCampo()}));
                return super.validarImplementado();
            }
        });
        this.getNiBeneficiario().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3){

            @Override
            public RetornoValidacao validarImplementado() {
                String codigoDoacao = Doacao.this.getCodigo().getConteudoAtual(0);
                String mensagem = null;
                RetornoValidacao retornoValidacao = null;
                byte severidade = 0;
                if (codigoDoacao.equals(Doacao.DOACAO_ESPECIE) || codigoDoacao.equals(Doacao.DOACAO_BENS)) {
                    if (this.getInformacao().isVazio()) {
                        mensagem = MensagemUtil.getMensagem("pagamento_cpf_beneficiario_branco", new String[]{Doacao.this.niBeneficiario.getNomeCampo()});
                        severidade = 3;
                        this.setSeveridade(severidade);
                    } else {
                        mensagem = MensagemUtil.getMensagem("pagamento_cpf_beneficiario_invalido", new String[]{Doacao.this.niBeneficiario.getNomeCampo()});
                        severidade = 3;
                        this.setSeveridade(severidade);
                    }
                    if (!Doacao.this.getNiBeneficiario().isVazio()) {
                        retornoValidacao = Validador.validarCPF((String)UtilitariosString.retiraMascara((String)this.getInformacao().formatado()));
                    }
                } else if (codigoDoacao.equals(Doacao.DOACAO_ESTATCRIANCA) || codigoDoacao.equals(Doacao.DOACAO_DESPORTO) || codigoDoacao.equals(Doacao.DOACAO_ESTATIDOSO) || codigoDoacao.equals(Doacao.DOACAO_PRONAS) || codigoDoacao.equals(Doacao.DOACAO_PRONON) || codigoDoacao.equals(Doacao.DOACAO_RECICLAGEM)) {
                    mensagem = this.getInformacao().isVazio() ? MensagemUtil.getMensagem("pagamento_cnpj_beneficiario_branco", new String[]{Doacao.this.niBeneficiario.getNomeCampo()}) : MensagemUtil.getMensagem("pagamento_cnpj_beneficiario_invalido", new String[]{Doacao.this.niBeneficiario.getNomeCampo()});
                    severidade = 3;
                    this.setSeveridade(severidade);
                    if (!Doacao.this.getNiBeneficiario().isVazio()) {
                        retornoValidacao = Validador.validarCNPJ((String)UtilitariosString.retiraMascara((String)this.getInformacao().formatado()));
                    }
                } else if (codigoDoacao.equals(Doacao.DOACAO_CULTURA) || codigoDoacao.equals(Doacao.DOACAO_AUDIOVISUAIS)) {
                    mensagem = this.getInformacao().isVazio() ? MensagemUtil.getMensagem("pagamento_ni_beneficiario_branco", new String[]{Doacao.this.niBeneficiario.getNomeCampo()}) : MensagemUtil.getMensagem("pagamento_ni_beneficiario_invalido", new String[]{Doacao.this.niBeneficiario.getNomeCampo()});
                    severidade = 3;
                    this.setSeveridade(severidade);
                    if (!Doacao.this.getNiBeneficiario().isVazio()) {
                        retornoValidacao = Validador.validarNI((String)UtilitariosString.retiraMascara((String)this.getInformacao().formatado()));
                    }
                } else if (codigoDoacao.equals(Doacao.DOACAO_OUTROS)) {
                    if (!this.getInformacao().isVazio()) {
                        mensagem = MensagemUtil.getMensagem("pagamento_ni_beneficiario_invalido", new String[]{Doacao.this.niBeneficiario.getNomeCampo()});
                        severidade = 3;
                        this.setSeveridade(severidade);
                        retornoValidacao = Validador.validarNI((String)UtilitariosString.retiraMascara((String)this.getInformacao().formatado()));
                    } else {
                        mensagem = MensagemUtil.getMensagem("pagamento_ni_beneficiario_branco", new String[]{Doacao.this.niBeneficiario.getNomeCampo()});
                        severidade = 2;
                        this.setSeveridade(severidade);
                    }
                } else {
                    mensagem = null;
                    retornoValidacao = null;
                }
                if ((Doacao.this.getNiBeneficiario().isVazio() || retornoValidacao != null) && mensagem != null) {
                    return new RetornoValidacao(mensagem, severidade);
                }
                return null;
            }
        });
        this.getParcelaNaoDedutivel().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3){

            @Override
            public RetornoValidacao validarImplementado() {
                String codigoDoacao = Doacao.this.getCodigo().getConteudoAtual(0);
                if (codigoDoacao.equals(Doacao.DOACAO_CULTURA) && Doacao.this.getParcelaNaoDedutivel().comparacao(">", Doacao.this.getValorPago())) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("pagamento_valor_reembolsado"), 3);
                }
                return null;
            }
        });
        this.getValorPago().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3){

            @Override
            public RetornoValidacao validarImplementado() {
                if (Doacao.this.getCodigo().isVazio() && Doacao.this.getNomeBeneficiario().isVazio() && Doacao.this.getNiBeneficiario().isVazio() && Doacao.this.getParcelaNaoDedutivel().isVazio()) {
                    return null;
                }
                super.setMensagemValidacao(MensagemUtil.getMensagem("doacao_valor_pago_branco"));
                return super.validarImplementado();
            }
        });
        this.getNiBeneficiario().addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                if (Doacao.this.getNiBeneficiario().naoFormatado().equals(Doacao.this.identificadorDeclaracao.getCpf().naoFormatado())) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("pagamento_cpf_beneficiario_igual", new String[]{MensagemUtil.getMensagem("cpf_cnpj_cod_beneficiario_" + Doacao.this.getCodigo())}), 3);
                }
                return null;
            }
        });
        this.getCodigo().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                dec.getDoacoes().getTotalDeducaoIncentivo().forcaDisparoObservadores();
            }
        });
    }

    public Codigo getCodigo() {
        return this.codigo;
    }

    public NI getNiBeneficiario() {
        return this.niBeneficiario;
    }

    public Alfa getNomeBeneficiario() {
        return this.nomeBeneficiario;
    }

    public Valor getParcelaNaoDedutivel() {
        return this.parcelaNaoDedutivel;
    }

    public Valor getValorPago() {
        return this.valorPago;
    }

    public Doacao obterCopia() {
        Doacao copia = new Doacao(IRPFFacade.getInstancia().getDeclaracao());
        copia.getCodigo().setConteudo(this.getCodigo());
        copia.getNomeBeneficiario().setConteudo(this.getNomeBeneficiario());
        copia.getNiBeneficiario().setConteudo(this.getNiBeneficiario());
        copia.getValorPago().setConteudo(this.getValorPago());
        copia.getParcelaNaoDedutivel().setConteudo(this.getParcelaNaoDedutivel());
        copia.getIndice().setConteudo(this.getIndice());
        return copia;
    }

    protected List<Informacao> recuperarListaCamposPendencia() {
        List retorno = super.recuperarListaCamposPendencia();
        retorno.add(this.codigo);
        retorno.add(this.nomeBeneficiario);
        retorno.add(this.niBeneficiario);
        retorno.add(this.valorPago);
        retorno.add(this.parcelaNaoDedutivel);
        return retorno;
    }

    public boolean isVazio() {
        for (Informacao informacao : this.recuperarCamposInformacao()) {
            if (informacao.isVazio() || informacao.getNomeCampo().equals("\u00cdndice") || informacao.getNomeCampo().equals(NOME_CODIGO)) continue;
            return false;
        }
        return true;
    }

    public int compareTo(Object o) {
        Doacao pgto = (Doacao)o;
        int cod = pgto.getCodigo().asInteger();
        return cod - this.getCodigo().asInteger();
    }

    public String getChave() {
        return this.getCodigo().naoFormatado();
    }

    @Override
    public Alfa getIndice() {
        return this.indice;
    }

    public String getClasseFicha() {
        return PainelDoacoesLista.class.getName();
    }

    public String getNomeAba() {
        return null;
    }

    public String getTituloFichaDashboard() {
        return "Doa\u00e7\u00f5es Efetuadas";
    }
}

