/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gcap.alienacao;

import java.util.ArrayList;
import serpro.ppgd.irpf.ValorPositivo;
import serpro.ppgd.irpf.gcap.ObjetoGCAP;
import serpro.ppgd.irpf.gcap.alienacao.AlienacaoBem;
import serpro.ppgd.irpf.gcap.alienacao.ParcelaAlienacaoBem;
import serpro.ppgd.irpf.gcap.apuracao.ApuracaoBemMovel;
import serpro.ppgd.irpf.gcap.aquisicao.Aquisicao;
import serpro.ppgd.irpf.gcap.bensmoveis.BemMovel;
import serpro.ppgd.irpf.tabelas.CadastroTabelasIRPF;
import serpro.ppgd.irpf.util.AplicacaoPropertiesUtil;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;

public class AlienacaoBemMovel
extends AlienacaoBem
implements ObjetoGCAP {
    public static final String NOME_FICHA_BEM_MOVEl = "Bens M\u00f3veis";
    public static final String NOME_ABA_IDENTIFICACAO = "Identifica\u00e7\u00e3o";
    public static final String NOME_ABA_ADQUIRENTES = "Adquirentes";
    public static final String NOME_ABA_OPERACAO = "Opera\u00e7\u00e3o";
    public static final String NOME_ABA_CALCULO = "C\u00e1lculo do Imposto";
    public static final int REDUCAO_AUSENTE = 0;
    public static final int REDUCAO_IMOVEL_PEQUENO_VALOR = 1;
    private BemMovel bemMovel = new BemMovel(this);
    private ApuracaoBemMovel apuracao = new ApuracaoBemMovel();
    private ApuracaoBemMovel apuracaoFinal = new ApuracaoBemMovel();
    private Alfa alienacaoAPrazoMovelAux = new Alfa((ObjetoNegocio)this, "Aliena\u00e7\u00e3o foi a prazo/presta\u00e7\u00e3o?", 1);

    public AlienacaoBemMovel() {
        this.bemMovel.getAquisicao().getCustoAquisicaoOrigemNacionalReal().setReadOnly(true);
        this.bemMovel.getAquisicao().getCustoAquisicaoTotalDolar().setReadOnly(true);
        this.getBemMovel().getBemAdquiridoNoBrasil().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                if (AlienacaoBemMovel.this.getBemMovel().isAdquiridoNoBrasil()) {
                    AlienacaoBemMovel.this.getNatureza().setColecaoElementoTabela(CadastroTabelasIRPF.recuperarNaturezaGCAPBemMovelDireitos());
                } else if (AlienacaoBemMovel.this.getBemMovel().isAdquiridoNoExterior()) {
                    AlienacaoBemMovel.this.getNatureza().setColecaoElementoTabela(CadastroTabelasIRPF.recuperarNaturezaGCMEBemMovelDireitos());
                } else {
                    AlienacaoBemMovel.this.getNatureza().setColecaoElementoTabela(new ArrayList());
                }
            }
        });
        if (this.getBemMovel().isAdquiridoNoBrasil()) {
            this.getNatureza().setColecaoElementoTabela(CadastroTabelasIRPF.recuperarNaturezaGCAPBemMovelDireitos());
        } else if (this.getBemMovel().isAdquiridoNoExterior()) {
            this.getNatureza().setColecaoElementoTabela(CadastroTabelasIRPF.recuperarNaturezaGCMEBemMovelDireitos());
        } else {
            this.getNatureza().setColecaoElementoTabela(new ArrayList());
        }
    }

    public BemMovel getBemMovel() {
        return this.bemMovel;
    }

    public Alfa getAlienacaoAPrazoMovelAux() {
        return this.alienacaoAPrazoMovelAux;
    }

    @Override
    public Aquisicao getAquisicao() {
        return this.getBemMovel().getAquisicao();
    }

    @Override
    public ApuracaoBemMovel getApuracao() {
        return this.apuracao;
    }

    @Override
    public ApuracaoBemMovel getApuracaoFinal() {
        return this.apuracaoFinal;
    }

    @Override
    public Codigo obterCodigoOrigemRendimentos() {
        return this.getBemMovel().getAquisicao().getOrigemRendimentos();
    }

    @Override
    public boolean isAlienacaoBrasil() {
        return this.getBemMovel().isAdquiridoNoBrasil();
    }

    public boolean isVazio() {
        return this.getBemMovel().getBemAdquiridoNoBrasil().isVazio();
    }

    public boolean isPrevisaoPrejuizo() {
        boolean retorno = false;
        if (!this.isAlienacaoBrasil()) {
            String origemRendimentos = this.obterCodigoOrigemRendimentos().naoFormatado();
            ValorPositivo ganhoCapital = new ValorPositivo();
            if ("1".equals(origemRendimentos)) {
                ganhoCapital.setConteudo(this.getApuracao().getGanhoCapital1OrigemNacionalReal());
            } else if ("2".equals(origemRendimentos)) {
                ganhoCapital.setConteudo(this.getApuracao().getGanhoCapital1OrigemMEReal());
            } else if ("3".equals(origemRendimentos)) {
                ganhoCapital.setConteudo(this.getApuracao().getGanhoCapital1OrigemNacionalReal().operacao('+', this.getApuracao().getGanhoCapital1OrigemMEReal()));
            }
            if (ganhoCapital.isVazio()) {
                retorno = true;
            }
        }
        return retorno;
    }

    public int obterEnquadramentoInicial() {
        int retorno = 0;
        if (!this.isValorOperacaoMaior35K() && (Logico.NAO.equals(this.getBemGrandeValor().formatado()) || Logico.NAO.equals(this.getBemGrandeValorOperacao().formatado()))) {
            retorno = 1;
        }
        return retorno;
    }

    public int obterEnquadramentoFinal() {
        int retorno = 0;
        if (!this.isValorParcelasMaior35K() && Logico.NAO.equals(this.getBemGrandeValor().formatado())) {
            retorno = 1;
        }
        return retorno;
    }

    public String obterMensagemMudancaEnquadramento() {
        String mensagem = null;
        int enquadramentoInicial = this.obterEnquadramentoInicial();
        int enquadramentoFinal = this.obterEnquadramentoFinal();
        if (this.getColecaoParcelaAlienacao().obterUltimaParcela() != null && enquadramentoInicial != enquadramentoFinal) {
            if (enquadramentoInicial == 0) {
                if (enquadramentoFinal == 1) {
                    mensagem = "<html>De acordo com o valor recebido (R$), h\u00e1 direito \u00e0 isen\u00e7\u00e3o por aliena\u00e7\u00e3o de bem de pequeno valor.</html>";
                }
            } else if (enquadramentoInicial == 1 && enquadramentoFinal == 0) {
                mensagem = "<html>De acordo com o valor recebido (R$), n\u00e3o h\u00e1 direito \u00e0 isen\u00e7\u00e3o por aliena\u00e7\u00e3o de bem de pequeno valor.<br>O imposto devido ser\u00e1 integralmente cobrado na \u00faltima parcela.</html>";
            }
        }
        return mensagem;
    }

    public String obterTextoIsencao() {
        String msgIsencao = "";
        if (this.isAlienacaoAVista()) {
            if (this.getCalculoImposto().getImpostoDevido().isVazio()) {
                msgIsencao = MensagemUtil.getMensagem("impostoDevidoZero");
            }
        } else if (this.getDataRecebimentoUltimaParcela().isVazio()) {
            if (this.isPrevisaoPrejuizo() || this.isIsento()) {
                msgIsencao = MensagemUtil.getMensagem("impostoDevidoZero");
            }
        } else {
            String msgMudancaEnquadramento = this.obterMensagemMudancaEnquadramento();
            if (msgMudancaEnquadramento != null) {
                msgIsencao = msgMudancaEnquadramento;
            } else if (this.getAjuste().getImpostoDevido().isVazio()) {
                msgIsencao = MensagemUtil.getMensagem("impostoDevidoZero");
            }
        }
        return msgIsencao;
    }

    public boolean podeResponderPerguntaPequenoValorNoExteriorPorParcelas() {
        boolean retorno = false;
        boolean residenteNoBrasil = Logico.SIM.equals(this.getResidenteBrasil().naoFormatado());
        ValorPositivo valorAlienacaoReal = new ValorPositivo();
        if (this.getBemMovel().isAdquiridoNoExterior()) {
            valorAlienacaoReal.setConteudo(this.getValorAlienacaoDolar().operacao('*', this.getCotacaoDolarDataAlienacao()));
            if (valorAlienacaoReal.comparacao(">", "35.000,00") && !this.getDataRecebimentoUltimaParcela().isVazio()) {
                valorAlienacaoReal.clear();
                for (ParcelaAlienacaoBem p : this.getColecaoParcelaAlienacao().itens()) {
                    ValorPositivo somaParcela = new ValorPositivo();
                    somaParcela.setConteudo(p.getValorRecebidoDolar());
                    somaParcela.append('*', p.getCotacaoDolar());
                    valorAlienacaoReal.append('+', somaParcela);
                }
                if (residenteNoBrasil && valorAlienacaoReal.comparacao("<=", "35.000,00") && this.getDataAlienacao().naoFormatado().length() == 8 && AplicacaoPropertiesUtil.getExercicio().equals(this.getDataAlienacao().getAno())) {
                    retorno = true;
                }
            }
        }
        return retorno;
    }

    @Override
    public boolean podePreencherCalculo() {
        boolean retorno = true;
        if (this.getAlienacaoAPrazo().isVazio() || this.getNatureza().isVazio() || !this.isAlienacaoBrasil() && this.getAquisicao().getOrigemRendimentos().isVazio()) {
            retorno = false;
        }
        return retorno;
    }

    @Override
    public boolean isAdquirenteRequerido() {
        boolean requerido = super.isAdquirenteRequerido();
        if (requerido && !this.isAlienacaoBrasil() && (String.valueOf(AlienacaoBem.CODIGO_NATUREZA_LIQUID_OU_RESGATE_DE_APLIC_FINANCEIRA).equals(this.getNatureza().naoFormatado()) || String.valueOf(AlienacaoBem.CODIGO_NATUREZA_ALIENACAO_ACOES_BOLSA_VALORES).equals(this.getNatureza().naoFormatado()) || String.valueOf(AlienacaoBem.CODIGO_NATUREZA_CREDITO_JUROS_APLICACAO_FINANCEIRA).equals(this.getNatureza().naoFormatado()))) {
            requerido = false;
        }
        return requerido;
    }
}

