/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gcap.apuracao;

import serpro.ppgd.irpf.ValorPositivo;
import serpro.ppgd.negocio.ObjetoNegocio;

public class Apuracao
extends ObjetoNegocio {
    private ValorPositivo valorAlienacao = new ValorPositivo(this, "Valor de Aliena\u00e7\u00e3o (R$)");
    private ValorPositivo custoCorretagem = new ValorPositivo(this, "Custo de Corretagem (R$)");
    private ValorPositivo valorLiquidoAlienacao = new ValorPositivo(this, "Valor L\u00edquido de Aliena\u00e7\u00e3o (R$)");
    private ValorPositivo custoAquisicao = new ValorPositivo(this, "Custo de Aquisi\u00e7\u00e3o (R$)");
    private ValorPositivo ganhoCapital1 = new ValorPositivo(this, "Ganho de Capital - Resultado 1 (R$)");

    public Apuracao() {
        this.valorAlienacao.setReadOnly(true);
        this.custoCorretagem.setReadOnly(true);
        this.valorLiquidoAlienacao.setReadOnly(true);
        this.custoAquisicao.setReadOnly(true);
        this.ganhoCapital1.setReadOnly(true);
    }

    public ValorPositivo getValorAlienacao() {
        return this.valorAlienacao;
    }

    public ValorPositivo getCustoCorretagem() {
        return this.custoCorretagem;
    }

    public ValorPositivo getValorLiquidoAlienacao() {
        return this.valorLiquidoAlienacao;
    }

    public ValorPositivo getGanhoCapital1() {
        return this.ganhoCapital1;
    }

    public ValorPositivo getCustoAquisicao() {
        return this.custoAquisicao;
    }

    public ValorPositivo calcularPercentualGanhoBrasil() {
        ValorPositivo percentualGanho = new ValorPositivo(this, "Percentual de Ganho", 11, 9);
        if (this.valorLiquidoAlienacao.comparacao(">", "0,00")) {
            percentualGanho.setConteudo(this.ganhoCapital1);
            percentualGanho.append('*', "100,000000");
            percentualGanho.append('/', this.valorLiquidoAlienacao);
            percentualGanho.converteQtdCasasDecimais(6);
        }
        return percentualGanho;
    }
}

