/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gcap.entidades;

import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import serpro.ppgd.irpf.gcap.entidades.ValidadorMaximoDigitosInteiros;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.Valor;

public class ValorBigDecimalGCAP
extends Valor {
    protected int maximoDigitosParteInteira = ConstantesGlobais.TAMANHO_VALOR - ConstantesGlobais.TAMANHO_VALOR_PARTE_DECIMAL;
    protected String msgErroEstourodigitos = "O valor m\u00e1ximo para o tipo do campo foi excedido.";
    protected byte severidadeValidacaoMaximoDigitos = (byte)3;
    protected BigInteger conteudo = new BigInteger("0");
    protected int casasDecimais = ConstantesGlobais.TAMANHO_VALOR_PARTE_DECIMAL;
    protected boolean porcentagem = false;
    private boolean campoCalculado = false;
    public static final int ESCALA_DECIMAIS_CALCULOS = 9;
    public static final RoundingMode METODO_ARREDONDAMENTO = RoundingMode.HALF_EVEN;
    public static final RoundingMode METODO_TRUNCAMENTO = RoundingMode.DOWN;
    protected BigDecimal conteudoBigDecimal = new BigDecimal(0L);
    protected boolean vazio = true;
    private DecimalFormat df = (DecimalFormat)DecimalFormat.getNumberInstance(ConstantesGlobais.LOCALIDADE);

    public ValorBigDecimalGCAP(BigDecimal valorBigDecimal) {
        this(valorBigDecimal, true);
    }

    public ValorBigDecimalGCAP(BigDecimal valorBigDecimal, boolean arredondar) {
        this.ajustarEscalaArredondamentoPrecisao(arredondar);
        BigInteger valConteudo = null;
        valConteudo = arredondar ? valorBigDecimal.setScale(this.getCasasDecimais(), METODO_ARREDONDAMENTO).multiply(new BigDecimal("10").pow(this.getCasasDecimais())).toBigInteger() : valorBigDecimal.setScale(this.getCasasDecimais(), METODO_TRUNCAMENTO).multiply(new BigDecimal("10").pow(this.getCasasDecimais())).toBigInteger();
        this.setConteudo(valConteudo);
        this.getListaValidadores().clear();
        this.addValidador((ValidadorIf)new ValidadorMaximoDigitosInteiros(this.severidadeValidacaoMaximoDigitos));
        this.ajustarEscalaArredondamentoPrecisao(arredondar);
    }

    public ValorBigDecimalGCAP() {
        this(new BigDecimal(0L), true);
    }

    public ValorBigDecimalGCAP(boolean arredondar) {
        this(new BigDecimal(0L), arredondar);
    }

    public ValorBigDecimalGCAP(String pVal) {
        BigDecimal v = new BigDecimal(pVal.trim().length() > 0 ? pVal.replaceAll("[.]", "").replaceAll("[,]", ".") : "0.00");
        this.setCasasDecimais(v.scale());
        this.setConteudo(v);
        this.getListaValidadores().clear();
        this.addValidador((ValidadorIf)new ValidadorMaximoDigitosInteiros(this.severidadeValidacaoMaximoDigitos));
        this.ajustarEscalaArredondamentoPrecisao();
    }

    public ValorBigDecimalGCAP(Long valorLong) {
        this(valorLong.toString());
    }

    public ValorBigDecimalGCAP(long valorLong) {
        this(new Long(valorLong));
    }

    public ValorBigDecimalGCAP(ObjetoNegocio owner, String nomeCampo) {
        super(owner, nomeCampo);
        this.ajustarEscalaArredondamentoPrecisao();
        BigInteger valConteudo = new BigInteger("0");
        this.setConteudo(valConteudo);
        this.getListaValidadores().clear();
        this.addValidador((ValidadorIf)new ValidadorMaximoDigitosInteiros(this.severidadeValidacaoMaximoDigitos));
        this.ajustarEscalaArredondamentoPrecisao();
    }

    public ValorBigDecimalGCAP(ObjetoNegocio owner, String nomeCampo, int pMaximoDigitosInteiros, int pQtdCasasDecimais) {
        this(owner, nomeCampo);
        this.setMaximoDigitosParteInteira(pMaximoDigitosInteiros);
        this.setCasasDecimais(pQtdCasasDecimais);
    }

    public ValorBigDecimalGCAP(ObjetoNegocio owner, String nomeCampo, boolean readOnly) {
        this(owner, nomeCampo);
        this.setReadOnly(readOnly);
    }

    protected void ajustarEscalaArredondamentoPrecisao() {
        this.ajustarEscalaArredondamentoPrecisao(true);
    }

    protected void ajustarEscalaArredondamentoPrecisao(boolean arredondar) {
        if (this.conteudoBigDecimal == null) {
            this.conteudoBigDecimal = new BigDecimal(0L);
        }
        this.conteudoBigDecimal = arredondar ? this.conteudoBigDecimal.setScale(9, METODO_ARREDONDAMENTO) : this.conteudoBigDecimal.setScale(9, METODO_TRUNCAMENTO);
    }

    public void clear() {
        this.vazio = false;
        this.reiniciarValor();
    }

    public void reiniciarValor() {
        this.vazio = false;
        this.setConteudoCompleto(0L);
    }

    public void esvaziar() {
        this.vazio = true;
        this.setConteudoCompleto(0L);
    }

    public boolean estaVazio() {
        return this.vazio;
    }

    public boolean isVazio() {
        return this.conteudo.equals(BigInteger.ZERO);
    }

    public int compareTo(ValorBigDecimalGCAP o) {
        int retorno = 0;
        retorno = this.obterCloneBigDecimalParaExibicao().compareTo(o.obterCloneBigDecimalParaExibicao());
        return retorno;
    }

    public String asString() {
        Object negativo = "";
        if (this.conteudo.compareTo(BigInteger.ZERO) < 0) {
            negativo = (String)negativo + "-";
        }
        String parteInteira = this.getParteInteira();
        Object parteDecimal = this.getParteDecimal();
        if (!((String)parteDecimal).trim().equals("")) {
            parteDecimal = "," + (String)parteDecimal;
        }
        return (String)negativo + parteInteira + (String)parteDecimal;
    }

    public boolean equals(Object obj) {
        return this.compareTo((ValorBigDecimalGCAP)((Object)obj)) == 0;
    }

    protected void carregarConteudoBigDecimal(BigInteger pConteudo) {
        this.conteudoBigDecimal = new BigDecimal(pConteudo).divide(new BigDecimal("10").pow(this.getCasasDecimais()));
        this.ajustarEscalaArredondamentoPrecisao();
    }

    public boolean isPorcentagem() {
        return this.porcentagem;
    }

    public void setPorcentagem(boolean porcentagem) {
        this.porcentagem = porcentagem;
    }

    public String formatado() {
        try {
            this.df.applyLocalizedPattern("###.###.##0");
        }
        catch (IllegalArgumentException e) {
            this.df.applyLocalizedPattern("###,###,##0");
        }
        Object negativo = "";
        String parteInteiraFormatada = this.df.format(new BigInteger(this.getParteInteira()));
        String parteDecimalFormatada = this.getParteDecimal();
        if (this.conteudo.compareTo(BigInteger.ZERO) < 0) {
            negativo = (String)negativo + "-";
        }
        if (parteDecimalFormatada.trim().length() == 0) {
            return (String)negativo + parteInteiraFormatada;
        }
        return (String)negativo + parteInteiraFormatada + "," + parteDecimalFormatada;
    }

    public String naoFormatado() {
        Object negativo = "";
        if (this.conteudo.compareTo(BigInteger.ZERO) < 0) {
            negativo = (String)negativo + "-";
        }
        String parteInteira = this.getParteInteira();
        Object parteDecimal = this.getParteDecimal();
        if (!((String)parteDecimal).trim().equals("")) {
            parteDecimal = "," + (String)parteDecimal;
        }
        return (String)negativo + parteInteira + (String)parteDecimal;
    }

    public void setConteudo(BigInteger pConteudo) {
        this.vazio = pConteudo == null;
        String antigo = this.asString();
        this.clearRetornosValidacoes();
        this.carregarConteudoBigDecimal(pConteudo);
        this.conteudo = pConteudo;
        if (!this.inicializouUltimoConteudoValido) {
            this.inicializouUltimoConteudoValido = true;
            this.setUltimoConteudoValido(this.asString());
        }
        if (this.isVazio()) {
            this.setUltimoConteudoValido("");
        }
        this.disparaObservadores(antigo);
    }

    public void setConteudoCompleto(BigInteger pConteudo) {
        this.vazio = pConteudo == null;
        for (int x = 0; x < this.getCasasDecimais(); ++x) {
            pConteudo = pConteudo.multiply(new BigInteger("10"));
        }
        this.setConteudo(pConteudo);
    }

    public void setConteudoCompleto(long pConteudo) {
        this.setConteudoCompleto(new BigInteger(new Long(pConteudo).toString()));
    }

    public void setConteudo(String pConteudo) {
        this.vazio = pConteudo == null;
        String lConteudo = pConteudo.replaceAll("[.]", "");
        if ((lConteudo = lConteudo.replaceAll("[,]", ".")).trim().length() == 0) {
            lConteudo = "0";
        }
        BigDecimal lConteudoBigDecimal = new BigDecimal(lConteudo);
        BigInteger valConteudo = lConteudoBigDecimal.setScale(this.getCasasDecimais(), METODO_ARREDONDAMENTO).multiply(new BigDecimal("10").pow(this.getCasasDecimais())).toBigInteger();
        this.setConteudo(valConteudo);
    }

    public void setConteudo(ValorBigDecimalGCAP pConteudo) {
        boolean bl = this.vazio = pConteudo == null;
        if (pConteudo instanceof ValorBigDecimalGCAP) {
            this.setConteudoBigDecimal(pConteudo.obterCloneBigDecimalParaCalculo());
            this.ajustarEscalaArredondamentoPrecisao();
            BigDecimal copia = pConteudo.obterCloneBigDecimalParaExibicao().multiply(new BigDecimal("10").pow(this.getCasasDecimais()));
            this.setConteudo(copia.toBigInteger());
        } else {
            this.setConteudo(pConteudo.getConteudoBigInteger());
        }
    }

    public BigInteger getConteudoBigInteger() {
        return this.conteudo;
    }

    public Long getConteudo() {
        throw new RuntimeException("O m\u00e9todo 'getConteudo()' que retorna um objeto do tipo Long n\u00e3o pode ser utilizado quando se trata de um ValorBigDecimal porque o ValorBigDecimal possui um conte\u00fado interno do tipo BigInteger e N\u00c3O Long. O valor do conte\u00fado poderia ser truncado indevidamente.");
    }

    public String getParteInteira() {
        BigInteger conteudoAtual = new BigInteger(this.conteudo.toString());
        BigInteger fatorCasaDecimal = new BigInteger("1");
        for (int i = 0; i < this.getCasasDecimais(); ++i) {
            fatorCasaDecimal = fatorCasaDecimal.multiply(new BigInteger("10"));
        }
        return String.valueOf(conteudoAtual.divide(fatorCasaDecimal).abs());
    }

    public String getParteDecimal() {
        if (this.getCasasDecimais() == 0) {
            return "";
        }
        Object lConteudo = this.conteudo.toString();
        while (((String)lConteudo).length() <= this.getCasasDecimais()) {
            lConteudo = "0" + (String)lConteudo;
        }
        String lDecimalAtual = ((String)lConteudo).substring(((String)lConteudo).length() - this.getCasasDecimais());
        return lDecimalAtual;
    }

    public String getConteudoFormatado() {
        Object negativo = "";
        BigInteger lParteInteiraFormatada = new BigInteger(this.getParteInteira());
        DecimalFormat df = (DecimalFormat)NumberFormat.getNumberInstance(ConstantesGlobais.LOCALIDADE);
        try {
            df.applyLocalizedPattern("###.###.##0");
        }
        catch (IllegalArgumentException e) {
            df.applyLocalizedPattern("###,###,##0");
        }
        String parteInteiraFormatada = df.format(lParteInteiraFormatada);
        String parteDecimalFormatada = this.getParteDecimal();
        if (this.conteudo.compareTo(BigInteger.ZERO) < 0) {
            negativo = (String)negativo + "-";
        }
        if (parteDecimalFormatada.trim().length() == 0) {
            return (String)negativo + parteInteiraFormatada;
        }
        return (String)negativo + parteInteiraFormatada + "," + parteDecimalFormatada;
    }

    public int getCasasDecimais() {
        return this.casasDecimais;
    }

    public void setCasasDecimais(int casasDecimais) {
        if (this.conteudo != null) {
            int diferenca = casasDecimais - this.casasDecimais;
            if (diferenca >= 0) {
                this.setConteudo(this.conteudo.multiply(new BigInteger("10").pow(diferenca)));
            } else {
                this.setConteudo(this.conteudo.divide(new BigInteger("10").pow(Math.abs(diferenca))));
            }
        }
        this.casasDecimais = casasDecimais;
    }

    public void setConteudo(BigDecimal pConteudo) {
        boolean bl = this.vazio = pConteudo == null;
        if (!this.vazio) {
            this.setConteudo(pConteudo.multiply(new BigDecimal("10").pow(this.getCasasDecimais())).toBigInteger());
        }
    }

    public BigDecimal getConteudoBigDecimal() {
        if (this.conteudoBigDecimal == null) {
            this.clear();
        }
        return this.conteudoBigDecimal;
    }

    public void setConteudoBigDecimal(BigDecimal conteudoBigDecimal) {
        this.vazio = conteudoBigDecimal == null;
        this.conteudoBigDecimal = conteudoBigDecimal;
        this.ajustarEscalaArredondamentoPrecisao();
    }

    public BigDecimal getConteudoBigDecimalArredondado() {
        if (this.conteudoBigDecimal == null) {
            this.clear();
        }
        return this.conteudoBigDecimal.setScale(this.getCasasDecimais(), METODO_ARREDONDAMENTO);
    }

    public MathContext getContexto(BigDecimal lOperando1, BigDecimal lOperando2) {
        return new MathContext(lOperando1.precision() + lOperando2.precision() + lOperando1.scale() + lOperando2.scale(), METODO_ARREDONDAMENTO);
    }

    public void somar(BigDecimal valorBigDecimal) {
        this.vazio = false;
        if (this.conteudoBigDecimal == null) {
            this.clear();
        }
        this.conteudoBigDecimal = this.conteudoBigDecimal.add(valorBigDecimal, this.getContexto(this.conteudoBigDecimal, valorBigDecimal));
        this.ajustarEscalaArredondamentoPrecisao();
        BigDecimal lConteudoBigInteger = this.getConteudoBigDecimalArredondado();
        this.setConteudo(lConteudoBigInteger.multiply(new BigDecimal("10").pow(this.getCasasDecimais())).toBigInteger());
    }

    public void subtrair(BigDecimal valorBigDecimal) {
        this.vazio = false;
        if (this.conteudoBigDecimal == null) {
            this.clear();
        }
        this.conteudoBigDecimal = this.conteudoBigDecimal.subtract(valorBigDecimal, this.getContexto(this.conteudoBigDecimal, valorBigDecimal));
        this.ajustarEscalaArredondamentoPrecisao();
        BigDecimal lConteudoBigInteger = this.getConteudoBigDecimalArredondado();
        this.setConteudo(lConteudoBigInteger.multiply(new BigDecimal("10").pow(this.getCasasDecimais())).toBigInteger());
    }

    public void subtrair(long pNumero) {
        this.subtrair(new BigDecimal(pNumero));
    }

    public void multiplicar(BigDecimal valorBigDecimal) {
        this.vazio = false;
        if (this.conteudoBigDecimal == null) {
            this.clear();
        }
        this.conteudoBigDecimal = this.conteudoBigDecimal.multiply(valorBigDecimal, this.getContexto(this.conteudoBigDecimal, valorBigDecimal));
        this.ajustarEscalaArredondamentoPrecisao();
        BigDecimal lConteudoBigInteger = this.getConteudoBigDecimalArredondado();
        this.setConteudo(lConteudoBigInteger.multiply(new BigDecimal("10").pow(this.getCasasDecimais())).toBigInteger());
    }

    public void multiplicar(long pNumero) {
        this.multiplicar(new BigDecimal(pNumero));
    }

    public void dividir(BigDecimal valorBigDecimal) {
        this.vazio = false;
        if (this.conteudoBigDecimal == null) {
            this.clear();
        }
        this.conteudoBigDecimal = this.conteudoBigDecimal.divide(valorBigDecimal, this.getContexto(this.conteudoBigDecimal, valorBigDecimal));
        this.ajustarEscalaArredondamentoPrecisao();
        BigDecimal lConteudoBigInteger = this.getConteudoBigDecimalArredondado();
        this.setConteudo(lConteudoBigInteger.multiply(new BigDecimal("10").pow(this.getCasasDecimais())).toBigInteger());
    }

    public void dividir(long pNumero) {
        this.dividir(new BigDecimal(pNumero));
    }

    public void obterResto(BigDecimal valorBigDecimal) {
        this.vazio = false;
        if (this.conteudoBigDecimal == null) {
            this.clear();
        }
        this.conteudoBigDecimal = this.conteudoBigDecimal.remainder(valorBigDecimal, this.getContexto(this.conteudoBigDecimal, valorBigDecimal));
        this.ajustarEscalaArredondamentoPrecisao();
        BigDecimal lConteudoBigInteger = this.getConteudoBigDecimalArredondado();
        this.setConteudo(lConteudoBigInteger.multiply(new BigDecimal("10").pow(this.getCasasDecimais())).toBigInteger());
    }

    public void obterResto(long pNumero) {
        this.obterResto(new BigDecimal(pNumero));
    }

    public BigDecimal obterCloneBigDecimalParaCalculo() {
        this.vazio = false;
        return new BigDecimal(this.conteudoBigDecimal.toString()).setScale(9, METODO_ARREDONDAMENTO);
    }

    public BigDecimal obterCloneBigDecimalParaExibicao() {
        this.vazio = false;
        return new BigDecimal(this.conteudoBigDecimal.toString()).setScale(this.getCasasDecimais(), METODO_ARREDONDAMENTO);
    }

    protected void carregarDadosValor(ValorBigDecimalGCAP lValorOrigem, boolean pIncluirObservadoresValidadores) {
        PropertyChangeListener[] lListeners;
        boolean lObservadoresAtivos = lValorOrigem.isObservadoresAtivos();
        this.setObservadoresAtivos(false);
        this.setAba(lValorOrigem.getAba());
        this.setAtributoPersistente(lValorOrigem.isAtributoPersistente());
        this.setCampoCalculado(lValorOrigem.isCampoCalculado());
        this.setFicha(lValorOrigem.getFicha());
        this.setHabilitado(lValorOrigem.isHabilitado());
        this.setMsgErroEstourodigitos(lValorOrigem.getMsgErroEstourodigitos());
        this.setNomeCampoCurto(lValorOrigem.getNomeCampoCurto());
        this.setPorcentagem(lValorOrigem.isPorcentagem());
        this.setRetornoTodasValidacoes(lValorOrigem.getRetornoTodasValidacoes());
        this.setSeveridadeValidacaoMaximoDigitos(lValorOrigem.getSeveridadeValidacaoMaximoDigitos());
        this.setTransportado(lValorOrigem.isTransportado());
        this.setUltimoConteudoValido(lValorOrigem.getUltimoConteudoValido());
        this.setValidadoresAtivos(lValorOrigem.isValidadoresAtivos());
        if (pIncluirObservadoresValidadores) {
            if (this.getObservadores() == null || this.getObservadores().getPropertyChangeListeners() == null || this.getObservadores().getPropertyChangeListeners().length == 0) {
                for (PropertyChangeListener lListener : lValorOrigem.getObservadores().getPropertyChangeListeners()) {
                    this.getObservadores().addPropertyChangeListener(lListener);
                }
            }
            if (this.getListaValidadores() == null && this.getListaValidadores().size() == 0) {
                for (ValidadorIf lValidador : lValorOrigem.getListaValidadores()) {
                    this.addValidador(lValidador);
                }
            }
            if (this.getListaValidadoresImpeditivos() == null && this.getListaValidadoresImpeditivos().size() == 0) {
                for (ValidadorIf lValidador : lValorOrigem.getListaValidadoresImpeditivos()) {
                    this.addValidador(lValidador);
                }
            }
        }
        this.setOwner(lValorOrigem.getOwner());
        for (PropertyChangeListener lListener : lListeners = this.getObservadores().getPropertyChangeListeners()) {
            this.getObservadores().removePropertyChangeListener(lListener);
        }
        this.setNomeCampo(lValorOrigem.getNomeCampo());
        for (PropertyChangeListener lListener : lListeners) {
            this.getObservadores().addPropertyChangeListener(lListener);
        }
        this.setMaximoDigitosParteInteira(lValorOrigem.getMaximoDigitosParteInteira());
        this.setCasasDecimais(lValorOrigem.getCasasDecimais());
        this.setReadOnly(lValorOrigem.isReadOnly());
        this.setObservadoresAtivos(lObservadoresAtivos);
    }

    public ValorBigDecimalGCAP obterCloneValorBigDecimalParaCalculo(boolean pIncluirObservadoresValidadores) {
        this.vazio = false;
        ValorBigDecimalGCAP lValor = new ValorBigDecimalGCAP();
        lValor.carregarDadosValor(this, pIncluirObservadoresValidadores);
        lValor.converteQtdCasasDecimais(9);
        lValor.setConteudo(new BigDecimal(this.conteudoBigDecimal.toString()).setScale(9, METODO_ARREDONDAMENTO));
        lValor.vazio = false;
        return lValor;
    }

    public ValorBigDecimalGCAP obterCloneValorBigDecimalParaExibicao(boolean pIncluirObservadoresValidadores) {
        this.vazio = false;
        ValorBigDecimalGCAP lValor = new ValorBigDecimalGCAP();
        lValor.carregarDadosValor(this, pIncluirObservadoresValidadores);
        lValor.setConteudo(new BigDecimal(this.conteudoBigDecimal.toString()).setScale(this.getCasasDecimais(), METODO_ARREDONDAMENTO));
        lValor.vazio = false;
        return lValor;
    }

    public boolean ehMenorQue(ValorBigDecimalGCAP valorBigDecimal, boolean valorParaCalculo) {
        this.vazio = false;
        if (valorParaCalculo) {
            return this.obterCloneBigDecimalParaCalculo().compareTo(valorBigDecimal.obterCloneBigDecimalParaCalculo()) < 0;
        }
        return this.obterCloneBigDecimalParaExibicao().compareTo(valorBigDecimal.obterCloneBigDecimalParaExibicao()) < 0;
    }

    public boolean ehMenorOuIgualA(ValorBigDecimalGCAP valorBigDecimal, boolean valorParaCalculo) {
        this.vazio = false;
        if (valorParaCalculo) {
            return this.obterCloneBigDecimalParaCalculo().compareTo(valorBigDecimal.obterCloneBigDecimalParaCalculo()) <= 0;
        }
        return this.obterCloneBigDecimalParaExibicao().compareTo(valorBigDecimal.obterCloneBigDecimalParaExibicao()) <= 0;
    }

    public boolean ehIgualA(ValorBigDecimalGCAP valorBigDecimal, boolean valorParaCalculo) {
        this.vazio = false;
        if (valorParaCalculo) {
            return this.obterCloneBigDecimalParaCalculo().compareTo(valorBigDecimal.obterCloneBigDecimalParaCalculo()) == 0;
        }
        return this.obterCloneBigDecimalParaExibicao().compareTo(valorBigDecimal.obterCloneBigDecimalParaExibicao()) == 0;
    }

    public boolean ehDiferenteDe(ValorBigDecimalGCAP valorBigDecimal, boolean valorParaCalculo) {
        this.vazio = false;
        if (valorParaCalculo) {
            return this.obterCloneBigDecimalParaCalculo().compareTo(valorBigDecimal.obterCloneBigDecimalParaCalculo()) != 0;
        }
        return this.obterCloneBigDecimalParaExibicao().compareTo(valorBigDecimal.obterCloneBigDecimalParaExibicao()) != 0;
    }

    public boolean ehMaiorOuIgualA(ValorBigDecimalGCAP valorBigDecimal, boolean valorParaCalculo) {
        this.vazio = false;
        if (valorParaCalculo) {
            return this.obterCloneBigDecimalParaCalculo().compareTo(valorBigDecimal.obterCloneBigDecimalParaCalculo()) >= 0;
        }
        return this.obterCloneBigDecimalParaExibicao().compareTo(valorBigDecimal.obterCloneBigDecimalParaExibicao()) >= 0;
    }

    public boolean ehMaiorQue(ValorBigDecimalGCAP valorBigDecimal, boolean valorParaCalculo) {
        this.vazio = false;
        if (valorParaCalculo) {
            return this.obterCloneBigDecimalParaCalculo().compareTo(valorBigDecimal.obterCloneBigDecimalParaCalculo()) > 0;
        }
        return this.obterCloneBigDecimalParaExibicao().compareTo(valorBigDecimal.obterCloneBigDecimalParaExibicao()) > 0;
    }

    public boolean ehMenorQue(BigDecimal valorBigDecimal, boolean valorParaCalculo) {
        this.vazio = false;
        if (valorParaCalculo) {
            return this.obterCloneBigDecimalParaCalculo().compareTo(valorBigDecimal) < 0;
        }
        return this.obterCloneBigDecimalParaExibicao().compareTo(valorBigDecimal) < 0;
    }

    public boolean ehMenorOuIgualA(BigDecimal valorBigDecimal, boolean valorParaCalculo) {
        this.vazio = false;
        if (valorParaCalculo) {
            return this.obterCloneBigDecimalParaCalculo().compareTo(valorBigDecimal) <= 0;
        }
        return this.obterCloneBigDecimalParaExibicao().compareTo(valorBigDecimal) <= 0;
    }

    public boolean ehIgualA(BigDecimal valorBigDecimal, boolean valorParaCalculo) {
        this.vazio = false;
        if (valorParaCalculo) {
            return this.obterCloneBigDecimalParaCalculo().compareTo(valorBigDecimal) == 0;
        }
        return this.obterCloneBigDecimalParaExibicao().compareTo(valorBigDecimal) == 0;
    }

    public boolean ehDiferenteDe(BigDecimal valorBigDecimal, boolean valorParaCalculo) {
        this.vazio = false;
        if (valorParaCalculo) {
            return this.obterCloneBigDecimalParaCalculo().compareTo(valorBigDecimal) != 0;
        }
        return this.obterCloneBigDecimalParaExibicao().compareTo(valorBigDecimal) != 0;
    }

    public boolean ehMaiorOuIgualA(BigDecimal valorBigDecimal, boolean valorParaCalculo) {
        this.vazio = false;
        if (valorParaCalculo) {
            return this.obterCloneBigDecimalParaCalculo().compareTo(valorBigDecimal) >= 0;
        }
        return this.obterCloneBigDecimalParaExibicao().compareTo(valorBigDecimal) >= 0;
    }

    public boolean ehMaiorQue(BigDecimal valorBigDecimal, boolean valorParaCalculo) {
        this.vazio = false;
        if (valorParaCalculo) {
            return this.obterCloneBigDecimalParaCalculo().compareTo(valorBigDecimal) > 0;
        }
        return this.obterCloneBigDecimalParaExibicao().compareTo(valorBigDecimal) > 0;
    }

    public boolean ehMenorQue(long valorLong, boolean valorParaCalculo) {
        this.vazio = false;
        if (valorParaCalculo) {
            return this.obterCloneBigDecimalParaCalculo().compareTo(new BigDecimal(valorLong)) < 0;
        }
        return this.obterCloneBigDecimalParaExibicao().compareTo(new BigDecimal(valorLong)) < 0;
    }

    public boolean ehMenorOuIgualA(long valorLong, boolean valorParaCalculo) {
        this.vazio = false;
        if (valorParaCalculo) {
            return this.obterCloneBigDecimalParaCalculo().compareTo(new BigDecimal(valorLong)) <= 0;
        }
        return this.obterCloneBigDecimalParaExibicao().compareTo(new BigDecimal(valorLong)) <= 0;
    }

    public boolean ehIgualA(long valorLong, boolean valorParaCalculo) {
        this.vazio = false;
        if (valorParaCalculo) {
            return this.obterCloneBigDecimalParaCalculo().compareTo(new BigDecimal(valorLong)) == 0;
        }
        return this.obterCloneBigDecimalParaExibicao().compareTo(new BigDecimal(valorLong)) == 0;
    }

    public boolean ehDiferenteDe(long valorLong, boolean valorParaCalculo) {
        this.vazio = false;
        if (valorParaCalculo) {
            return this.obterCloneBigDecimalParaCalculo().compareTo(new BigDecimal(valorLong)) != 0;
        }
        return this.obterCloneBigDecimalParaExibicao().compareTo(new BigDecimal(valorLong)) != 0;
    }

    public boolean ehMaiorOuIgualA(long valorLong, boolean valorParaCalculo) {
        this.vazio = false;
        if (valorParaCalculo) {
            return this.obterCloneBigDecimalParaCalculo().compareTo(new BigDecimal(valorLong)) >= 0;
        }
        return this.obterCloneBigDecimalParaExibicao().compareTo(new BigDecimal(valorLong)) >= 0;
    }

    public boolean ehMaiorQue(long valorLong, boolean valorParaCalculo) {
        this.vazio = false;
        if (valorParaCalculo) {
            return this.obterCloneBigDecimalParaCalculo().compareTo(new BigDecimal(valorLong)) > 0;
        }
        return this.obterCloneBigDecimalParaExibicao().compareTo(new BigDecimal(valorLong)) > 0;
    }

    public ValorBigDecimalGCAP operacao(char pOperacao, String pVal) {
        ValorBigDecimalGCAP val = new ValorBigDecimalGCAP(pVal);
        return this.operacao(pOperacao, val);
    }

    public ValorBigDecimalGCAP operacao(char pOperacao, ValorBigDecimalGCAP pVal) {
        ValorBigDecimalGCAP retorno = this.obterCloneValorBigDecimalParaCalculo(false);
        pVal.setObservadoresAtivos(false);
        pVal.setValidadoresAtivos(false);
        switch (pOperacao) {
            case '+': {
                retorno.somar(pVal.getConteudoBigDecimal());
                break;
            }
            case '-': {
                retorno.subtrair(pVal.getConteudoBigDecimal());
                break;
            }
            case '*': {
                retorno.multiplicar(pVal.getConteudoBigDecimal());
                break;
            }
            case '/': {
                retorno.dividir(pVal.getConteudoBigDecimal());
                break;
            }
            case '%': {
                retorno.obterResto(pVal.getConteudoBigDecimal());
                break;
            }
            default: {
                throw new IllegalArgumentException("Sinal de Opera\u00e7\u00e3o '" + pOperacao + "' inv\u00e1lido!!!");
            }
        }
        pVal.setObservadoresAtivos(true);
        pVal.setValidadoresAtivos(true);
        return retorno;
    }

    public boolean comparacao(String pComp, ValorBigDecimalGCAP pVal) {
        boolean retorno = false;
        this.setObservadoresAtivos(false);
        this.setValidadoresAtivos(false);
        pVal.setObservadoresAtivos(false);
        pVal.setValidadoresAtivos(false);
        if (pComp.equals(">")) {
            retorno = this.ehMaiorQue(pVal.getConteudoBigDecimal(), true);
        } else if (pComp.equals(">=")) {
            retorno = this.ehMaiorOuIgualA(pVal.getConteudoBigDecimal(), true);
        } else if (pComp.equals("<")) {
            retorno = this.ehMenorQue(pVal.getConteudoBigDecimal(), true);
        } else if (pComp.equals("<=")) {
            retorno = this.ehMenorOuIgualA(pVal.getConteudoBigDecimal(), true);
        } else if (pComp.equals("=")) {
            retorno = this.equals((Object)pVal);
        } else if (pComp.equals("!=") || pComp.equals("<>")) {
            retorno = !this.equals((Object)pVal);
        }
        this.setObservadoresAtivos(true);
        this.setValidadoresAtivos(true);
        pVal.setObservadoresAtivos(true);
        pVal.setValidadoresAtivos(true);
        return retorno;
    }

    public boolean comparacao(String pComp, String pVal) {
        ValorBigDecimalGCAP m = new ValorBigDecimalGCAP(pVal);
        return this.comparacao(pComp, m);
    }

    public void append(char pOperacao, ValorBigDecimalGCAP pVal) {
        ValorBigDecimalGCAP operado = this.operacao(pOperacao, pVal);
        this.setConteudo(operado);
    }

    public void append(char pOperacao, String pVal) {
        this.setConteudo(this.operacao(pOperacao, pVal));
    }

    public String asTxt() {
        Object negativo = "";
        if (this.conteudo.compareTo(BigInteger.ZERO) < 0) {
            negativo = (String)negativo + "-";
        }
        return (String)negativo + this.getParteInteira() + this.getParteDecimal();
    }

    public ValorBigDecimalGCAP getValorAbsoluto() {
        ValorBigDecimalGCAP result = new ValorBigDecimalGCAP();
        result.setCasasDecimais(this.getCasasDecimais());
        result.setConteudo(this.conteudo.abs());
        return result;
    }

    public boolean isCampoCalculado() {
        return this.campoCalculado;
    }

    public void setCampoCalculado(boolean campoCalculado) {
        this.campoCalculado = campoCalculado;
    }

    public int getMaximoDigitosParteInteira() {
        return this.maximoDigitosParteInteira;
    }

    public void setMaximoDigitosParteInteira(int maximoParteInteira) {
        this.maximoDigitosParteInteira = maximoParteInteira;
    }

    public String getMsgErroEstourodigitos() {
        return this.msgErroEstourodigitos;
    }

    public void setMsgErroEstourodigitos(String msgErroEstourodigitos) {
        this.msgErroEstourodigitos = msgErroEstourodigitos;
    }

    public byte getSeveridadeValidacaoMaximoDigitos() {
        return this.severidadeValidacaoMaximoDigitos;
    }

    public void setSeveridadeValidacaoMaximoDigitos(byte severidadeValidacaoMaximoDigitos) {
        this.severidadeValidacaoMaximoDigitos = severidadeValidacaoMaximoDigitos;
    }

    public void append(char operacao, Valor val) {
        this.append(operacao, (ValorBigDecimalGCAP)val);
    }

    public void arredonda(int qtdCasas, int piso) {
    }

    public boolean comparacao(String comp, Valor val) {
        return this.comparacao(comp, (ValorBigDecimalGCAP)val);
    }

    public int compareTo(Valor o) {
        return this.compareTo((ValorBigDecimalGCAP)o);
    }

    public Long getParteInteiraAsLong() {
        throw new RuntimeException("O m\u00e9todo 'getParteInteiraAsLong()' que retorna um objeto do tipo Long n\u00e3o pode ser utilizado quando se trata de um ValorBigDecimal porque o ValorBigDecimal possui um conte\u00fado interno do tipo BigInteger e N\u00c3O Long. O valor do conte\u00fado poderia ser truncado indevidamente.");
    }

    public int getPisoArredondamento() {
        return 0;
    }

    public int getTratamentocasasDecimais() {
        return Valor.ARREDONDA;
    }

    public Valor operacao(char operacao, Valor val) {
        return this.operacao(operacao, (ValorBigDecimalGCAP)val);
    }

    public void setConteudo(Long conteudo) {
        this.setConteudo(new BigInteger(conteudo.toString()));
    }

    public void setConteudo(Valor conteudo) {
        this.setConteudo((ValorBigDecimalGCAP)conteudo);
    }

    public void setPisoArredondamento(int pisoArredondamento) {
    }

    public void setTratamentocasasDecimais(int tratamentocasasDecimais) {
    }

    public void converteQtdCasasDecimais(int pCasasDecimais) {
        this.converteQtdCasasDecimais(pCasasDecimais, true);
    }

    public void converteQtdCasasDecimais(int pCasasDecimais, boolean arredondar) {
        if (this.getCasasDecimais() == pCasasDecimais) {
            return;
        }
        BigDecimal lNovoValor = null;
        lNovoValor = arredondar ? this.obterCloneBigDecimalParaCalculo().setScale(pCasasDecimais, METODO_ARREDONDAMENTO) : this.obterCloneBigDecimalParaCalculo().setScale(pCasasDecimais, METODO_TRUNCAMENTO);
        this.setCasasDecimais(pCasasDecimais);
        this.setConteudo(lNovoValor);
    }

    public void converteQtdCasasDecimaisRoundUp(int pCasasDecimais) {
        if (this.getCasasDecimais() == pCasasDecimais) {
            return;
        }
        BigDecimal lNovoValor = this.obterCloneBigDecimalParaCalculo().setScale(pCasasDecimais, RoundingMode.UP);
        this.setCasasDecimais(pCasasDecimais);
        this.setConteudo(lNovoValor);
    }
}

