/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.impostopago;

import java.util.List;
import serpro.ppgd.irpf.ValorPositivo;
import serpro.ppgd.irpf.gui.impostopago.PainelImpostoPago;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorDefault;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.Valor;

public class ImpostoPago
extends ObjetoNegocio
implements ObjetoFicha {
    private ValorPositivo impostoComplementar = new ValorPositivo(this, "imposto Complementar");
    private ValorPositivo impostoPagoExterior = new ValorPositivo(this, "Imposto pago no exterior");
    private Valor impostoDevidoComRendExterior = new Valor((ObjetoNegocio)this, "imposto Devido Com Rend Exterior");
    private Valor impostoDevidoSemRendExterior = new Valor((ObjetoNegocio)this, "imposto Devido Sem Rend Exterior");
    private Valor limiteImpPagoExterior = new Valor((ObjetoNegocio)this, "limite Imp Pago Exterior");
    private ValorPositivo impostoRetidoFonte = new ValorPositivo(this, "Imposto sobre a renda na fonte");
    private Valor impostoRetidoFonteTitular = new Valor((ObjetoNegocio)this, "Imposto retido na fonte do titular");
    private Valor impostoRetidoFonteDependentes = new Valor((ObjetoNegocio)this, "Imposto retido na fonte dos dependentes");
    private Valor carneLeaoTitular = new Valor((ObjetoNegocio)this, "Carn\u00ea Le\u00e3o do Titular");
    private Valor carneLeaoDependentes = new Valor((ObjetoNegocio)this, "Carn\u00ea Le\u00e3o dos Dependentes");

    public ImpostoPago() {
        this.impostoPagoExterior.addValidador((ValidadorIf)new ValidadorDefault(1){

            public RetornoValidacao validarImplementado() {
                this.setExibePopup(true);
                if (ImpostoPago.this.impostoPagoExterior.comparacao(">", ImpostoPago.this.limiteImpPagoExterior)) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("imposto_pago_exterior_limite"), this.getSeveridade());
                }
                return null;
            }
        });
        this.impostoDevidoComRendExterior.setReadOnly(true);
        this.impostoDevidoSemRendExterior.setReadOnly(true);
        this.limiteImpPagoExterior.setReadOnly(true);
        this.impostoRetidoFonteTitular.setReadOnly(true);
        this.impostoRetidoFonteDependentes.setReadOnly(true);
        this.carneLeaoTitular.setReadOnly(true);
        this.carneLeaoDependentes.setReadOnly(true);
        this.setFicha("Imposto Pago");
    }

    public ValorPositivo getImpostoComplementar() {
        return this.impostoComplementar;
    }

    public ValorPositivo getImpostoPagoExterior() {
        return this.impostoPagoExterior;
    }

    public ValorPositivo getImpostoRetidoFonte() {
        return this.impostoRetidoFonte;
    }

    public Valor getImpostoDevidoComRendExterior() {
        return this.impostoDevidoComRendExterior;
    }

    public Valor getImpostoDevidoSemRendExterior() {
        return this.impostoDevidoSemRendExterior;
    }

    public Valor getLimiteImpPagoExterior() {
        return this.limiteImpPagoExterior;
    }

    public Valor getImpostoRetidoFonteTitular() {
        return this.impostoRetidoFonteTitular;
    }

    public Valor getImpostoRetidoFonteDependentes() {
        return this.impostoRetidoFonteDependentes;
    }

    public Valor getCarneLeaoTitular() {
        return this.carneLeaoTitular;
    }

    public Valor getCarneLeaoDependentes() {
        return this.carneLeaoDependentes;
    }

    protected List<Informacao> recuperarListaCamposPendencia() {
        List retorno = super.recuperarListaCamposPendencia();
        retorno.add(this.getImpostoRetidoFonte());
        return retorno;
    }

    public String getClasseFicha() {
        return PainelImpostoPago.class.getName();
    }

    public String getNomeAba() {
        return null;
    }

    public String getTituloFichaDashboard() {
        return "Imposto Pago/Retido";
    }
}

