/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.pagamentos;

import java.lang.ref.WeakReference;
import java.util.List;
import serpro.ppgd.cacheni.CacheNI;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.ValidadorNaoNuloIRPF;
import serpro.ppgd.irpf.ValorPositivo;
import serpro.ppgd.irpf.alimentandos.Alimentando;
import serpro.ppgd.irpf.alimentandos.Alimentandos;
import serpro.ppgd.irpf.calculos.CalculosPagamentos;
import serpro.ppgd.irpf.gui.pagamentos.PainelPagamentosLista;
import serpro.ppgd.irpf.pagamentos.ObservadorLimpaNomeDependente;
import serpro.ppgd.irpf.pagamentos.Pagamentos;
import serpro.ppgd.irpf.tabelas.CadastroTabelasIRPF;
import serpro.ppgd.irpf.tabelas.TabelaAliquotasIRPF;
import serpro.ppgd.irpf.util.ConstantesGlobaisIRPF;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.irpf.util.ObjetoComChaveIRPF;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.CPF;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.NI;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorDefault;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.Valor;
import serpro.ppgd.negocio.util.UtilitariosString;
import serpro.ppgd.negocio.util.Validador;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorCodigo;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNIT;

public class Pagamento
extends ObjetoNegocio
implements ObjetoComChaveIRPF,
ObjetoFicha {
    public static final String PAGAMENTO_INSTRUCAO_BR = "01";
    public static final String PAGAMENTO_INSTRUCAO_EX = "02";
    public static final String PAGAMENTO_FONOAUDIOLOGO_BR = "09";
    public static final String PAGAMENTO_MEDICO_BR = "10";
    public static final String PAGAMENTO_DENTISTA_BR = "11";
    public static final String PAGAMENTO_PSICOLOGO_BR = "12";
    public static final String PAGAMENTO_FISIOTERAPEUTA_BR = "13";
    public static final String PAGAMENTO_TERAPEUTA_OCUPACIONAL_BR = "14";
    public static final String PAGAMENTO_MEDICO_EX = "15";
    public static final String PAGAMENTO_DENTISTA_EX = "16";
    public static final String PAGAMENTO_PSICOLOGO_EX = "17";
    public static final String PAGAMENTO_FISIOTERAPEUTA_EX = "18";
    public static final String PAGAMENTO_TERAPEUTA_OCUPACIONAL_EX = "19";
    public static final String PAGAMENTO_FONOAUDIOLOGO_EX = "20";
    public static final String PAGAMENTO_HOSPITAL_BR = "21";
    public static final String PAGAMENTO_HOSPITAL_EX = "22";
    public static final String PAGAMENTO_PLANOSAUDE_BR = "26";
    public static final String PAGAMENTO_PENSAOALIMENTICIA_BR = "30";
    public static final String PAGAMENTO_PENSAOALIMENTICIA_EX = "31";
    public static final String PAGAMENTO_PENSAODIVORCIO_BR = "33";
    public static final String PAGAMENTO_PENSAODIVORCIO_EX = "34";
    public static final String PAGAMENTO_PREVIPRIVADA = "36";
    public static final String PAGAMENTO_FUNPRESP = "37";
    public static final String PAGAMENTO_FAPI = "38";
    public static final String PAGAMENTO_CONTRIBUICAO_PATRONAL = "50";
    public static final String PAGAMENTO_ADVOGADOS = "60";
    public static final String PAGAMENTO_ADVOGADOS_TRAB = "61";
    public static final String PAGAMENTO_ADVOGADOS_HONORARIOS = "62";
    public static final String PAGAMENTO_PROFLIBERAL = "66";
    public static final String PAGAMENTO_ALUGUEIS = "70";
    public static final String PAGAMENTO_ADMINISTRADOR_IMOVEL = "71";
    public static final String PAGAMENTO_CORRETOR_IMOVEIS = "72";
    public static final String PAGAMENTO_ARRENDRURAL = "76";
    public static final String PAGAMENTO_OUTROS = "99";
    public static final String NOME_CAMPO_LOCAL_PAIS = "Localiza\u00e7\u00e3o (Pa\u00eds)";
    public static final String NOME_CODIGO = "C\u00f3digo";
    public static final String NOME_TIPO = "Tipo";
    private Codigo codigo = new Codigo((ObjetoNegocio)this, "C\u00f3digo", CadastroTabelasIRPF.recuperarTipoPagamentos());
    private Alfa tipo = new Alfa((ObjetoNegocio)this, "Tipo");
    public static final String TIPO_TITULAR = "T";
    public static final String TIPO_DEPENDENTE = "D";
    public static final String TIPO_ALIMENTANDO = "A";
    public static final String TIPO_PADRAO = "V";
    private Alfa dependenteOuAlimentando = new Alfa((ObjetoNegocio)this, "Dependente/Alimentando", 60);
    private Alfa nomeBeneficiario = new Alfa((ObjetoNegocio)this, "Nome do Benefici\u00e1rio", 60);
    private NI niBeneficiario = new NI((ObjetoNegocio)this, "CPF/CNPJ do Beneficiario");
    private ValorPositivo valorPago = new ValorPositivo(this, "Valor Pago");
    private ValorPositivo parcelaNaoDedutivel = new ValorPositivo(this, "Parcela N\u00e3o Dedut\u00edvel/Valor Reembolsado");
    private ValorPositivo contribuicaoEntePatrocinador = new ValorPositivo(this, "Contribui\u00e7\u00e3o do ente p\u00fablico patrocinador");
    private Alfa nitEmpregadoDomestico = new Alfa((ObjetoNegocio)this, "NIT do empregado dom\u00e9stico");
    private Alfa indice = new Alfa((ObjetoNegocio)this, "\u00cdndice");
    private CPF cpfDependente = new CPF((ObjetoNegocio)this, "CPF Dependente");
    private CPF cpfAlimentando = new CPF((ObjetoNegocio)this, "CPF Alimentando");
    private Alfa descricao = new Alfa((ObjetoNegocio)this, "Descri\u00e7\u00e3o", 60);
    private Codigo pais = new Codigo((ObjetoNegocio)this, "Localiza\u00e7\u00e3o (Pa\u00eds)", CadastroTabelasIRPF.recuperarPaisesExterior());
    protected transient IdentificadorDeclaracao identificadorDeclaracao = null;
    private WeakReference<DeclaracaoIRPF> declaracaoRef = null;

    public Pagamento(DeclaracaoIRPF dec) {
        this.identificadorDeclaracao = dec.getIdentificadorDeclaracao();
        this.declaracaoRef = new WeakReference<DeclaracaoIRPF>(dec);
        CacheNI.getInstancia().registrarNINome(this.niBeneficiario, this.nomeBeneficiario);
        this.tipo.addObservador((Observador)new ObservadorLimpaNomeDependente(this));
        this.getCodigo().setColunaFiltro(1);
        this.getDependenteOuAlimentando().addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                DeclaracaoIRPF declaracaoIRPF = (DeclaracaoIRPF)((Object)Pagamento.this.declaracaoRef.get());
                if (Pagamento.TIPO_DEPENDENTE.equals(Pagamento.this.tipo.naoFormatado()) && !declaracaoIRPF.getDependentes().isExisteNome(Pagamento.this.getDependenteOuAlimentando().naoFormatado())) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("pagamento_dependente_nao_existe"), 3);
                }
                if (Pagamento.TIPO_ALIMENTANDO.equals(Pagamento.this.tipo.naoFormatado()) && !declaracaoIRPF.getAlimentandos().isExisteNome(Pagamento.this.getDependenteOuAlimentando().naoFormatado())) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("pagamento_alimentando_nao_existe"), 3);
                }
                return null;
            }
        });
        this.getNitEmpregadoDomestico().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3, MensagemUtil.getMensagem("pagamento_nit_branco")){

            @Override
            public RetornoValidacao validarImplementado() {
                if (Pagamento.this.codigo.naoFormatado().equals(Pagamento.PAGAMENTO_CONTRIBUICAO_PATRONAL)) {
                    return super.validarImplementado();
                }
                return null;
            }
        });
        this.getNitEmpregadoDomestico().addValidador((ValidadorIf)new ValidadorNIT(3, MensagemUtil.getMensagem("pagamento_nit_invalido")){

            public RetornoValidacao validarImplementado() {
                if (Pagamento.this.codigo.naoFormatado().equals(Pagamento.PAGAMENTO_CONTRIBUICAO_PATRONAL)) {
                    return super.validarImplementado();
                }
                return null;
            }
        });
        this.getCodigo().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                if (valorNovo != null && !valorNovo.toString().trim().equals("") && !Integer.valueOf(valorNovo.toString()).equals(-1)) {
                    Pagamento.this.nomeBeneficiario.setNomeCampo(MensagemUtil.getMensagem("nome_cod_beneficiario_" + valorNovo));
                    Pagamento.this.nomeBeneficiario.setNomeCampoCurto(MensagemUtil.getMensagem("nome_cod_beneficiario_" + valorNovo));
                    Pagamento.this.niBeneficiario.setNomeCampo(MensagemUtil.getMensagem("cpf_cnpj_cod_beneficiario_" + valorNovo));
                    Pagamento.this.niBeneficiario.setNomeCampoCurto(MensagemUtil.getMensagem("cpf_cnpj_cod_beneficiario_" + valorNovo));
                }
            }
        });
        this.getCodigo().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3, MensagemUtil.getMensagem("pagamento_codigo_invalido")){

            @Override
            public RetornoValidacao validarImplementado() {
                if (this.getInformacao().isVazio()) {
                    this.setMensagemValidacao(MensagemUtil.getMensagem("pagamento_codigo_branco"));
                }
                return super.validarImplementado();
            }
        });
        this.getCodigo().addValidador((ValidadorIf)new ValidadorCodigo(3, MensagemUtil.getMensagem("pagamento_codigo_invalido")));
        this.getNomeBeneficiario().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3){

            @Override
            public RetornoValidacao validarImplementado() {
                boolean validar = false;
                String codigoPagamento = Pagamento.this.getCodigo().getConteudoAtual(0);
                if (codigoPagamento.equals(Pagamento.PAGAMENTO_INSTRUCAO_EX) || codigoPagamento.equals(Pagamento.PAGAMENTO_MEDICO_EX) || codigoPagamento.equals(Pagamento.PAGAMENTO_DENTISTA_EX) || codigoPagamento.equals(Pagamento.PAGAMENTO_PSICOLOGO_EX) || codigoPagamento.equals(Pagamento.PAGAMENTO_FISIOTERAPEUTA_EX) || codigoPagamento.equals(Pagamento.PAGAMENTO_TERAPEUTA_OCUPACIONAL_EX) || codigoPagamento.equals(Pagamento.PAGAMENTO_FONOAUDIOLOGO_EX) || codigoPagamento.equals(Pagamento.PAGAMENTO_HOSPITAL_EX)) {
                    this.setSeveridade((byte)3);
                    validar = true;
                } else if (!(codigoPagamento.isEmpty() || codigoPagamento.equals(Pagamento.PAGAMENTO_PENSAOALIMENTICIA_BR) || codigoPagamento.equals(Pagamento.PAGAMENTO_PENSAOALIMENTICIA_EX) || codigoPagamento.equals(Pagamento.PAGAMENTO_PENSAODIVORCIO_BR) || codigoPagamento.equals(Pagamento.PAGAMENTO_PENSAODIVORCIO_EX))) {
                    this.setSeveridade((byte)2);
                    validar = true;
                }
                if (validar && this.getInformacao().isVazio()) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("pagamento_beneficiario_branco", new String[]{Pagamento.this.getNomeBeneficiario().getNomeCampo()}), this.getSeveridade());
                }
                return null;
            }
        });
        this.getNiBeneficiario().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3){

            @Override
            public RetornoValidacao validarImplementado() {
                String codigoPagamento = Pagamento.this.getCodigo().getConteudoAtual(0);
                String mensagem = null;
                RetornoValidacao retornoValidacao = null;
                byte severidade = 0;
                if (codigoPagamento.equals(Pagamento.PAGAMENTO_FONOAUDIOLOGO_BR) || codigoPagamento.equals(Pagamento.PAGAMENTO_MEDICO_BR) || codigoPagamento.equals(Pagamento.PAGAMENTO_DENTISTA_BR) || codigoPagamento.equals(Pagamento.PAGAMENTO_PSICOLOGO_BR) || codigoPagamento.equals(Pagamento.PAGAMENTO_FISIOTERAPEUTA_BR) || codigoPagamento.equals(Pagamento.PAGAMENTO_TERAPEUTA_OCUPACIONAL_BR) || codigoPagamento.equals(Pagamento.PAGAMENTO_PROFLIBERAL) || codigoPagamento.equals(Pagamento.PAGAMENTO_CONTRIBUICAO_PATRONAL)) {
                    mensagem = this.getInformacao().isVazio() ? MensagemUtil.getMensagem("pagamento_cpf_beneficiario_branco", new String[]{Pagamento.this.niBeneficiario.getNomeCampo()}) : MensagemUtil.getMensagem("pagamento_cpf_beneficiario_invalido", new String[]{Pagamento.this.niBeneficiario.getNomeCampo()});
                    severidade = 3;
                    this.setSeveridade(severidade);
                    if (!Pagamento.this.getNiBeneficiario().isVazio()) {
                        retornoValidacao = Validador.validarCPF((String)UtilitariosString.retiraMascara((String)this.getInformacao().formatado()));
                    }
                } else if (codigoPagamento.equals(Pagamento.PAGAMENTO_PENSAOALIMENTICIA_EX) || codigoPagamento.equals(Pagamento.PAGAMENTO_PENSAODIVORCIO_EX)) {
                    if (!this.getInformacao().isVazio()) {
                        mensagem = MensagemUtil.getMensagem("pagamento_cpf_beneficiario_invalido", new String[]{Pagamento.this.niBeneficiario.getNomeCampo()});
                        severidade = 3;
                        this.setSeveridade(severidade);
                        retornoValidacao = Validador.validarCPF((String)UtilitariosString.retiraMascara((String)this.getInformacao().formatado()));
                    }
                } else if (codigoPagamento.equals(Pagamento.PAGAMENTO_PENSAOALIMENTICIA_BR) || codigoPagamento.equals(Pagamento.PAGAMENTO_PENSAODIVORCIO_BR)) {
                    if (this.getInformacao().isVazio()) {
                        if (!Pagamento.this.getDependenteOuAlimentando().isVazio()) {
                            String nomeAlimentando = Pagamento.this.getDependenteOuAlimentando().naoFormatado();
                            DeclaracaoIRPF declaracaoIRPF = (DeclaracaoIRPF)((Object)Pagamento.this.declaracaoRef.get());
                            Alimentandos alimentandos = declaracaoIRPF.getAlimentandos();
                            for (ObjetoNegocio alimentando : alimentandos.itens()) {
                                if (!((Alimentando)alimentando).getNome().naoFormatado().equals(nomeAlimentando)) continue;
                                Data dtNascimento = ((Alimentando)alimentando).getDtNascimento();
                                Data data18 = new Data();
                                int ano = Integer.parseInt(ConstantesGlobais.ANO_BASE) - 18;
                                data18.setConteudo("31/12/" + ano);
                                if (!dtNascimento.maisAntiga(data18) && !dtNascimento.igual(data18)) continue;
                                mensagem = MensagemUtil.getMensagem("pagamento_cpf_beneficiario_branco", new String[]{Pagamento.this.niBeneficiario.getNomeCampo() + " na ficha Alimentandos"});
                                severidade = 3;
                                this.setSeveridade(severidade);
                                break;
                            }
                        }
                    } else {
                        retornoValidacao = Validador.validarCPF((String)UtilitariosString.retiraMascara((String)this.getInformacao().formatado()));
                        severidade = 3;
                        this.setSeveridade(severidade);
                    }
                } else if (codigoPagamento.equals(Pagamento.PAGAMENTO_INSTRUCAO_BR) || codigoPagamento.equals(Pagamento.PAGAMENTO_HOSPITAL_BR) || codigoPagamento.equals(Pagamento.PAGAMENTO_PLANOSAUDE_BR) || codigoPagamento.equals(Pagamento.PAGAMENTO_PREVIPRIVADA) || codigoPagamento.equals(Pagamento.PAGAMENTO_FUNPRESP)) {
                    mensagem = this.getInformacao().isVazio() ? MensagemUtil.getMensagem("pagamento_cnpj_beneficiario_branco", new String[]{Pagamento.this.niBeneficiario.getNomeCampo()}) : MensagemUtil.getMensagem("pagamento_cnpj_beneficiario_invalido", new String[]{Pagamento.this.niBeneficiario.getNomeCampo()});
                    severidade = 3;
                    this.setSeveridade(severidade);
                    if (!Pagamento.this.getNiBeneficiario().isVazio()) {
                        retornoValidacao = Validador.validarCNPJ((String)UtilitariosString.retiraMascara((String)this.getInformacao().formatado()));
                    }
                } else if (codigoPagamento.equals(Pagamento.PAGAMENTO_ADVOGADOS) || codigoPagamento.equals(Pagamento.PAGAMENTO_ADVOGADOS_TRAB) || codigoPagamento.equals(Pagamento.PAGAMENTO_ADVOGADOS_HONORARIOS) || codigoPagamento.equals(Pagamento.PAGAMENTO_ALUGUEIS) || codigoPagamento.equals(Pagamento.PAGAMENTO_ADMINISTRADOR_IMOVEL) || codigoPagamento.equals(Pagamento.PAGAMENTO_CORRETOR_IMOVEIS) || codigoPagamento.equals(Pagamento.PAGAMENTO_ARRENDRURAL)) {
                    mensagem = this.getInformacao().isVazio() ? MensagemUtil.getMensagem("pagamento_ni_beneficiario_branco", new String[]{Pagamento.this.niBeneficiario.getNomeCampo()}) : MensagemUtil.getMensagem("pagamento_ni_beneficiario_invalido", new String[]{Pagamento.this.niBeneficiario.getNomeCampo()});
                    severidade = 3;
                    this.setSeveridade(severidade);
                    if (!Pagamento.this.getNiBeneficiario().isVazio()) {
                        retornoValidacao = Validador.validarNI((String)UtilitariosString.retiraMascara((String)this.getInformacao().formatado()));
                    }
                } else if (codigoPagamento.equals(Pagamento.PAGAMENTO_OUTROS)) {
                    if (!this.getInformacao().isVazio()) {
                        mensagem = MensagemUtil.getMensagem("pagamento_ni_beneficiario_invalido", new String[]{Pagamento.this.niBeneficiario.getNomeCampo()});
                        severidade = 3;
                        this.setSeveridade(severidade);
                        retornoValidacao = Validador.validarNI((String)UtilitariosString.retiraMascara((String)this.getInformacao().formatado()));
                    } else {
                        mensagem = MensagemUtil.getMensagem("pagamento_ni_beneficiario_branco", new String[]{Pagamento.this.niBeneficiario.getNomeCampo()});
                        severidade = 2;
                        this.setSeveridade(severidade);
                    }
                } else {
                    mensagem = null;
                    retornoValidacao = null;
                }
                if (Pagamento.this.tipo.formatado().equals(Pagamento.TIPO_DEPENDENTE) && Pagamento.this.getCPFDependente().formatado().equals(Pagamento.this.getNiBeneficiario().formatado())) {
                    mensagem = MensagemUtil.getMensagem("pagamento_beneficiario_dependente_igual");
                    severidade = 3;
                    retornoValidacao = new RetornoValidacao(mensagem, severidade);
                } else if (!codigoPagamento.equals(Pagamento.PAGAMENTO_PENSAOALIMENTICIA_BR) && !codigoPagamento.equals(Pagamento.PAGAMENTO_PENSAOALIMENTICIA_EX) && !codigoPagamento.equals(Pagamento.PAGAMENTO_PENSAODIVORCIO_BR) && !codigoPagamento.equals(Pagamento.PAGAMENTO_PENSAODIVORCIO_EX) && Pagamento.this.tipo.formatado().equals(Pagamento.TIPO_ALIMENTANDO) && Pagamento.this.getCPFAlimentando().formatado().equals(Pagamento.this.getNiBeneficiario().formatado())) {
                    mensagem = MensagemUtil.getMensagem("pagamento_beneficiario_alimentando_igual");
                    severidade = 3;
                    retornoValidacao = new RetornoValidacao(mensagem, severidade);
                }
                if ((Pagamento.this.getNiBeneficiario().isVazio() || retornoValidacao != null) && mensagem != null) {
                    return new RetornoValidacao(mensagem, severidade);
                }
                return null;
            }
        });
        this.getParcelaNaoDedutivel().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3){

            @Override
            public RetornoValidacao validarImplementado() {
                String codigoPagamento = Pagamento.this.getCodigo().getConteudoAtual(0);
                if ((codigoPagamento.equals(Pagamento.PAGAMENTO_INSTRUCAO_BR) || codigoPagamento.equals(Pagamento.PAGAMENTO_INSTRUCAO_EX) || codigoPagamento.equals(Pagamento.PAGAMENTO_FONOAUDIOLOGO_BR) || codigoPagamento.equals(Pagamento.PAGAMENTO_MEDICO_BR) || codigoPagamento.equals(Pagamento.PAGAMENTO_DENTISTA_BR) || codigoPagamento.equals(Pagamento.PAGAMENTO_PSICOLOGO_BR) || codigoPagamento.equals(Pagamento.PAGAMENTO_FISIOTERAPEUTA_BR) || codigoPagamento.equals(Pagamento.PAGAMENTO_TERAPEUTA_OCUPACIONAL_BR) || codigoPagamento.equals(Pagamento.PAGAMENTO_MEDICO_EX) || codigoPagamento.equals(Pagamento.PAGAMENTO_DENTISTA_EX) || codigoPagamento.equals(Pagamento.PAGAMENTO_PSICOLOGO_EX) || codigoPagamento.equals(Pagamento.PAGAMENTO_FISIOTERAPEUTA_EX) || codigoPagamento.equals(Pagamento.PAGAMENTO_TERAPEUTA_OCUPACIONAL_EX) || codigoPagamento.equals(Pagamento.PAGAMENTO_FONOAUDIOLOGO_EX) || codigoPagamento.equals(Pagamento.PAGAMENTO_HOSPITAL_BR) || codigoPagamento.equals(Pagamento.PAGAMENTO_HOSPITAL_EX) || codigoPagamento.equals(Pagamento.PAGAMENTO_PLANOSAUDE_BR) || codigoPagamento.equals(Pagamento.PAGAMENTO_PENSAOALIMENTICIA_BR) || codigoPagamento.equals(Pagamento.PAGAMENTO_PENSAOALIMENTICIA_EX) || codigoPagamento.equals(Pagamento.PAGAMENTO_PENSAODIVORCIO_BR) || codigoPagamento.equals(Pagamento.PAGAMENTO_PENSAODIVORCIO_EX) || codigoPagamento.equals(Pagamento.PAGAMENTO_PREVIPRIVADA) || codigoPagamento.equals(Pagamento.PAGAMENTO_CONTRIBUICAO_PATRONAL)) && Pagamento.this.getParcelaNaoDedutivel().comparacao(">", Pagamento.this.getValorPago())) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("pagamento_valor_reembolsado"), 3);
                }
                return null;
            }
        });
        this.getValorPago().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3){

            @Override
            public RetornoValidacao validarImplementado() {
                if (Pagamento.this.getCodigo().isVazio() && Pagamento.this.getNomeBeneficiario().isVazio() && Pagamento.this.getNiBeneficiario().isVazio() && Pagamento.this.getParcelaNaoDedutivel().isVazio()) {
                    return null;
                }
                super.setMensagemValidacao(Pagamento.this.getCodigo().naoFormatado().equals(Pagamento.PAGAMENTO_CONTRIBUICAO_PATRONAL) ? MensagemUtil.getMensagem("pagamento_empregado_valor_pago_branco") : MensagemUtil.getMensagem("pagamento_valor_pago_branco"));
                return super.validarImplementado();
            }
        });
        this.getDependenteOuAlimentando().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3){

            @Override
            public RetornoValidacao validarImplementado() {
                String tipo = Pagamento.this.getTipo().naoFormatado();
                if (!tipo.equals(Pagamento.TIPO_TITULAR) && !tipo.equals(Pagamento.TIPO_PADRAO)) {
                    String msg = null;
                    if (tipo.equals(Pagamento.TIPO_DEPENDENTE)) {
                        msg = MensagemUtil.getMensagem("pagamento_nome_dependente_alimentando_branco", new String[]{"dependente"});
                        this.getInformacao().setNomeCampoCurto("Nome do dependente");
                    } else {
                        msg = MensagemUtil.getMensagem("pagamento_nome_dependente_alimentando_branco", new String[]{"alimentando"});
                        this.getInformacao().setNomeCampoCurto("Nome do alimentando");
                    }
                    this.setMensagemValidacao(msg);
                    return super.validarImplementado();
                }
                return null;
            }
        });
        this.getNiBeneficiario().addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                if (Pagamento.this.getNiBeneficiario().naoFormatado().equals(Pagamento.this.identificadorDeclaracao.getCpf().naoFormatado())) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("pagamento_cpf_beneficiario_igual", new String[]{MensagemUtil.getMensagem("cpf_cnpj_cod_beneficiario_" + Pagamento.this.getCodigo())}), 3);
                }
                return null;
            }
        });
        this.getTipo().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3, MensagemUtil.getMensagem("pagamento_tipo_pagamento_vazio")){

            @Override
            public RetornoValidacao validarImplementado() {
                String codigoPagamento = Pagamento.this.getCodigo().naoFormatado();
                if (!(codigoPagamento.equals(Pagamento.PAGAMENTO_PENSAOALIMENTICIA_BR) || codigoPagamento.equals(Pagamento.PAGAMENTO_PENSAOALIMENTICIA_EX) || codigoPagamento.equals(Pagamento.PAGAMENTO_PENSAODIVORCIO_BR) || codigoPagamento.equals(Pagamento.PAGAMENTO_PENSAODIVORCIO_EX) || codigoPagamento.equals(Pagamento.PAGAMENTO_CONTRIBUICAO_PATRONAL) || codigoPagamento.equals(Pagamento.PAGAMENTO_ADVOGADOS) || codigoPagamento.equals(Pagamento.PAGAMENTO_ADVOGADOS_TRAB) || codigoPagamento.equals(Pagamento.PAGAMENTO_ADVOGADOS_HONORARIOS) || codigoPagamento.equals(Pagamento.PAGAMENTO_PROFLIBERAL) || codigoPagamento.equals(Pagamento.PAGAMENTO_ALUGUEIS) || codigoPagamento.equals(Pagamento.PAGAMENTO_ADMINISTRADOR_IMOVEL) || codigoPagamento.equals(Pagamento.PAGAMENTO_CORRETOR_IMOVEIS) || codigoPagamento.equals(Pagamento.PAGAMENTO_ARRENDRURAL) || !Pagamento.this.getTipo().naoFormatado().equals(Pagamento.TIPO_PADRAO))) {
                    return new RetornoValidacao(3);
                }
                return null;
            }
        });
        this.getDescricao().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3, MensagemUtil.getMensagem("pagamento_descricao_branco")){

            @Override
            public RetornoValidacao validarImplementado() {
                if (Pagamento.this.codigo.naoFormatado().equals(Pagamento.PAGAMENTO_OUTROS)) {
                    return super.validarImplementado();
                }
                return null;
            }
        });
        this.getPais().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3, MensagemUtil.getMensagem("msg_validador_nao_nulo", new String[]{this.getPais().getNomeCampo()})){

            @Override
            public RetornoValidacao validarImplementado() {
                if (Pagamento.this.isPagamentoExterior(Pagamento.this.getCodigo().naoFormatado())) {
                    return super.validarImplementado();
                }
                return null;
            }
        });
    }

    public Codigo getCodigo() {
        return this.codigo;
    }

    public NI getNiBeneficiario() {
        return this.niBeneficiario;
    }

    public Alfa getNomeBeneficiario() {
        return this.nomeBeneficiario;
    }

    public Valor getParcelaNaoDedutivel() {
        return this.parcelaNaoDedutivel;
    }

    public Valor getContribuicaoEntePatrocinador() {
        return this.contribuicaoEntePatrocinador;
    }

    public Valor getValorPago() {
        return this.valorPago;
    }

    public Alfa getDependenteOuAlimentando() {
        return this.dependenteOuAlimentando;
    }

    protected List<Informacao> recuperarListaCamposPendencia() {
        List retorno = super.recuperarListaCamposPendencia();
        retorno.add(this.codigo);
        retorno.add(this.dependenteOuAlimentando);
        retorno.add(this.nomeBeneficiario);
        retorno.add(this.niBeneficiario);
        retorno.add(this.nitEmpregadoDomestico);
        retorno.add(this.valorPago);
        retorno.add(this.parcelaNaoDedutivel);
        retorno.add(this.contribuicaoEntePatrocinador);
        retorno.add(this.tipo);
        retorno.add(this.descricao);
        retorno.add(this.pais);
        return retorno;
    }

    public Alfa getNitEmpregadoDomestico() {
        return this.nitEmpregadoDomestico;
    }

    public boolean isVazio() {
        if (!ConstantesGlobaisIRPF.PERMITIR_DEDUCAO_CONTRIBUICAO_PATRONAL && PAGAMENTO_CONTRIBUICAO_PATRONAL.equals(this.getCodigo().naoFormatado())) {
            return true;
        }
        for (Informacao informacao : this.recuperarCamposInformacao()) {
            if (informacao.isVazio() || informacao.getNomeCampo().equals("\u00cdndice") || informacao.getNomeCampo().equals(NOME_TIPO) || informacao.getNomeCampo().equals(NOME_CODIGO)) continue;
            return false;
        }
        return true;
    }

    public int compareTo(Object o) {
        Pagamento pgto = (Pagamento)o;
        int cod = pgto.getCodigo().asInteger();
        return cod - this.getCodigo().asInteger();
    }

    public String getChave() {
        return this.getCodigo().naoFormatado();
    }

    @Override
    public Alfa getIndice() {
        return this.indice;
    }

    public Alfa getTipo() {
        return this.tipo;
    }

    public CPF getCPFDependente() {
        return this.cpfDependente;
    }

    public CPF getCPFAlimentando() {
        return this.cpfAlimentando;
    }

    public Alfa getDescricao() {
        return this.descricao;
    }

    public Pagamento obterCopia() {
        Pagamento copia = new Pagamento(IRPFFacade.getInstancia().getDeclaracao());
        copia.getCodigo().setConteudo(this.getCodigo());
        copia.getTipo().setConteudo(this.getTipo());
        copia.getDependenteOuAlimentando().setConteudo(this.getDependenteOuAlimentando());
        copia.getNomeBeneficiario().setConteudo(this.getNomeBeneficiario());
        copia.getNiBeneficiario().setConteudo(this.getNiBeneficiario());
        copia.getValorPago().setConteudo(this.getValorPago());
        copia.getParcelaNaoDedutivel().setConteudo(this.getParcelaNaoDedutivel());
        copia.getContribuicaoEntePatrocinador().setConteudo(this.getContribuicaoEntePatrocinador());
        copia.getNitEmpregadoDomestico().setConteudo(this.getNitEmpregadoDomestico());
        copia.getIndice().setConteudo(this.getIndice());
        copia.getCPFDependente().setConteudo(this.getCPFDependente());
        copia.getCPFAlimentando().setConteudo(this.getCPFAlimentando());
        copia.getDescricao().setConteudo(this.getDescricao());
        return copia;
    }

    public boolean ehTitularBrasil() {
        return this.getTipo().naoFormatado().equals(TIPO_TITULAR) && this.getCodigo().naoFormatado().equals(PAGAMENTO_INSTRUCAO_BR);
    }

    public boolean ehTitularExterior() {
        return this.getTipo().naoFormatado().equals(TIPO_TITULAR) && this.getCodigo().naoFormatado().equals(PAGAMENTO_INSTRUCAO_EX);
    }

    public boolean ehDependenteBrasil() {
        return this.getTipo().naoFormatado().equals(TIPO_DEPENDENTE) && this.getCodigo().naoFormatado().equals(PAGAMENTO_INSTRUCAO_BR);
    }

    public boolean ehDependenteExterior() {
        return this.getTipo().naoFormatado().equals(TIPO_DEPENDENTE) && this.getCodigo().naoFormatado().equals(PAGAMENTO_INSTRUCAO_EX);
    }

    public boolean ehAlimentandoBrasil() {
        return this.getTipo().naoFormatado().equals(TIPO_ALIMENTANDO) && this.getCodigo().naoFormatado().equals(PAGAMENTO_INSTRUCAO_BR);
    }

    public boolean ehAlimentandoExterior() {
        return this.getTipo().naoFormatado().equals(TIPO_ALIMENTANDO) && this.getCodigo().naoFormatado().equals(PAGAMENTO_INSTRUCAO_EX);
    }

    public boolean isPensao() {
        return this.getCodigo().naoFormatado().equals(PAGAMENTO_PENSAOALIMENTICIA_BR) || this.getCodigo().naoFormatado().equals(PAGAMENTO_PENSAOALIMENTICIA_EX) || this.getCodigo().naoFormatado().equals(PAGAMENTO_PENSAODIVORCIO_BR) || this.getCodigo().naoFormatado().equals(PAGAMENTO_PENSAODIVORCIO_EX);
    }

    public boolean isPrevidenciaPrivada() {
        return this.getCodigo().naoFormatado().equals(PAGAMENTO_PREVIPRIVADA);
    }

    public boolean isFunpresp() {
        return this.getCodigo().naoFormatado().equals(PAGAMENTO_FUNPRESP);
    }

    public boolean isSomenteTitular() {
        return this.getCodigo().naoFormatado().equals(PAGAMENTO_CONTRIBUICAO_PATRONAL) || this.getCodigo().naoFormatado().equals(PAGAMENTO_ADVOGADOS) || this.getCodigo().naoFormatado().equals(PAGAMENTO_ADVOGADOS_TRAB) || this.getCodigo().naoFormatado().equals(PAGAMENTO_ADVOGADOS_HONORARIOS) || this.getCodigo().naoFormatado().equals(PAGAMENTO_PROFLIBERAL) || this.getCodigo().naoFormatado().equals(PAGAMENTO_ALUGUEIS) || this.getCodigo().naoFormatado().equals(PAGAMENTO_ADMINISTRADOR_IMOVEL) || this.getCodigo().naoFormatado().equals(PAGAMENTO_CORRETOR_IMOVEIS) || this.getCodigo().naoFormatado().equals(PAGAMENTO_ARRENDRURAL);
    }

    public Valor getValorPagoFunprespCalculado() {
        Valor retorno = new Valor();
        if (this.getContribuicaoEntePatrocinador().comparacao("<", this.getValorPago())) {
            retorno.setConteudo(this.getContribuicaoEntePatrocinador());
        } else {
            retorno.setConteudo(this.getValorPago());
        }
        return retorno;
    }

    public Valor getValorPagoAtravesFunpresp() {
        Valor retorno = new Valor();
        if (this.getValorPago().comparacao(">", this.getContribuicaoEntePatrocinador())) {
            retorno.setConteudo(this.getValorPago().subtract(this.getContribuicaoEntePatrocinador()));
        }
        return retorno;
    }

    public String obterMensagemExcedeuLimiteDeducaoPrevPrivadaFunpresp() {
        boolean codigoValido = this.isFunpresp() || this.isPrevidenciaPrivada();
        String msg = null;
        if (codigoValido) {
            Pagamentos pagamentos = ((DeclaracaoIRPF)((Object)this.getDeclaracaoRef().get())).getPagamentos();
            Valor previdencia = CalculosPagamentos.totalizarPagamentosGlosado((Pagamentos)pagamentos, (String[])new String[]{PAGAMENTO_PREVIPRIVADA}, (boolean)true);
            Valor calculadoFunpresp = CalculosPagamentos.totalizarValorPagoAtravesFunpresp((Pagamentos)pagamentos);
            Valor prevPrivada = new Valor();
            prevPrivada.append('+', previdencia);
            prevPrivada.append('+', calculadoFunpresp);
            Valor totalLimitado = pagamentos.getTotalContribuicaoPreviPrivada();
            Valor totalRendimentosTributaveis = new Valor();
            totalRendimentosTributaveis.setConteudo(((DeclaracaoIRPF)((Object)this.getDeclaracaoRef().get())).getResumo().getRendimentosTributaveisDeducoes().getTotalRendimentos());
            Valor percentualPrevidencia = new Valor();
            percentualPrevidencia.setConteudo(TabelaAliquotasIRPF.ConstantesAliquotas.deducaoPrevidenciaPrivada.getValor());
            percentualPrevidencia.append('/', "100,00");
            Valor limiteDeducPrevPrivada = new Valor();
            limiteDeducPrevPrivada.setConteudo(totalRendimentosTributaveis);
            limiteDeducPrevPrivada.append('*', percentualPrevidencia);
            if (codigoValido && prevPrivada.comparacao(">", totalLimitado)) {
                msg = MensagemUtil.getMensagem("pagamento_limite_prevprivada", new String[]{prevPrivada.formatado(), totalLimitado.formatado(), previdencia.formatado(), calculadoFunpresp.formatado(), prevPrivada.formatado(), totalRendimentosTributaveis.formatado(), limiteDeducPrevPrivada.formatado(), TabelaAliquotasIRPF.ConstantesAliquotas.deducaoPrevidenciaPrivada.getValor().formatado()});
            }
        }
        return msg;
    }

    public void verificarLegadoPagamento() {
        DeclaracaoIRPF declaracaoIRPF = (DeclaracaoIRPF)((Object)this.declaracaoRef.get());
        if (this.getCodigo().naoFormatado().equals(PAGAMENTO_PENSAOALIMENTICIA_BR) || this.getCodigo().naoFormatado().equals(PAGAMENTO_PENSAODIVORCIO_BR)) {
            if (!this.getDependenteOuAlimentando().isVazio()) {
                for (Alimentando alimentando : declaracaoIRPF.getAlimentandos().itens()) {
                    if (!this.getDependenteOuAlimentando().naoFormatado().equals(alimentando.getNome().naoFormatado()) || !alimentando.getResidente().naoFormatado().equals("1")) continue;
                    this.getDependenteOuAlimentando().clear();
                    this.getNiBeneficiario().clear();
                }
            }
        } else if (this.getCodigo().naoFormatado().equals(PAGAMENTO_PENSAOALIMENTICIA_EX) || this.getCodigo().naoFormatado().equals(PAGAMENTO_PENSAODIVORCIO_EX)) {
            if (!this.getDependenteOuAlimentando().isVazio()) {
                for (Alimentando alimentando : declaracaoIRPF.getAlimentandos().itens()) {
                    if (!this.getDependenteOuAlimentando().naoFormatado().equals(alimentando.getNome().naoFormatado()) || !alimentando.getResidente().naoFormatado().equals("0")) continue;
                    this.getDependenteOuAlimentando().clear();
                    this.getNiBeneficiario().clear();
                }
            }
        } else if (this.getCodigo().naoFormatado().equals(PAGAMENTO_INSTRUCAO_EX) || this.getCodigo().naoFormatado().equals(PAGAMENTO_MEDICO_EX) || this.getCodigo().naoFormatado().equals(PAGAMENTO_DENTISTA_EX) || this.getCodigo().naoFormatado().equals(PAGAMENTO_PSICOLOGO_EX) || this.getCodigo().naoFormatado().equals(PAGAMENTO_FISIOTERAPEUTA_EX) || this.getCodigo().naoFormatado().equals(PAGAMENTO_TERAPEUTA_OCUPACIONAL_EX) || this.getCodigo().naoFormatado().equals(PAGAMENTO_FONOAUDIOLOGO_EX) || this.getCodigo().naoFormatado().equals(PAGAMENTO_HOSPITAL_EX)) {
            this.getNiBeneficiario().clear();
        }
    }

    public boolean isPagamentoExterior(String codigoPagamento) {
        return codigoPagamento.equals(PAGAMENTO_INSTRUCAO_EX) || codigoPagamento.equals(PAGAMENTO_MEDICO_EX) || codigoPagamento.equals(PAGAMENTO_DENTISTA_EX) || codigoPagamento.equals(PAGAMENTO_PSICOLOGO_EX) || codigoPagamento.equals(PAGAMENTO_FISIOTERAPEUTA_EX) || codigoPagamento.equals(PAGAMENTO_TERAPEUTA_OCUPACIONAL_EX) || codigoPagamento.equals(PAGAMENTO_FONOAUDIOLOGO_EX) || codigoPagamento.equals(PAGAMENTO_HOSPITAL_EX) || codigoPagamento.equals(PAGAMENTO_PENSAOALIMENTICIA_EX) || codigoPagamento.equals(PAGAMENTO_PENSAODIVORCIO_EX);
    }

    public WeakReference<DeclaracaoIRPF> getDeclaracaoRef() {
        return this.declaracaoRef;
    }

    public String getClasseFicha() {
        return PainelPagamentosLista.class.getName();
    }

    public String getNomeAba() {
        return null;
    }

    public String getTituloFichaDashboard() {
        return "Pagamentos Efetuados";
    }

    public Codigo getPais() {
        return this.pais;
    }
}

