/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.pagamentos;

import serpro.ppgd.irpf.gui.TableModelImportacao;
import serpro.ppgd.irpf.pagamentos.Pagamento;
import serpro.ppgd.irpf.pagamentos.Pagamentos;
import serpro.ppgd.negocio.Colecao;

public class TableModelImportacaoPagamentos
extends TableModelImportacao {
    private static final long serialVersionUID = 1L;

    public TableModelImportacaoPagamentos(Pagamentos colecao) {
        super((Colecao)colecao);
    }

    public int getColumnCount() {
        return 3;
    }

    public Object getValueAt(int row, int col) {
        Pagamento pagamento = (Pagamento)this.colecao.itens().get(row);
        switch (col) {
            case 0: {
                return super.getValueAt(row, col);
            }
            case 1: {
                int tipoPagamento = 0;
                try {
                    tipoPagamento = Integer.parseInt(pagamento.getCodigo().getConteudoAtual(0));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (tipoPagamento == 30 || tipoPagamento == 31 || tipoPagamento == 33 || tipoPagamento == 34) {
                    return pagamento.getDependenteOuAlimentando().naoFormatado();
                }
                return pagamento.getNomeBeneficiario().naoFormatado();
            }
            case 2: {
                return pagamento.getNiBeneficiario().formatado();
            }
        }
        return null;
    }

    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "";
            }
            case 1: {
                return "Nome do Benefici\u00e1rio";
            }
            case 2: {
                return "CPF/CNPJ do Benefici\u00e1rio";
            }
        }
        return null;
    }
}

