/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.rendIsentos;

import java.util.Iterator;
import serpro.ppgd.irpf.rendIsentos.ItemQuadroPensaoAlimenticia;
import serpro.ppgd.irpf.rendacm.RendAcmTitular;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Valor;

public class ColecaoItemQuadroPensaoAlimenticia
extends Colecao<ItemQuadroPensaoAlimenticia> {
    public static final int MAX_TAMANHO_DESCRICAO = 60;
    private transient RendAcmTitular rendAcm = null;
    private Valor totais = new Valor((ObjetoNegocio)this, "Totais");

    public ColecaoItemQuadroPensaoAlimenticia(RendAcmTitular rendAcm) {
        this.getTotais().setReadOnly(true);
        this.rendAcm = rendAcm;
    }

    public Valor getTotais() {
        return this.totais;
    }

    public void objetoInserido(ItemQuadroPensaoAlimenticia itemQuadroPensaoAlimenticia) {
        itemQuadroPensaoAlimenticia.getAlimentando().addObservador((Observador)this);
        itemQuadroPensaoAlimenticia.getValor().addObservador((Observador)this);
        this.recalculaTotal();
    }

    public void objetoRemovido(Object o) {
        ((ItemQuadroPensaoAlimenticia)((Object)o)).getAlimentando().removeObservador((Observador)this);
        ((ItemQuadroPensaoAlimenticia)((Object)o)).getValor().removeObservador((Observador)this);
        this.recalculaTotal();
    }

    public void recalculaTotal() {
        Iterator it = this.itens().iterator();
        this.totais.clear();
        while (it.hasNext()) {
            ItemQuadroPensaoAlimenticia ItemQuadroPensaoAlimenticia2 = (ItemQuadroPensaoAlimenticia)((Object)it.next());
            this.totais.append('+', ItemQuadroPensaoAlimenticia2.getValor());
        }
    }

    public String getDescricoes() {
        Object desc = "";
        Iterator it = this.itens().iterator();
        this.totais.clear();
        while (it.hasNext()) {
            ItemQuadroPensaoAlimenticia ItemQuadroPensaoAlimenticia2 = (ItemQuadroPensaoAlimenticia)((Object)it.next());
            if (!((String)desc).equals("")) {
                desc = (String)desc + ", ";
            }
            desc = (String)desc + ItemQuadroPensaoAlimenticia2.getAlimentando().naoFormatado();
        }
        if (((String)desc).length() > 60) {
            desc = ((String)desc).substring(0, 60);
        }
        return desc;
    }

    public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
        this.recalculaTotal();
    }

    public boolean existeAlimentando(String nomeAlimentando) {
        for (ItemQuadroPensaoAlimenticia participacao : this.itens()) {
            if (participacao.getAlimentando().naoFormatado().isEmpty() || !participacao.getAlimentando().naoFormatado().equals(nomeAlimentando)) continue;
            return true;
        }
        return false;
    }

    public void excluirAlimentando(String nomeAlimentando) {
        Iterator it = this.itens().iterator();
        while (it.hasNext()) {
            ItemQuadroPensaoAlimenticia participacao = (ItemQuadroPensaoAlimenticia)((Object)it.next());
            if (participacao.getAlimentando().naoFormatado().isEmpty() || !participacao.getAlimentando().naoFormatado().equals(nomeAlimentando)) continue;
            it.remove();
        }
        this.recalculaTotal();
        this.rendAcm.getPensaoAlimenticia().setConteudo(this.totais);
    }

    public RendAcmTitular getRendAcm() {
        return this.rendAcm;
    }
}

