/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.rendIsentos;

import java.lang.ref.WeakReference;
import java.util.Iterator;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.rendIsentos.ItemQuadroPensaoAlimenticiaRendIsentos;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Valor;

public class ColecaoItemQuadroPensaoAlimenticiaRendIsentos
extends Colecao<ItemQuadroPensaoAlimenticiaRendIsentos> {
    private Valor totais = new Valor((ObjetoNegocio)this, "Totais");
    private WeakReference<DeclaracaoIRPF> dec = null;
    private ObjetoNegocio parent;

    public ColecaoItemQuadroPensaoAlimenticiaRendIsentos() {
        this.getTotais().setReadOnly(true);
    }

    public Valor getTotais() {
        return this.totais;
    }

    public void objetoInserido(ItemQuadroPensaoAlimenticiaRendIsentos itemQuadroTransporteDetalhado) {
        itemQuadroTransporteDetalhado.getValor().addObservador((Observador)this);
        itemQuadroTransporteDetalhado.getValor13Salario().addObservador((Observador)this);
        this.calculaTotal();
    }

    public void objetoRemovido(Object o) {
        ((ItemQuadroPensaoAlimenticiaRendIsentos)((Object)o)).getValor().removeObservador((Observador)this);
        ((ItemQuadroPensaoAlimenticiaRendIsentos)((Object)o)).getValor13Salario().removeObservador((Observador)this);
        this.calculaTotal();
    }

    private void calculaTotal() {
        Iterator it = this.itens().iterator();
        this.totais.clear();
        while (it.hasNext()) {
            ItemQuadroPensaoAlimenticiaRendIsentos itemQuadroAuxiliar = (ItemQuadroPensaoAlimenticiaRendIsentos)((Object)it.next());
            this.totais.append('+', itemQuadroAuxiliar.getValor());
        }
    }

    public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
        this.calculaTotal();
    }

    public boolean possuiDependenteComCPF(String cpf) {
        if ("".equals(cpf.trim())) {
            return false;
        }
        for (ItemQuadroPensaoAlimenticiaRendIsentos item : this.itens()) {
            if (!item.getTipoBeneficiario().naoFormatado().equals("Dependente") || !cpf.equals(item.getCpfBeneficiario().naoFormatado())) continue;
            return true;
        }
        return false;
    }

    public void excluirDependentesComCPF(String cpf) {
        Iterator it = this.itens().iterator();
        while (it.hasNext()) {
            ItemQuadroPensaoAlimenticiaRendIsentos item = (ItemQuadroPensaoAlimenticiaRendIsentos)((Object)it.next());
            if (!item.getTipoBeneficiario().naoFormatado().equals("Dependente") || !cpf.equals(item.getCpfBeneficiario().naoFormatado())) continue;
            it.remove();
        }
    }

    public ItemQuadroPensaoAlimenticiaRendIsentos instanciaNovoObjeto() {
        return this.parent == null ? new ItemQuadroPensaoAlimenticiaRendIsentos((DeclaracaoIRPF)((Object)this.dec.get())) : new ItemQuadroPensaoAlimenticiaRendIsentos((DeclaracaoIRPF)((Object)this.dec.get()), this.parent);
    }

    public WeakReference<DeclaracaoIRPF> getDec() {
        return this.dec;
    }

    public void setDec(WeakReference<DeclaracaoIRPF> dec) {
        this.dec = dec;
    }

    public ObjetoNegocio getParent() {
        return this.parent;
    }
}

