/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.rendIsentos;

import java.text.DecimalFormat;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.ValidadorNaoNuloIRPF;
import serpro.ppgd.irpf.rendIsentos.ColecaoItemQuadroGanhosAcoesOuro;
import serpro.ppgd.irpf.rendIsentos.ItemQuadroAuxiliar;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.ValidadorImpeditivoDefault;
import serpro.ppgd.negocio.Valor;

public class ItemQuadroGanhosAcoesOuro
extends ItemQuadroAuxiliar {
    private static final DecimalFormat df = new DecimalFormat("0.00");

    public ItemQuadroGanhosAcoesOuro(DeclaracaoIRPF dec, final ColecaoItemQuadroGanhosAcoesOuro colecaoItemQuadroGanhosAcoesOuro) {
        super(dec);
        this.getValor().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3));
        this.getValor().addValidador((ValidadorIf)new ValidadorImpeditivoDefault("rendisentos_quadro_auxiliar_ganhos_acoes_ouro_valor_limite"){

            public void acaoCancelar() {
            }

            public void acaoOk() {
            }

            public String getTituloPopup() {
                return "Aviso";
            }

            public RetornoValidacao validarImplementado() {
                String val = (String)this.getProximoConteudo();
                Valor valAnterior = (Valor)this.getInformacao();
                if (val != null && !val.trim().isEmpty() && !val.equals("0,00")) {
                    Double doubleVal = Double.valueOf(val.replace(".", "").replace(',', '.'));
                    String valFormatado = df.format(doubleVal);
                    Valor atual = new Valor(valFormatado);
                    Valor totalCpf = colecaoItemQuadroGanhosAcoesOuro.obterTotalPorCPF(ItemQuadroGanhosAcoesOuro.this.getCpfBeneficiario().naoFormatado(), valAnterior);
                    Valor totalCpfMaisAtual = totalCpf.operacao('+', atual);
                    if (totalCpfMaisAtual.comparacao(">", "240.000,00")) {
                        Valor diferenca = totalCpfMaisAtual.operacao('-', "240.000,00");
                        this.setMensagemValidacao(MensagemUtil.getMensagem("rendisentos_quadro_auxiliar_ganhos_acoes_ouro_valor_limite", new String[]{diferenca.formatado()}));
                        this.setTipoExibicao(0);
                        this.setSeveridade((byte)4);
                        RetornoValidacao retorno = new RetornoValidacao(this.getMensagemValidacao(), this.getSeveridade());
                        return retorno;
                    }
                }
                return null;
            }
        });
    }

    @Override
    public String getTituloFichaDashboard() {
        return null;
    }
}

