/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.rendIsentos;

import serpro.ppgd.cacheni.CacheNI;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.ObservadorEspacosDuplicados;
import serpro.ppgd.irpf.ValidadorNaoNuloIRPF;
import serpro.ppgd.irpf.rendIsentos.ItemQuadroAuxiliar;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.NI;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNI;

public class ItemQuadroRendimentosNI
extends ItemQuadroAuxiliar {
    private NI cnpjEmpresa = new NI((ObjetoNegocio)this, "CPF/CNPJ da fonte pagadora");
    private Alfa nomeFonte = new Alfa((ObjetoNegocio)this, "Nome da fonte pagadora", 60);

    public ItemQuadroRendimentosNI(DeclaracaoIRPF dec) {
        super(dec);
        CacheNI.getInstancia().registrarNINome(this.cnpjEmpresa, this.nomeFonte);
        this.getCnpjEmpresa().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3));
        this.getCnpjEmpresa().addValidador((ValidadorIf)new ValidadorNI(3){

            public RetornoValidacao validarImplementado() {
                super.setMensagemValidacao(MensagemUtil.getMensagem("campo_invalido", new String[]{this.getInformacao().getNomeCampo()}));
                return super.validarImplementado();
            }
        });
        this.getNomeFonte().addObservador((Observador)new ObservadorEspacosDuplicados());
        this.getNomeFonte().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(2));
    }

    public Alfa getNomeFonte() {
        return this.nomeFonte;
    }

    public NI getCnpjEmpresa() {
        return this.cnpjEmpresa;
    }

    @Override
    public void adicionaCamposParaPendencia() {
        super.adicionaCamposParaPendencia();
        this.camposPendencia.add(this.cnpjEmpresa);
        this.camposPendencia.add(this.nomeFonte);
    }

    @Override
    public NI getNIFontePagadora() {
        return this.getCnpjEmpresa();
    }

    @Override
    public Alfa getNomeFontePagadora() {
        return this.getNomeFonte();
    }

    @Override
    public String getTituloFichaDashboard() {
        return null;
    }
}

