/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.rendacm;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.rendacm.ColecaoRendAcmTitular;
import serpro.ppgd.irpf.rendacm.RendAcmDependente;
import serpro.ppgd.irpf.rendacm.RendAcmTitular;
import serpro.ppgd.negocio.CPF;
import serpro.ppgd.negocio.Valor;

public class ColecaoRendAcmDependente
extends ColecaoRendAcmTitular {
    public ColecaoRendAcmDependente(DeclaracaoIRPF dec) {
        super(dec);
        this.setFicha("Rendimentos Recebidos Acumuladamente pelos Dependentes");
    }

    @Override
    public RendAcmDependente instanciaNovoObjeto() {
        DeclaracaoIRPF declaracaoIRPF = (DeclaracaoIRPF)((Object)this.weakDec.get());
        return new RendAcmDependente(declaracaoIRPF, this);
    }

    public boolean possuiDependenteComCPF(String cpf) {
        if (cpf.trim().isEmpty()) {
            return false;
        }
        for (RendAcmDependente rend : this.itens()) {
            if (!rend.getCpfDependente().naoFormatado().equals(cpf)) continue;
            return true;
        }
        return false;
    }

    public void excluirDependentesComCPF(String cpf) {
        Iterator it = this.itens().iterator();
        while (it.hasNext()) {
            RendAcmDependente rend = (RendAcmDependente)((Object)it.next());
            if (!rend.getCpfDependente().naoFormatado().equals(cpf)) continue;
            it.remove();
        }
    }

    public Valor obterRendimentosRecebidosPorDependente(CPF cpf) {
        Valor retorno = new Valor();
        for (RendAcmDependente rend : this.itens()) {
            if (!rend.getCpfDependente().naoFormatado().equals(cpf.naoFormatado())) continue;
            retorno.append('+', (Valor)rend.getRendRecebidos());
        }
        return retorno;
    }

    public Valor obterPrevidenciaAjustePorDependente(CPF cpf) {
        Valor retorno = new Valor();
        for (RendAcmDependente rend : this.itens()) {
            if (!rend.getCpfDependente().naoFormatado().equals(cpf.naoFormatado()) || !"A".equals(rend.getOpcaoTributacao().naoFormatado())) continue;
            retorno.append('+', (Valor)rend.getContribuicaoPrevOficial());
        }
        return retorno;
    }

    public Valor obterPensaoAlimenticiaPorDependente(CPF cpf) {
        Valor retorno = new Valor();
        for (RendAcmDependente rend : this.itens()) {
            if (!rend.getCpfDependente().naoFormatado().equals(cpf.naoFormatado()) || !"A".equals(rend.getOpcaoTributacao().naoFormatado())) continue;
            retorno.append('+', (Valor)rend.getPensaoAlimenticia());
        }
        return retorno;
    }

    public Valor obterRendimentosRecebidosAjustePorDependente(CPF cpf) {
        Valor retorno = new Valor();
        for (RendAcmDependente rend : this.itens()) {
            if (!rend.getCpfDependente().naoFormatado().equals(cpf.naoFormatado()) || !"A".equals(rend.getOpcaoTributacao().naoFormatado())) continue;
            retorno.append('+', (Valor)rend.getRendRecebidos());
        }
        return retorno;
    }

    public List<RendAcmDependente> obterRRAsPorCPF(String cpfDependente) {
        ArrayList<RendAcmDependente> rendimentosRRA = new ArrayList<RendAcmDependente>();
        for (RendAcmTitular rendacm : this.itens()) {
            RendAcmDependente rendRRADep = (RendAcmDependente)rendacm;
            if (!rendRRADep.getCpfDependente().naoFormatado().equals(cpfDependente)) continue;
            rendimentosRRA.add(rendRRADep);
        }
        return rendimentosRRA;
    }
}

