/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.rendacm;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.ValorPositivo;
import serpro.ppgd.irpf.rendacm.ColecaoRendAcmDependente;
import serpro.ppgd.irpf.rendacm.ColecaoRendAcmTitular;
import serpro.ppgd.irpf.rendacm.RendAcmDependente;
import serpro.ppgd.irpf.rendacm.RendAcmTitular;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.CPF;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Valor;

public class RendAcm
extends ObjetoNegocio {
    public static final String OPCAO_TRIBUTACAO_VAZIA = "V";
    public static final String OPCAO_TRIBUTACAO_AJUSTE = "A";
    public static final String OPCAO_TRIBUTACAO_EXCLUSIVA = "E";
    private ColecaoRendAcmTitular colecaoRendAcmTitular = null;
    private ColecaoRendAcmDependente colecaoRendAcmDependente = null;
    private Valor totalRendRecebAcumuladamente = new Valor((ObjetoNegocio)this, "Total Rend. Receb. Acumuladamente Tit + Dep");
    private WeakReference<DeclaracaoIRPF> weakDec = null;

    public RendAcm(DeclaracaoIRPF dec) {
        this.colecaoRendAcmTitular = new ColecaoRendAcmTitular(dec);
        this.colecaoRendAcmDependente = new ColecaoRendAcmDependente(dec);
        this.weakDec = new WeakReference<DeclaracaoIRPF>(dec);
    }

    public ColecaoRendAcmDependente getColecaoRendAcmDependente() {
        return this.colecaoRendAcmDependente;
    }

    public ColecaoRendAcmTitular getColecaoRendAcmTitular() {
        return this.colecaoRendAcmTitular;
    }

    public Valor getTotalRendRecebAcumuladamente() {
        return this.totalRendRecebAcumuladamente;
    }

    public List<String> obterBeneficiariosEmOrdemDecrescente() {
        BeneficiarioRRA beneficiario;
        String chave;
        ArrayList<String> retorno = new ArrayList<String>();
        HashMap<String, BeneficiarioRRA> fontesPagadoras = new HashMap<String, BeneficiarioRRA>();
        this.colecaoRendAcmTitular.excluirRegistrosEmBranco();
        for (RendAcmTitular rendAcmTitularAtual : this.colecaoRendAcmTitular.itens()) {
            chave = ((DeclaracaoIRPF)((Object)this.weakDec.get())).getIdentificadorDeclaracao().getCpf().naoFormatado();
            if (!fontesPagadoras.containsKey(chave)) {
                beneficiario = new BeneficiarioRRA();
                beneficiario.getCpf().setConteudo(((DeclaracaoIRPF)((Object)this.weakDec.get())).getIdentificadorDeclaracao().getCpf());
                beneficiario.getOpcaoTributacao().setConteudo(rendAcmTitularAtual.getOpcaoTributacao());
                fontesPagadoras.put(chave, beneficiario);
            }
            beneficiario = (BeneficiarioRRA)((Object)fontesPagadoras.get(chave));
            beneficiario.getValorTotal().append('+', (Valor)rendAcmTitularAtual.getRendRecebidos());
        }
        this.colecaoRendAcmDependente.excluirRegistrosEmBranco();
        for (RendAcmDependente rendAcmDependenteAtual : this.colecaoRendAcmDependente.itens()) {
            chave = rendAcmDependenteAtual.getCpfDependente().naoFormatado();
            if (!fontesPagadoras.containsKey(chave)) {
                beneficiario = new BeneficiarioRRA();
                beneficiario.getCpf().setConteudo(rendAcmDependenteAtual.getCpfDependente());
                beneficiario.getOpcaoTributacao().setConteudo(rendAcmDependenteAtual.getOpcaoTributacao());
                fontesPagadoras.put(chave, beneficiario);
            }
            beneficiario = (BeneficiarioRRA)((Object)fontesPagadoras.get(chave));
            beneficiario.getValorTotal().append('+', (Valor)rendAcmDependenteAtual.getRendRecebidos());
        }
        ArrayList listaOrdenadaFontesPagadoras = new ArrayList(fontesPagadoras.values());
        Collections.sort(listaOrdenadaFontesPagadoras, new Comparator<BeneficiarioRRA>(){

            @Override
            public int compare(BeneficiarioRRA o1, BeneficiarioRRA o2) {
                return o2.getValorTotal().comparacao(">", o1.getValorTotal()) ? 1 : (o2.getValorTotal().comparacao("=", o1.getValorTotal()) ? 0 : -1);
            }
        });
        for (BeneficiarioRRA f : listaOrdenadaFontesPagadoras) {
            if (f.getValorTotal().isVazio()) continue;
            retorno.add(f.getCpf().naoFormatado() + "#" + f.getOpcaoTributacao().naoFormatado());
        }
        return retorno;
    }

    public ValorPositivo obterTotalParcela65AnosAjuste() {
        ValorPositivo total = new ValorPositivo();
        for (RendAcmTitular rendTitular : this.getColecaoRendAcmTitular().itens()) {
            if (!rendTitular.getOpcaoTributacao().naoFormatado().equals(OPCAO_TRIBUTACAO_AJUSTE)) continue;
            total.append('+', rendTitular.getParcIsenta65Anos());
        }
        for (RendAcmTitular rendTitular : this.getColecaoRendAcmDependente().itens()) {
            if (!rendTitular.getOpcaoTributacao().naoFormatado().equals(OPCAO_TRIBUTACAO_AJUSTE)) continue;
            total.append('+', rendTitular.getParcIsenta65Anos());
        }
        return total;
    }

    public Map<String, Valor> obterTotalParcelaIsenta65AnosPorCPF() {
        HashMap<String, Valor> valoresPorCPF = new HashMap<String, Valor>();
        String cpf = ((DeclaracaoIRPF)((Object)this.weakDec.get())).getIdentificadorDeclaracao().getCpf().formatado();
        for (RendAcmTitular rendTitular : this.getColecaoRendAcmTitular().itens()) {
            if (!rendTitular.getOpcaoTributacao().naoFormatado().equals(OPCAO_TRIBUTACAO_AJUSTE)) continue;
            if (!valoresPorCPF.containsKey(cpf)) {
                valoresPorCPF.put(cpf, new Valor());
            }
            Valor total = (Valor)valoresPorCPF.get(cpf);
            total.append('+', (Valor)rendTitular.getParcIsenta65Anos());
        }
        for (RendAcmTitular rend : this.getColecaoRendAcmDependente().itens()) {
            RendAcmDependente rendDependente = (RendAcmDependente)rend;
            cpf = rendDependente.getCpfDependente().formatado();
            if (!rendDependente.getOpcaoTributacao().naoFormatado().equals(OPCAO_TRIBUTACAO_AJUSTE)) continue;
            if (!valoresPorCPF.containsKey(cpf)) {
                valoresPorCPF.put(cpf, new Valor());
            }
            Valor total = (Valor)valoresPorCPF.get(cpf);
            total.append('+', (Valor)rendDependente.getParcIsenta65Anos());
        }
        return valoresPorCPF;
    }

    private static class BeneficiarioRRA
    extends ObjetoNegocio {
        private CPF cpf = new CPF();
        private Alfa opcaoTributacao = new Alfa();
        private Valor valorTotal = new Valor((ObjetoNegocio)this, "");

        public CPF getCpf() {
            return this.cpf;
        }

        public Alfa getOpcaoTributacao() {
            return this.opcaoTributacao;
        }

        public Valor getValorTotal() {
            return this.valorTotal;
        }
    }
}

