/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.rendavariavel;

import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.rendIsentos.ObservadorRecuperacaoPrejuizoBolsaDeValores;
import serpro.ppgd.irpf.rendavariavel.ItemFundosInvestimentosDependente;
import serpro.ppgd.irpf.rendavariavel.RendaVariavel;
import serpro.ppgd.negocio.CPF;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Valor;

public class ColecaoFundosInvestimentosDependente
extends Colecao<ItemFundosInvestimentosDependente> {
    private static final String NOME_FICHA = "Renda Vari\u00e1vel - Opera\u00e7\u00f5es de Fundos de Investimento Imobili\u00e1rio - Dependentes";
    private WeakReference<DeclaracaoIRPF> weakDec;
    private Valor totalBaseCalculo = new Valor((ObjetoNegocio)this, "Total Base C\u00e1lculo");
    private Valor totalImpostoDevido = new Valor((ObjetoNegocio)this, "Total Imposto Devido");
    private Valor totalImpostoRetidoFonteLei11033 = new Valor((ObjetoNegocio)this, "Total Imposto Retido Na Fonte");
    private Valor totalImpostoPago = new Valor((ObjetoNegocio)this, "Total Imposto Pago");
    private ObservadorRecuperacaoPrejuizoBolsaDeValores observadorRecuperacaoPrejuizoBolsaDeValores;

    public ColecaoFundosInvestimentosDependente(DeclaracaoIRPF dec) {
        this.weakDec = new WeakReference<DeclaracaoIRPF>(dec);
        this.setFicha(NOME_FICHA);
    }

    public void adicionarObservGanhosFundInvest(Observador pObservador) {
        this.getTotalBaseCalculo().addObservador(pObservador);
        this.getTotalImpostoDevido().addObservador(pObservador);
        this.getTotalImpostoRetidoFonteLei11033().addObservador(pObservador);
        this.getTotalImpostoPago().addObservador(pObservador);
    }

    public void adicionarObservadorRecuperacaoPrejuizoBolsaDeValores(ObservadorRecuperacaoPrejuizoBolsaDeValores pObservador) {
        this.observadorRecuperacaoPrejuizoBolsaDeValores = pObservador;
    }

    public ItemFundosInvestimentosDependente instanciaNovoObjeto() {
        return new ItemFundosInvestimentosDependente((DeclaracaoIRPF)((Object)this.weakDec.get()));
    }

    public void objetoInserido(ItemFundosInvestimentosDependente item) {
        item.addValidador();
        item.setFicha(NOME_FICHA);
        item.getFundosInvestimentos().getJan().getResultNegativoAnterior().addObservador((Observador)this.observadorRecuperacaoPrejuizoBolsaDeValores);
        item.getFundosInvestimentos().getDez().getPrejuizoCompensar().addObservador((Observador)this.observadorRecuperacaoPrejuizoBolsaDeValores);
    }

    public void objetoRemovido(Object o) {
        ItemFundosInvestimentosDependente item = (ItemFundosInvestimentosDependente)((Object)o);
        item.getFundosInvestimentos().getJan().getResultNegativoAnterior().removeObservador((Observador)this.observadorRecuperacaoPrejuizoBolsaDeValores);
        item.getFundosInvestimentos().getDez().getPrejuizoCompensar().removeObservador((Observador)this.observadorRecuperacaoPrejuizoBolsaDeValores);
    }

    public boolean todosCpfsPreenchidos() {
        boolean preenchido = true;
        Iterator it = this.itens().iterator();
        while (it.hasNext() && preenchido) {
            ItemFundosInvestimentosDependente item = (ItemFundosInvestimentosDependente)((Object)it.next());
            preenchido = preenchido && !item.getCpf().isVazio();
        }
        return preenchido;
    }

    public Map<String, Valor> obterTotalAnual() {
        Map<String, Valor> retorno = null;
        for (ItemFundosInvestimentosDependente item : this.itens()) {
            if (retorno == null) {
                retorno = item.getFundosInvestimentos().obterTotalAnual();
                continue;
            }
            RendaVariavel.somarTotalAnual(retorno, item.getFundosInvestimentos().obterTotalAnual());
        }
        return retorno;
    }

    public boolean possuiDependenteComCPF(String cpf) {
        if ("".equals(cpf.trim())) {
            return false;
        }
        for (ItemFundosInvestimentosDependente item : this.itens()) {
            if (!cpf.equals(item.getCpf().naoFormatado())) continue;
            return true;
        }
        return false;
    }

    public void excluirDependentesComCPF(String cpf) {
        Iterator it = this.itens().iterator();
        while (it.hasNext()) {
            ItemFundosInvestimentosDependente item = (ItemFundosInvestimentosDependente)((Object)it.next());
            if (!cpf.equals(item.getCpf().naoFormatado())) continue;
            it.remove();
        }
    }

    public boolean temResultadoLiquido() {
        for (ItemFundosInvestimentosDependente item : this.itens()) {
            if (!item.getFundosInvestimentos().temResultadoLiquido()) continue;
            return true;
        }
        return false;
    }

    public boolean temIRRF() {
        for (ItemFundosInvestimentosDependente item : this.itens()) {
            if (!item.getFundosInvestimentos().temIRRF()) continue;
            return true;
        }
        return false;
    }

    public Valor getTotalBaseCalculo() {
        return this.totalBaseCalculo;
    }

    public Valor getTotalImpostoDevido() {
        return this.totalImpostoDevido;
    }

    public Valor getTotalImpostoRetidoFonteLei11033() {
        return this.totalImpostoRetidoFonteLei11033;
    }

    public Valor getTotalImpostoPago() {
        return this.totalImpostoPago;
    }

    public Valor recuperarTotalRendimentosPorBeneficiario(CPF cpf) {
        Valor total = new Valor("0,00");
        for (ItemFundosInvestimentosDependente item : this.itens()) {
            if (!item.getCpf().naoFormatado().equals(cpf.naoFormatado())) continue;
            for (int i = 0; i < 12; ++i) {
                total.append('+', item.getFundosInvestimentos().getMeses()[i].getResultLiquidoMes());
            }
        }
        return total;
    }
}

