/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.rendavariavel;

import java.util.HashMap;
import java.util.Map;
import serpro.ppgd.irpf.ValorPositivo;
import serpro.ppgd.irpf.rendavariavel.MesFundosInvestimentos;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Valor;

public class FundosInvestimentos
extends ObjetoNegocio {
    public static final String TOTAL_BASE_CALCULO = "Total Base C\u00e1lculo";
    public static final String TOTAL_IMPOSTO_DEVIDO = "Total Imposto Devido";
    public static final String TOTAL_IMPOSTO_RETIDO_FONTE_LEI_11033 = "Total Imposto Retido Na Fonte";
    public static final String TOTAL_IMPOSTO_PAGO = "Total Imposto Pago";
    private MesFundosInvestimentos jan = new MesFundosInvestimentos(0);
    private MesFundosInvestimentos fev = new MesFundosInvestimentos(1);
    private MesFundosInvestimentos mar = new MesFundosInvestimentos(2);
    private MesFundosInvestimentos abr = new MesFundosInvestimentos(3);
    private MesFundosInvestimentos mai = new MesFundosInvestimentos(4);
    private MesFundosInvestimentos jun = new MesFundosInvestimentos(5);
    private MesFundosInvestimentos jul = new MesFundosInvestimentos(6);
    private MesFundosInvestimentos ago = new MesFundosInvestimentos(7);
    private MesFundosInvestimentos set = new MesFundosInvestimentos(8);
    private MesFundosInvestimentos out = new MesFundosInvestimentos(9);
    private MesFundosInvestimentos nov = new MesFundosInvestimentos(10);
    private MesFundosInvestimentos dez = new MesFundosInvestimentos(11);
    private MesFundosInvestimentos[] meses = new MesFundosInvestimentos[]{this.jan, this.fev, this.mar, this.abr, this.mai, this.jun, this.jul, this.ago, this.set, this.out, this.nov, this.dez};
    private Valor totalBaseCalcImposto = new Valor((ObjetoNegocio)this, "Total Base C\u00e1lculo");
    private Valor totalImpostoDevido = new Valor((ObjetoNegocio)this, "Total Imposto Devido");
    private Valor totalImpostoRetidoFonteLei11033 = new Valor((ObjetoNegocio)this, "Total Imposto Retido Na Fonte");
    private Valor totalImpostoPago = new Valor((ObjetoNegocio)this, "Total Imposto Pago");

    public FundosInvestimentos() {
        this.addObservadorAtualizaIrFonteLei11033ProxMes(this.jan, this.fev);
        this.addObservadorAtualizaIrFonteLei11033ProxMes(this.fev, this.mar);
        this.addObservadorAtualizaIrFonteLei11033ProxMes(this.mar, this.abr);
        this.addObservadorAtualizaIrFonteLei11033ProxMes(this.abr, this.mai);
        this.addObservadorAtualizaIrFonteLei11033ProxMes(this.mai, this.jun);
        this.addObservadorAtualizaIrFonteLei11033ProxMes(this.jun, this.jul);
        this.addObservadorAtualizaIrFonteLei11033ProxMes(this.jul, this.ago);
        this.addObservadorAtualizaIrFonteLei11033ProxMes(this.ago, this.set);
        this.addObservadorAtualizaIrFonteLei11033ProxMes(this.set, this.out);
        this.addObservadorAtualizaIrFonteLei11033ProxMes(this.out, this.nov);
        this.addObservadorAtualizaIrFonteLei11033ProxMes(this.nov, this.dez);
    }

    public void addObservador(Observador obs) {
        this.totalBaseCalcImposto.addObservador(obs);
        this.totalImpostoDevido.addObservador(obs);
        this.totalImpostoRetidoFonteLei11033.addObservador(obs);
        this.totalImpostoPago.addObservador(obs);
    }

    public void removeObservador(Observador obs) {
        this.totalBaseCalcImposto.removeObservador(obs);
        this.totalImpostoDevido.removeObservador(obs);
        this.totalImpostoRetidoFonteLei11033.removeObservador(obs);
        this.totalImpostoPago.removeObservador(obs);
    }

    public void adicionarObservGanhosFundInvest(Observador obs) {
        this.totalBaseCalcImposto.addObservador(obs);
        this.totalImpostoDevido.addObservador(obs);
        this.totalImpostoRetidoFonteLei11033.addObservador(obs);
        this.totalImpostoPago.addObservador(obs);
    }

    public void adicionarCalculosTotaisFundInvest(Observador obs) {
        for (int i = 0; i < 12; ++i) {
            this.meses[i].getBaseCalcImposto().addObservador(obs);
            this.meses[i].getImpostoPago().addObservador(obs);
            this.meses[i].getImpostoDevido().addObservador(obs);
            this.meses[i].getImpostoRetidoFonte().addObservador(obs);
        }
    }

    public Valor getTotalBaseCalcImposto() {
        return this.totalBaseCalcImposto;
    }

    public Valor getTotalImpostoDevido() {
        return this.totalImpostoDevido;
    }

    public Valor getTotalImpostoRetidoFonteLei11033() {
        return this.totalImpostoRetidoFonteLei11033;
    }

    public Valor getTotalImpostoPago() {
        return this.totalImpostoPago;
    }

    public MesFundosInvestimentos getAbr() {
        return this.abr;
    }

    public MesFundosInvestimentos getAgo() {
        return this.ago;
    }

    public MesFundosInvestimentos getDez() {
        return this.dez;
    }

    public MesFundosInvestimentos getFev() {
        return this.fev;
    }

    public MesFundosInvestimentos getJan() {
        return this.jan;
    }

    public MesFundosInvestimentos getJul() {
        return this.jul;
    }

    public MesFundosInvestimentos getJun() {
        return this.jun;
    }

    public MesFundosInvestimentos getMar() {
        return this.mar;
    }

    public MesFundosInvestimentos getNov() {
        return this.nov;
    }

    public MesFundosInvestimentos getOut() {
        return this.out;
    }

    public MesFundosInvestimentos getSet() {
        return this.set;
    }

    public MesFundosInvestimentos[] getMeses() {
        return this.meses;
    }

    public MesFundosInvestimentos getMai() {
        return this.mai;
    }

    public Map<String, Valor> obterTotalAnual() {
        Valor totalResultLiquido = new Valor();
        ValorPositivo totalResultNegativoAnterior = new ValorPositivo();
        Valor totalBaseCalcImposto = new Valor();
        ValorPositivo totalPrejuizoCompensar = new ValorPositivo();
        Valor totalImpostoDevido = new Valor();
        Valor totalImpostoPago = new Valor();
        ValorPositivo totalImpostoRetidoNaFonte = new ValorPositivo();
        for (int i = 0; i < 12; ++i) {
            totalResultLiquido.append('+', this.meses[i].getResultLiquidoMes());
            totalBaseCalcImposto.append('+', this.meses[i].getBaseCalcImposto());
            totalImpostoDevido.append('+', this.meses[i].getImpostoDevido());
            totalImpostoPago.append('+', this.meses[i].getImpostoPago());
            totalImpostoRetidoNaFonte.append('+', this.meses[i].getImpostoRetidoFonte());
        }
        totalResultNegativoAnterior.setConteudo(this.meses[11].getResultNegativoAnterior());
        totalPrejuizoCompensar.setConteudo(this.meses[11].getPrejuizoCompensar());
        HashMap<String, Valor> hash = new HashMap<String, Valor>();
        hash.put("VR_TOTALANUALRESULTADOLIQUIDOSRENDAVARIAVEL_FII", totalResultLiquido);
        hash.put("VR_TOTALANUALRESULTADONEGATIVOMESANTERIOR_FII", totalResultNegativoAnterior);
        hash.put("VR_TOTALANUALBASECALCULOIMPOSTO_FII", totalBaseCalcImposto);
        hash.put("VR_TOTALANUALPREJUIZOCOMPENSAR_FII", totalPrejuizoCompensar);
        hash.put("VR_TOTALANUALIMPOSTODEVIDO_FII", totalImpostoDevido);
        hash.put("VR_TOTALANUALIMPOSTOPAGAR_FII", totalImpostoPago);
        hash.put("VR_TOTALANUALIMPOSTORETIDONAFONTE_FII", totalImpostoRetidoNaFonte);
        return hash;
    }

    private void addObservadorAtualizaIrFonteLei11033ProxMes(MesFundosInvestimentos mesAnt, MesFundosInvestimentos mesPost) {
        class ObservadorAtualizaIRLei11033ProxMes
        extends Observador {
            MesFundosInvestimentos mesAnterior = null;
            MesFundosInvestimentos mesPosterior = null;

            public ObservadorAtualizaIRLei11033ProxMes(MesFundosInvestimentos _mesAnterior, MesFundosInvestimentos _mesPosterior) {
                this.mesAnterior = _mesAnterior;
                this.mesPosterior = _mesPosterior;
            }

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                this.mesPosterior.getImpostoRetidoMesesAnteriores().setConteudo(this.mesAnterior.getImpostoRetidoCompensar());
            }
        }
        mesAnt.getImpostoRetidoCompensar().addObservador((Observador)new ObservadorAtualizaIRLei11033ProxMes(mesAnt, mesPost));
    }

    public boolean temResultadoLiquido() {
        for (int i = 0; i < 12; ++i) {
            if (this.meses[i].getResultLiquidoMes().isVazio()) continue;
            return true;
        }
        return false;
    }

    public boolean temIRRF() {
        for (int i = 0; i < 12; ++i) {
            if (this.meses[i].getImpostoRetidoFonte().isVazio()) continue;
            return true;
        }
        return false;
    }
}

