/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.rendavariavel;

import java.util.List;
import serpro.ppgd.irpf.ValorPositivo;
import serpro.ppgd.irpf.gui.rendavariavel.PainelDadosRendaVariavelOpComunsDayTrade;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Valor;

public class Operacoes
extends ObjetoNegocio
implements ObjetoFicha {
    public static final String PROP_BASE_CALC = "BASE CALCULO";
    private Valor mercadoVistaAcoes = new Valor((ObjetoNegocio)this, "Mercado \u00e0 Vista - A\u00e7\u00f5es");
    private Valor mercadoVistaOuro = new Valor((ObjetoNegocio)this, "Mercado \u00e0 Vista - Ouro");
    private Valor mercadoVistaForaBolsa = new Valor((ObjetoNegocio)this, "Mercado \u00e0 Vista - Fora Bolsa");
    private Valor mercadoOpcoesAcoes = new Valor((ObjetoNegocio)this, "Mercado Op\u00e7\u00f5es - A\u00e7\u00f5es");
    private Valor mercadoOpcoesOuro = new Valor((ObjetoNegocio)this, "Mercado Op\u00e7\u00f5es - Ouro");
    private Valor mercadoOpcoesForaDeBolsa = new Valor((ObjetoNegocio)this, "Mercado Op\u00e7\u00f5es - Fora Bolsa");
    private Valor mercadoOpcoesOutros = new Valor((ObjetoNegocio)this, "Mercado Op\u00e7\u00f5es - Outros");
    private Valor mercadoFuturoDolar = new Valor((ObjetoNegocio)this, "Mercado Futuro - D\u00f3lar dos EUA");
    private Valor mercadoFuturoIndices = new Valor((ObjetoNegocio)this, "Mercado Futuro - \u00cdndices");
    private Valor mercadoFuturoJuros = new Valor((ObjetoNegocio)this, "Mercado Futuro - Juros");
    private Valor mercadoFuturoOutros = new Valor((ObjetoNegocio)this, "Mercado Futuro - Outros");
    private Valor mercadoTermoAcoes = new Valor((ObjetoNegocio)this, "Mercado a Termo - A\u00e7\u00f5es/Ouro");
    private Valor mercadoTermoOutros = new Valor((ObjetoNegocio)this, "Mercado a Termo - Outros");
    private Valor resultadoLiquidoMes = new Valor((ObjetoNegocio)this, "Resultado L\u00edquido do M\u00eas");
    private ValorPositivo resultadoNegativoMesAnterior = new ValorPositivo(this, "Resultado Negativo at\u00e9 o M\u00eas Anterior");
    private Valor baseCalculoImposto = new Valor((ObjetoNegocio)this, "BASE CALCULO");
    private ValorPositivo prejuizoCompensar = new ValorPositivo(this, "Preju\u00edzo a Compensar");
    private Alfa aliquotaDoImposto = new Alfa((ObjetoNegocio)this, "Al\u00edquota do Imposto");
    private Valor impostoDevido = new Valor((ObjetoNegocio)this, "Imposto Devido");
    private String VALOR_ALIQUOTA;

    public Operacoes(String valorAliquota) {
        this.VALOR_ALIQUOTA = valorAliquota;
        this.adicionarObservadorValoresMercado((Observador)this);
    }

    public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
        this.atualizaOperacoes(this);
    }

    private void adicionarObservadorValoresMercado(Observador pObservador) {
        this.adicionaObservador((Informacao)this.mercadoVistaAcoes, pObservador);
        this.adicionaObservador((Informacao)this.mercadoVistaOuro, pObservador);
        this.adicionaObservador((Informacao)this.mercadoVistaForaBolsa, pObservador);
        this.adicionaObservador((Informacao)this.mercadoOpcoesAcoes, pObservador);
        this.adicionaObservador((Informacao)this.mercadoTermoOutros, pObservador);
        this.adicionaObservador((Informacao)this.mercadoTermoAcoes, pObservador);
        this.adicionaObservador((Informacao)this.mercadoFuturoOutros, pObservador);
        this.adicionaObservador((Informacao)this.mercadoFuturoJuros, pObservador);
        this.adicionaObservador((Informacao)this.mercadoFuturoIndices, pObservador);
        this.adicionaObservador((Informacao)this.mercadoFuturoDolar, pObservador);
        this.adicionaObservador((Informacao)this.mercadoOpcoesOutros, pObservador);
        this.adicionaObservador((Informacao)this.mercadoOpcoesOuro, pObservador);
        this.adicionaObservador((Informacao)this.mercadoOpcoesForaDeBolsa, pObservador);
        this.adicionaObservador((Informacao)this.resultadoNegativoMesAnterior, pObservador);
    }

    private void atualizaOperacoes(Operacoes operacoes) {
        Valor resultLiqMes = new Valor();
        resultLiqMes.append('+', operacoes.getMercadoVistaAcoes());
        resultLiqMes.append('+', operacoes.getMercadoVistaOuro());
        resultLiqMes.append('+', operacoes.getMercadoVistaForaBolsa());
        resultLiqMes.append('+', operacoes.getMercadoOpcoesAcoes());
        resultLiqMes.append('+', operacoes.getMercadoOpcoesOuro());
        resultLiqMes.append('+', operacoes.getMercadoOpcoesForaDeBolsa());
        resultLiqMes.append('+', operacoes.getMercadoOpcoesOutros());
        resultLiqMes.append('+', operacoes.getMercadoFuturoDolar());
        resultLiqMes.append('+', operacoes.getMercadoFuturoIndices());
        resultLiqMes.append('+', operacoes.getMercadoFuturoJuros());
        resultLiqMes.append('+', operacoes.getMercadoFuturoOutros());
        resultLiqMes.append('+', operacoes.getMercadoTermoAcoes());
        resultLiqMes.append('+', operacoes.getMercadoTermoOutros());
        operacoes.getResultadoLiquidoMes().setConteudo(resultLiqMes);
        if (operacoes.getResultadoLiquidoMes().comparacao(">", (Valor)operacoes.getResultadoNegativoMesAnterior())) {
            Valor baseCalc = new Valor();
            baseCalc.append('+', operacoes.getResultadoLiquidoMes());
            baseCalc.append('-', (Valor)operacoes.getResultadoNegativoMesAnterior());
            operacoes.getBaseCalculoImposto().setConteudo(baseCalc);
            operacoes.getPrejuizoCompensar().clear();
        } else {
            Valor prejuCompensar = new Valor();
            prejuCompensar.append('+', (Valor)operacoes.getResultadoNegativoMesAnterior());
            prejuCompensar.append('-', operacoes.getResultadoLiquidoMes());
            operacoes.getPrejuizoCompensar().setConteudo(prejuCompensar);
            operacoes.getBaseCalculoImposto().clear();
        }
        if (operacoes.getBaseCalculoImposto().comparacao(">", "0,00")) {
            String aliquotaImpostoDevido = "0," + this.VALOR_ALIQUOTA;
            Valor baseCalculoImposto = new Valor();
            baseCalculoImposto.setConteudo(operacoes.getBaseCalculoImposto());
            baseCalculoImposto.append('*', aliquotaImpostoDevido);
            operacoes.getImpostoDevido().setConteudo(baseCalculoImposto);
        } else {
            operacoes.getImpostoDevido().clear();
        }
    }

    private void adicionaObservador(Informacao pObservado, Observador pObservador) {
        pObservado.addObservador(pObservador);
    }

    public Alfa getAliquotaDoImposto() {
        return this.aliquotaDoImposto;
    }

    public Valor getImpostoDevido() {
        return this.impostoDevido;
    }

    public Valor getMercadoTermoAcoes() {
        return this.mercadoTermoAcoes;
    }

    public Valor getMercadoTermoOutros() {
        return this.mercadoTermoOutros;
    }

    public Valor getPrejuizoCompensar() {
        return this.prejuizoCompensar;
    }

    public Valor getBaseCalculoImposto() {
        return this.baseCalculoImposto;
    }

    public Valor getMercadoFuturoDolar() {
        return this.mercadoFuturoDolar;
    }

    public Valor getMercadoFuturoIndices() {
        return this.mercadoFuturoIndices;
    }

    public Valor getMercadoFuturoJuros() {
        return this.mercadoFuturoJuros;
    }

    public Valor getMercadoFuturoOutros() {
        return this.mercadoFuturoOutros;
    }

    public Valor getMercadoOpcoesAcoes() {
        return this.mercadoOpcoesAcoes;
    }

    public Valor getMercadoOpcoesForaDeBolsa() {
        return this.mercadoOpcoesForaDeBolsa;
    }

    public Valor getMercadoOpcoesOuro() {
        return this.mercadoOpcoesOuro;
    }

    public Valor getMercadoOpcoesOutros() {
        return this.mercadoOpcoesOutros;
    }

    public Valor getMercadoVistaAcoes() {
        return this.mercadoVistaAcoes;
    }

    public Valor getMercadoVistaForaBolsa() {
        return this.mercadoVistaForaBolsa;
    }

    public Valor getMercadoVistaOuro() {
        return this.mercadoVistaOuro;
    }

    public Valor getResultadoLiquidoMes() {
        return this.resultadoLiquidoMes;
    }

    public ValorPositivo getResultadoNegativoMesAnterior() {
        return this.resultadoNegativoMesAnterior;
    }

    protected List<Informacao> recuperarListaCamposPendencia() {
        List listaCamposPendencia = this.recuperarCamposInformacao();
        return listaCamposPendencia;
    }

    public boolean isVazio() {
        boolean retorno = true;
        retorno = retorno && this.mercadoVistaAcoes.isVazio();
        retorno = retorno && this.mercadoVistaOuro.isVazio();
        retorno = retorno && this.mercadoVistaForaBolsa.isVazio();
        retorno = retorno && this.mercadoOpcoesAcoes.isVazio();
        retorno = retorno && this.mercadoOpcoesOuro.isVazio();
        retorno = retorno && this.mercadoOpcoesForaDeBolsa.isVazio();
        retorno = retorno && this.mercadoOpcoesOutros.isVazio();
        retorno = retorno && this.mercadoFuturoDolar.isVazio();
        retorno = retorno && this.mercadoFuturoIndices.isVazio();
        retorno = retorno && this.mercadoFuturoJuros.isVazio();
        retorno = retorno && this.mercadoFuturoOutros.isVazio();
        retorno = retorno && this.mercadoTermoAcoes.isVazio();
        retorno = retorno && this.mercadoTermoOutros.isVazio();
        return retorno;
    }

    public void clear() {
        this.mercadoVistaAcoes.clear();
        this.mercadoVistaOuro.clear();
        this.mercadoVistaForaBolsa.clear();
        this.mercadoOpcoesAcoes.clear();
        this.mercadoOpcoesOuro.clear();
        this.mercadoOpcoesForaDeBolsa.clear();
        this.mercadoOpcoesOutros.clear();
        this.mercadoFuturoDolar.clear();
        this.mercadoFuturoIndices.clear();
        this.mercadoFuturoJuros.clear();
        this.mercadoFuturoOutros.clear();
        this.mercadoTermoAcoes.clear();
        this.mercadoTermoOutros.clear();
    }

    public String getClasseFicha() {
        return PainelDadosRendaVariavelOpComunsDayTrade.class.getName();
    }

    public String getNomeAba() {
        return null;
    }

    public String getTituloFichaDashboard() {
        return null;
    }

    public Operacoes obterCopia(Operacoes copia) {
        copia.getMercadoVistaAcoes().setConteudo(this.getMercadoVistaAcoes());
        copia.getMercadoVistaOuro().setConteudo(this.getMercadoVistaOuro());
        copia.getMercadoVistaForaBolsa().setConteudo(this.getMercadoVistaForaBolsa());
        copia.getMercadoOpcoesAcoes().setConteudo(this.getMercadoOpcoesAcoes());
        copia.getMercadoOpcoesOuro().setConteudo(this.getMercadoOpcoesOuro());
        copia.getMercadoOpcoesForaDeBolsa().setConteudo(this.getMercadoOpcoesForaDeBolsa());
        copia.getMercadoOpcoesOutros().setConteudo(this.getMercadoOpcoesOutros());
        copia.getMercadoFuturoDolar().setConteudo(this.getMercadoFuturoDolar());
        copia.getMercadoFuturoIndices().setConteudo(this.getMercadoFuturoIndices());
        copia.getMercadoFuturoJuros().setConteudo(this.getMercadoFuturoJuros());
        copia.getMercadoFuturoOutros().setConteudo(this.getMercadoFuturoOutros());
        copia.getMercadoTermoAcoes().setConteudo(this.getMercadoTermoAcoes());
        copia.getMercadoTermoOutros().setConteudo(this.getMercadoTermoOutros());
        copia.getResultadoLiquidoMes().setConteudo(this.getResultadoLiquidoMes());
        copia.getResultadoNegativoMesAnterior().setConteudo(this.getResultadoNegativoMesAnterior());
        copia.getBaseCalculoImposto().setConteudo(this.getBaseCalculoImposto());
        copia.getPrejuizoCompensar().setConteudo(this.getPrejuizoCompensar());
        copia.getAliquotaDoImposto().setConteudo(this.getAliquotaDoImposto());
        copia.getImpostoDevido().setConteudo(this.getImpostoDevido());
        return copia;
    }
}

