/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.rendpf;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.rendpf.CPFDependente;
import serpro.ppgd.irpf.rendpf.ColecaoCPFDependentes;
import serpro.ppgd.irpf.rendpf.ContasAno;
import serpro.ppgd.irpf.rendpf.ContasMes;
import serpro.ppgd.irpf.rendpf.ItemRendPFDependente;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.CPF;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Pendencia;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.Valor;
import serpro.ppgd.negocio.util.FabricaUtilitarios;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNaoNulo;

public class ColecaoRendPFDependente
extends Colecao<ItemRendPFDependente> {
    private WeakReference<DeclaracaoIRPF> refDeclaracao;
    private Valor totalPessoaFisica = new Valor((ObjetoNegocio)this, "Total Pessoa F\u00edsica");
    private Valor totalAlugueis = new Valor((ObjetoNegocio)this, "Total Alugueis");
    private Valor totalOutros = new Valor((ObjetoNegocio)this, "Total Outros");
    private Valor totalExterior = new Valor((ObjetoNegocio)this, "Total Exterior");
    private Valor totalPrevidencia = new Valor((ObjetoNegocio)this, "Total Previd\u00eancia");
    private Valor totalDependentes = new Valor((ObjetoNegocio)this, "Total Dependentes");
    private Valor totalPensao = new Valor((ObjetoNegocio)this, "Total Pens\u00e3o");
    private Valor totalLivroCaixa = new Valor((ObjetoNegocio)this, "Total Livro Caixa");
    private Valor totalImpostoPagoExteriorCompensar = new Valor((ObjetoNegocio)this, "Total Imposto Pago no Exterior a Compensar");
    private Valor totalDarfPago = new Valor((ObjetoNegocio)this, "Total DARF");
    private Alfa usouImportacaoCarneLeaoWeb = new Alfa((ObjetoNegocio)this, "");

    public ColecaoRendPFDependente(DeclaracaoIRPF dec) {
        this.refDeclaracao = new WeakReference<DeclaracaoIRPF>(dec);
        this.setFicha("Rendimentos Tribut\u00e1veis Recebidos de PF e do Exterior - Dependentes");
        this.usouImportacaoCarneLeaoWeb.setConteudo(Logico.NAO);
    }

    public void objetoInserido(final ItemRendPFDependente item) {
        item.addValidador((DeclaracaoIRPF)((Object)this.refDeclaracao.get()));
        item.getRendimentos().getNITPISPASEP().addValidador((ValidadorIf)new ValidadorNaoNulo(3){

            public RetornoValidacao validarImplementado() {
                if (item.getRendimentos().getNITPISPASEP().isVazio() && item.getRendimentos().getTotalPrevidencia().comparacao(">", "0,00")) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("contribuinte_previdencia_pf_sem_nit_pis_pasep"), this.getSeveridade());
                }
                return null;
            }
        });
        item.aplicaNomeFicha();
    }

    public Boolean existeContribuicaoPrevidenciariaPorDependente(CPF cpf) {
        Boolean retorno = false;
        for (ItemRendPFDependente rend : this.itens()) {
            if (!rend.getCpf().naoFormatado().equals(cpf.naoFormatado()) || !rend.getRendimentos().existeContribuicaoPrevidenciaria()) continue;
            retorno = true;
            break;
        }
        return retorno;
    }

    public Valor getTotalDarfPago() {
        return this.totalDarfPago;
    }

    public Valor getTotalDependentes() {
        return this.totalDependentes;
    }

    public Valor getTotalExterior() {
        return this.totalExterior;
    }

    public Valor getTotalLivroCaixa() {
        return this.totalLivroCaixa;
    }

    public Valor getTotalPensao() {
        return this.totalPensao;
    }

    public Valor getTotalPrevidencia() {
        return this.totalPrevidencia;
    }

    public Valor getTotalPessoaFisica() {
        return this.totalPessoaFisica;
    }

    public boolean todosCpfsPreenchidos() {
        boolean preenchido = true;
        Iterator it = this.itens().iterator();
        while (it.hasNext() && preenchido) {
            ItemRendPFDependente item = (ItemRendPFDependente)((Object)it.next());
            preenchido = preenchido && !item.getCpf().isVazio();
        }
        return preenchido;
    }

    public ColecaoCPFDependentes getCpfDependentes() {
        ColecaoCPFDependentes list = new ColecaoCPFDependentes();
        for (ItemRendPFDependente item : this.itens()) {
            CPFDependente dep = new CPFDependente();
            dep.getCpf().setConteudo(item.getCpf().naoFormatado());
            list.itens().add(dep);
        }
        return list;
    }

    public boolean possuiMaisDeUmDependenteComCPF(String cpf) {
        int contador = 0;
        if ("".equals(cpf.trim())) {
            return false;
        }
        for (ItemRendPFDependente item : this.itens()) {
            if (!cpf.equals(item.getCpf().naoFormatado())) continue;
            ++contador;
        }
        return contador > 1;
    }

    public boolean possuiDependenteComCPF(String cpf) {
        if ("".equals(cpf.trim())) {
            return false;
        }
        for (ItemRendPFDependente item : this.itens()) {
            if (!cpf.equals(item.getCpf().naoFormatado())) continue;
            return true;
        }
        return false;
    }

    public void excluirDependentesComCPF(String cpf) {
        Iterator it = this.itens().iterator();
        while (it.hasNext()) {
            ItemRendPFDependente item = (ItemRendPFDependente)((Object)it.next());
            if (!cpf.equals(item.getCpf().naoFormatado())) continue;
            it.remove();
        }
    }

    public Valor obterRendimentosRecebidosPorDependente(CPF cpf) {
        Valor retorno = new Valor();
        for (ItemRendPFDependente rend : this.itens()) {
            if (!rend.getCpf().naoFormatado().equals(cpf.naoFormatado())) continue;
            retorno.append('+', rend.getRendimentos().getTotalPessoaFisica());
            retorno.append('+', rend.getRendimentos().getTotalExterior());
            retorno.append('+', rend.getRendimentos().getTotalAlugueis());
            retorno.append('+', rend.getRendimentos().getTotalOutros());
        }
        return retorno;
    }

    public Valor obterPrevidenciaPorDependente(CPF cpf) {
        Valor retorno = new Valor();
        for (ItemRendPFDependente rend : this.itens()) {
            if (!rend.getCpf().naoFormatado().equals(cpf.naoFormatado())) continue;
            retorno.append('+', rend.getRendimentos().getTotalPrevidencia());
        }
        return retorno;
    }

    public Valor obterLivroCaixaPorDependente(CPF cpf) {
        Valor retorno = new Valor();
        for (ItemRendPFDependente rend : this.itens()) {
            if (!rend.getCpf().naoFormatado().equals(cpf.naoFormatado())) continue;
            retorno.append('+', rend.getRendimentos().getTotalLivroCaixa());
        }
        return retorno;
    }

    public ContasAno obterContasAnoPorCPF(String cpf) {
        ContasAno contasAno = null;
        for (ItemRendPFDependente item : this.itens()) {
            if (!item.getCpf().naoFormatado().equals(cpf)) continue;
            contasAno = item.getRendimentos().getContasAno();
            break;
        }
        return contasAno;
    }

    public ItemRendPFDependente obterItemRendPFDependentePorCPF(String cpf) {
        ItemRendPFDependente lItem = null;
        for (ItemRendPFDependente item : this.itens()) {
            if (!item.getCpf().naoFormatado().equals(cpf)) continue;
            lItem = item;
            break;
        }
        return lItem;
    }

    public Valor getTotalAlugueis() {
        return this.totalAlugueis;
    }

    public Valor getTotalOutros() {
        return this.totalOutros;
    }

    public Valor getTotalImpostoPagoExteriorCompensar() {
        return this.totalImpostoPagoExteriorCompensar;
    }

    public Alfa getUsouImportacaoCarneLeaoWeb() {
        return this.usouImportacaoCarneLeaoWeb;
    }

    private List<Pendencia> getListaPendencias() {
        ArrayList<Pendencia> pendencias = new ArrayList<Pendencia>();
        for (ItemRendPFDependente lItem : this.itens()) {
            for (ContasMes mes : lItem.getRendimentos().getContasAno().getColecaoEscrituracao().itens()) {
                pendencias.addAll(FabricaUtilitarios.verificarPendencias((Object)((Object)mes)));
            }
        }
        return pendencias;
    }

    public List<Pendencia> verificarPendencias(int numeroItem) {
        List pendencias = super.verificarPendencias(numeroItem);
        pendencias.addAll(this.getListaPendencias());
        return pendencias;
    }
}

