/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.rendpf;

import java.util.ArrayList;
import java.util.List;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.gui.rendpf.PainelDadosEscrituracao;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.CPF;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorDefault;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.Valor;
import serpro.ppgd.negocio.util.LogPPGD;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorCPF;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNaoNulo;

public class Conta
extends ObjetoNegocio
implements ObjetoFicha {
    public static final String TITULO_FICHA_TITULAR = "Rendimentos Tribut\u00e1veis Recebidos de PF e do Exterior - Titular";
    public static final String TITULO_FICHA_DEPENDENTES = "Rendimentos Tribut\u00e1veis Recebidos de PF e do Exterior - Dependentes";
    private Alfa dataMesAno = new Alfa((ObjetoNegocio)this, "dataMesAno", 6);
    private Valor valor = new Valor((ObjetoNegocio)this, "ValorR$");
    private Alfa nomeMes = new Alfa((ObjetoNegocio)this, "Nome do Mes");
    private CPF cpfTitularPagamento = new CPF((ObjetoNegocio)this, "Titular do Pagamento");
    private Alfa indTitularEhBeneficiario = new Alfa((ObjetoNegocio)this, "Titular \u00e9 benefici\u00e1rio");
    private CPF cpfBeneficiarioServico = new CPF((ObjetoNegocio)this, "Benefici\u00e1rio do Servi\u00e7o");
    private Alfa indBeneficiarioNaoPossuiCPF = new Alfa((ObjetoNegocio)this, "Benefici\u00e1rio n\u00e3o possui CPF");
    private CPF cpfContribuinte = new CPF((ObjetoNegocio)this, "CPF do Contribuinte");
    private transient CPF cpfDeclaranteIRPF = new CPF((ObjetoNegocio)this, "CPF do Declarante do IRPF");

    public Conta() {
        this.indTitularEhBeneficiario.setConteudo(Logico.NAO);
        this.indBeneficiarioNaoPossuiCPF.setConteudo(Logico.NAO);
        this.valor.addValidador((ValidadorIf)new ValidadorNaoNulo(3){

            public RetornoValidacao validarImplementado() {
                if (Conta.this.valor.comparacao("<=", "0")) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("valor_nao_positivo"), 3);
                }
                return null;
            }
        });
        this.cpfTitularPagamento.addValidador((ValidadorIf)new ValidadorCPF(3));
        this.cpfTitularPagamento.addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                if (this.getInformacao().naoFormatado().equals(Conta.this.cpfContribuinte.naoFormatado())) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("400010"), 3);
                }
                return null;
            }
        });
        this.cpfTitularPagamento.addValidador((ValidadorIf)new ValidadorNaoNulo(3, MensagemUtil.getMensagem("msg_validador_nao_nulo", new String[]{this.getCpfTitularPagamento().getNomeCampo()})){

            public RetornoValidacao validarImplementado() {
                if (IRPFFacade.getInstancia().getIdDeclaracaoAberto() != null) {
                    boolean isOcupacaoComRegProfissionalObrigatorio = IRPFFacade.getInstancia().getContribuinte().isOcupacaoComRegistroProfissionalObrigatorio(IRPFFacade.getInstancia().getIdDeclaracaoAberto().getTipoDeclaracaoAES().naoFormatado());
                    boolean heTitular = IRPFFacade.getInstancia().getIdDeclaracaoAberto().getCpf().naoFormatado().equals(Conta.this.getCpfContribuinte().naoFormatado());
                    if (this.getInformacao().isVazio() && isOcupacaoComRegProfissionalObrigatorio && heTitular) {
                        return super.validarImplementado();
                    }
                } else if (IRPFFacade.getInstancia().getDeclaracaoEmGravacao() != null) {
                    boolean isOcupacaoComRegProfissionalObrigatorio = IRPFFacade.getInstancia().getDeclaracaoEmGravacao().getContribuinte().isOcupacaoComRegistroProfissionalObrigatorio(IRPFFacade.getInstancia().getDeclaracaoEmGravacao().getIdentificadorDeclaracao().getTipoDeclaracaoAES().naoFormatado());
                    boolean heTitular = IRPFFacade.getInstancia().getDeclaracaoEmGravacao().getIdentificadorDeclaracao().getCpf().naoFormatado().equals(Conta.this.getCpfContribuinte().naoFormatado());
                    if (this.getInformacao().isVazio() && isOcupacaoComRegProfissionalObrigatorio && heTitular) {
                        Conta.this.setFicha(Conta.TITULO_FICHA_TITULAR);
                        return super.validarImplementado();
                    }
                }
                return null;
            }
        });
        this.cpfBeneficiarioServico.addValidador((ValidadorIf)new ValidadorCPF(3));
        this.cpfBeneficiarioServico.addValidador((ValidadorIf)new ValidadorNaoNulo(3){

            public RetornoValidacao validarImplementado() {
                if (!this.getInformacao().isVazio() && this.getInformacao().naoFormatado().equals(Conta.this.cpfContribuinte.naoFormatado())) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("400020"), 3);
                }
                return null;
            }
        });
        this.cpfBeneficiarioServico.addValidador((ValidadorIf)new ValidadorNaoNulo(3, MensagemUtil.getMensagem("msg_validador_nao_nulo", new String[]{this.getCpfBeneficiarioServico().getNomeCampo()})){

            public RetornoValidacao validarImplementado() {
                if (!Conta.this.cpfTitularPagamento.isVazio() && !Conta.this.indBeneficiarioNaoPossuiCPF.naoFormatado().equals(Logico.SIM)) {
                    return super.validarImplementado();
                }
                return null;
            }
        });
        this.cpfTitularPagamento.addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                if (Conta.this.getIndTitularEhBeneficiario().naoFormatado().equals(Logico.SIM)) {
                    Conta.this.getCpfBeneficiarioServico().setConteudo(Conta.this.getCpfTitularPagamento().naoFormatado());
                }
            }
        });
        this.dataMesAno.addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                try {
                    Conta.this.nomeMes.setConteudo(Conta.this.getNomeMesExtenso(Integer.valueOf(((String)valorNovo).substring(0, 2))));
                }
                catch (Exception ex) {
                    LogPPGD.erro((String)ex.getMessage());
                }
            }
        });
    }

    public List recuperarListaCamposPendencia() {
        ArrayList<Object> campos = new ArrayList<Object>();
        campos.add(this.getCpfTitularPagamento());
        campos.add(this.getCpfBeneficiarioServico());
        campos.add(this.getValor());
        return campos;
    }

    public Conta obterCopia() {
        Conta conta = new Conta();
        conta.getCpfContribuinte().setConteudo(this.getCpfContribuinte());
        conta.getCpfBeneficiarioServico().setConteudo(this.getCpfBeneficiarioServico());
        conta.getCpfTitularPagamento().setConteudo(this.getCpfTitularPagamento());
        conta.getIndBeneficiarioNaoPossuiCPF().setConteudo(this.getIndBeneficiarioNaoPossuiCPF());
        conta.getIndTitularEhBeneficiario().setConteudo(this.getIndTitularEhBeneficiario());
        conta.getNomeMes().setConteudo(this.getNomeMes());
        conta.getDataMesAno().setConteudo(this.getDataMesAno());
        conta.getValor().setConteudo(this.getValor());
        return conta;
    }

    public Alfa getDataMesAno() {
        return this.dataMesAno;
    }

    public Valor getValor() {
        return this.valor;
    }

    public int compareTo(Object o) {
        Conta outro = (Conta)((Object)o);
        if (this.getCpfTitularPagamento().isVazio() && outro.getCpfTitularPagamento().isVazio()) {
            return 0;
        }
        if (outro.getCpfTitularPagamento().isVazio()) {
            return -1;
        }
        if (this.getCpfTitularPagamento().isVazio()) {
            return 1;
        }
        return outro.getCpfTitularPagamento().naoFormatado().compareTo(this.getCpfTitularPagamento().naoFormatado());
    }

    public boolean isVazio() {
        return this.getCpfTitularPagamento().isVazio() && this.getValor().isVazio();
    }

    public boolean isEmpty() {
        return this.valor.isVazio() && this.cpfTitularPagamento.isVazio() && this.cpfBeneficiarioServico.isVazio();
    }

    public String getClasseFicha() {
        return PainelDadosEscrituracao.class.getName();
    }

    public String getNomeAba() {
        return this.getFicha();
    }

    public Alfa getNomeMes() {
        return this.nomeMes;
    }

    public Alfa converteNomeMesABC() {
        String convertido = "";
        Alfa nomeMesABC = new Alfa();
        switch (this.nomeMes.naoFormatado()) {
            case "1": {
                convertido = "A";
                break;
            }
            case "2": {
                convertido = "B";
                break;
            }
            case "3": {
                convertido = "C";
                break;
            }
            case "4": {
                convertido = "D";
                break;
            }
            case "5": {
                convertido = "E";
                break;
            }
            case "6": {
                convertido = "F";
                break;
            }
            case "7": {
                convertido = "G";
                break;
            }
            case "8": {
                convertido = "H";
                break;
            }
            case "9": {
                convertido = "I";
                break;
            }
            case "10": {
                convertido = "J";
                break;
            }
            case "11": {
                convertido = "K";
                break;
            }
            case "12": {
                convertido = "L";
            }
        }
        nomeMesABC.setConteudo(convertido);
        return nomeMesABC;
    }

    public CPF getCpfTitularPagamento() {
        return this.cpfTitularPagamento;
    }

    public Alfa getIndTitularEhBeneficiario() {
        return this.indTitularEhBeneficiario;
    }

    public CPF getCpfBeneficiarioServico() {
        return this.cpfBeneficiarioServico;
    }

    public Alfa getIndBeneficiarioNaoPossuiCPF() {
        return this.indBeneficiarioNaoPossuiCPF;
    }

    public String getNomeMesExtenso(int mes) {
        String nomeMes = "";
        switch (Integer.valueOf(mes)) {
            case 1: {
                nomeMes = "Janeiro";
                break;
            }
            case 2: {
                nomeMes = "Fevereiro";
                break;
            }
            case 3: {
                nomeMes = "Mar\u00e7o";
                break;
            }
            case 4: {
                nomeMes = "Abril";
                break;
            }
            case 5: {
                nomeMes = "Maio";
                break;
            }
            case 6: {
                nomeMes = "Junho";
                break;
            }
            case 7: {
                nomeMes = "Julho";
                break;
            }
            case 8: {
                nomeMes = "Agosto";
                break;
            }
            case 9: {
                nomeMes = "Setembro";
                break;
            }
            case 10: {
                nomeMes = "Outubro";
                break;
            }
            case 11: {
                nomeMes = "Novembro";
                break;
            }
            case 12: {
                nomeMes = "Dezembro";
            }
        }
        return nomeMes;
    }

    public CPF getCpfContribuinte() {
        return this.cpfContribuinte;
    }

    public String getTituloFichaDashboard() {
        if (this.getFicha().indexOf("Titular") > -1) {
            return TITULO_FICHA_TITULAR;
        }
        return "Rendimentos Tribut\u00e1veis Recebidos de PF e do Exterior - Dependente";
    }

    public CPF getCpfDeclaranteIRPF() {
        return this.cpfDeclaranteIRPF;
    }
}

