/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.rendpf;

import java.util.ArrayList;
import java.util.List;
import serpro.ppgd.irpf.gui.rendpf.PainelDadosEscrituracao;
import serpro.ppgd.irpf.rendpf.ContasAno;
import serpro.ppgd.irpf.rendpf.MesRendPF;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.Valor;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNIT;

public class RendPF
extends ObjetoNegocio
implements ObjetoFicha {
    public static final String FICHA_TIT = "Rendimentos Tribut\u00e1veis Recebidos de PF e do Exterior - Titular";
    public static final String FICHA_DEP = "Rendimentos Tribut\u00e1veis Recebidos de PF e do Exterior - Dependentes";
    public static final String NOME_TOTAL_PF = "Total Pessoa F\u00edsica";
    public static final String NOME_TOTAL_ALUGUEIS = "Total Alugueis";
    public static final String NOME_TOTAL_OUTROS = "Total Outros";
    public static final String NOME_TOTAL_EXTERIOR = "Total Exterior";
    public static final String NOME_TOTAL_PREVIDENCIA = "Total Previd\u00eancia";
    public static final String NOME_TOTAL_DEPENDENTES = "Total Dependentes";
    public static final String NOME_TOTAL_PENSAO = "Total Pens\u00e3o";
    public static final String NOME_TOTAL_IMPOSTO_PAGO_COMPENSAR_EXTEIOR = "Total Imposto Pago no Exterior a Compensar";
    public static final String NOME_TOTAL_LIVROCAIXA = "Total Livro Caixa";
    public static final String NOME_TOTAL_DARF = "Total DARF";
    private MesRendPF janeiro;
    private MesRendPF fevereiro;
    private MesRendPF marco;
    private MesRendPF abril;
    private MesRendPF maio;
    private MesRendPF junho;
    private MesRendPF julho;
    private MesRendPF agosto;
    private MesRendPF setembro;
    private MesRendPF outubro;
    private MesRendPF novembro;
    private MesRendPF dezembro;
    protected MesRendPF[] meses;
    private Valor totalPessoaFisica = new Valor((ObjetoNegocio)this, "Total Pessoa F\u00edsica");
    private Valor totalAlugueis = new Valor((ObjetoNegocio)this, "Total Alugueis");
    private Valor totalOutros = new Valor((ObjetoNegocio)this, "Total Outros");
    private Valor totalExterior = new Valor((ObjetoNegocio)this, "Total Exterior");
    private Valor totalPrevidencia = new Valor((ObjetoNegocio)this, "Total Previd\u00eancia");
    private Valor totalDependentes = new Valor((ObjetoNegocio)this, "Total Dependentes");
    private Alfa totalNumDependentes = new Alfa((ObjetoNegocio)this, "");
    private Valor totalPensao = new Valor((ObjetoNegocio)this, "Total Pens\u00e3o");
    private Valor totalImpostoPagoExteriorCompensar = new Valor((ObjetoNegocio)this, "Total Imposto Pago no Exterior a Compensar");
    private Valor totalLivroCaixa = new Valor((ObjetoNegocio)this, "Total Livro Caixa");
    private Valor totalDarfPago = new Valor((ObjetoNegocio)this, "Total DARF");
    private Alfa NITPISPASEP = new Alfa((ObjetoNegocio)this, "NIT/PIS/PASEP do contribuinte");
    private ContasAno contasAno;
    private Alfa usouImportacaoCarneLeaoWeb = new Alfa((ObjetoNegocio)this, "");

    public RendPF() {
        this.getNITPISPASEP().addValidador((ValidadorIf)new ValidadorNIT(3, MensagemUtil.getMensagem("nit_pis_pasep_invalido")){

            public RetornoValidacao validarImplementado() {
                if (!RendPF.this.getNITPISPASEP().isVazio()) {
                    return super.validarImplementado();
                }
                return null;
            }
        });
        this.contasAno = new ContasAno();
        this.janeiro = new MesRendPF(0, this.getContasAno().getArrayMeses()[0]);
        this.fevereiro = new MesRendPF(1, this.getContasAno().getArrayMeses()[1]);
        this.marco = new MesRendPF(2, this.getContasAno().getArrayMeses()[2]);
        this.abril = new MesRendPF(3, this.getContasAno().getArrayMeses()[3]);
        this.maio = new MesRendPF(4, this.getContasAno().getArrayMeses()[4]);
        this.junho = new MesRendPF(5, this.getContasAno().getArrayMeses()[5]);
        this.julho = new MesRendPF(6, this.getContasAno().getArrayMeses()[6]);
        this.agosto = new MesRendPF(7, this.getContasAno().getArrayMeses()[7]);
        this.setembro = new MesRendPF(8, this.getContasAno().getArrayMeses()[8]);
        this.outubro = new MesRendPF(9, this.getContasAno().getArrayMeses()[9]);
        this.novembro = new MesRendPF(10, this.getContasAno().getArrayMeses()[10]);
        this.dezembro = new MesRendPF(11, this.getContasAno().getArrayMeses()[11]);
        this.meses = new MesRendPF[]{this.janeiro, this.fevereiro, this.marco, this.abril, this.maio, this.junho, this.julho, this.agosto, this.setembro, this.outubro, this.novembro, this.dezembro};
        this.aplicaNomeFicha();
        this.usouImportacaoCarneLeaoWeb.setConteudo(Logico.NAO);
    }

    public void limparTrabalhoNaoAssalariadoSemLancamento() {
        for (int i = 0; i < 12; ++i) {
            if (this.contasAno.getArrayMeses()[i].itens().size() != 0) continue;
            this.meses[i].getPessoaFisica().clear();
        }
    }

    public List recuperarListaCamposPendencia() {
        ArrayList<Alfa> campos = new ArrayList<Alfa>();
        campos.add(this.getNITPISPASEP());
        return campos;
    }

    public void aplicaNomeFicha() {
        this.setFicha(FICHA_TIT);
        for (int i = 0; i < 12; ++i) {
            this.meses[i].setFicha(FICHA_TIT);
        }
    }

    public MesRendPF getMesRendPFPorIndice(int mes) {
        if (mes == 0) {
            return this.janeiro;
        }
        if (mes == 1) {
            return this.fevereiro;
        }
        if (mes == 2) {
            return this.marco;
        }
        if (mes == 3) {
            return this.abril;
        }
        if (mes == 4) {
            return this.maio;
        }
        if (mes == 5) {
            return this.junho;
        }
        if (mes == 6) {
            return this.julho;
        }
        if (mes == 7) {
            return this.agosto;
        }
        if (mes == 8) {
            return this.setembro;
        }
        if (mes == 9) {
            return this.outubro;
        }
        if (mes == 10) {
            return this.novembro;
        }
        if (mes == 11) {
            return this.dezembro;
        }
        return null;
    }

    public int obterMesFormatoNumerico(MesRendPF ganhos) {
        if (((Object)((Object)ganhos)).equals((Object)this.janeiro)) {
            return 0;
        }
        if (((Object)((Object)ganhos)).equals((Object)this.fevereiro)) {
            return 1;
        }
        if (((Object)((Object)ganhos)).equals((Object)this.marco)) {
            return 2;
        }
        if (((Object)((Object)ganhos)).equals((Object)this.abril)) {
            return 3;
        }
        if (((Object)((Object)ganhos)).equals((Object)this.maio)) {
            return 4;
        }
        if (((Object)((Object)ganhos)).equals((Object)this.junho)) {
            return 5;
        }
        if (((Object)((Object)ganhos)).equals((Object)this.julho)) {
            return 6;
        }
        if (((Object)((Object)ganhos)).equals((Object)this.agosto)) {
            return 7;
        }
        if (((Object)((Object)ganhos)).equals((Object)this.setembro)) {
            return 8;
        }
        if (((Object)((Object)ganhos)).equals((Object)this.outubro)) {
            return 9;
        }
        if (((Object)((Object)ganhos)).equals((Object)this.novembro)) {
            return 10;
        }
        if (((Object)((Object)ganhos)).equals((Object)this.dezembro)) {
            return 11;
        }
        return 0;
    }

    public boolean existeContribuicaoPrevidenciaria() {
        boolean retorno = false;
        for (int i = 0; i < 12; ++i) {
            if (this.getMesRendPFPorIndice(i).getPrevidencia().isVazio()) continue;
            retorno = true;
            break;
        }
        return retorno;
    }

    public void addObservador(Observador obs) {
        this.janeiro.addObservador(obs);
        this.fevereiro.addObservador(obs);
        this.marco.addObservador(obs);
        this.abril.addObservador(obs);
        this.maio.addObservador(obs);
        this.junho.addObservador(obs);
        this.julho.addObservador(obs);
        this.agosto.addObservador(obs);
        this.setembro.addObservador(obs);
        this.outubro.addObservador(obs);
        this.novembro.addObservador(obs);
        this.dezembro.addObservador(obs);
    }

    public void removeObservador(Observador obs) {
        this.janeiro.removeObservador(obs);
        this.fevereiro.removeObservador(obs);
        this.marco.removeObservador(obs);
        this.abril.removeObservador(obs);
        this.maio.removeObservador(obs);
        this.junho.removeObservador(obs);
        this.julho.removeObservador(obs);
        this.agosto.removeObservador(obs);
        this.setembro.removeObservador(obs);
        this.outubro.removeObservador(obs);
        this.novembro.removeObservador(obs);
        this.dezembro.removeObservador(obs);
    }

    public MesRendPF getAbril() {
        return this.abril;
    }

    public MesRendPF getAgosto() {
        return this.agosto;
    }

    public MesRendPF getDezembro() {
        return this.dezembro;
    }

    public MesRendPF getFevereiro() {
        return this.fevereiro;
    }

    public MesRendPF getJaneiro() {
        return this.janeiro;
    }

    public MesRendPF getJulho() {
        return this.julho;
    }

    public MesRendPF getJunho() {
        return this.junho;
    }

    public MesRendPF getMaio() {
        return this.maio;
    }

    public MesRendPF getMarco() {
        return this.marco;
    }

    public MesRendPF getNovembro() {
        return this.novembro;
    }

    public MesRendPF getOutubro() {
        return this.outubro;
    }

    public MesRendPF getSetembro() {
        return this.setembro;
    }

    public Valor getTotalDarfPago() {
        return this.totalDarfPago;
    }

    public Valor getTotalDependentes() {
        return this.totalDependentes;
    }

    public Valor getTotalExterior() {
        return this.totalExterior;
    }

    public Valor getTotalLivroCaixa() {
        return this.totalLivroCaixa;
    }

    public Valor getTotalPensao() {
        return this.totalPensao;
    }

    public Valor getTotalPessoaFisica() {
        return this.totalPessoaFisica;
    }

    public Valor getTotalPrevidencia() {
        return this.totalPrevidencia;
    }

    public Alfa getNITPISPASEP() {
        return this.NITPISPASEP;
    }

    public ContasAno getContasAno() {
        return this.contasAno;
    }

    public boolean isVazio() {
        return this.janeiro.isVazio() && this.fevereiro.isVazio() && this.marco.isVazio() && this.abril.isVazio() && this.maio.isVazio() && this.junho.isVazio() && this.julho.isVazio() && this.agosto.isVazio() && this.setembro.isVazio() && this.outubro.isVazio() && this.novembro.isVazio() && this.dezembro.isVazio() && this.contasAno.isVazio() && this.NITPISPASEP.isVazio();
    }

    public void clear() {
        super.clear();
        this.janeiro.clear();
        this.fevereiro.clear();
        this.marco.clear();
        this.abril.clear();
        this.maio.clear();
        this.junho.clear();
        this.julho.clear();
        this.agosto.clear();
        this.setembro.clear();
        this.outubro.clear();
        this.novembro.clear();
        this.dezembro.clear();
    }

    public String getClasseFicha() {
        return PainelDadosEscrituracao.class.getName();
    }

    public String getNomeAba() {
        if (this.getFicha().equals(FICHA_TIT)) {
            return "Outras Informa\u00e7\u00f5es";
        }
        return "Outras Informa\u00e7\u00f5es";
    }

    public Valor getTotalAlugueis() {
        return this.totalAlugueis;
    }

    public Valor getTotalOutros() {
        return this.totalOutros;
    }

    public Valor getTotalImpostoPagoExteriorCompensar() {
        return this.totalImpostoPagoExteriorCompensar;
    }

    public String getTituloFichaDashboard() {
        return "Rendimentos Tribut\u00e1veis Recebidos de PF e do Exterior";
    }

    public Alfa getTotalNumDependentes() {
        return this.totalNumDependentes;
    }

    public Alfa getUsouImportacaoCarneLeaoWeb() {
        return this.usouImportacaoCarneLeaoWeb;
    }

    public void limpar() {
        this.totalPessoaFisica.setObservadoresAtivos(false);
        this.totalAlugueis.setObservadoresAtivos(false);
        this.totalOutros.setObservadoresAtivos(false);
        this.totalExterior.setObservadoresAtivos(false);
        this.totalPrevidencia.setObservadoresAtivos(false);
        this.totalDependentes.setObservadoresAtivos(false);
        this.totalNumDependentes.setObservadoresAtivos(false);
        this.totalPensao.setObservadoresAtivos(false);
        this.totalImpostoPagoExteriorCompensar.setObservadoresAtivos(false);
        this.totalLivroCaixa.setObservadoresAtivos(false);
        this.totalDarfPago.setObservadoresAtivos(false);
        this.totalPessoaFisica.clear();
        this.totalAlugueis.clear();
        this.totalOutros.clear();
        this.totalExterior.clear();
        this.totalPrevidencia.clear();
        this.totalDependentes.clear();
        this.totalNumDependentes.clear();
        this.totalPensao.clear();
        this.totalImpostoPagoExteriorCompensar.clear();
        this.totalLivroCaixa.clear();
        this.totalDarfPago.clear();
        this.totalPessoaFisica.setObservadoresAtivos(true);
        this.totalAlugueis.setObservadoresAtivos(true);
        this.totalOutros.setObservadoresAtivos(true);
        this.totalExterior.setObservadoresAtivos(true);
        this.totalPrevidencia.setObservadoresAtivos(true);
        this.totalDependentes.setObservadoresAtivos(true);
        this.totalNumDependentes.setObservadoresAtivos(true);
        this.totalPensao.setObservadoresAtivos(true);
        this.totalImpostoPagoExteriorCompensar.setObservadoresAtivos(true);
        this.totalLivroCaixa.setObservadoresAtivos(true);
        this.totalDarfPago.setObservadoresAtivos(true);
        for (MesRendPF mes : this.meses) {
            mes.limpar();
        }
    }
}

