/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.resumo;

import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.ItemLimiteDeducaoIncentivo;
import serpro.ppgd.irpf.ValorPositivo;
import serpro.ppgd.irpf.calculos.CalculosDeducoesIncentivos;
import serpro.ppgd.irpf.calculos.CalculosPagamentos;
import serpro.ppgd.irpf.gcap.ValorBigDecimalGCME;
import serpro.ppgd.irpf.resumo.ModeloDeclaracao;
import serpro.ppgd.irpf.util.ConstantesGlobaisIRPF;
import serpro.ppgd.irpf.util.TipoDeclaracaoAES;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Valor;

public class ModeloCompleta
extends ModeloDeclaracao {
    private Valor rendRecebidoPJTitular = new Valor((ObjetoNegocio)this, "");
    private Valor rendRecebidoPJDependentes = new Valor((ObjetoNegocio)this, "");
    private Valor rendRecebidoAcmTitular = new Valor((ObjetoNegocio)this, "");
    private Valor rendRecebidoAcmDependentes = new Valor((ObjetoNegocio)this, "");
    private Valor rendRecebidoPFEXTTitular = new Valor((ObjetoNegocio)this, "");
    private Valor rendRecebidoPFEXTDependentes = new Valor((ObjetoNegocio)this, "");
    private Valor resultadoTributavelAR = new Valor((ObjetoNegocio)this, "");
    private Valor totalRendimentos = new Valor((ObjetoNegocio)this, "");
    private Valor previdenciaOficial = new Valor((ObjetoNegocio)this, "");
    private Valor previdenciaOficialRRA = new Valor((ObjetoNegocio)this, "");
    private Valor previdencia = new Valor((ObjetoNegocio)this, "");
    private Valor deducaoDependentes = new Valor((ObjetoNegocio)this, "");
    private Valor despesasInstrucao = new Valor((ObjetoNegocio)this, "");
    private Valor despesasMedicas = new Valor((ObjetoNegocio)this, "");
    private Valor pensaoAlimenticia = new Valor((ObjetoNegocio)this, "");
    private Valor pensaoAlimenticiaRRA = new Valor((ObjetoNegocio)this, "");
    private Valor pensaoCartoral = new Valor((ObjetoNegocio)this, "");
    private Valor livroCaixa = new Valor((ObjetoNegocio)this, "");
    private Valor totalDeducoes = new Valor((ObjetoNegocio)this, "");
    private Valor totalContribEmpregadoDomestico = new Valor((ObjetoNegocio)this, "");
    private Valor imposto = new Valor((ObjetoNegocio)this, "");
    private Valor deducaoIncentivo = new Valor((ObjetoNegocio)this, "");
    private Valor impostoRetidoFonteTitular = new Valor((ObjetoNegocio)this, "");
    private Valor impostoRetidoFonteDependentes = new Valor((ObjetoNegocio)this, "");
    private Valor carneLeaoTitular = new Valor((ObjetoNegocio)this, "");
    private Valor carneLeaoDependentes = new Valor((ObjetoNegocio)this, "");
    private Valor impostoComplementar = new Valor((ObjetoNegocio)this, "");
    private Valor impostoPagoExterior = new Valor((ObjetoNegocio)this, "");
    private Valor impostoRetidoFonteLei11033 = new Valor((ObjetoNegocio)this, "");
    private Valor totalImpostoPago = new Valor((ObjetoNegocio)this, "");
    private Valor bensDireitosExercicioAnterior = new Valor((ObjetoNegocio)this, "");
    private Valor bensDireitosExercicioAtual = new Valor((ObjetoNegocio)this, "");
    private Valor dividasExercicioAnterior = new Valor((ObjetoNegocio)this, "");
    private Valor dividasExercicioAtual = new Valor((ObjetoNegocio)this, "");
    private Valor rendIsentosNaoTributaveis = new Valor((ObjetoNegocio)this, "");
    private Valor rendTributaveisExigibilidadeSuspensa = new Valor((ObjetoNegocio)this, "");
    private Valor depositosJudiciais = new Valor((ObjetoNegocio)this, "");
    private ValorPositivo rendSujeitoTribExclusiva = new ValorPositivo(this, "");
    private Valor impostoPagoGCAP = new Valor((ObjetoNegocio)this, "");
    private Valor impostoPagoME = new Valor((ObjetoNegocio)this, "");
    private Valor totalImpostoRetidoNaFonte = new Valor((ObjetoNegocio)this, "");
    private Valor impostoPagoSobreRendaVariavel = new Valor((ObjetoNegocio)this, "");
    private Valor impostoDiferidoGCAP = new Valor((ObjetoNegocio)this, "");
    private Valor impostoDevidoGCAP = new Valor((ObjetoNegocio)this, "");
    private Valor impostoDevidoRendaVariavel = new Valor((ObjetoNegocio)this, "");
    private Valor impostoDevidoGCME = new Valor((ObjetoNegocio)this, "");
    private Valor impostoDevidoComRendExterior = new Valor((ObjetoNegocio)this, "");
    private Valor impostoDevidoSemRendExterior = new Valor((ObjetoNegocio)this, "");
    private Valor limiteImpPagoExterior = new Valor((ObjetoNegocio)this, "");
    private Valor aliquotaEfetiva = new Valor((ObjetoNegocio)this, "");

    public ModeloCompleta(DeclaracaoIRPF dec) {
        super(dec);
    }

    @Override
    public void resumoRendimentosTributaveis() {
        this.rendRecebidoPJTitular.setConteudo(this.declaracaoIRPF.getColecaoRendPJTitular().getTotaisRendRecebidoPJ());
        this.rendRecebidoPJDependentes.setConteudo(this.declaracaoIRPF.getColecaoRendPJDependente().getTotaisRendRecebidoPJ());
        this.rendRecebidoAcmTitular.setConteudo(this.declaracaoIRPF.getColecaoRendAcmTitular().getTotaisRendRecebidosAjuste());
        this.rendRecebidoAcmDependentes.setConteudo(this.declaracaoIRPF.getColecaoRendAcmDependente().getTotaisRendRecebidosAjuste());
        this.rendRecebidoPFEXTTitular.clear();
        this.rendRecebidoPFEXTTitular.append('+', this.declaracaoIRPF.getRendPFTitular().getTotalPessoaFisica());
        this.rendRecebidoPFEXTTitular.append('+', this.declaracaoIRPF.getRendPFTitular().getTotalAlugueis());
        this.rendRecebidoPFEXTTitular.append('+', this.declaracaoIRPF.getRendPFTitular().getTotalOutros());
        this.rendRecebidoPFEXTTitular.append('+', this.declaracaoIRPF.getRendPFTitular().getTotalExterior());
        this.rendRecebidoPFEXTDependentes.clear();
        this.rendRecebidoPFEXTDependentes.append('+', this.declaracaoIRPF.getRendPFDependente().getTotalPessoaFisica());
        this.rendRecebidoPFEXTDependentes.append('+', this.declaracaoIRPF.getRendPFDependente().getTotalAlugueis());
        this.rendRecebidoPFEXTDependentes.append('+', this.declaracaoIRPF.getRendPFDependente().getTotalOutros());
        this.rendRecebidoPFEXTDependentes.append('+', this.declaracaoIRPF.getRendPFDependente().getTotalExterior());
        this.rendRecebidoExterior.clear();
        this.rendRecebidoExterior.append('+', this.declaracaoIRPF.getRendPFTitular().getTotalExterior());
        this.rendRecebidoExterior.append('+', this.declaracaoIRPF.getRendPFDependente().getTotalExterior());
        this.resultadoTributavelAR.clear();
        if (this.declaracaoIRPF.getAtividadeRural().getBrasil().getApuracaoResultado().getResultadoTributavel().comparacao(">", "0,00")) {
            this.resultadoTributavelAR.append('+', (Valor)this.declaracaoIRPF.getAtividadeRural().getBrasil().getApuracaoResultado().getResultadoTributavel());
        }
        if (this.declaracaoIRPF.getAtividadeRural().getExterior().getApuracaoResultado().getResultadoTributavel().comparacao(">", "0,00")) {
            this.resultadoTributavelAR.append('+', (Valor)this.declaracaoIRPF.getAtividadeRural().getExterior().getApuracaoResultado().getResultadoTributavel());
        }
        this.totalRendimentos.clear();
        this.totalRendimentos.append('+', this.rendRecebidoPJTitular);
        this.totalRendimentos.append('+', this.rendRecebidoPJDependentes);
        this.totalRendimentos.append('+', this.rendRecebidoAcmTitular);
        this.totalRendimentos.append('+', this.rendRecebidoAcmDependentes);
        this.totalRendimentos.append('+', this.rendRecebidoPFEXTTitular);
        this.totalRendimentos.append('+', this.rendRecebidoPFEXTDependentes);
        this.totalRendimentos.append('+', this.resultadoTributavelAR);
        this.previdenciaOficial.clear();
        this.previdenciaOficial.append('+', this.declaracaoIRPF.getRendPFTitular().getTotalPrevidencia());
        this.previdenciaOficial.append('+', this.declaracaoIRPF.getRendPFDependente().getTotalPrevidencia());
        this.previdenciaOficial.append('+', this.declaracaoIRPF.getRendPJ().getColecaoRendPJTitular().getTotaisContribuicaoPrevOficial());
        this.previdenciaOficial.append('+', this.declaracaoIRPF.getRendPJ().getColecaoRendPJDependente().getTotaisContribuicaoPrevOficial());
        this.previdenciaOficial.append('+', this.declaracaoIRPF.getPagamentos().getTotalContribuicaoFunpresp());
        this.previdenciaOficial.append('+', this.declaracaoIRPF.getRendIsentos().getPensaoQuadroAuxiliar().getTotalPrevidenciaOficialTitular());
        this.previdenciaOficial.append('+', this.declaracaoIRPF.getRendIsentos().getPensaoQuadroAuxiliar().getTotalPrevidenciaOficialDependentes());
        this.previdenciaOficialRRA.clear();
        this.previdenciaOficialRRA.append('+', this.declaracaoIRPF.getColecaoRendAcmTitular().getTotaisContribuicaoPrevOficialAjuste());
        this.previdenciaOficialRRA.append('+', this.declaracaoIRPF.getColecaoRendAcmDependente().getTotaisContribuicaoPrevOficialAjuste());
        this.previdencia.setConteudo(this.declaracaoIRPF.getPagamentos().getTotalContribuicaoPreviPrivada());
        this.deducaoDependentes.setConteudo(this.declaracaoIRPF.getDependentes().getTotalDeducaoDependentes());
        this.despesasInstrucao.setConteudo(this.declaracaoIRPF.getPagamentos().getTotalDeducoesInstrucao());
        this.despesasMedicas.setConteudo(this.declaracaoIRPF.getPagamentos().getTotalDespesasMedicas());
        this.pensaoAlimenticia.clear();
        this.pensaoAlimenticia.append('+', this.declaracaoIRPF.getPagamentos().getTotalPensao());
        this.pensaoCartoral.setConteudo(this.declaracaoIRPF.getPagamentos().getTotalPensaoCartoral());
        this.pensaoAlimenticiaRRA.clear();
        this.pensaoAlimenticiaRRA.append('+', this.declaracaoIRPF.getColecaoRendAcmTitular().getTotaisPensaoAlimenticiaAjuste());
        this.pensaoAlimenticiaRRA.append('+', this.declaracaoIRPF.getColecaoRendAcmDependente().getTotaisPensaoAlimenticiaAjuste());
        this.livroCaixa.clear();
        this.livroCaixa.append('+', this.declaracaoIRPF.getRendPFTitular().getTotalLivroCaixa());
        this.livroCaixa.append('+', this.declaracaoIRPF.getRendPFDependente().getTotalLivroCaixa());
        if (ConstantesGlobaisIRPF.PERMITIR_DEDUCAO_CONTRIBUICAO_PATRONAL) {
            this.totalContribEmpregadoDomestico.setConteudo(this.declaracaoIRPF.getPagamentos().getTotalContribEmpregadoDomestico());
        } else {
            this.totalContribEmpregadoDomestico.clear();
        }
        ItemLimiteDeducaoIncentivo lItemLimiteDeducaoIncentivo = CalculosDeducoesIncentivos.calculaDeducaoIncentivo((DeclaracaoIRPF)this.declaracaoIRPF, (Valor)this.declaracaoIRPF.getModeloCompleta().getImposto());
        Valor limiteSemPronasPronon = new Valor();
        limiteSemPronasPronon.setCasasDecimais(4);
        limiteSemPronasPronon.setConteudo(lItemLimiteDeducaoIncentivo.getLimite6porcento());
        Valor utilizado = new Valor();
        utilizado.setCasasDecimais(4);
        utilizado.append('+', this.declaracaoIRPF.getDoacoes().getTotalDeducaoIncentivo());
        utilizado.append('+', this.declaracaoIRPF.getColecaoEstatutoCriancaAdolescente().getTotalDeducaoIncentivoBruto());
        utilizado.append('+', this.declaracaoIRPF.getColecaoEstatutoIdoso().getTotalDeducaoIncentivoBruto());
        Valor deducaoIncentivoAux = new Valor();
        deducaoIncentivoAux.setCasasDecimais(4);
        if (utilizado.comparacao(">", limiteSemPronasPronon)) {
            deducaoIncentivoAux.setConteudo(limiteSemPronasPronon);
        } else {
            deducaoIncentivoAux.setConteudo(utilizado);
        }
        deducaoIncentivoAux.append('+', lItemLimiteDeducaoIncentivo.getDeducaoEfetivaCod45());
        deducaoIncentivoAux.append('+', lItemLimiteDeducaoIncentivo.getDeducaoEfetivaCod46());
        this.deducaoIncentivo.setConteudo(deducaoIncentivoAux);
        this.totalDeducoes.clear();
        this.totalDeducoes.append('+', this.previdenciaOficial);
        this.totalDeducoes.append('+', this.previdencia);
        this.totalDeducoes.append('+', this.deducaoDependentes);
        this.totalDeducoes.append('+', this.despesasInstrucao);
        this.totalDeducoes.append('+', this.despesasMedicas);
        this.totalDeducoes.append('+', this.pensaoAlimenticia);
        this.totalDeducoes.append('+', this.pensaoCartoral);
        this.totalDeducoes.append('+', this.livroCaixa);
        this.totalDeducoes.append('+', this.previdenciaOficialRRA);
        this.totalDeducoes.append('+', this.pensaoAlimenticiaRRA);
    }

    @Override
    public void resumoCalculoImposto() {
        this.baseCalculo.clear();
        this.baseCalculo.append('+', this.totalRendimentos);
        this.baseCalculo.append('-', this.totalDeducoes);
        if (this.baseCalculo.comparacao("<", "0,00")) {
            this.baseCalculo.clear();
        }
        this.imposto.setConteudo(this.calculaImposto(this.baseCalculo));
        ItemLimiteDeducaoIncentivo lItemLimiteDeducaoIncentivo = CalculosDeducoesIncentivos.calculaDeducaoIncentivo((DeclaracaoIRPF)this.declaracaoIRPF);
        Valor limiteSemPronasPronon = new Valor();
        limiteSemPronasPronon.setCasasDecimais(4);
        limiteSemPronasPronon.setConteudo(lItemLimiteDeducaoIncentivo.getLimite6porcento());
        Valor utilizado = new Valor();
        utilizado.setCasasDecimais(4);
        utilizado.append('+', lItemLimiteDeducaoIncentivo.getDeducaoEfetivaSemCod39());
        utilizado.append('+', this.declaracaoIRPF.getColecaoEstatutoCriancaAdolescente().getTotalDeducaoIncentivoBruto());
        utilizado.append('+', this.declaracaoIRPF.getColecaoEstatutoIdoso().getTotalDeducaoIncentivoBruto());
        Valor deducaoIncentivoAux = new Valor();
        deducaoIncentivoAux.setCasasDecimais(4);
        if (utilizado.comparacao(">", limiteSemPronasPronon)) {
            deducaoIncentivoAux.setConteudo(limiteSemPronasPronon);
        } else {
            deducaoIncentivoAux.setConteudo(utilizado);
        }
        deducaoIncentivoAux.append('+', lItemLimiteDeducaoIncentivo.getDeducaoEfetivaCod45());
        deducaoIncentivoAux.append('+', lItemLimiteDeducaoIncentivo.getDeducaoEfetivaCod46());
        this.deducaoIncentivo.setConteudo(deducaoIncentivoAux);
        this.impostoDevido.clear();
        this.impostoDevido.append('+', this.imposto);
        this.impostoDevido.append('-', this.deducaoIncentivo);
        if (this.impostoDevido.comparacao("<", "0,00")) {
            this.impostoDevido.clear();
        }
        if (ConstantesGlobaisIRPF.PERMITIR_DEDUCAO_CONTRIBUICAO_PATRONAL) {
            this.totalContribEmpregadoDomestico.setConteudo(this.declaracaoIRPF.getPagamentos().getTotalContribEmpregadoDomestico());
        } else {
            this.totalContribEmpregadoDomestico.clear();
        }
        if (this.declaracaoIRPF.getIdentificadorDeclaracao().isEspolio()) {
            int numMeses = this.declaracaoIRPF.getEspolio().getQtdMesesParaCalculos();
            Valor limiteContribEmpEspolio = new Valor("0,0000");
            if (numMeses == 12) {
                limiteContribEmpEspolio.setConteudo("1.251,07");
            } else {
                limiteContribEmpEspolio.setConteudo(this.calcularLimiteContribuicaoEmpregadoEspolio(numMeses));
                Valor proporcionalDecimoTerceiro = this.calcularProporcionalDecimoTerceiroEspolio(numMeses);
                limiteContribEmpEspolio.append('+', proporcionalDecimoTerceiro);
                Valor abonoFerias = this.calcularAbonoFerias();
                limiteContribEmpEspolio.append('+', abonoFerias);
            }
            this.calcularTotalContribuicaoEmpregadoDomestico(limiteContribEmpEspolio);
        } else if (this.declaracaoIRPF.getIdentificadorDeclaracao().isSaida()) {
            int numMesInicial = this.declaracaoIRPF.getSaida().getMesInicial();
            int numMesFinal = this.declaracaoIRPF.getSaida().getMesFinal();
            int numMeses = numMesFinal - numMesInicial + 1;
            Valor limiteContribEmpSaida = new Valor("0,0000");
            if (numMeses == 12) {
                limiteContribEmpSaida.setConteudo("1.251,07");
            } else {
                limiteContribEmpSaida.setConteudo(this.calcularLimiteContribuicaoEmpregadoSaida(numMesInicial, numMesFinal));
                Valor proporcionalDecimoTerceiro = this.calcularProporcionalDecimoTerceiroSaida(numMeses, numMesInicial, numMesFinal);
                limiteContribEmpSaida.append('+', proporcionalDecimoTerceiro);
                Valor abonoFerias = this.calcularAbonoFerias();
                limiteContribEmpSaida.append('+', abonoFerias);
            }
            this.calcularTotalContribuicaoEmpregadoDomestico(limiteContribEmpSaida);
        } else {
            this.calcularTotalContribuicaoEmpregadoDomestico(new Valor("1.251,07"));
        }
        this.impostoDevidoLei14754.setConteudo((Valor)this.declaracaoIRPF.getContribuinte().getImpostoDevidoLei14754());
        this.impostoDevidoRRA.clear();
        this.impostoDevidoRRA.append('+', this.declaracaoIRPF.getRendAcm().getColecaoRendAcmTitular().getTotaisImpostoDevidoRRA());
        this.impostoDevidoRRA.append('+', this.declaracaoIRPF.getRendAcm().getColecaoRendAcmDependente().getTotaisImpostoDevidoRRA());
        this.impostoDevidoI.clear();
        this.impostoDevidoI.append('+', this.impostoDevido);
        this.impostoDevidoI.append('-', this.totalContribEmpregadoDomestico);
        if (this.impostoDevidoI.comparacao("<", "0,00")) {
            this.impostoDevidoI.clear();
        }
        this.impostoDevidoII.clear();
        this.impostoDevidoII.append('+', this.impostoDevido);
        this.impostoDevidoII.append('+', this.impostoDevidoRRA);
        this.impostoDevidoII.append('+', this.impostoDevidoLei14754);
        this.impostoDevidoII.append('-', this.totalContribEmpregadoDomestico);
        if (this.impostoDevidoII.comparacao("<", "0,00")) {
            this.impostoDevidoII.clear();
        }
        this.impostoRetidoFonteTitular.clear();
        this.impostoRetidoFonteTitular.append('+', this.declaracaoIRPF.getColecaoRendPJTitular().getTotaisImpostoRetidoFonte());
        this.impostoRetidoFonteTitular.append('+', this.declaracaoIRPF.getColecaoRendAcmTitular().getTotaisImpostoRetidoFonteAjuste());
        this.impostoRetidoFonteTitular.append('+', this.declaracaoIRPF.getRendIsentos().getPensaoQuadroAuxiliar().getTotalIRRFTitular());
        this.impostoRetidoFonteTitular.append('+', this.declaracaoIRPF.getRendIsentos().getPensaoQuadroAuxiliar().getTotalIRRF13SalarioTitular());
        this.impostoRetidoFonteDependentes.clear();
        this.impostoRetidoFonteDependentes.append('+', this.declaracaoIRPF.getColecaoRendPJDependente().getTotaisImpostoRetidoFonte());
        this.impostoRetidoFonteDependentes.append('+', this.declaracaoIRPF.getColecaoRendAcmDependente().getTotaisImpostoRetidoFonteAjuste());
        this.impostoRetidoFonteDependentes.append('+', this.declaracaoIRPF.getRendIsentos().getPensaoQuadroAuxiliar().getTotalIRRFDependentes());
        this.impostoRetidoFonteDependentes.append('+', this.declaracaoIRPF.getRendIsentos().getPensaoQuadroAuxiliar().getTotalIRRF13SalarioDependentes());
        this.carneLeaoTitular.setConteudo(this.declaracaoIRPF.getRendPFTitular().getTotalDarfPago());
        this.carneLeaoDependentes.setConteudo(this.declaracaoIRPF.getRendPFDependente().getTotalDarfPago());
        this.impostoComplementar.setConteudo((Valor)this.declaracaoIRPF.getImpostoPago().getImpostoComplementar());
        Valor impPagoExt = new Valor();
        this.aplicaLimitesImpostoPagoExterior(impPagoExt);
        this.impostoPagoExterior.setConteudo(impPagoExt);
        this.declaracaoIRPF.getImpostoPago().getImpostoRetidoFonteTitular().setConteudo(this.impostoRetidoFonteTitular);
        this.declaracaoIRPF.getImpostoPago().getImpostoRetidoFonteDependentes().setConteudo(this.impostoRetidoFonteDependentes);
        this.declaracaoIRPF.getImpostoPago().getCarneLeaoTitular().setConteudo(this.carneLeaoTitular);
        this.declaracaoIRPF.getImpostoPago().getCarneLeaoDependentes().setConteudo(this.carneLeaoDependentes);
        this.impostoRetidoFonteLei11033.setConteudo((Valor)this.declaracaoIRPF.getImpostoPago().getImpostoRetidoFonte());
        this.impostoRetidoRRA.clear();
        this.impostoRetidoRRA.append('+', this.declaracaoIRPF.getRendAcm().getColecaoRendAcmTitular().getTotaisImpostoRetidoFonteExclusiva());
        this.impostoRetidoRRA.append('+', this.declaracaoIRPF.getRendAcm().getColecaoRendAcmDependente().getTotaisImpostoRetidoFonteExclusiva());
        this.totalImpostoPago.clear();
        this.totalImpostoPago.append('+', this.impostoRetidoFonteTitular);
        this.totalImpostoPago.append('+', this.impostoRetidoFonteDependentes);
        this.totalImpostoPago.append('+', this.carneLeaoTitular);
        this.totalImpostoPago.append('+', this.carneLeaoDependentes);
        this.totalImpostoPago.append('+', this.impostoRetidoFonteLei11033);
        this.totalImpostoPago.append('+', this.impostoComplementar);
        this.totalImpostoPago.append('+', this.impostoPagoExterior);
        this.totalImpostoPago.append('+', this.impostoRetidoRRA);
        this.saldoImpostoPagar.clear();
        this.impostoRestituir.clear();
        Valor impostoDevidoIIComDuasCasas = new Valor(this.impostoDevidoII.formatado());
        if (impostoDevidoIIComDuasCasas.comparacao("<", this.totalImpostoPago)) {
            this.impostoRestituir.clear();
            this.impostoRestituir.append('+', this.totalImpostoPago);
            this.impostoRestituir.append('-', impostoDevidoIIComDuasCasas);
        } else {
            this.saldoImpostoPagar.clear();
            this.saldoImpostoPagar.append('+', impostoDevidoIIComDuasCasas);
            this.saldoImpostoPagar.append('-', this.totalImpostoPago);
        }
        ValorBigDecimalGCME lAliquotaEfetiva = new ValorBigDecimalGCME(null, "Aliquota Efetiva", 15, 4);
        if (!this.totalRendimentos.isVazio()) {
            lAliquotaEfetiva.append('+', this.impostoDevidoI.formatado());
            lAliquotaEfetiva.append('/', this.totalRendimentos.formatado());
            lAliquotaEfetiva.append('*', "100,00");
        }
        this.aliquotaEfetiva.setConteudo((Valor)lAliquotaEfetiva);
    }

    private void calcularTotalContribuicaoEmpregadoDomestico(Valor limiteContribEmpSaida) {
        if (ConstantesGlobaisIRPF.PERMITIR_DEDUCAO_CONTRIBUICAO_PATRONAL) {
            if (this.impostoDevido.comparacao(">", limiteContribEmpSaida)) {
                if (this.totalContribEmpregadoDomestico.comparacao(">", limiteContribEmpSaida)) {
                    this.totalContribEmpregadoDomestico.setConteudo(limiteContribEmpSaida);
                }
            } else if (this.totalContribEmpregadoDomestico.comparacao(">", this.impostoDevido.formatado())) {
                this.totalContribEmpregadoDomestico.setConteudo(this.impostoDevido.formatado());
            }
        } else {
            this.totalContribEmpregadoDomestico.clear();
        }
    }

    private Valor calcularLimiteContribuicaoEmpregadoEspolio(int numMeses) {
        return this.calcularLimiteContribuicaoEmpregadoSaida(1, numMeses);
    }

    private Valor calcularLimiteContribuicaoEmpregadoSaida(int mesInicial, int mesFinal) {
        Valor limiteContribEmpEspolio = new Valor("0,0000");
        for (int i = mesInicial; i <= mesFinal; ++i) {
            limiteContribEmpEspolio.append('+', ConstantesGlobaisIRPF.CONTRIB_PATRONAL[i - 1]);
        }
        return limiteContribEmpEspolio;
    }

    private Valor calcularProporcionalDecimoTerceiroEspolio(Integer numMeses) {
        return this.calcularProporcionalDecimoTerceiro(numMeses, 1, numMeses, TipoDeclaracaoAES.ESPOLIO);
    }

    private Valor calcularProporcionalDecimoTerceiroSaida(Integer numMeses, Integer numMesInicial, Integer numMesFinal) {
        return this.calcularProporcionalDecimoTerceiro(numMeses, numMesInicial, numMesFinal, TipoDeclaracaoAES.SAIDA);
    }

    private Valor calcularProporcionalDecimoTerceiro(Integer numMeses, Integer numMesInicial, Integer numMesFinal, TipoDeclaracaoAES tipoDeclaracaoAES) {
        Valor proporcionalDecimoTerceiro = new Valor();
        proporcionalDecimoTerceiro.setCasasDecimais(4);
        int quantidadeMesesMutiplicar = numMeses;
        Valor decimoTerceiroJaneiro = new Valor();
        decimoTerceiroJaneiro.setCasasDecimais(4);
        int numMesInicialCalculo = numMesInicial;
        if (numMesInicial != null && numMesInicial == 1) {
            numMesInicialCalculo = 2;
            --quantidadeMesesMutiplicar;
            decimoTerceiroJaneiro.setConteudo(ConstantesGlobaisIRPF.CONTRIB_PATRONAL_DECIMO_TERCEIRO[0]);
        } else {
            decimoTerceiroJaneiro.setConteudo("0,00");
        }
        if (quantidadeMesesMutiplicar > 0) {
            for (int i = numMesInicialCalculo; i <= numMesFinal; ++i) {
                proporcionalDecimoTerceiro.append('+', ConstantesGlobaisIRPF.CONTRIB_PATRONAL_DECIMO_TERCEIRO[i - 1]);
            }
        }
        proporcionalDecimoTerceiro.append('+', decimoTerceiroJaneiro);
        return proporcionalDecimoTerceiro;
    }

    private Valor calcularAbonoFerias() {
        Valor abonoFerias = new Valor("0,0000");
        abonoFerias.setConteudo("29,2747");
        return abonoFerias;
    }

    @Override
    public void resumoOutrasInformacoes() {
        this.bensDireitosExercicioAnterior.setConteudo(this.declaracaoIRPF.getBens().getTotalExercicioAnterior());
        this.bensDireitosExercicioAtual.setConteudo(this.declaracaoIRPF.getBens().getTotalExercicioAtual());
        this.dividasExercicioAnterior.setConteudo(this.declaracaoIRPF.getDividas().getTotalExercicioAnterior());
        this.dividasExercicioAtual.setConteudo(this.declaracaoIRPF.getDividas().getTotalExercicioAtual());
        this.rendIsentosNaoTributaveis.setConteudo(this.declaracaoIRPF.getRendIsentos().getTotal());
        this.rendTributaveisExigibilidadeSuspensa.setConteudo(this.declaracaoIRPF.getRendPJComExigibilidade().getTotalRendRecebPessoaJuridica());
        this.depositosJudiciais.setConteudo(this.declaracaoIRPF.getRendPJComExigibilidade().getTotalDepositoJudicial());
        this.rendSujeitoTribExclusiva.setConteudo(this.declaracaoIRPF.getRendTributacaoExclusiva().getTotal());
        this.impostoPagoGCAP.setConteudo((Valor)this.declaracaoIRPF.getGCAP().getConsolidacaoGeralBrasil().getTotalImpostoPago());
        this.impostoDevidoGCME.setConteudo((Valor)this.declaracaoIRPF.getGCAP().obterSomatorioImpostoDevido1NoExercicioAlienacoesGCME());
        this.impostoPagoME.setConteudo((Valor)this.declaracaoIRPF.getGCAP().getConsolidacaoGeralExterior().getTotalImpostoPago());
        this.declaracaoIRPF.getResumo().getOutrasInformacoes().getImpostoEspecie().setConteudo((Valor)this.declaracaoIRPF.getGCAP().getConsolidacaoGeralEspecie().getImpostoDevido());
        this.declaracaoIRPF.getResumo().getOutrasInformacoes().getImpostoDevidoGCME().setConteudo((Valor)this.declaracaoIRPF.getGCAP().obterSomatorioImpostoDevido1NoExercicioAlienacoesGCME());
        this.totalImpostoRetidoNaFonte.clear();
        this.totalImpostoRetidoNaFonte.append('+', this.declaracaoIRPF.getRendaVariavel().getTotalImpostoRetidoFonteLei11033());
        this.totalImpostoRetidoNaFonte.append('+', this.declaracaoIRPF.getRendaVariavelDependente().getTotalImpostoRetidoFonteLei11033());
        this.totalImpostoRetidoNaFonte.append('+', this.declaracaoIRPF.getFundosInvestimentos().getTotalImpostoRetidoFonteLei11033());
        this.totalImpostoRetidoNaFonte.append('+', this.declaracaoIRPF.getFundosInvestimentosDependente().getTotalImpostoRetidoFonteLei11033());
        this.totalImpostoRetidoNaFonte.append('+', (Valor)this.declaracaoIRPF.getGCAP().getConsolidacaoGeralBrasil().getValorIRF());
        Valor rendVarImpostoPago = new Valor(this.declaracaoIRPF.getRendaVariavel().getTotalImpostoPago().naoFormatado());
        rendVarImpostoPago.append('+', this.declaracaoIRPF.getFundosInvestimentos().getTotalImpostoPago());
        rendVarImpostoPago.append('+', this.declaracaoIRPF.getRendaVariavelDependente().getTotalImpostoPago());
        rendVarImpostoPago.append('+', this.declaracaoIRPF.getFundosInvestimentosDependente().getTotalImpostoPago());
        this.impostoPagoSobreRendaVariavel.setConteudo(rendVarImpostoPago);
        this.totalDoacoesCampanhasEleitorais.setConteudo(this.declaracaoIRPF.getDoacoesEleitorais().getTotalDoacoes());
        this.impostoDiferidoGCAP.setConteudo((Valor)this.declaracaoIRPF.getGCAP().getConsolidacaoGeralBrasil().getImpostoDiferidoAnosPosteriores());
        this.impostoDevidoGCAP.setConteudo((Valor)this.declaracaoIRPF.getGCAP().getConsolidacaoGeralBrasil().getImpostoDevidoAnoAtual());
        this.impostoDevidoRendaVariavel.clear();
        this.impostoDevidoRendaVariavel.append('+', this.declaracaoIRPF.getRendaVariavel().getTotalImpostoAPagar());
        this.impostoDevidoRendaVariavel.append('+', this.declaracaoIRPF.getRendaVariavelDependente().getTotalImpostoAPagar());
        Valor impostoPagarFIITitular = new Valor();
        impostoPagarFIITitular.append('+', this.declaracaoIRPF.getFundosInvestimentos().getTotalImpostoDevido());
        impostoPagarFIITitular.append('-', this.declaracaoIRPF.getFundosInvestimentos().getTotalImpostoRetidoFonteLei11033());
        Valor impostoPagarFIIDependentes = new Valor();
        impostoPagarFIIDependentes.append('+', this.declaracaoIRPF.getFundosInvestimentosDependente().getTotalImpostoDevido());
        impostoPagarFIIDependentes.append('-', this.declaracaoIRPF.getFundosInvestimentosDependente().getTotalImpostoRetidoFonteLei11033());
        Valor impostoPagarFII = new Valor();
        impostoPagarFII.append('+', impostoPagarFIITitular);
        impostoPagarFII.append('+', impostoPagarFIIDependentes);
        if (impostoPagarFII.comparacao("<", "0")) {
            impostoPagarFII.clear();
        }
        this.impostoDevidoRendaVariavel.append('+', impostoPagarFII);
        if (this.impostoDevidoRendaVariavel.comparacao("<", "0")) {
            this.impostoDevidoRendaVariavel.clear();
        }
        this.impostoDevidoGCAP.setConteudo((Valor)this.declaracaoIRPF.getGCAP().getConsolidacaoGeralBrasil().getImpostoDevidoAnoAtual());
    }

    private void aplicaLimitesImpostoPagoExterior(Valor impPagoExt) {
        if (this.declaracaoIRPF.getImpostoPago().getImpostoPagoExterior().comparacao(">", "0,00")) {
            Valor limiteImpostoPagoNoExterior;
            Valor deducaoIncentivoSemRendExterior = new Valor();
            impPagoExt.setConteudo((Valor)this.declaracaoIRPF.getImpostoPago().getImpostoPagoExterior());
            Valor baseCalcImpDevidoCOMRendNoExterior = new Valor();
            baseCalcImpDevidoCOMRendNoExterior.append('+', this.totalRendimentos);
            baseCalcImpDevidoCOMRendNoExterior.append('-', this.totalDeducoes);
            Valor impDevidoCOMRendExterior = new Valor();
            impDevidoCOMRendExterior.setConteudo(this.calculaImposto(baseCalcImpDevidoCOMRendNoExterior));
            impDevidoCOMRendExterior.append('-', this.totalContribEmpregadoDomestico);
            impDevidoCOMRendExterior.append('-', this.deducaoIncentivo);
            this.impostoDevidoComRendExterior.setConteudo(impDevidoCOMRendExterior);
            Valor totalRendTrib = new Valor();
            totalRendTrib.append('+', this.totalRendimentos);
            totalRendTrib.append('-', this.rendRecebidoExterior);
            Valor totalDeducoesSemRendExt = new Valor();
            totalDeducoesSemRendExt.append('+', this.previdenciaOficial);
            totalDeducoesSemRendExt.append('+', CalculosPagamentos.calculaTotalContribuicaoPreviPrivada((DeclaracaoIRPF)this.declaracaoIRPF, (Valor)totalRendTrib));
            totalDeducoesSemRendExt.append('+', this.deducaoDependentes);
            totalDeducoesSemRendExt.append('+', this.despesasInstrucao);
            totalDeducoesSemRendExt.append('+', this.despesasMedicas);
            totalDeducoesSemRendExt.append('+', this.pensaoAlimenticia);
            totalDeducoesSemRendExt.append('+', this.pensaoCartoral);
            totalDeducoesSemRendExt.append('+', this.livroCaixa);
            totalDeducoesSemRendExt.append('+', this.previdenciaOficialRRA);
            totalDeducoesSemRendExt.append('+', this.pensaoAlimenticiaRRA);
            Valor baseCalcImpDevidoSEMRendNoExterior = new Valor();
            baseCalcImpDevidoSEMRendNoExterior.append('+', totalRendTrib);
            baseCalcImpDevidoSEMRendNoExterior.append('-', totalDeducoesSemRendExt);
            Valor impDevidoSEMRendExterior = this.calculaImposto(baseCalcImpDevidoSEMRendNoExterior);
            ItemLimiteDeducaoIncentivo lItemLimiteDeducaoIncentivo = CalculosDeducoesIncentivos.calculaDeducaoIncentivo((DeclaracaoIRPF)this.declaracaoIRPF, (Valor)impDevidoSEMRendExterior);
            deducaoIncentivoSemRendExterior.setConteudo(lItemLimiteDeducaoIncentivo.getValorAceitoDeducaoExercicio());
            impDevidoSEMRendExterior.append('-', this.totalContribEmpregadoDomestico);
            impDevidoSEMRendExterior.append('-', deducaoIncentivoSemRendExterior);
            if (impDevidoSEMRendExterior.comparacao("<", "0,00")) {
                impDevidoSEMRendExterior.clear();
            }
            if (impPagoExt.comparacao(">", limiteImpostoPagoNoExterior = impDevidoCOMRendExterior.operacao('-', impDevidoSEMRendExterior))) {
                impPagoExt.setConteudo(limiteImpostoPagoNoExterior);
            }
            this.impostoDevidoSemRendExterior.setConteudo(impDevidoSEMRendExterior);
            this.limiteImpPagoExterior.setConteudo(impPagoExt);
        } else {
            this.impostoDevidoComRendExterior.clear();
            this.impostoDevidoSemRendExterior.clear();
            this.limiteImpPagoExterior.clear();
        }
    }

    @Override
    public void aplicaValoresNaDeclaracao() {
        this.declaracaoIRPF.getImpostoPago().getImpostoDevidoComRendExterior().setConteudo(this.impostoDevidoComRendExterior);
        this.declaracaoIRPF.getImpostoPago().getImpostoDevidoSemRendExterior().setConteudo(this.impostoDevidoSemRendExterior);
        this.declaracaoIRPF.getImpostoPago().getLimiteImpPagoExterior().setConteudo(this.limiteImpPagoExterior);
        this.declaracaoIRPF.getResumo().getRendimentosTributaveisDeducoes().getRendRecebidoPJTitular().setConteudo(this.rendRecebidoPJTitular);
        this.declaracaoIRPF.getResumo().getRendimentosTributaveisDeducoes().getRendRecebidoPJDependentes().setConteudo(this.rendRecebidoPJDependentes);
        this.declaracaoIRPF.getResumo().getRendimentosTributaveisDeducoes().getRendRecebidoAcmTitular().setConteudo(this.rendRecebidoAcmTitular);
        this.declaracaoIRPF.getResumo().getRendimentosTributaveisDeducoes().getRendRecebidoAcmDependentes().setConteudo(this.rendRecebidoAcmDependentes);
        this.declaracaoIRPF.getResumo().getRendimentosTributaveisDeducoes().getRendRecebidoPFEXTTitular().setConteudo(this.rendRecebidoPFEXTTitular);
        this.declaracaoIRPF.getResumo().getRendimentosTributaveisDeducoes().getRendRecebidoPFEXTDependentes().setConteudo(this.rendRecebidoPFEXTDependentes);
        this.declaracaoIRPF.getResumo().getRendimentosTributaveisDeducoes().getRendTributavelAR().setConteudo(this.resultadoTributavelAR);
        this.declaracaoIRPF.getResumo().getRendimentosTributaveisDeducoes().getTotalRendimentos().setConteudo(this.totalRendimentos);
        this.declaracaoIRPF.getResumo().getRendimentosTributaveisDeducoes().getPrevidenciaOficial().setConteudo(this.previdenciaOficial);
        this.declaracaoIRPF.getResumo().getRendimentosTributaveisDeducoes().getPrevidenciaOficialRRA().setConteudo(this.previdenciaOficialRRA);
        this.declaracaoIRPF.getResumo().getRendimentosTributaveisDeducoes().getPrevidencia().setConteudo(this.previdencia);
        this.declaracaoIRPF.getResumo().getRendimentosTributaveisDeducoes().getDependentes().setConteudo(this.deducaoDependentes);
        this.declaracaoIRPF.getResumo().getRendimentosTributaveisDeducoes().getDespesasInstrucao().setConteudo(this.despesasInstrucao);
        this.declaracaoIRPF.getResumo().getRendimentosTributaveisDeducoes().getDespesasMedicas().setConteudo(this.despesasMedicas);
        this.declaracaoIRPF.getResumo().getRendimentosTributaveisDeducoes().getPensaoAlimenticia().setConteudo(this.pensaoAlimenticia);
        this.declaracaoIRPF.getResumo().getRendimentosTributaveisDeducoes().getPensaoAlimenticiaRRA().setConteudo(this.pensaoAlimenticiaRRA);
        this.declaracaoIRPF.getResumo().getRendimentosTributaveisDeducoes().getPensaoCartoral().setConteudo(this.pensaoCartoral);
        this.declaracaoIRPF.getResumo().getRendimentosTributaveisDeducoes().getLivroCaixa().setConteudo(this.livroCaixa);
        this.declaracaoIRPF.getResumo().getRendimentosTributaveisDeducoes().getTotalDeducoes().setConteudo(this.totalDeducoes);
        this.declaracaoIRPF.getResumo().getCalculoImposto().getBaseCalculo().setConteudo(this.baseCalculo);
        this.declaracaoIRPF.getResumo().getCalculoImposto().getImposto().setConteudo(this.imposto);
        this.declaracaoIRPF.getResumo().getCalculoImposto().getDeducaoIncentivo().setConteudo(this.deducaoIncentivo);
        this.declaracaoIRPF.getResumo().getCalculoImposto().getTotalContribEmpregadoDomestico().setConteudo(this.totalContribEmpregadoDomestico);
        this.declaracaoIRPF.getResumo().getCalculoImposto().getImpostoDevido().setConteudo(this.impostoDevido);
        this.declaracaoIRPF.getResumo().getCalculoImposto().getImpostoDevidoI().setConteudo(this.impostoDevidoI);
        this.declaracaoIRPF.getResumo().getCalculoImposto().getImpostoDevidoLei14754().setConteudo(this.impostoDevidoLei14754);
        this.declaracaoIRPF.getResumo().getCalculoImposto().getImpostoDevidoII().setConteudo(this.impostoDevidoII);
        this.declaracaoIRPF.getResumo().getCalculoImposto().getImpostoDevidoRRA().setConteudo(this.impostoDevidoRRA);
        this.declaracaoIRPF.getResumo().getCalculoImposto().getImpostoRetidoFonteTitular().setConteudo(this.impostoRetidoFonteTitular);
        this.declaracaoIRPF.getResumo().getCalculoImposto().getImpostoRetidoFonteDependentes().setConteudo(this.impostoRetidoFonteDependentes);
        this.declaracaoIRPF.getResumo().getCalculoImposto().getCarneLeaoTitular().setConteudo(this.carneLeaoTitular);
        this.declaracaoIRPF.getResumo().getCalculoImposto().getCarneLeaoDependentes().setConteudo(this.carneLeaoDependentes);
        this.declaracaoIRPF.getResumo().getCalculoImposto().getImpostoComplementar().setConteudo(this.impostoComplementar);
        this.declaracaoIRPF.getResumo().getCalculoImposto().getImpostoPagoExterior().setConteudo(this.impostoPagoExterior);
        this.declaracaoIRPF.getResumo().getCalculoImposto().getImpostoRetidoFonteLei11033().setConteudo(this.impostoRetidoFonteLei11033);
        this.declaracaoIRPF.getResumo().getCalculoImposto().getImpostoRetidoRRA().setConteudo(this.impostoRetidoRRA);
        this.declaracaoIRPF.getResumo().getCalculoImposto().getTotalImpostoPago().setConteudo(this.totalImpostoPago);
        this.declaracaoIRPF.getResumo().getCalculoImposto().getSaldoImpostoPagar().setConteudo(this.saldoImpostoPagar);
        this.declaracaoIRPF.getResumo().getCalculoImposto().getImpostoRestituir().setConteudo(this.impostoRestituir);
        this.declaracaoIRPF.getResumo().getOutrasInformacoes().getBensDireitosExercicioAnterior().setConteudo(this.bensDireitosExercicioAnterior);
        this.declaracaoIRPF.getResumo().getOutrasInformacoes().getBensDireitosExercicioAtual().setConteudo(this.bensDireitosExercicioAtual);
        this.declaracaoIRPF.getResumo().getOutrasInformacoes().getDividasOnusReaisExercicioAnterior().setConteudo(this.dividasExercicioAnterior);
        this.declaracaoIRPF.getResumo().getOutrasInformacoes().getDividasOnusReaisExercicioAtual().setConteudo(this.dividasExercicioAtual);
        this.declaracaoIRPF.getResumo().getOutrasInformacoes().getRendIsentosNaoTributaveis().setConteudo(this.rendIsentosNaoTributaveis);
        this.declaracaoIRPF.getResumo().getOutrasInformacoes().getRendIsentosTributacaoExclusiva().setConteudo((Valor)this.rendSujeitoTribExclusiva);
        this.declaracaoIRPF.getResumo().getOutrasInformacoes().getRendTributaveisExigibilidadeSuspensa().setConteudo(this.rendTributaveisExigibilidadeSuspensa);
        this.declaracaoIRPF.getResumo().getOutrasInformacoes().getDepositosJudiciais().setConteudo(this.depositosJudiciais);
        this.declaracaoIRPF.getResumo().getOutrasInformacoes().getImpostoPagoGCAP().setConteudo(this.impostoPagoGCAP);
        this.declaracaoIRPF.getResumo().getOutrasInformacoes().getImpostoDiferidoGCAP().setConteudo(this.impostoDiferidoGCAP);
        this.declaracaoIRPF.getResumo().getOutrasInformacoes().getImpostoDevidoGCAP().setConteudo(this.impostoDevidoGCAP);
        this.declaracaoIRPF.getResumo().getOutrasInformacoes().getImpostoDevidoRendaVariavel().setConteudo(this.impostoDevidoRendaVariavel);
        this.declaracaoIRPF.getResumo().getOutrasInformacoes().getImpostoDevidoGCME().setConteudo(this.impostoDevidoGCME);
        this.declaracaoIRPF.getResumo().getOutrasInformacoes().getImpostoPagoME().setConteudo(this.impostoPagoME);
        this.declaracaoIRPF.getResumo().getOutrasInformacoes().getTotalImpostoRetidoNaFonte().setConteudo(this.totalImpostoRetidoNaFonte);
        this.declaracaoIRPF.getResumo().getOutrasInformacoes().getImpostoPagoSobreRendaVariavel().setConteudo(this.impostoPagoSobreRendaVariavel);
        this.declaracaoIRPF.getResumo().getOutrasInformacoes().getTotalDoacoesCampanhasEleitorais().setConteudo(this.totalDoacoesCampanhasEleitorais);
        Valor lImpostoRestituir = this.declaracaoIRPF.getResumo().getCalculoImposto().getImpostoRestituir();
        Valor lImpostoPagar = this.declaracaoIRPF.getResumo().getCalculoImposto().getSaldoImpostoPagar();
        int resultCompare = lImpostoPagar.compareTo(lImpostoRestituir);
        Alfa resultado = new Alfa("resultadoDeclaracao");
        if (resultCompare == 0) {
            resultado.setConteudo("SSI");
        } else if (resultCompare < 0) {
            resultado.setConteudo("IAR");
        } else {
            resultado.setConteudo("IAP");
        }
        this.declaracaoIRPF.getIdentificadorDeclaracao().getResultadoDeclaracao().setConteudo(resultado);
        this.declaracaoIRPF.getResumo().getCalculoImposto().getAliquotaEfetiva().setConteudo(this.aliquotaEfetiva);
    }

    public Valor getBensDireitosExercicioAnterior() {
        return this.bensDireitosExercicioAnterior;
    }

    public Valor getBensDireitosExercicioAtual() {
        return this.bensDireitosExercicioAtual;
    }

    public Valor getCarneLeaoTitular() {
        return this.carneLeaoTitular;
    }

    public Valor getCarneLeaoDependentes() {
        return this.carneLeaoDependentes;
    }

    public Valor getDeducaoDependentes() {
        return this.deducaoDependentes;
    }

    public Valor getDeducaoIncentivo() {
        return this.deducaoIncentivo;
    }

    public Valor getDespesasInstrucao() {
        return this.despesasInstrucao;
    }

    public Valor getDespesasMedicas() {
        return this.despesasMedicas;
    }

    public Valor getDividasExercicioAnterior() {
        return this.dividasExercicioAnterior;
    }

    public Valor getDividasExercicioAtual() {
        return this.dividasExercicioAtual;
    }

    public Valor getImposto() {
        return this.imposto;
    }

    public Valor getImpostoComplementar() {
        return this.impostoComplementar;
    }

    public Valor getImpostoPagoExterior() {
        return this.impostoPagoExterior;
    }

    public Valor getImpostoPagoGCAP() {
        return this.impostoPagoGCAP;
    }

    public Valor getImpostoPagoME() {
        return this.impostoPagoME;
    }

    public Valor getImpostoPagoSobreRendaVariavel() {
        return this.impostoPagoSobreRendaVariavel;
    }

    @Override
    public Valor getImpostoRestituir() {
        return this.impostoRestituir;
    }

    public Valor getImpostoRetidoFonteDependentes() {
        return this.impostoRetidoFonteDependentes;
    }

    public Valor getImpostoRetidoFonteLei11033() {
        return this.impostoRetidoFonteLei11033;
    }

    public Valor getImpostoRetidoFonteTitular() {
        return this.impostoRetidoFonteTitular;
    }

    public Valor getLivroCaixa() {
        return this.livroCaixa;
    }

    public Valor getPensaoAlimenticia() {
        return this.pensaoAlimenticia;
    }

    public Valor getPensaoCartoral() {
        return this.pensaoCartoral;
    }

    public Valor getPrevidencia() {
        return this.previdencia;
    }

    public Valor getPrevidenciaOficial() {
        return this.previdenciaOficial;
    }

    public Valor getRendIsentosNaoTributaveis() {
        return this.rendIsentosNaoTributaveis;
    }

    public Valor getRendRecebidoPFEXTDependentes() {
        return this.rendRecebidoPFEXTDependentes;
    }

    public Valor getRendRecebidoPFEXTTitular() {
        return this.rendRecebidoPFEXTTitular;
    }

    public Valor getRendRecebidoPJDependentes() {
        return this.rendRecebidoPJDependentes;
    }

    public Valor getRendRecebidoPJTitular() {
        return this.rendRecebidoPJTitular;
    }

    public ValorPositivo getRendSujeitoTribExclusiva() {
        return this.rendSujeitoTribExclusiva;
    }

    public Valor getResultadoTributavelAR() {
        return this.resultadoTributavelAR;
    }

    public Valor getTotalDeducoes() {
        return this.totalDeducoes;
    }

    public Valor getTotalImpostoPago() {
        return this.totalImpostoPago;
    }

    public Valor getTotalImpostoRetidoNaFonte() {
        return this.totalImpostoRetidoNaFonte;
    }

    public Valor getTotalRendimentos() {
        return this.totalRendimentos;
    }

    @Override
    public Valor recuperarTotalImpostoPago() {
        Valor result = new Valor();
        result.append('+', this.declaracaoIRPF.getResumo().getCalculoImposto().getImpostoRetidoFonteTitular());
        result.append('+', this.declaracaoIRPF.getResumo().getCalculoImposto().getImpostoRetidoFonteDependentes());
        result.append('+', this.declaracaoIRPF.getResumo().getCalculoImposto().getImpostoPagoExterior());
        result.append('+', this.declaracaoIRPF.getResumo().getCalculoImposto().getImpostoComplementar());
        result.append('+', this.declaracaoIRPF.getResumo().getCalculoImposto().getCarneLeaoTitular());
        result.append('+', this.declaracaoIRPF.getResumo().getCalculoImposto().getCarneLeaoDependentes());
        result.append('+', this.declaracaoIRPF.getResumo().getCalculoImposto().getImpostoRetidoFonteLei11033());
        return result;
    }

    @Override
    public String recuperarCodInImpostoPago() {
        int cod = 0;
        Object codStr = "";
        if (!this.declaracaoIRPF.getResumo().getCalculoImposto().getImpostoRetidoFonteTitular().isVazio() || !this.declaracaoIRPF.getResumo().getCalculoImposto().getImpostoRetidoFonteDependentes().isVazio()) {
            ++cod;
        }
        if (!this.declaracaoIRPF.getResumo().getCalculoImposto().getImpostoPagoExterior().isVazio()) {
            cod += 8;
        }
        if (!this.declaracaoIRPF.getResumo().getCalculoImposto().getImpostoComplementar().isVazio()) {
            cod += 4;
        }
        if (!this.declaracaoIRPF.getResumo().getCalculoImposto().getCarneLeaoTitular().isVazio() || !this.declaracaoIRPF.getResumo().getCalculoImposto().getCarneLeaoDependentes().isVazio()) {
            cod += 2;
        }
        if (!this.declaracaoIRPF.getResumo().getCalculoImposto().getImpostoRetidoFonteLei11033().isVazio()) {
            cod += 16;
        }
        if (!this.declaracaoIRPF.getResumo().getCalculoImposto().getImpostoRetidoRRA().isVazio()) {
            cod += 32;
        }
        codStr = cod < 9 ? "0" + cod : "" + cod;
        return codStr;
    }

    @Override
    public Valor recuperarTotalRendimentosTributaveis() {
        Valor result = new Valor(this.declaracaoIRPF.getResumo().getRendimentosTributaveisDeducoes().getTotalRendimentos().formatado());
        return result;
    }

    public Valor getRendTributaveisExigibilidadeSuspensa() {
        return this.rendTributaveisExigibilidadeSuspensa;
    }

    public Valor getDepositosJudiciais() {
        return this.depositosJudiciais;
    }

    public Valor getImpostoDevidoComRendExterior() {
        return this.impostoDevidoComRendExterior;
    }

    public Valor getImpostoDevidoSemRendExterior() {
        return this.impostoDevidoSemRendExterior;
    }

    public Valor getLimiteImpPagoExterior() {
        return this.limiteImpPagoExterior;
    }

    public Valor getAliquotaEfetiva() {
        return this.aliquotaEfetiva;
    }
}

