/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.tabelas;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.Collator;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.alimentandos.Alimentando;
import serpro.ppgd.irpf.alimentandos.Alimentandos;
import serpro.ppgd.irpf.bens.Bem;
import serpro.ppgd.irpf.bens.Bens;
import serpro.ppgd.irpf.dependentes.Dependente;
import serpro.ppgd.irpf.dependentes.Dependentes;
import serpro.ppgd.irpf.gcap.alienacao.AlienacaoBem;
import serpro.ppgd.irpf.herdeiros.Herdeiro;
import serpro.ppgd.irpf.herdeiros.Herdeiros;
import serpro.ppgd.irpf.rendIsentos.RendIsentos;
import serpro.ppgd.irpf.rendTributacaoExclusiva.RendTributacaoExclusiva;
import serpro.ppgd.irpf.tabelas.CodigoTabelaLinks;
import serpro.ppgd.irpf.tabelas.CodigoTabelaMensagens;
import serpro.ppgd.irpf.tabelas.TabelaAliquotasIRPF;
import serpro.ppgd.irpf.tabelas.TabelaDatasIRPF;
import serpro.ppgd.irpf.tabelas.TabelaRendimentos;
import serpro.ppgd.irpf.util.AplicacaoPropertiesUtil;
import serpro.ppgd.irpf.util.TipoDeclaracaoAES;
import serpro.ppgd.negocio.CPF;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.ElementoTabela;
import serpro.ppgd.negocio.util.FabricaTratamentoErro;
import serpro.ppgd.negocio.util.LogPPGD;
import serpro.ppgd.negocio.util.TrataErroSistemicoIf;
import serpro.ppgd.negocio.util.UtilitariosArquivo;
import serpro.ppgd.negocio.util.UtilitariosString;
import serpro.ppgd.repositorio.RepositorioException;
import serpro.ppgd.repositorio.RepositorioTabelasBasicasIf;
import serpro.ppgd.repositorio.repositorioXML.RepositorioTabelasBasicasXML;
import serpro.ppgd.repositorio.repositorioXML.RepositorioXMLException;

public abstract class CadastroTabelasIRPF {
    private static RepositorioTabelasBasicasIRPF repositorioTabelasBasicas = new RepositorioTabelasBasicasIRPF();
    private static TrataErroSistemicoIf trataErro = FabricaTratamentoErro.getTrataErroSistemico();
    private static boolean testarCRC = true;
    private static Map<String, List<ElementoTabela>> tabelaMunicipios = new HashMap<String, List<ElementoTabela>>();
    private static Map<String, String> nomesEstados = new HashMap<String, String>();
    private static Map<String, String> codsPagamentos = new HashMap<String, String>();
    private static Map<String, String> codsDoacoes = new HashMap<String, String>();
    private static Map<String, String> ocupacaoPrincipalTitulos = new HashMap<String, String>();
    private static Map<String, String> ocupacaoPrincipalCodigos = new HashMap<String, String>();
    private static Map<String, String> municipiosCalamidade = new HashMap<String, String>();
    public static String TIPO_CONTA_CORRENTE = "1";
    public static String TIPO_CONTA_POUPANCA = "2";
    public static String TIPO_CONTA_PAGAMENTO = "3";
    public static String TIPO_CONTA_PIX = "4";
    public static String CONTA_CEF_TIPO_1 = "1";
    public static String CONTA_CEF_TIPO_2 = "2";
    private static TabelaDoacoesDireta tabelaECA;
    private static TabelaDoacoesDireta tabelaIdoso;
    private static List<ElementoTabela> colecaoUFs;
    private static List<ElementoTabela> colecaoPaises;
    private static List<ElementoTabela> colecaoPaisesExterior;
    private static List<ElementoTabela> colecaoPaisesGCAP;
    private static List<ElementoTabela> colecaoGrupoBens;
    private static List<ElementoTabela> colecaoTipoBensAR;
    private static List<ElementoTabela> colecaoTipoDividas;
    private static List<ElementoTabela> colecaoTipoPagamentosDoacoes;
    private static List<ElementoTabela> colecaoTipoPagamentos;
    private static List<ElementoTabela> colecaoDependencias;
    private static List<ElementoTabela> colecaoTipoAtividadesRural;
    private static List<ElementoTabela> colecaoCondicoesExploracao;
    private static List<ElementoTabela> colecaoOcupacoesPrincipal;
    private static List<ElementoTabela> colecaoTipoConta;
    private static List<ElementoTabela> colecaoBancosCredito;
    private static List<ElementoTabela> colecaoBancosDebito;
    private static List<ElementoTabela> colecaoBancosBens;
    private static List<ElementoTabela> colecaoBancosContaPagamento;
    private static List<ElementoTabela> colecaoNaturezasOcupacao;
    private static List<ElementoTabela> colecaoRepresentacoes;
    private static List<ElementoTabela> colecaoTipoLogradouro;
    private static List<ElementoTabela> colecaoTipoDoacoes;
    private static List<ElementoTabela> colecaoTiposRendimentosIsentos;
    private static List<ElementoTabela> colecaoTiposRendimentosIsentosTotais;
    private static List<ElementoTabela> colecaoTiposRendTributExclusiva;
    private static List<ElementoTabela> colecaoTiposRendTributExclusivaTotais;
    private static List<ElementoTabela> colecaoTiposRendimentos;
    private static List<ElementoTabela> colecaoMoedas;
    private static List<ElementoTabela> colecaoOrigemRendimentos;
    private static List<ElementoTabela> colecaoLinks;
    private static List<ElementoTabela> colecaoMensagens;
    private static List<ElementoTabela> colecaoAltcoins;
    private static List<ElementoTabela> colecaoStablecoins;
    private static List<ElementoTabela> colecaoNaturezasGCMEBemImovel;
    private static List<ElementoTabela> colecaoNaturezasGCMEBemMovel;
    private static List<ElementoTabela> colecaoNaturezasGCAPBemImovel;
    private static List<ElementoTabela> colecaoNaturezasGCAPBemMovel;
    private static List<ElementoTabela> colecaoNaturezasParticipacaoSocietaria;
    private static List<ElementoTabela> colecaoEspecieOperacaoPSocietaria;
    private static List<ElementoTabela> colecaoEspecieAquisicaoPSocietaria;
    private static Map<String, List<ElementoTabela>> tabelaTiposBens;

    public static List<ElementoTabela> recuperarUFs(int pColunaDeOrdenacao) {
        try {
            if (colecaoUFs == null) {
                colecaoUFs = repositorioTabelasBasicas.recuperarObjetosTabela("ufssigla.xml", testarCRC);
            }
            CadastroTabelasIRPF.ordenarElementosPorColuna(pColunaDeOrdenacao, colecaoUFs);
        }
        catch (RepositorioException e) {
            trataErro.trataErroSistemico((Throwable)e);
        }
        return colecaoUFs;
    }

    public static void carregarUFsECA() {
        CadastroTabelasIRPF.carregarUFsDoacoesDireta(TabelasBasicas.ECA.getNomeArquivo(), tabelaECA);
    }

    public static void carregarUFsIdoso() {
        CadastroTabelasIRPF.carregarUFsDoacoesDireta(TabelasBasicas.Idoso.getNomeArquivo(), tabelaIdoso);
    }

    public static void carregarUFsDoacoesDireta(String nomeArquivo, TabelaDoacoesDireta tabela) {
        try {
            List<ElementoTabela> colecaoECA = repositorioTabelasBasicas.recuperarObjetosTabela(nomeArquivo, testarCRC);
            ArrayList<ElementoTabela> colecaoUFsECAEstadual = new ArrayList<ElementoTabela>();
            ArrayList<ElementoTabela> colecaoUFsECAMunicipal = new ArrayList<ElementoTabela>();
            HashMap<String, List<ElementoTabela>> mapaMunicipiosECA = new HashMap<String, List<ElementoTabela>>();
            String cnpjECANacional = null;
            for (ElementoTabela et : colecaoECA) {
                String uf = et.getConteudo(0);
                String ufNome = et.getConteudo(0) + " - " + nomesEstados.get(et.getConteudo(0));
                String cnpj = et.getConteudo(1);
                String municipio = et.getConteudo(2);
                String municipioCNPJ = municipio + " - " + cnpj;
                if (et.getConteudo(0).startsWith("BR")) {
                    cnpjECANacional = cnpj;
                    continue;
                }
                if (municipio == null || municipio.isEmpty()) {
                    ElementoTabela etUFsECAEstadual = new ElementoTabela();
                    etUFsECAEstadual.setConteudo(0, uf);
                    etUFsECAEstadual.setConteudo(1, ufNome);
                    etUFsECAEstadual.setConteudo(2, cnpj);
                    etUFsECAEstadual.setConteudo(3, municipio);
                    colecaoUFsECAEstadual.add(etUFsECAEstadual);
                    continue;
                }
                if (!mapaMunicipiosECA.containsKey(uf)) {
                    ElementoTabela etUFECAMunicipal = new ElementoTabela();
                    etUFECAMunicipal.setConteudo(0, uf);
                    etUFECAMunicipal.setConteudo(1, ufNome);
                    colecaoUFsECAMunicipal.add(etUFECAMunicipal);
                    mapaMunicipiosECA.put(uf, new ArrayList());
                }
                ElementoTabela etMunicipioECA = new ElementoTabela();
                etMunicipioECA.setConteudo(0, cnpj);
                etMunicipioECA.setConteudo(1, municipioCNPJ);
                etMunicipioECA.setConteudo(2, uf);
                etMunicipioECA.setConteudo(3, municipio);
                ((List)mapaMunicipiosECA.get(uf)).add(etMunicipioECA);
            }
            CadastroTabelasIRPF.ordenarElementosPorColuna(0, colecaoUFsECAEstadual);
            CadastroTabelasIRPF.ordenarElementosPorColuna(0, colecaoUFsECAMunicipal);
            for (List listaMunicipios : mapaMunicipiosECA.values()) {
                CadastroTabelasIRPF.ordenarElementosPorColuna(3, listaMunicipios);
            }
            tabela.cnpjECANacional = cnpjECANacional;
            tabela.colecaoUFsECAEstadual = colecaoUFsECAEstadual;
            tabela.colecaoUFsECAMunicipal = colecaoUFsECAMunicipal;
            tabela.mapaMunicipiosECA = mapaMunicipiosECA;
        }
        catch (RepositorioException e) {
            trataErro.trataErroSistemico((Throwable)e);
        }
    }

    public static String getCnpjECANacional() {
        if (CadastroTabelasIRPF.tabelaECA.cnpjECANacional == null) {
            CadastroTabelasIRPF.carregarUFsECA();
        }
        return CadastroTabelasIRPF.tabelaECA.cnpjECANacional;
    }

    public static List<ElementoTabela> recuperarUFsECA() {
        if (CadastroTabelasIRPF.tabelaECA.colecaoUFsECAMunicipal == null) {
            CadastroTabelasIRPF.carregarUFsECA();
        }
        return CadastroTabelasIRPF.tabelaECA.colecaoUFsECAMunicipal;
    }

    public static List<ElementoTabela> recuperarUFsECAEstadual() {
        if (CadastroTabelasIRPF.tabelaECA.colecaoUFsECAEstadual == null) {
            CadastroTabelasIRPF.carregarUFsECA();
        }
        return CadastroTabelasIRPF.tabelaECA.colecaoUFsECAEstadual;
    }

    public static List<ElementoTabela> recuperarMunicipiosECA(String uf) {
        return CadastroTabelasIRPF.tabelaECA.mapaMunicipiosECA.get(uf);
    }

    public static String getCnpjEstatutoIdosoNacional() {
        if (CadastroTabelasIRPF.tabelaIdoso.cnpjECANacional == null) {
            CadastroTabelasIRPF.carregarUFsIdoso();
        }
        return CadastroTabelasIRPF.tabelaIdoso.cnpjECANacional;
    }

    public static List<ElementoTabela> recuperarUFsIdoso() {
        if (CadastroTabelasIRPF.tabelaIdoso.colecaoUFsECAMunicipal == null) {
            CadastroTabelasIRPF.carregarUFsIdoso();
        }
        return CadastroTabelasIRPF.tabelaIdoso.colecaoUFsECAMunicipal;
    }

    public static List<ElementoTabela> recuperarUFsIdosoEstadual() {
        if (CadastroTabelasIRPF.tabelaIdoso.colecaoUFsECAEstadual == null) {
            CadastroTabelasIRPF.carregarUFsIdoso();
        }
        return CadastroTabelasIRPF.tabelaIdoso.colecaoUFsECAEstadual;
    }

    public static List<ElementoTabela> recuperarMunicipiosIdoso(String uf) {
        return CadastroTabelasIRPF.tabelaIdoso.mapaMunicipiosECA.get(uf);
    }

    public static List<ElementoTabela> recuperarSiglasUFs(int pColunaDeOrdenacao) {
        try {
            if (colecaoUFs == null) {
                colecaoUFs = repositorioTabelasBasicas.recuperarObjetosTabela("ufssigla.xml", testarCRC);
            }
            CadastroTabelasIRPF.ordenarElementosPorColuna(pColunaDeOrdenacao, colecaoUFs);
            for (ElementoTabela et : colecaoUFs) {
                String cod = et.getConteudo(0);
                et.setConteudo(1, cod);
            }
        }
        catch (RepositorioException e) {
            trataErro.trataErroSistemico((Throwable)e);
        }
        return colecaoUFs;
    }

    public static List<ElementoTabela> recuperarMoedas() {
        if (colecaoMoedas == null) {
            try {
                colecaoMoedas = repositorioTabelasBasicas.recuperarObjetosTabela("moedas.xml", testarCRC);
            }
            catch (RepositorioException e) {
                trataErro.trataErroSistemico((Throwable)e);
            }
        }
        return colecaoMoedas;
    }

    public static void carregarPaises() {
        try {
            ArrayList<ElementoTabela> colecaoPaises = new ArrayList<ElementoTabela>();
            ArrayList<ElementoTabela> colecaoPaisesExterior = new ArrayList<ElementoTabela>();
            repositorioTabelasBasicas.recuperarObjetosTabela(TabelasBasicas.Pais.getNomeArquivo(), colecaoPaises, false);
            for (ElementoTabela et : colecaoPaises) {
                String cod = et.getConteudo(0);
                String desc = et.getConteudo(1);
                et.setConteudo(1, cod + " - " + desc);
                et.setConteudo(2, desc);
                if (et.getConteudo(0).equals("105")) continue;
                colecaoPaisesExterior.add(et);
            }
            CadastroTabelasIRPF.colecaoPaises = colecaoPaises;
            CadastroTabelasIRPF.colecaoPaisesExterior = colecaoPaisesExterior;
        }
        catch (RepositorioException e) {
            trataErro.trataErroSistemico((Throwable)e);
        }
    }

    public static List<ElementoTabela> recuperarPaises() {
        if (colecaoPaises == null) {
            TabelasBasicas.Pais.carregarTabela();
        }
        return colecaoPaises;
    }

    public static List<ElementoTabela> recuperarPaisesExterior() {
        if (colecaoPaisesExterior == null) {
            TabelasBasicas.Pais.carregarTabela();
        }
        return colecaoPaisesExterior;
    }

    public static List<ElementoTabela> recuperarPaisesGCAP() {
        if (colecaoPaisesGCAP == null) {
            try {
                colecaoPaisesGCAP = repositorioTabelasBasicas.recuperarObjetosTabela("paises_gcap.xml", testarCRC);
                ElementoTabela brasil = null;
                for (ElementoTabela et : colecaoPaisesGCAP) {
                    if (et.getConteudo(0).equals("105")) {
                        brasil = et;
                        continue;
                    }
                    String cod = et.getConteudo(0);
                    String desc = et.getConteudo(1);
                    String inParaiso = et.getConteudo(2);
                    et.setConteudo(1, cod + " - " + desc);
                    et.setConteudo(2, desc);
                    et.setConteudo(3, inParaiso);
                }
                colecaoPaisesGCAP.remove(brasil);
            }
            catch (RepositorioException e) {
                trataErro.trataErroSistemico((Throwable)e);
            }
        }
        return colecaoPaisesGCAP;
    }

    public static void carregarTiposBens() {
        try {
            HashMap<String, List<ElementoTabela>> mapaTiposBens = new HashMap<String, List<ElementoTabela>>();
            ArrayList<ElementoTabela> colecaoTipoBens = new ArrayList<ElementoTabela>();
            ArrayList<ElementoTabela> colecaoGrupoBens = new ArrayList<ElementoTabela>();
            repositorioTabelasBasicas.recuperarObjetosTabela("resources/tipoBens.xml", colecaoTipoBens, testarCRC);
            for (ElementoTabela et : colecaoTipoBens) {
                Object codBem;
                Object codGrupo = et.getConteudo(3);
                if (((String)codGrupo).length() == 1) {
                    codGrupo = "0" + (String)codGrupo;
                }
                String descGrupo = et.getConteudo(4);
                ArrayList<ElementoTabela> listaTipoBens = (ArrayList<ElementoTabela>)mapaTiposBens.get(codGrupo);
                if (listaTipoBens == null) {
                    listaTipoBens = new ArrayList<ElementoTabela>();
                    mapaTiposBens.put((String)codGrupo, listaTipoBens);
                    ElementoTabela grupo = new ElementoTabela();
                    grupo.setConteudo(0, (String)codGrupo);
                    grupo.setConteudo(1, (String)codGrupo + " - " + descGrupo);
                    grupo.setConteudo(2, descGrupo);
                    colecaoGrupoBens.add(grupo);
                }
                if (((String)(codBem = et.getConteudo(0))).length() == 1) {
                    codBem = "0" + (String)codBem;
                }
                String descBem = et.getConteudo(1);
                ElementoTabela bem = new ElementoTabela();
                bem.setConteudo(0, (String)codBem);
                bem.setConteudo(1, (String)codBem + " - " + descBem);
                bem.setConteudo(2, descBem);
                listaTipoBens.add(bem);
            }
            CadastroTabelasIRPF.colecaoGrupoBens = colecaoGrupoBens;
            tabelaTiposBens = mapaTiposBens;
        }
        catch (RepositorioException e) {
            e.printStackTrace();
            trataErro.trataErroSistemico((Throwable)e);
        }
    }

    public static List<ElementoTabela> recuperarGrupoBens() {
        if (colecaoGrupoBens == null) {
            CadastroTabelasIRPF.carregarTiposBens();
        }
        return colecaoGrupoBens;
    }

    public static List<ElementoTabela> recuperarTipoBens(String grupo) {
        if (grupo.isEmpty()) {
            return new ArrayList<ElementoTabela>();
        }
        if (tabelaTiposBens == null) {
            CadastroTabelasIRPF.carregarTiposBens();
        }
        return tabelaTiposBens.get(grupo);
    }

    public static List<ElementoTabela> recuperarTipoBensAR() {
        try {
            if (colecaoTipoBensAR == null) {
                colecaoTipoBensAR = repositorioTabelasBasicas.recuperarObjetosTabela("tipoBensAR.xml", testarCRC);
                for (ElementoTabela et : colecaoTipoBensAR) {
                    String cod = et.getConteudo(0);
                    String desc = et.getConteudo(1);
                    et.setConteudo(1, cod + " - " + desc);
                }
            }
        }
        catch (RepositorioException e) {
            trataErro.trataErroSistemico((Throwable)e);
        }
        return colecaoTipoBensAR;
    }

    public static List<ElementoTabela> recuperarTipoConta() {
        try {
            if (colecaoTipoConta == null) {
                colecaoTipoConta = repositorioTabelasBasicas.recuperarObjetosTabela("tipoConta.xml", testarCRC);
            }
        }
        catch (RepositorioException e) {
            trataErro.trataErroSistemico((Throwable)e);
        }
        return colecaoTipoConta;
    }

    public static List<ElementoTabela> recuperarAlticoins() {
        try {
            if (colecaoAltcoins == null) {
                colecaoAltcoins = repositorioTabelasBasicas.recuperarObjetosTabela("altcoins.xml", testarCRC);
                for (ElementoTabela et : colecaoAltcoins) {
                    String cod = et.getConteudo(0);
                    String desc = et.getConteudo(1);
                    et.setConteudo(1, cod + " - " + desc);
                }
            }
        }
        catch (RepositorioException e) {
            trataErro.trataErroSistemico((Throwable)e);
        }
        return colecaoAltcoins;
    }

    public static List<ElementoTabela> recuperarStablecoins() {
        try {
            if (colecaoStablecoins == null) {
                colecaoStablecoins = repositorioTabelasBasicas.recuperarObjetosTabela("stablecoins.xml", testarCRC);
                for (ElementoTabela et : colecaoStablecoins) {
                    String cod = et.getConteudo(0);
                    String desc = et.getConteudo(1);
                    et.setConteudo(1, cod + " - " + desc);
                }
            }
        }
        catch (RepositorioException e) {
            trataErro.trataErroSistemico((Throwable)e);
        }
        return colecaoStablecoins;
    }

    public static void carregarTipoDividas() {
        try {
            ArrayList<ElementoTabela> colecaoTipoDividas = new ArrayList<ElementoTabela>();
            repositorioTabelasBasicas.recuperarObjetosTabela(TabelasBasicas.DividasOnus.getNomeArquivo(), colecaoTipoDividas, testarCRC);
            for (ElementoTabela et : colecaoTipoDividas) {
                String cod = et.getConteudo(0);
                String desc = et.getConteudo(1);
                et.setConteudo(1, cod + " - " + desc);
                et.setConteudo(2, desc);
            }
            CadastroTabelasIRPF.colecaoTipoDividas = colecaoTipoDividas;
        }
        catch (RepositorioException e) {
            trataErro.trataErroSistemico((Throwable)e);
        }
    }

    public static List<ElementoTabela> recuperarTipoDividas() {
        if (colecaoTipoDividas == null) {
            TabelasBasicas.DividasOnus.carregarTabela();
        }
        return colecaoTipoDividas;
    }

    public static void carregarTipoPagamentosDoacoes() {
        try {
            ArrayList<ElementoTabela> colecaoTipoPagamentosDoacoes = new ArrayList<ElementoTabela>();
            repositorioTabelasBasicas.recuperarObjetosTabela(TabelasBasicas.TipoPagamentosDoacoes.getNomeArquivo(), colecaoTipoPagamentosDoacoes, testarCRC);
            CadastroTabelasIRPF.colecaoTipoPagamentosDoacoes = colecaoTipoPagamentosDoacoes;
        }
        catch (RepositorioException e) {
            trataErro.trataErroSistemico((Throwable)e);
        }
    }

    public static void carregarTipoPagamentos() {
        ArrayList<ElementoTabela> colecaoTipoPagamentos = new ArrayList<ElementoTabela>();
        CadastroTabelasIRPF.carregarTipoPagamentosDoacoes();
        for (ElementoTabela et : colecaoTipoPagamentosDoacoes) {
            if (codsPagamentos.get(et.getConteudo(0)) == null) continue;
            String cod = et.getConteudo(0);
            String desc = et.getConteudo(1);
            et.setConteudo(1, cod + " - " + desc);
            et.setConteudo(2, desc);
            colecaoTipoPagamentos.add(et);
        }
        ElementoTabela etOutros = new ElementoTabela();
        String cod = "99";
        String desc = "Outros";
        etOutros.setConteudo(0, cod);
        etOutros.setConteudo(1, cod + " - " + desc);
        etOutros.setConteudo(2, desc);
        colecaoTipoPagamentos.add(etOutros);
        CadastroTabelasIRPF.colecaoTipoPagamentos = colecaoTipoPagamentos;
    }

    public static void carregarTipoDoacoes() {
        ArrayList<ElementoTabela> colecaoTipoDoacoes = new ArrayList<ElementoTabela>();
        CadastroTabelasIRPF.carregarTipoPagamentosDoacoes();
        for (ElementoTabela et : colecaoTipoPagamentosDoacoes) {
            if (codsDoacoes.get(et.getConteudo(0)) == null) continue;
            String cod = et.getConteudo(0);
            String desc = et.getConteudo(1);
            et.setConteudo(1, cod + " - " + desc);
            et.setConteudo(2, desc);
            colecaoTipoDoacoes.add(et);
        }
        ElementoTabela etOutros = new ElementoTabela();
        String cod = "99";
        String desc = "Outras";
        etOutros.setConteudo(0, cod);
        etOutros.setConteudo(1, cod + " - " + desc);
        etOutros.setConteudo(2, desc);
        colecaoTipoDoacoes.add(etOutros);
        CadastroTabelasIRPF.colecaoTipoDoacoes = colecaoTipoDoacoes;
    }

    public static List<ElementoTabela> recuperarTipoPagamentos() {
        CadastroTabelasIRPF.carregarTipoPagamentos();
        return colecaoTipoPagamentos;
    }

    public static List<ElementoTabela> recuperarTipoPagamentosPorCodigo(String[] codigos) {
        ArrayList<ElementoTabela> pagamentos = new ArrayList<ElementoTabela>();
        List<ElementoTabela> listaPagamentos = CadastroTabelasIRPF.recuperarTipoPagamentos();
        for (ElementoTabela pagamento : listaPagamentos) {
            for (int i = 0; i < codigos.length; ++i) {
                if (!pagamento.getConteudo(0).equals(codigos[i])) continue;
                pagamentos.add(pagamento);
            }
        }
        return pagamentos;
    }

    public static List<ElementoTabela> recuperarTipoPagamentosSaude() {
        return CadastroTabelasIRPF.recuperarTipoPagamentosPorCodigo(new String[]{"09", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "26"});
    }

    public static List<ElementoTabela> recuperarTipoPagamentosSaudePF() {
        return CadastroTabelasIRPF.recuperarTipoPagamentosPorCodigo(new String[]{"09", "10", "11", "12", "13", "14"});
    }

    public static List<ElementoTabela> recuperarTipoPagamentosSaudePJ() {
        return CadastroTabelasIRPF.recuperarTipoPagamentosPorCodigo(new String[]{"21", "26"});
    }

    public static List<ElementoTabela> recuperarTipoPagamentosSaudeEducacaoPJ() {
        return CadastroTabelasIRPF.recuperarTipoPagamentosPorCodigo(new String[]{"01", "21", "26"});
    }

    public static List<ElementoTabela> recuperarTipoPagamentosSaudeEducacao() {
        return CadastroTabelasIRPF.recuperarTipoPagamentosPorCodigo(new String[]{"01", "02", "09", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "26"});
    }

    public static List<ElementoTabela> recuperarTipoDoacoes() {
        CadastroTabelasIRPF.carregarTipoDoacoes();
        return colecaoTipoDoacoes;
    }

    public static void carregarDependencias() {
        try {
            ArrayList<ElementoTabela> colecaoDependencias = new ArrayList<ElementoTabela>();
            repositorioTabelasBasicas.recuperarObjetosTabela(TabelasBasicas.Dependencias.getNomeArquivo(), colecaoDependencias, testarCRC);
            for (ElementoTabela et : colecaoDependencias) {
                String cod = et.getConteudo(0);
                String desc = et.getConteudo(1);
                et.setConteudo(1, cod + " - " + desc);
            }
            CadastroTabelasIRPF.colecaoDependencias = colecaoDependencias;
        }
        catch (RepositorioException e) {
            trataErro.trataErroSistemico((Throwable)e);
        }
    }

    public static List<ElementoTabela> recuperarDependencias() {
        if (colecaoDependencias == null) {
            TabelasBasicas.Dependencias.carregarTabela();
        }
        return colecaoDependencias;
    }

    public static List<ElementoTabela> recuperarTipoAtividadesRural() {
        try {
            if (colecaoTipoAtividadesRural == null) {
                colecaoTipoAtividadesRural = repositorioTabelasBasicas.recuperarObjetosTabela("tipoAtividadesRural.xml", testarCRC);
                for (ElementoTabela et : colecaoTipoAtividadesRural) {
                    String cod = et.getConteudo(0);
                    String desc = et.getConteudo(1);
                    et.setConteudo(1, cod + " - " + desc);
                }
            }
        }
        catch (RepositorioException e) {
            trataErro.trataErroSistemico((Throwable)e);
        }
        return colecaoTipoAtividadesRural;
    }

    public static List<ElementoTabela> recuperarCondicoesExploracao() {
        try {
            if (colecaoCondicoesExploracao == null) {
                colecaoCondicoesExploracao = repositorioTabelasBasicas.recuperarObjetosTabela("condicoesExploracao.xml", testarCRC);
                for (ElementoTabela et : colecaoCondicoesExploracao) {
                    String cod = et.getConteudo(0);
                    String desc = et.getConteudo(1);
                    et.setConteudo(1, cod + " - " + desc);
                }
            }
        }
        catch (RepositorioException e) {
            trataErro.trataErroSistemico((Throwable)e);
        }
        return colecaoCondicoesExploracao;
    }

    public static List<ElementoTabela> recuperarOcupacoesPrincipal() {
        ArrayList<ElementoTabela> colecaoOcupacoesPrincipalEntrada = new ArrayList<ElementoTabela>();
        ArrayList<ElementoTabela> colecaoOcupacoesPrincipalSaida = new ArrayList<ElementoTabela>();
        try {
            repositorioTabelasBasicas.recuperarObjetosTabela(TabelasBasicas.Ocupacoes.getNomeArquivo(), colecaoOcupacoesPrincipalEntrada, testarCRC);
            for (ElementoTabela elemento : colecaoOcupacoesPrincipalEntrada) {
                String subcodigo = elemento.getConteudo(0);
                String codigo = ocupacaoPrincipalCodigos.get(subcodigo);
                String subtitulo = elemento.getConteudo(1);
                String titulo = ocupacaoPrincipalTitulos.get(codigo);
                if (codigo == null) continue;
                elemento.setConteudo(0, subcodigo);
                elemento.setConteudo(1, codigo);
                elemento.setConteudo(2, titulo);
                elemento.setConteudo(3, subtitulo);
                colecaoOcupacoesPrincipalSaida.add(elemento);
            }
            colecaoOcupacoesPrincipalSaida.sort(new Comparator<ElementoTabela>(){

                @Override
                public int compare(ElementoTabela o1, ElementoTabela o2) {
                    return o1.getConteudo(1).compareTo(o2.getConteudo(1));
                }
            });
        }
        catch (RepositorioException e) {
            trataErro.trataErroSistemico((Throwable)e);
        }
        colecaoOcupacoesPrincipal = colecaoOcupacoesPrincipalSaida;
        return colecaoOcupacoesPrincipal;
    }

    public static List<ElementoTabela> recuperarNaturezaGCMEBemImovel() {
        if (colecaoNaturezasGCMEBemImovel == null) {
            colecaoNaturezasGCMEBemImovel = new ArrayList<ElementoTabela>();
            ElementoTabela e1 = new ElementoTabela();
            e1.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_VENDA));
            e1.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_VENDA);
            colecaoNaturezasGCMEBemImovel.add(e1);
            ElementoTabela e2 = new ElementoTabela();
            e2.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_PERMURTA_COM_RECEBIMENTO_DE_TORNA));
            e2.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_PERMURTA_COM_RECEBIMENTO_DE_TORNA);
            colecaoNaturezasGCMEBemImovel.add(e2);
            ElementoTabela e4 = new ElementoTabela();
            e4.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_DACAO_EM_PAGAMENTO));
            e4.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_DACAO_EM_PAGAMENTO);
            colecaoNaturezasGCMEBemImovel.add(e4);
            ElementoTabela e13 = new ElementoTabela();
            e13.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_DOACAO_ADIANTAMENTO_LEGITIMA));
            e13.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_DOACAO_ADIANTAMENTO_LEGITIMA);
            colecaoNaturezasGCMEBemImovel.add(e13);
            ElementoTabela e5 = new ElementoTabela();
            e5.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_OUTRAS_DOACOES));
            e5.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_OUTRAS_DOACOES);
            colecaoNaturezasGCMEBemImovel.add(e5);
            ElementoTabela e6 = new ElementoTabela();
            e6.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_PROCURACAO_EM_CAUSA_PROPRIA));
            e6.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_PROCURACAO_EM_CAUSA_PROPRIA);
            colecaoNaturezasGCMEBemImovel.add(e6);
            ElementoTabela e7 = new ElementoTabela();
            e7.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_PROMESSA_DE_COMPRA_E_VENDA));
            e7.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_PROMESSA_DE_COMPRA_E_VENDA);
            colecaoNaturezasGCMEBemImovel.add(e7);
            ElementoTabela e8 = new ElementoTabela();
            e8.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_CESSAO_DE_DIREITOS));
            e8.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_CESSAO_DE_DIREITOS);
            colecaoNaturezasGCMEBemImovel.add(e8);
            ElementoTabela e9 = new ElementoTabela();
            e9.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_LIQUID_OU_RESGATE_DE_APLIC_FINANCEIRA));
            e9.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_LIQUID_OU_RESGATE_DE_APLIC_FINANCEIRA);
            colecaoNaturezasGCMEBemImovel.add(e9);
            ElementoTabela e10 = new ElementoTabela();
            e10.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_OUTROS));
            e10.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_OUTROS);
            colecaoNaturezasGCMEBemImovel.add(e10);
        }
        return colecaoNaturezasGCMEBemImovel;
    }

    public static List<ElementoTabela> recuperarNaturezaGCMEBemMovelDireitos() {
        if (colecaoNaturezasGCMEBemMovel == null) {
            colecaoNaturezasGCMEBemMovel = new ArrayList<ElementoTabela>();
            ElementoTabela e1 = new ElementoTabela();
            e1.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_VENDA));
            e1.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_VENDA);
            colecaoNaturezasGCMEBemMovel.add(e1);
            ElementoTabela e4 = new ElementoTabela();
            e4.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_DACAO_EM_PAGAMENTO));
            e4.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_DACAO_EM_PAGAMENTO);
            colecaoNaturezasGCMEBemMovel.add(e4);
            ElementoTabela e13 = new ElementoTabela();
            e13.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_DOACAO_ADIANTAMENTO_LEGITIMA));
            e13.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_DOACAO_ADIANTAMENTO_LEGITIMA);
            colecaoNaturezasGCMEBemMovel.add(e13);
            ElementoTabela e5 = new ElementoTabela();
            e5.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_OUTRAS_DOACOES));
            e5.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_OUTRAS_DOACOES);
            colecaoNaturezasGCMEBemMovel.add(e5);
            ElementoTabela e6 = new ElementoTabela();
            e6.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_PROCURACAO_EM_CAUSA_PROPRIA));
            e6.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_PROCURACAO_EM_CAUSA_PROPRIA);
            colecaoNaturezasGCMEBemMovel.add(e6);
            ElementoTabela e7 = new ElementoTabela();
            e7.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_PROMESSA_DE_COMPRA_E_VENDA));
            e7.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_PROMESSA_DE_COMPRA_E_VENDA);
            colecaoNaturezasGCMEBemMovel.add(e7);
            ElementoTabela e8 = new ElementoTabela();
            e8.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_CESSAO_DE_DIREITOS));
            e8.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_CESSAO_DE_DIREITOS);
            colecaoNaturezasGCMEBemMovel.add(e8);
            ElementoTabela e9 = new ElementoTabela();
            e9.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_DEPOSITO_CONTA_CORRENTE_CARTAO_CREDITO_DEBITO));
            e9.setConteudo(1, AlienacaoBem.DESCRICAO_DEPOSITO_CONTA_CORRENTE_CARTAO_CREDITO_DEBITO);
            colecaoNaturezasGCMEBemMovel.add(e9);
            ElementoTabela e10 = new ElementoTabela();
            e10.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_DISSOLUCAO_DA_SOCIEDADE_CONJUGAL_OU_UNIAO_ESTAVEL));
            e10.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_DISSOLUCAO_DA_SOCIEDADE_CONJUGAL_OU_UNIAO_ESTAVEL);
            colecaoNaturezasGCMEBemMovel.add(e10);
            ElementoTabela e11 = new ElementoTabela();
            e11.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_TRASMISSAO_CAUSA_MORTIS));
            e11.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_TRASMISSAO_CAUSA_MORTIS);
            colecaoNaturezasGCMEBemMovel.add(e11);
            ElementoTabela e12 = new ElementoTabela();
            e12.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_OUTROS));
            e12.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_OUTROS);
            colecaoNaturezasGCMEBemMovel.add(e12);
        }
        return colecaoNaturezasGCMEBemMovel;
    }

    public static List<ElementoTabela> recuperarNaturezaGCAPBemImovel() {
        if (colecaoNaturezasGCAPBemImovel == null) {
            colecaoNaturezasGCAPBemImovel = new ArrayList<ElementoTabela>();
            ElementoTabela e1 = new ElementoTabela();
            e1.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_VENDA));
            e1.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_VENDA);
            colecaoNaturezasGCAPBemImovel.add(e1);
            ElementoTabela e3 = new ElementoTabela();
            e3.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_DACAO_EM_PAGAMENTO));
            e3.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_DACAO_EM_PAGAMENTO);
            colecaoNaturezasGCAPBemImovel.add(e3);
            ElementoTabela e13 = new ElementoTabela();
            e13.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_DOACAO_ADIANTAMENTO_LEGITIMA));
            e13.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_DOACAO_ADIANTAMENTO_LEGITIMA);
            colecaoNaturezasGCAPBemImovel.add(e13);
            ElementoTabela e4 = new ElementoTabela();
            e4.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_OUTRAS_DOACOES));
            e4.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_OUTRAS_DOACOES);
            colecaoNaturezasGCAPBemImovel.add(e4);
            ElementoTabela e5 = new ElementoTabela();
            e5.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_PROCURACAO_EM_CAUSA_PROPRIA));
            e5.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_PROCURACAO_EM_CAUSA_PROPRIA);
            colecaoNaturezasGCAPBemImovel.add(e5);
            ElementoTabela e6 = new ElementoTabela();
            e6.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_PROMESSA_DE_COMPRA_E_VENDA));
            e6.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_PROMESSA_DE_COMPRA_E_VENDA);
            colecaoNaturezasGCAPBemImovel.add(e6);
            ElementoTabela e7 = new ElementoTabela();
            e7.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_CESSAO_DE_DIREITOS));
            e7.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_CESSAO_DE_DIREITOS);
            colecaoNaturezasGCAPBemImovel.add(e7);
            ElementoTabela e8 = new ElementoTabela();
            e8.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_DISSOLUCAO_DA_SOCIEDADE_CONJUGAL_OU_UNIAO_ESTAVEL));
            e8.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_DISSOLUCAO_DA_SOCIEDADE_CONJUGAL_OU_UNIAO_ESTAVEL);
            colecaoNaturezasGCAPBemImovel.add(e8);
            ElementoTabela e9 = new ElementoTabela();
            e9.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_TRASMISSAO_CAUSA_MORTIS));
            e9.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_TRASMISSAO_CAUSA_MORTIS);
            colecaoNaturezasGCAPBemImovel.add(e9);
            ElementoTabela e10 = new ElementoTabela();
            e10.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_PERMURTA_COM_RECEBIMENTO_DE_TORNA));
            e10.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_PERMURTA_COM_RECEBIMENTO_DE_TORNA);
            colecaoNaturezasGCAPBemImovel.add(e10);
            ElementoTabela e11 = new ElementoTabela();
            e11.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_OUTROS));
            e11.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_OUTROS);
            colecaoNaturezasGCAPBemImovel.add(e11);
        }
        return colecaoNaturezasGCAPBemImovel;
    }

    public static List<ElementoTabela> recuperarNaturezaGCAPBemMovelDireitos() {
        if (colecaoNaturezasGCAPBemMovel == null) {
            colecaoNaturezasGCAPBemMovel = new ArrayList<ElementoTabela>();
            ElementoTabela e1 = new ElementoTabela();
            e1.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_VENDA));
            e1.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_VENDA);
            colecaoNaturezasGCAPBemMovel.add(e1);
            ElementoTabela e3 = new ElementoTabela();
            e3.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_DACAO_EM_PAGAMENTO));
            e3.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_DACAO_EM_PAGAMENTO);
            colecaoNaturezasGCAPBemMovel.add(e3);
            ElementoTabela e13 = new ElementoTabela();
            e13.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_DOACAO_ADIANTAMENTO_LEGITIMA));
            e13.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_DOACAO_ADIANTAMENTO_LEGITIMA);
            colecaoNaturezasGCAPBemMovel.add(e13);
            ElementoTabela e4 = new ElementoTabela();
            e4.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_OUTRAS_DOACOES));
            e4.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_OUTRAS_DOACOES);
            colecaoNaturezasGCAPBemMovel.add(e4);
            ElementoTabela e5 = new ElementoTabela();
            e5.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_PROCURACAO_EM_CAUSA_PROPRIA));
            e5.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_PROCURACAO_EM_CAUSA_PROPRIA);
            colecaoNaturezasGCAPBemMovel.add(e5);
            ElementoTabela e6 = new ElementoTabela();
            e6.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_PROMESSA_DE_COMPRA_E_VENDA));
            e6.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_PROMESSA_DE_COMPRA_E_VENDA);
            colecaoNaturezasGCAPBemMovel.add(e6);
            ElementoTabela e7 = new ElementoTabela();
            e7.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_CESSAO_DE_DIREITOS));
            e7.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_CESSAO_DE_DIREITOS);
            colecaoNaturezasGCAPBemMovel.add(e7);
            ElementoTabela e8 = new ElementoTabela();
            e8.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_DISSOLUCAO_DA_SOCIEDADE_CONJUGAL_OU_UNIAO_ESTAVEL));
            e8.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_DISSOLUCAO_DA_SOCIEDADE_CONJUGAL_OU_UNIAO_ESTAVEL);
            colecaoNaturezasGCAPBemMovel.add(e8);
            ElementoTabela e9 = new ElementoTabela();
            e9.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_TRASMISSAO_CAUSA_MORTIS));
            e9.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_TRASMISSAO_CAUSA_MORTIS);
            colecaoNaturezasGCAPBemMovel.add(e9);
            ElementoTabela e10 = new ElementoTabela();
            e10.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_OUTROS));
            e10.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_OUTROS);
            colecaoNaturezasGCAPBemMovel.add(e10);
        }
        return colecaoNaturezasGCAPBemMovel;
    }

    public static List<ElementoTabela> recuperarNaturezaParticipacaoSocietaria() {
        if (colecaoNaturezasParticipacaoSocietaria == null) {
            colecaoNaturezasParticipacaoSocietaria = new ArrayList<ElementoTabela>();
            ElementoTabela e1 = new ElementoTabela();
            e1.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_ALIENACAO_RESGATES_OUTRAS));
            e1.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_ALIENACAO_RESGATES_OUTRAS);
            colecaoNaturezasParticipacaoSocietaria.add(e1);
            ElementoTabela e2 = new ElementoTabela();
            e2.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_TRASMISSAO_CAUSA_MORTIS));
            e2.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_TRASMISSAO_CAUSA_MORTIS);
            colecaoNaturezasParticipacaoSocietaria.add(e2);
            ElementoTabela e3 = new ElementoTabela();
            e3.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_DOACAO_ADIANTAMENTO_LEGITIMA));
            e3.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_DOACAO_ADIANTAMENTO_LEGITIMA);
            colecaoNaturezasParticipacaoSocietaria.add(e3);
            ElementoTabela e4 = new ElementoTabela();
            e4.setConteudo(0, String.valueOf(AlienacaoBem.CODIGO_NATUREZA_DISSOLUCAO_DA_SOCIEDADE_CONJUGAL_OU_UNIAO_ESTAVEL));
            e4.setConteudo(1, AlienacaoBem.DESCRICAO_NATUREZA_DISSOLUCAO_DA_SOCIEDADE_CONJUGAL_OU_UNIAO_ESTAVEL);
            colecaoNaturezasParticipacaoSocietaria.add(e4);
        }
        return colecaoNaturezasParticipacaoSocietaria;
    }

    public static List<ElementoTabela> recuperarEspecieOperacaoPSocietaria() {
        if (colecaoEspecieOperacaoPSocietaria == null) {
            colecaoEspecieOperacaoPSocietaria = new ArrayList<ElementoTabela>();
            ElementoTabela e1 = new ElementoTabela();
            e1.setConteudo(0, "A");
            e1.setConteudo(1, "A\u00e7\u00f5es");
            colecaoEspecieOperacaoPSocietaria.add(e1);
            ElementoTabela e2 = new ElementoTabela();
            e2.setConteudo(0, "F");
            e2.setConteudo(1, "F.I.I. (Fundos de Investimento Imobili\u00e1rio)");
            colecaoEspecieOperacaoPSocietaria.add(e2);
            ElementoTabela e3 = new ElementoTabela();
            e3.setConteudo(0, "P");
            e3.setConteudo(1, "Fundos de Investimentos em Participa\u00e7\u00f5es");
            colecaoEspecieOperacaoPSocietaria.add(e3);
            ElementoTabela e4 = new ElementoTabela();
            e4.setConteudo(0, "C");
            e4.setConteudo(1, "Fundos de Investimentos em Cotas de Investimentos em Fundos de Participa\u00e7\u00f5es");
            colecaoEspecieOperacaoPSocietaria.add(e4);
            ElementoTabela e5 = new ElementoTabela();
            e5.setConteudo(0, "E");
            e5.setConteudo(1, "Fundos de Investimento em Empresas Emergentes");
            colecaoEspecieOperacaoPSocietaria.add(e5);
            ElementoTabela e6 = new ElementoTabela();
            e6.setConteudo(0, "Q");
            e6.setConteudo(1, "Quotas");
            colecaoEspecieOperacaoPSocietaria.add(e6);
            ElementoTabela e7 = new ElementoTabela();
            e7.setConteudo(0, "O");
            e7.setConteudo(1, "Outras");
            colecaoEspecieOperacaoPSocietaria.add(e7);
        }
        return colecaoEspecieOperacaoPSocietaria;
    }

    public static List<ElementoTabela> recuperarEspecieAquisicaoPSAcoes() {
        colecaoEspecieAquisicaoPSocietaria = new ArrayList<ElementoTabela>();
        ElementoTabela e1 = new ElementoTabela();
        e1.setConteudo(0, String.valueOf(1));
        e1.setConteudo(1, "A\u00e7\u00e3o preferencial nominativa");
        colecaoEspecieAquisicaoPSocietaria.add(e1);
        ElementoTabela e2 = new ElementoTabela();
        e2.setConteudo(0, String.valueOf(2));
        e2.setConteudo(1, "A\u00e7\u00e3o ordin\u00e1ria nominativa");
        colecaoEspecieAquisicaoPSocietaria.add(e2);
        return colecaoEspecieAquisicaoPSocietaria;
    }

    public static List<ElementoTabela> recuperarEspecieAquisicaoPSQuota() {
        colecaoEspecieAquisicaoPSocietaria = new ArrayList<ElementoTabela>();
        ElementoTabela e1 = new ElementoTabela();
        e1.setConteudo(0, String.valueOf(3));
        e1.setConteudo(1, "Quota");
        colecaoEspecieAquisicaoPSocietaria.add(e1);
        return colecaoEspecieAquisicaoPSocietaria;
    }

    public static List<ElementoTabela> recuperarEspecieAquisicaoPSOutras() {
        colecaoEspecieAquisicaoPSocietaria = new ArrayList<ElementoTabela>();
        ElementoTabela e1 = new ElementoTabela();
        e1.setConteudo(0, String.valueOf(4));
        e1.setConteudo(1, "Outras");
        colecaoEspecieAquisicaoPSocietaria.add(e1);
        return colecaoEspecieAquisicaoPSocietaria;
    }

    public static List<ElementoTabela> recuperarTiposOrigemRendimentos() {
        if (colecaoOrigemRendimentos == null) {
            ElementoTabela e1 = new ElementoTabela();
            e1.setConteudo(0, String.valueOf(1));
            e1.setConteudo(1, "Rendimentos auferidos em moeda nacional");
            ElementoTabela e2 = new ElementoTabela();
            e2.setConteudo(0, String.valueOf(2));
            e2.setConteudo(1, "Rendimentos auferidos em moeda estrangeira");
            ElementoTabela e3 = new ElementoTabela();
            e3.setConteudo(0, String.valueOf(3));
            e3.setConteudo(1, "Rendimentos auferidos em moeda nacional e moeda estrangeira");
            colecaoOrigemRendimentos = new ArrayList<ElementoTabela>();
            colecaoOrigemRendimentos.add(e1);
            colecaoOrigemRendimentos.add(e2);
            colecaoOrigemRendimentos.add(e3);
        }
        return colecaoOrigemRendimentos;
    }

    public static List<ElementoTabela> recuperarBancosCredito() {
        if (colecaoBancosCredito == null) {
            TabelasBasicas.Banco.carregarTabela();
        }
        return colecaoBancosCredito;
    }

    public static List<ElementoTabela> recuperarBancosDebito() {
        if (colecaoBancosDebito == null) {
            TabelasBasicas.Banco.carregarTabela();
        }
        return colecaoBancosDebito;
    }

    public static List<ElementoTabela> recuperarBancosContaPagamento() {
        if (colecaoBancosContaPagamento == null) {
            TabelasBasicas.Banco.carregarTabela();
        }
        return colecaoBancosContaPagamento;
    }

    public static List<ElementoTabela> recuperarBancosBens() {
        if (colecaoBancosBens == null) {
            CadastroTabelasIRPF.carregarBancosBens();
        }
        return colecaoBancosBens;
    }

    public static void carregarBancos() {
        try {
            ArrayList<ElementoTabela> colecaoBancos = new ArrayList<ElementoTabela>();
            ArrayList<ElementoTabela> colecaoBancosDebito = new ArrayList<ElementoTabela>();
            ArrayList<ElementoTabela> colecaoBancosCredito = new ArrayList<ElementoTabela>();
            ArrayList<ElementoTabela> colecaoBancosContaPagamento = new ArrayList<ElementoTabela>();
            List<ElementoTabela> colecaoBancosCalculoDv = repositorioTabelasBasicas.recuperarObjetosTabela("bancos_calculo_dv.xml", testarCRC);
            repositorioTabelasBasicas.recuperarObjetosTabela(TabelasBasicas.Banco.getNomeArquivo(), colecaoBancos, testarCRC);
            final Collator collator = Collator.getInstance(new Locale("pt", "BR"));
            Collections.sort(colecaoBancos, new Comparator<ElementoTabela>(){

                @Override
                public int compare(ElementoTabela o1, ElementoTabela o2) {
                    return collator.compare(o1.getConteudo(1), o2.getConteudo(1));
                }
            });
            Comparator<ElementoTabela> comparator = new Comparator<ElementoTabela>(){

                @Override
                public int compare(ElementoTabela e1, ElementoTabela e2) {
                    return Integer.valueOf(e1.getConteudo(0)).compareTo(Integer.valueOf(e2.getConteudo(0)));
                }
            };
            for (ElementoTabela et : colecaoBancos) {
                int searchIndex = Collections.binarySearch(colecaoBancosCalculoDv, et, comparator);
                String contaPagamento = et.getConteudo(4);
                if ("S".equals(contaPagamento)) {
                    colecaoBancosContaPagamento.add(et);
                }
                if (searchIndex >= 0) {
                    et.setConteudo(4, "S");
                    et.setConteudo(5, colecaoBancosCalculoDv.get(searchIndex).getConteudo(2));
                    et.setConteudo(6, colecaoBancosCalculoDv.get(searchIndex).getConteudo(3));
                    et.setConteudo(7, contaPagamento);
                } else {
                    et.setConteudo(4, "N");
                    et.setConteudo(5, contaPagamento);
                }
                if ("S".equals(et.getConteudo(2))) {
                    colecaoBancosCredito.add(et);
                }
                if ("S".equals(et.getConteudo(3))) {
                    colecaoBancosDebito.add(et);
                }
                et.setConteudo(1, et.getConteudo(0) + " - " + et.getConteudo(1));
            }
            CadastroTabelasIRPF.colecaoBancosCredito = colecaoBancosCredito;
            CadastroTabelasIRPF.colecaoBancosDebito = colecaoBancosDebito;
            CadastroTabelasIRPF.colecaoBancosContaPagamento = colecaoBancosContaPagamento;
        }
        catch (RepositorioException e) {
            trataErro.trataErroSistemico((Throwable)e);
        }
    }

    public static void carregarTipoConta() {
        try {
            ArrayList colecaoTipoConta = new ArrayList();
            repositorioTabelasBasicas.recuperarObjetosTabela(TabelasBasicas.TipoConta.getNomeArquivo(), CadastroTabelasIRPF.colecaoTipoConta, testarCRC);
            for (ElementoTabela et : colecaoTipoConta) {
                String cod = et.getConteudo(0);
                String desc = et.getConteudo(1);
                et.setConteudo(1, cod + " - " + desc);
            }
        }
        catch (RepositorioException e) {
            trataErro.trataErroSistemico((Throwable)e);
        }
    }

    public static void carregarBancosBens() {
        try {
            ArrayList<ElementoTabela> colecaoBancos = new ArrayList<ElementoTabela>();
            List<ElementoTabela> colecaoBancosCalculoDv = repositorioTabelasBasicas.recuperarObjetosTabela("bancos_calculo_dv.xml", testarCRC);
            repositorioTabelasBasicas.recuperarObjetosTabela(TabelasBasicas.BancoBens.getNomeArquivo(), colecaoBancos, testarCRC);
            final Collator collator = Collator.getInstance(new Locale("pt", "BR"));
            Collections.sort(colecaoBancos, new Comparator<ElementoTabela>(){

                @Override
                public int compare(ElementoTabela o1, ElementoTabela o2) {
                    return collator.compare(o1.getConteudo(1), o2.getConteudo(1));
                }
            });
            Comparator<ElementoTabela> comparator = new Comparator<ElementoTabela>(){

                @Override
                public int compare(ElementoTabela e1, ElementoTabela e2) {
                    return Integer.valueOf(e1.getConteudo(0)).compareTo(Integer.valueOf(e2.getConteudo(0)));
                }
            };
            for (ElementoTabela et : colecaoBancos) {
                int searchIndex = Collections.binarySearch(colecaoBancosCalculoDv, et, comparator);
                if (searchIndex >= 0) {
                    et.setConteudo(4, "S");
                    et.setConteudo(5, colecaoBancosCalculoDv.get(searchIndex).getConteudo(2));
                    et.setConteudo(6, colecaoBancosCalculoDv.get(searchIndex).getConteudo(3));
                } else {
                    et.setConteudo(4, "N");
                }
                et.setConteudo(1, et.getConteudo(0) + " - " + et.getConteudo(1));
            }
            colecaoBancosBens = colecaoBancos;
        }
        catch (RepositorioException e) {
            trataErro.trataErroSistemico((Throwable)e);
        }
    }

    public static void carregarNaturezaOcupacao() {
        try {
            List<ElementoTabela> colecaoNaturezasOcupacao = repositorioTabelasBasicas.recuperarObjetosTabela(TabelasBasicas.NaturezaOcupacao.getNomeArquivo(), testarCRC);
            ElementoTabela elementoEspolio = null;
            for (ElementoTabela et : colecaoNaturezasOcupacao) {
                String cod = et.getConteudo(0);
                String desc = et.getConteudo(1);
                et.setConteudo(1, cod + " - " + desc);
                if (!"81".equals(cod)) continue;
                elementoEspolio = et;
            }
            if (IRPFFacade.getInstancia().getIdDeclaracaoAberto() != null && TipoDeclaracaoAES.SAIDA.getTipo().equals(IRPFFacade.getInstancia().getIdDeclaracaoAberto().getTipoDeclaracaoAES().naoFormatado()) && elementoEspolio != null) {
                colecaoNaturezasOcupacao.remove(elementoEspolio);
            }
            CadastroTabelasIRPF.colecaoNaturezasOcupacao = colecaoNaturezasOcupacao;
        }
        catch (RepositorioException e) {
            trataErro.trataErroSistemico((Throwable)e);
        }
    }

    public static List<ElementoTabela> recuperarNaturezasOcupacao() {
        try {
            colecaoNaturezasOcupacao = repositorioTabelasBasicas.recuperarObjetosTabela("resources/naturezasOcupacao.xml", testarCRC);
            ElementoTabela elementoEspolio = null;
            for (ElementoTabela et : colecaoNaturezasOcupacao) {
                String cod = et.getConteudo(0);
                String desc = et.getConteudo(1);
                et.setConteudo(1, cod + " - " + desc);
                if (!"81".equals(cod)) continue;
                elementoEspolio = et;
            }
            if (IRPFFacade.getInstancia().getIdDeclaracaoAberto() != null && TipoDeclaracaoAES.SAIDA.getTipo().equals(IRPFFacade.getInstancia().getIdDeclaracaoAberto().getTipoDeclaracaoAES().naoFormatado()) && elementoEspolio != null) {
                colecaoNaturezasOcupacao.remove(elementoEspolio);
            }
        }
        catch (RepositorioException e) {
            trataErro.trataErroSistemico((Throwable)e);
        }
        return colecaoNaturezasOcupacao;
    }

    public static List<ElementoTabela> recuperarRepresentacoes() {
        try {
            if (colecaoRepresentacoes == null) {
                colecaoRepresentacoes = repositorioTabelasBasicas.recuperarObjetosTabela("representacoes.xml", testarCRC);
                for (ElementoTabela et : colecaoRepresentacoes) {
                    String cod = et.getConteudo(0);
                    String cidade = et.getConteudo(1);
                    String pais = et.getConteudo(2);
                    String representacao = et.getConteudo(3);
                    et.setConteudo(1, cod + " - " + cidade + ", " + pais + " - " + representacao);
                }
            }
        }
        catch (RepositorioException e) {
            trataErro.trataErroSistemico((Throwable)e);
        }
        return colecaoRepresentacoes;
    }

    public static List<ElementoTabela> recuperarMunicipios(String uf, int pColunaDeOrdenacao) {
        try {
            if (tabelaMunicipios.containsKey(uf)) {
                return tabelaMunicipios.get(uf);
            }
            List<ElementoTabela> novaColecaoMunicipios = repositorioTabelasBasicas.recuperarObjetosTabela(uf + ".xml", testarCRC);
            CadastroTabelasIRPF.ordenarElementosPorColuna(pColunaDeOrdenacao, novaColecaoMunicipios);
            tabelaMunicipios.put(uf, novaColecaoMunicipios);
            return novaColecaoMunicipios;
        }
        catch (RepositorioException e) {
            trataErro.trataErroSistemico((Throwable)e);
            return null;
        }
    }

    public static void carregarMunicipiosCalamidade() {
        try {
            List<ElementoTabela> colecaoMunicipiosCalamidade = repositorioTabelasBasicas.recuperarObjetosTabela(TabelasBasicas.MunicipiosCalamidade.getNomeArquivo(), false);
            Map<String, String> mapaMunicipiosCalamidade = colecaoMunicipiosCalamidade.stream().collect(Collectors.toMap(e -> e.getConteudo(0), e -> e.getConteudo(1)));
            municipiosCalamidade = mapaMunicipiosCalamidade;
        }
        catch (RepositorioException e2) {
            trataErro.trataErroSistemico((Throwable)e2);
        }
    }

    public static Map<String, String> recuperarMunicipiosEmCalamidade() {
        if (municipiosCalamidade.isEmpty()) {
            TabelasBasicas.MunicipiosCalamidade.carregarTabela();
        }
        return municipiosCalamidade;
    }

    public static boolean municipioEmCalamidade(String codigoMunicipio) {
        return CadastroTabelasIRPF.recuperarMunicipiosEmCalamidade().containsKey(codigoMunicipio);
    }

    public static String getCodBrasilia() {
        String cod = "0";
        List<ElementoTabela> municipios = CadastroTabelasIRPF.recuperarMunicipios("DF", 0);
        for (ElementoTabela elem : municipios) {
            if (!elem.getConteudo(1).equals("Bras\u00edlia")) continue;
            cod = elem.getConteudo(0);
            break;
        }
        return cod;
    }

    public static boolean isTestarCRC() {
        return testarCRC;
    }

    public static void setTestarCRC(boolean b) {
        testarCRC = b;
    }

    private static void ordenarElementosPorColuna(final int pColuna, List<ElementoTabela> pColecao) {
        final Collator collator = Collator.getInstance(new Locale("pt", "BR"));
        Collections.sort(pColecao, new Comparator<ElementoTabela>(){

            @Override
            public int compare(ElementoTabela o1, ElementoTabela o2) {
                String conteudo1 = "";
                String conteudo2 = "";
                if (pColuna < o1.size()) {
                    conteudo1 = o1.getConteudo(pColuna);
                }
                if (pColuna < o2.size()) {
                    conteudo2 = o2.getConteudo(pColuna);
                }
                return collator.compare(conteudo1, conteudo2);
            }
        });
    }

    public static List<ElementoTabela> recuperarMeses() {
        ArrayList<ElementoTabela> retorno = new ArrayList<ElementoTabela>();
        ElementoTabela elemento = new ElementoTabela();
        elemento.setConteudo(0, "01");
        elemento.setConteudo(1, "Janeiro");
        retorno.add(0, elemento);
        elemento = new ElementoTabela();
        elemento.setConteudo(0, "02");
        elemento.setConteudo(1, "Fevereiro");
        retorno.add(1, elemento);
        elemento = new ElementoTabela();
        elemento.setConteudo(0, "03");
        elemento.setConteudo(1, "Mar\u00e7o");
        retorno.add(2, elemento);
        elemento = new ElementoTabela();
        elemento.setConteudo(0, "04");
        elemento.setConteudo(1, "Abril");
        retorno.add(3, elemento);
        elemento = new ElementoTabela();
        elemento.setConteudo(0, "05");
        elemento.setConteudo(1, "Maio");
        retorno.add(4, elemento);
        elemento = new ElementoTabela();
        elemento.setConteudo(0, "06");
        elemento.setConteudo(1, "Junho");
        retorno.add(5, elemento);
        elemento = new ElementoTabela();
        elemento.setConteudo(0, "07");
        elemento.setConteudo(1, "Julho");
        retorno.add(6, elemento);
        elemento = new ElementoTabela();
        elemento.setConteudo(0, "08");
        elemento.setConteudo(1, "Agosto");
        retorno.add(7, elemento);
        elemento = new ElementoTabela();
        elemento.setConteudo(0, "09");
        elemento.setConteudo(1, "Setembro");
        retorno.add(8, elemento);
        elemento = new ElementoTabela();
        elemento.setConteudo(0, "10");
        elemento.setConteudo(1, "Outubro");
        retorno.add(9, elemento);
        elemento = new ElementoTabela();
        elemento.setConteudo(0, "11");
        elemento.setConteudo(1, "Novembro");
        retorno.add(10, elemento);
        elemento = new ElementoTabela();
        elemento.setConteudo(0, "12");
        elemento.setConteudo(1, "Dezembro");
        retorno.add(11, elemento);
        return retorno;
    }

    public static List<ElementoTabela> recuperarTiposLogradouro() {
        try {
            if (colecaoTipoLogradouro == null) {
                colecaoTipoLogradouro = repositorioTabelasBasicas.recuperarObjetosTabela("tipoLogradouro.xml", testarCRC);
                CadastroTabelasIRPF.ordenarElementosPorColuna(1, colecaoTipoLogradouro);
            }
        }
        catch (RepositorioException e) {
            trataErro.trataErroSistemico((Throwable)e);
        }
        return colecaoTipoLogradouro;
    }

    public static List<ElementoTabela> recuperarMotivacoes() {
        ArrayList<ElementoTabela> retorno = new ArrayList<ElementoTabela>();
        ElementoTabela elemento = new ElementoTabela();
        elemento.setConteudo(0, "J");
        elemento.setConteudo(1, "Decis\u00e3o judicial ou acordo homologado judicialmente");
        retorno.add(0, elemento);
        elemento = new ElementoTabela();
        elemento.setConteudo(0, "C");
        elemento.setConteudo(1, "Escritura p\u00fablica");
        retorno.add(1, elemento);
        return retorno;
    }

    public static List<ElementoTabela> recuperarDependentes() {
        Dependentes col = IRPFFacade.getInstancia().getDependentes();
        ArrayList<ElementoTabela> lista = new ArrayList<ElementoTabela>(col.getTamanho());
        for (Dependente d : col.itens()) {
            if (d.getCpfDependente().isVazio()) continue;
            ElementoTabela el = new ElementoTabela();
            el.setConteudo(0, d.getCpfDependente().formatado());
            el.setConteudo(1, d.getCpfDependente().formatado() + " - " + d.getNome().naoFormatado());
            lista.add(el);
        }
        return lista;
    }

    public static List<ElementoTabela> recuperarDependentesCPFValido() {
        Dependentes col = IRPFFacade.getInstancia().getDependentes();
        ArrayList<ElementoTabela> lista = new ArrayList<ElementoTabela>(col.getTamanho());
        for (Dependente d : col.itens()) {
            if (3 == d.getCpfDependente().validar().getPrimeiroRetornoValidacaoMaisSevero().getSeveridade()) continue;
            ElementoTabela el = new ElementoTabela();
            el.setConteudo(0, d.getCpfDependente().formatado());
            el.setConteudo(1, d.getCpfDependente().formatado() + " - " + d.getNome().naoFormatado());
            lista.add(el);
        }
        return lista;
    }

    public static List<ElementoTabela> recuperarDependentesInforme() {
        Dependentes col = IRPFFacade.getInstancia().getDependentes();
        ArrayList<ElementoTabela> lista = new ArrayList<ElementoTabela>(col.getTamanho());
        for (Dependente dependente : col.itens()) {
            ElementoTabela el = new ElementoTabela();
            el.setConteudo(0, dependente.getCpfDependente().naoFormatado() + "|" + dependente.getNome().naoFormatado());
            el.setConteudo(1, (String)(dependente.getCpfDependente().isVazio() ? "" : dependente.getCpfDependente().formatado() + " - ") + dependente.getNome().formatado());
            lista.add(el);
        }
        return lista;
    }

    public static List<ElementoTabela> recuperarTitular() {
        IdentificadorDeclaracao id = IRPFFacade.getInstancia().getIdDeclaracaoAberto();
        ArrayList<ElementoTabela> lista = new ArrayList<ElementoTabela>(1);
        if (!id.getCpf().isVazio() || !id.getNome().isVazio()) {
            ElementoTabela el = new ElementoTabela();
            el.setConteudo(0, id.getCpf().formatado());
            el.setConteudo(1, id.getCpf().formatado() + " - " + id.getNome().naoFormatado());
            lista.add(el);
        }
        return lista;
    }

    public static List<ElementoTabela> recuperarTitularDependentes() {
        List<ElementoTabela> lista = CadastroTabelasIRPF.recuperarTitular();
        lista.addAll(CadastroTabelasIRPF.recuperarDependentes());
        return lista;
    }

    public static List<ElementoTabela> recuperarHerdeiros() {
        Herdeiros col = IRPFFacade.getInstancia().getHerdeiros();
        ArrayList<ElementoTabela> lista = new ArrayList<ElementoTabela>(col.getTamanho());
        for (Herdeiro herdeiro : col.itens()) {
            if (herdeiro.getNiHerdeiro().isVazio() || herdeiro.getNome().isVazio()) continue;
            ElementoTabela el = new ElementoTabela();
            el.setConteudo(0, herdeiro.getNiHerdeiro().formatado());
            el.setConteudo(1, herdeiro.getNiHerdeiro().formatado() + " - " + herdeiro.getNome().naoFormatado());
            lista.add(el);
        }
        return lista;
    }

    public static List<ElementoTabela> recuperarNomesDependentes() {
        Dependentes col = IRPFFacade.getInstancia().getDependentes();
        ArrayList<ElementoTabela> lista = new ArrayList<ElementoTabela>(col.getTamanho());
        for (Dependente dependente : col.itens()) {
            if (dependente.getCpfDependente().isVazio() && dependente.getNome().isVazio()) continue;
            ElementoTabela el = new ElementoTabela();
            el.setConteudo(0, dependente.getNome().naoFormatado());
            el.setConteudo(1, dependente.getNome().naoFormatado());
            el.setConteudo(2, dependente.getCpfDependente().formatado());
            lista.add(el);
        }
        return lista;
    }

    public static List<ElementoTabela> recuperarNomesAlimentandos(String tipoResidente) {
        Alimentandos col = IRPFFacade.getInstancia().getAlimentandos();
        ArrayList<ElementoTabela> lista = new ArrayList<ElementoTabela>(col.getTamanho());
        for (Alimentando alimentando : col.itens()) {
            if (!tipoResidente.equals("2") && !alimentando.getResidente().formatado().equals(tipoResidente) || alimentando.getNome().isVazio()) continue;
            ElementoTabela el = new ElementoTabela();
            el.setConteudo(0, alimentando.getNome().naoFormatado());
            el.setConteudo(1, alimentando.getNome().naoFormatado());
            el.setConteudo(2, alimentando.getCpf().formatado());
            lista.add(el);
        }
        return lista;
    }

    public static List<ElementoTabela> recuperarNomesAlimentandosPorCPF(String tipoResidente, CPF cpfDependente) {
        Alimentandos col = IRPFFacade.getInstancia().getAlimentandos();
        ArrayList<ElementoTabela> lista = new ArrayList<ElementoTabela>(col.getTamanho());
        for (Alimentando alimentando : col.itens()) {
            if (!tipoResidente.equals("2") && !alimentando.getResidente().formatado().equals(tipoResidente) || !alimentando.getCpfResponsavel().naoFormatado().equals(cpfDependente.naoFormatado()) || alimentando.getNome().isVazio()) continue;
            ElementoTabela el = new ElementoTabela();
            el.setConteudo(0, alimentando.getNome().naoFormatado());
            el.setConteudo(1, alimentando.getNome().naoFormatado());
            el.setConteudo(2, alimentando.getCpf().formatado());
            lista.add(el);
        }
        return lista;
    }

    public static List<ElementoTabela> recuperarAlimentandosInforme() {
        Alimentandos col = IRPFFacade.getInstancia().getAlimentandos();
        ArrayList<ElementoTabela> lista = new ArrayList<ElementoTabela>(col.getTamanho());
        for (Alimentando alimentando : col.itens()) {
            if (alimentando.getNome().isVazio()) continue;
            ElementoTabela el = new ElementoTabela();
            el.setConteudo(0, alimentando.getCpf().naoFormatado() + "|" + alimentando.getNome().naoFormatado() + "|" + alimentando.getResidente().naoFormatado());
            el.setConteudo(1, (String)(alimentando.getCpf().isVazio() ? "" : alimentando.getCpf().formatado() + " - ") + alimentando.getNome().formatado());
            el.setConteudo(2, alimentando.getResidente().naoFormatado());
            lista.add(el);
        }
        return lista;
    }

    public static List<ElementoTabela> recuperarAlimentandosResidentesInforme() {
        Alimentandos col = IRPFFacade.getInstancia().getAlimentandos();
        ArrayList<ElementoTabela> lista = new ArrayList<ElementoTabela>(col.getTamanho());
        for (Alimentando alimentando : col.itens()) {
            if (!alimentando.getResidente().formatado().equals("0") && !alimentando.getResidente().formatado().equals("1") || alimentando.getNome().isVazio()) continue;
            ElementoTabela el = new ElementoTabela();
            el.setConteudo(0, alimentando.getCpf().naoFormatado() + "|" + alimentando.getNome().naoFormatado() + "|" + alimentando.getResidente().naoFormatado());
            el.setConteudo(1, (String)(alimentando.getCpf().isVazio() ? "" : alimentando.getCpf().formatado() + " - ") + alimentando.getNome().formatado());
            el.setConteudo(2, alimentando.getResidente().naoFormatado());
            lista.add(el);
        }
        return lista;
    }

    public static void carregarTiposRendimentos() {
        try {
            colecaoTiposRendimentos = repositorioTabelasBasicas.recuperarObjetosTabela("resources/tipoRendimentos.xml", testarCRC);
            colecaoTiposRendimentosIsentos = null;
            colecaoTiposRendimentosIsentosTotais = null;
            colecaoTiposRendTributExclusiva = null;
        }
        catch (RepositorioException e) {
            trataErro.trataErroSistemico((Throwable)e);
        }
    }

    public static List<ElementoTabela> recuperarTiposRendimentos() {
        if (colecaoTiposRendimentos == null) {
            CadastroTabelasIRPF.carregarTiposRendimentos();
        }
        return colecaoTiposRendimentos;
    }

    public static List<ElementoTabela> recuperarTiposRendimentosIsentosAjusteTela(Map<String, String> mapCorrespondenciaRend) {
        List<ElementoTabela> colecaoTiposRendimentos = CadastroTabelasIRPF.recuperarTiposRendimentos();
        ArrayList<ElementoTabela> colecaoTiposRendimentosEspecifico = new ArrayList<ElementoTabela>();
        ElementoTabela elementoOutros = null;
        for (int i = 0; i < colecaoTiposRendimentos.size(); ++i) {
            ElementoTabela elemento = colecaoTiposRendimentos.get(i);
            String codigoPGD = mapCorrespondenciaRend.get(elemento.getConteudo(0));
            if (codigoPGD == null) continue;
            if (RendIsentos.TIPO_RENDISENTO_26.equals(codigoPGD)) {
                codigoPGD = RendIsentos.TIPO_RENDISENTO_OUTROS_TELA;
            }
            if (RendIsentos.TIPO_RENDISENTO_27.equals(codigoPGD)) {
                codigoPGD = RendIsentos.TIPO_RENDISENTO_RRA_TELA;
            }
            if (RendIsentos.TIPO_RENDISENTO_28.equals(codigoPGD)) {
                codigoPGD = RendIsentos.TIPO_RENDISENTO_PENSAO_ALIMENTICIA_TELA;
            }
            ElementoTabela elementoNovo = new ElementoTabela();
            elementoNovo.setConteudo(0, codigoPGD);
            elementoNovo.setConteudo(1, codigoPGD + " - " + elemento.getConteudo(1));
            elementoNovo.setConteudo(2, elemento.getConteudo(1));
            elementoNovo.setConteudo(3, elemento.getConteudo(1));
            if (RendIsentos.TIPO_RENDISENTO_OUTROS_TELA.equals(codigoPGD)) {
                elementoOutros = elementoNovo;
                continue;
            }
            colecaoTiposRendimentosEspecifico.add(elementoNovo);
        }
        if (elementoOutros != null) {
            colecaoTiposRendimentosEspecifico.add(elementoOutros);
        }
        return colecaoTiposRendimentosEspecifico;
    }

    public static List<ElementoTabela> recuperarTiposRendimentosIsentos() {
        if (colecaoTiposRendimentosIsentos == null) {
            colecaoTiposRendimentosIsentos = CadastroTabelasIRPF.recuperarTiposRendimentosIsentosAjusteTela(TabelaRendimentos.getCorrespondenciaRendIsentos());
        }
        return colecaoTiposRendimentosIsentos;
    }

    public static List<ElementoTabela> recuperarTiposRendimentosExclusivosAjusteTela(Map<String, String> mapCorrespondenciaRend) {
        List<ElementoTabela> colecaoTiposRendimentos = CadastroTabelasIRPF.recuperarTiposRendimentos();
        ArrayList<ElementoTabela> colecaoTiposRendimentosEspecifico = new ArrayList<ElementoTabela>();
        ElementoTabela elementoOutros = null;
        for (int i = 0; i < colecaoTiposRendimentos.size(); ++i) {
            ElementoTabela elemento = colecaoTiposRendimentos.get(i);
            String codigoPGD = mapCorrespondenciaRend.get(elemento.getConteudo(0));
            if (codigoPGD == null) continue;
            if (RendTributacaoExclusiva.TIPO_RENDEXCLUSIVO_12.equals(codigoPGD)) {
                codigoPGD = RendTributacaoExclusiva.TIPO_RENDEXCLUSIVO_OUTROS_TELA;
            }
            if (RendTributacaoExclusiva.TIPO_RENDEXCLUSIVO_13.equals(codigoPGD)) {
                codigoPGD = RendTributacaoExclusiva.TIPO_RENDEXCLUSIVO_LEI14754_TELA;
            }
            ElementoTabela elementoNovo = new ElementoTabela();
            elementoNovo.setConteudo(0, codigoPGD);
            elementoNovo.setConteudo(1, codigoPGD + " - " + elemento.getConteudo(1));
            elementoNovo.setConteudo(2, elemento.getConteudo(1));
            elementoNovo.setConteudo(3, elemento.getConteudo(1));
            if (RendTributacaoExclusiva.TIPO_RENDEXCLUSIVO_OUTROS_TELA.equals(codigoPGD)) {
                elementoOutros = elementoNovo;
                continue;
            }
            colecaoTiposRendimentosEspecifico.add(elementoNovo);
        }
        if (elementoOutros != null) {
            colecaoTiposRendimentosEspecifico.add(elementoOutros);
        }
        return colecaoTiposRendimentosEspecifico;
    }

    public static List<ElementoTabela> recuperarTiposRendimentosIsentosTotais() {
        if (colecaoTiposRendimentosIsentosTotais == null) {
            colecaoTiposRendimentosIsentosTotais = new ArrayList<ElementoTabela>(CadastroTabelasIRPF.recuperarTiposRendimentosIsentos());
            colecaoTiposRendimentosIsentosTotais.addAll(CadastroTabelasIRPF.recuperarTiposRendimentosIsentosAjusteTela(TabelaRendimentos.getCorrespondenciaRendIsentosTotais()));
        }
        return colecaoTiposRendimentosIsentosTotais;
    }

    public static List<ElementoTabela> recuperarTiposRendimentosTributacaoExclusiva() {
        if (colecaoTiposRendTributExclusiva == null) {
            colecaoTiposRendTributExclusiva = CadastroTabelasIRPF.recuperarTiposRendimentosExclusivosAjusteTela(TabelaRendimentos.getCorrespondenciaRendExclusivos());
        }
        return colecaoTiposRendTributExclusiva;
    }

    public static List<ElementoTabela> recuperarTiposRendimentosTributacaoExclusivaTotais() {
        if (colecaoTiposRendTributExclusivaTotais == null) {
            colecaoTiposRendTributExclusivaTotais = new ArrayList<ElementoTabela>(CadastroTabelasIRPF.recuperarTiposRendimentosTributacaoExclusiva());
            colecaoTiposRendTributExclusivaTotais.addAll(CadastroTabelasIRPF.recuperarTiposRendimentosExclusivosAjusteTela(TabelaRendimentos.getCorrespondenciaRendExclusivosTotais()));
        }
        return colecaoTiposRendTributExclusivaTotais;
    }

    public static List<ElementoTabela> obterBensComContasCadastradas(Bens bens, boolean debito) {
        ArrayList<ElementoTabela> listaContasCadastradas = new ArrayList<ElementoTabela>();
        for (Bem bem : bens.itens()) {
            if (bem.getBanco().isVazio() || bem.getAgencia().isVazio() || bem.getDVConta().isVazio() || !bem.getTipo().naoFormatado().equals("T") || (!debito || !"S".equals(bem.getBanco().getConteudoAtual(3))) && (debito || !"S".equals(bem.getBanco().getConteudoAtual(2)))) continue;
            ElementoTabela contaCadastrada = new ElementoTabela();
            contaCadastrada.setConteudo(0, bem.getBanco().naoFormatado() + "-" + bem.getAgencia().naoFormatado() + "-" + bem.getConta().naoFormatado() + "-" + bem.getOperacao().naoFormatado());
            contaCadastrada.setConteudo(1, Bem.obterDescricaoTipoContaBem(bem.getIndicadorContaPagamento().naoFormatado(), bem.getGrupo().naoFormatado(), bem.getCodigo().naoFormatado()) + ": AG:" + bem.getAgencia().naoFormatado().trim() + " - C/C:" + bem.getConta().naoFormatado().trim() + "-" + bem.getDVConta().naoFormatado().trim() + " (" + bem.getBanco().getConteudoAtual(1) + ")");
            contaCadastrada.setConteudo(2, bem.getBanco().naoFormatado());
            contaCadastrada.setConteudo(3, bem.getAgencia().naoFormatado());
            contaCadastrada.setConteudo(4, bem.getConta().naoFormatado());
            contaCadastrada.setConteudo(5, bem.getDVConta().naoFormatado());
            contaCadastrada.setConteudo(6, bem.getBanco().getConteudoAtual(1));
            contaCadastrada.setConteudo(7, bem.getOperacao().naoFormatado());
            contaCadastrada.setConteudo(8, CONTA_CEF_TIPO_2);
            contaCadastrada.setConteudo(9, bem.getIndicadorContaPagamento().naoFormatado());
            contaCadastrada.setConteudo(10, bem.getGrupo().naoFormatado());
            contaCadastrada.setConteudo(11, bem.getCodigo().naoFormatado());
            listaContasCadastradas.add(contaCadastrada);
        }
        return listaContasCadastradas;
    }

    public static void carregarTabelaMensagens() {
        ArrayList<ElementoTabela> listaMensagens = new ArrayList<ElementoTabela>();
        try {
            repositorioTabelasBasicas.recuperarObjetosTabela(TabelasBasicas.Mensagens.getNomeArquivo(), listaMensagens, true);
        }
        catch (RepositorioException e) {
            e.printStackTrace();
        }
        colecaoMensagens = listaMensagens;
    }

    public static String recuperarMensagem(CodigoTabelaMensagens codigo) {
        if (colecaoMensagens == null) {
            CadastroTabelasIRPF.carregarTabelaMensagens();
        }
        for (ElementoTabela et : colecaoMensagens) {
            if (!et.getConteudo(0).equals(codigo.getCodigo())) continue;
            return et.getConteudo(1);
        }
        return "";
    }

    public static String recuperarMensagemHTML(CodigoTabelaMensagens codigo, int largura) {
        String msg = "<html><body style='width: " + largura + "px;'>" + CadastroTabelasIRPF.recuperarMensagem(codigo) + "</body></html>";
        return msg;
    }

    public static String recuperarMensagemHTML(CodigoTabelaMensagens codigo) {
        String msg = "<html><body>" + CadastroTabelasIRPF.recuperarMensagem(codigo) + "</body></html>";
        return msg;
    }

    public static String recuperarMensagemHTML(CodigoTabelaMensagens codigo, boolean converterMenorMaior) {
        Object msg = "<html><body>" + CadastroTabelasIRPF.recuperarMensagem(codigo) + "</body></html>";
        if (converterMenorMaior) {
            msg = ((String)msg).replaceAll("&lt;", "<").replaceAll("&gt;", ">");
        }
        return msg;
    }

    public static String recuperarMensagemComQuebra(CodigoTabelaMensagens codigo) {
        String msg = CadastroTabelasIRPF.recuperarMensagem(codigo);
        msg = UtilitariosString.insereQuebraDeLinha((String)msg, (int)100, (String)"\n");
        return msg;
    }

    public static void carregarTabelaLinks() {
        ArrayList<ElementoTabela> listaLinks = new ArrayList<ElementoTabela>();
        try {
            repositorioTabelasBasicas.recuperarObjetosTabela(TabelasBasicas.Links.getNomeArquivo(), listaLinks, true);
        }
        catch (RepositorioException e) {
            e.printStackTrace();
        }
        colecaoLinks = listaLinks;
    }

    public static ElementoTabela recuperarLink(CodigoTabelaLinks codigo) {
        if (colecaoLinks == null) {
            CadastroTabelasIRPF.carregarTabelaLinks();
        }
        for (ElementoTabela et : colecaoLinks) {
            if (!et.getConteudo(0).equals(codigo.getCodigo())) continue;
            return et;
        }
        return null;
    }

    public static String recuperarDescricaoLink(CodigoTabelaLinks codigo) {
        ElementoTabela et = CadastroTabelasIRPF.recuperarLink(codigo);
        if (et != null) {
            return et.getConteudo(1);
        }
        return "";
    }

    public static String recuperarURLLink(CodigoTabelaLinks codigo) {
        ElementoTabela et = CadastroTabelasIRPF.recuperarLink(codigo);
        if (et != null) {
            return et.getConteudo(2);
        }
        return "";
    }

    public static void atualizarHash(String arqXml) throws RepositorioException {
        repositorioTabelasBasicas.salvar(arqXml, repositorioTabelasBasicas.recuperarObjetosTabela(arqXml, false));
    }

    public static void main(String[] Args) {
        try {
            CadastroTabelasIRPF.atualizarHash("resources/links.xml");
        }
        catch (Exception e) {
            LogPPGD.erro((String)e.getMessage());
        }
        System.out.println("Gerou!!!");
    }

    static {
        nomesEstados.put("AC", "Acre");
        nomesEstados.put("AL", "Alagoas");
        nomesEstados.put("AP", "Amap\u00e1");
        nomesEstados.put("AM", "Amazonas");
        nomesEstados.put("BA", "Bahia");
        nomesEstados.put("CE", "Cear\u00e1");
        nomesEstados.put("DF", "Distrito Federal");
        nomesEstados.put("ES", "Esp\u00edrito Santo");
        nomesEstados.put("GO", "Goi\u00e1s");
        nomesEstados.put("MA", "Maranh\u00e3o");
        nomesEstados.put("MT", "Mato Grosso");
        nomesEstados.put("MS", "Mato Grosso do Sul");
        nomesEstados.put("MG", "Minas Gerais");
        nomesEstados.put("PA", "Par\u00e1");
        nomesEstados.put("PB", "Para\u00edba");
        nomesEstados.put("PR", "Paran\u00e1");
        nomesEstados.put("PE", "Pernambuco");
        nomesEstados.put("PI", "Piau\u00ed");
        nomesEstados.put("RJ", "Rio de Janeiro");
        nomesEstados.put("RN", "Rio Grande do Norte");
        nomesEstados.put("RS", "Rio Grande do Sul");
        nomesEstados.put("RO", "Rond\u00f4nia");
        nomesEstados.put("RR", "Roraima");
        nomesEstados.put("SC", "Santa Catarina");
        nomesEstados.put("SP", "S\u00e3o Paulo");
        nomesEstados.put("SE", "Sergipe");
        nomesEstados.put("TO", "Tocantins");
        codsPagamentos.put("01", "01");
        codsPagamentos.put("02", "02");
        codsPagamentos.put("09", "09");
        codsPagamentos.put("10", "10");
        codsPagamentos.put("11", "11");
        codsPagamentos.put("12", "12");
        codsPagamentos.put("13", "13");
        codsPagamentos.put("14", "14");
        codsPagamentos.put("15", "15");
        codsPagamentos.put("16", "16");
        codsPagamentos.put("17", "17");
        codsPagamentos.put("18", "18");
        codsPagamentos.put("19", "19");
        codsPagamentos.put("20", "20");
        codsPagamentos.put("21", "21");
        codsPagamentos.put("22", "22");
        codsPagamentos.put("26", "26");
        codsPagamentos.put("30", "30");
        codsPagamentos.put("31", "31");
        codsPagamentos.put("33", "33");
        codsPagamentos.put("34", "34");
        codsPagamentos.put("36", "36");
        codsPagamentos.put("37", "37");
        codsPagamentos.put("38", "38");
        codsPagamentos.put("60", "60");
        codsPagamentos.put("61", "61");
        codsPagamentos.put("62", "62");
        codsPagamentos.put("66", "66");
        codsPagamentos.put("70", "70");
        codsPagamentos.put("71", "71");
        codsPagamentos.put("72", "72");
        codsPagamentos.put("76", "76");
        codsDoacoes.put("40", "40");
        codsDoacoes.put("41", "41");
        codsDoacoes.put("42", "42");
        codsDoacoes.put("43", "43");
        codsDoacoes.put("44", "44");
        if (AplicacaoPropertiesUtil.isPronasPronon()) {
            codsDoacoes.put("45", "45");
            codsDoacoes.put("46", "46");
        }
        codsDoacoes.put("47", "47");
        codsDoacoes.put("80", "80");
        codsDoacoes.put("81", "81");
        ocupacaoPrincipalTitulos.put("01", "Membros Superiores, Dirigentes e Servidores do Poder P\u00fablico e de Organiza\u00e7\u00f5es de Interesse P\u00fablico");
        ocupacaoPrincipalTitulos.put("02", "Dirigentes e Gerentes");
        ocupacaoPrincipalTitulos.put("03", "Profissionais das Ci\u00eancias Exatas, F\u00edsicas, Qu\u00edmicas e da Engenharia");
        ocupacaoPrincipalTitulos.put("04", "Profissionais das Ci\u00eancias Biol\u00f3gicas, Bioqu\u00edmicas, da Sa\u00fade e Afins");
        ocupacaoPrincipalTitulos.put("05", "Profissionais das Ci\u00eancias Jur\u00eddicas, Sociais e Humanas");
        ocupacaoPrincipalTitulos.put("06", "Profissionais das Letras, das Artes, da Comunica\u00e7\u00e3o e Religiosos");
        ocupacaoPrincipalTitulos.put("07", "Profissionais do Ensino");
        ocupacaoPrincipalTitulos.put("08", "T\u00e9cnicos de N\u00edvel M\u00e9dio das Ci\u00eancias F\u00edsicas, Qu\u00edmicas, Engenharia e Afins");
        ocupacaoPrincipalTitulos.put("09", "T\u00e9cnicos de N\u00edvel M\u00e9dio das Ci\u00eancias Biol\u00f3gicas, Bioqu\u00edmicas, da Sa\u00fade e Afins");
        ocupacaoPrincipalTitulos.put("10", "T\u00e9cnicos de N\u00edvel M\u00e9dio em Servi\u00e7os de Transportes");
        ocupacaoPrincipalTitulos.put("11", "T\u00e9cnicos de Nivel M\u00e9dio nas Ci\u00eancias Administrativas");
        ocupacaoPrincipalTitulos.put("12", "T\u00e9cnicos de Nivel M\u00e9dio dos Servi\u00e7os Culturais, das Comunica\u00e7\u00f5es e dos Desportos");
        ocupacaoPrincipalTitulos.put("13", "Outros T\u00e9cnicos de N\u00edvel M\u00e9dio");
        ocupacaoPrincipalTitulos.put("14", "Trabalhadores de Servi\u00e7os Administrativos");
        ocupacaoPrincipalTitulos.put("15", "Trabalhadores de Servi\u00e7os Diversos");
        ocupacaoPrincipalTitulos.put("16", "Vendedores e Prestadores de Servi\u00e7os do Com\u00e9rcio");
        ocupacaoPrincipalTitulos.put("17", "Trabalhadores do Setor Prim\u00e1rio");
        ocupacaoPrincipalTitulos.put("18", "Trabalhadores das Ind\u00fastrias");
        ocupacaoPrincipalTitulos.put("19", "Trabalhadores de Repara\u00e7\u00e3o e Manuten\u00e7\u00e3o");
        ocupacaoPrincipalTitulos.put("20", "Militares");
        ocupacaoPrincipalTitulos.put("21", "Outras Ocupa\u00e7\u00f5es");
        ocupacaoPrincipalCodigos.put("101", "01");
        ocupacaoPrincipalCodigos.put("102", "01");
        ocupacaoPrincipalCodigos.put("103", "01");
        ocupacaoPrincipalCodigos.put("104", "01");
        ocupacaoPrincipalCodigos.put("105", "01");
        ocupacaoPrincipalCodigos.put("106", "01");
        ocupacaoPrincipalCodigos.put("107", "01");
        ocupacaoPrincipalCodigos.put("108", "01");
        ocupacaoPrincipalCodigos.put("109", "01");
        ocupacaoPrincipalCodigos.put("110", "01");
        ocupacaoPrincipalCodigos.put("111", "01");
        ocupacaoPrincipalCodigos.put("112", "01");
        ocupacaoPrincipalCodigos.put("113", "01");
        ocupacaoPrincipalCodigos.put("114", "01");
        ocupacaoPrincipalCodigos.put("115", "01");
        ocupacaoPrincipalCodigos.put("116", "01");
        ocupacaoPrincipalCodigos.put("117", "01");
        ocupacaoPrincipalCodigos.put("118", "01");
        ocupacaoPrincipalCodigos.put("120", "02");
        ocupacaoPrincipalCodigos.put("121", "02");
        ocupacaoPrincipalCodigos.put("130", "02");
        ocupacaoPrincipalCodigos.put("131", "02");
        ocupacaoPrincipalCodigos.put("140", "02");
        ocupacaoPrincipalCodigos.put("211", "03");
        ocupacaoPrincipalCodigos.put("212", "03");
        ocupacaoPrincipalCodigos.put("213", "03");
        ocupacaoPrincipalCodigos.put("214", "03");
        ocupacaoPrincipalCodigos.put("215", "03");
        ocupacaoPrincipalCodigos.put("221", "04");
        ocupacaoPrincipalCodigos.put("222", "04");
        ocupacaoPrincipalCodigos.put("223", "04");
        ocupacaoPrincipalCodigos.put("224", "04");
        ocupacaoPrincipalCodigos.put("225", "04");
        ocupacaoPrincipalCodigos.put("226", "04");
        ocupacaoPrincipalCodigos.put("227", "04");
        ocupacaoPrincipalCodigos.put("228", "04");
        ocupacaoPrincipalCodigos.put("230", "04");
        ocupacaoPrincipalCodigos.put("231", "04");
        ocupacaoPrincipalCodigos.put("232", "04");
        ocupacaoPrincipalCodigos.put("241", "05");
        ocupacaoPrincipalCodigos.put("250", "05");
        ocupacaoPrincipalCodigos.put("251", "05");
        ocupacaoPrincipalCodigos.put("252", "05");
        ocupacaoPrincipalCodigos.put("253", "05");
        ocupacaoPrincipalCodigos.put("254", "05");
        ocupacaoPrincipalCodigos.put("255", "05");
        ocupacaoPrincipalCodigos.put("256", "05");
        ocupacaoPrincipalCodigos.put("257", "05");
        ocupacaoPrincipalCodigos.put("258", "05");
        ocupacaoPrincipalCodigos.put("259", "05");
        ocupacaoPrincipalCodigos.put("261", "06");
        ocupacaoPrincipalCodigos.put("263", "06");
        ocupacaoPrincipalCodigos.put("264", "06");
        ocupacaoPrincipalCodigos.put("265", "06");
        ocupacaoPrincipalCodigos.put("266", "06");
        ocupacaoPrincipalCodigos.put("267", "06");
        ocupacaoPrincipalCodigos.put("271", "06");
        ocupacaoPrincipalCodigos.put("272", "06");
        ocupacaoPrincipalCodigos.put("273", "06");
        ocupacaoPrincipalCodigos.put("274", "06");
        ocupacaoPrincipalCodigos.put("275", "06");
        ocupacaoPrincipalCodigos.put("276", "06");
        ocupacaoPrincipalCodigos.put("277", "06");
        ocupacaoPrincipalCodigos.put("279", "06");
        ocupacaoPrincipalCodigos.put("290", "07");
        ocupacaoPrincipalCodigos.put("291", "07");
        ocupacaoPrincipalCodigos.put("292", "07");
        ocupacaoPrincipalCodigos.put("293", "07");
        ocupacaoPrincipalCodigos.put("294", "07");
        ocupacaoPrincipalCodigos.put("295", "07");
        ocupacaoPrincipalCodigos.put("296", "07");
        ocupacaoPrincipalCodigos.put("311", "08");
        ocupacaoPrincipalCodigos.put("312", "08");
        ocupacaoPrincipalCodigos.put("313", "08");
        ocupacaoPrincipalCodigos.put("314", "08");
        ocupacaoPrincipalCodigos.put("316", "08");
        ocupacaoPrincipalCodigos.put("317", "08");
        ocupacaoPrincipalCodigos.put("318", "08");
        ocupacaoPrincipalCodigos.put("319", "08");
        ocupacaoPrincipalCodigos.put("320", "09");
        ocupacaoPrincipalCodigos.put("321", "09");
        ocupacaoPrincipalCodigos.put("322", "09");
        ocupacaoPrincipalCodigos.put("323", "09");
        ocupacaoPrincipalCodigos.put("324", "09");
        ocupacaoPrincipalCodigos.put("325", "09");
        ocupacaoPrincipalCodigos.put("328", "09");
        ocupacaoPrincipalCodigos.put("341", "10");
        ocupacaoPrincipalCodigos.put("342", "10");
        ocupacaoPrincipalCodigos.put("351", "11");
        ocupacaoPrincipalCodigos.put("352", "11");
        ocupacaoPrincipalCodigos.put("353", "11");
        ocupacaoPrincipalCodigos.put("354", "11");
        ocupacaoPrincipalCodigos.put("355", "11");
        ocupacaoPrincipalCodigos.put("371", "12");
        ocupacaoPrincipalCodigos.put("372", "12");
        ocupacaoPrincipalCodigos.put("373", "12");
        ocupacaoPrincipalCodigos.put("374", "12");
        ocupacaoPrincipalCodigos.put("375", "12");
        ocupacaoPrincipalCodigos.put("376", "12");
        ocupacaoPrincipalCodigos.put("377", "12");
        ocupacaoPrincipalCodigos.put("391", "13");
        ocupacaoPrincipalCodigos.put("410", "14");
        ocupacaoPrincipalCodigos.put("420", "14");
        ocupacaoPrincipalCodigos.put("511", "15");
        ocupacaoPrincipalCodigos.put("512", "15");
        ocupacaoPrincipalCodigos.put("513", "15");
        ocupacaoPrincipalCodigos.put("514", "15");
        ocupacaoPrincipalCodigos.put("515", "15");
        ocupacaoPrincipalCodigos.put("516", "15");
        ocupacaoPrincipalCodigos.put("517", "15");
        ocupacaoPrincipalCodigos.put("518", "15");
        ocupacaoPrincipalCodigos.put("519", "15");
        ocupacaoPrincipalCodigos.put("529", "16");
        ocupacaoPrincipalCodigos.put("610", "17");
        ocupacaoPrincipalCodigos.put("620", "17");
        ocupacaoPrincipalCodigos.put("630", "17");
        ocupacaoPrincipalCodigos.put("640", "17");
        ocupacaoPrincipalCodigos.put("710", "18");
        ocupacaoPrincipalCodigos.put("720", "18");
        ocupacaoPrincipalCodigos.put("730", "18");
        ocupacaoPrincipalCodigos.put("740", "18");
        ocupacaoPrincipalCodigos.put("750", "18");
        ocupacaoPrincipalCodigos.put("760", "18");
        ocupacaoPrincipalCodigos.put("770", "18");
        ocupacaoPrincipalCodigos.put("780", "18");
        ocupacaoPrincipalCodigos.put("810", "18");
        ocupacaoPrincipalCodigos.put("820", "18");
        ocupacaoPrincipalCodigos.put("830", "19");
        ocupacaoPrincipalCodigos.put("840", "18");
        ocupacaoPrincipalCodigos.put("860", "18");
        ocupacaoPrincipalCodigos.put("870", "18");
        ocupacaoPrincipalCodigos.put("900", "19");
        ocupacaoPrincipalCodigos.put("010", "20");
        ocupacaoPrincipalCodigos.put("020", "20");
        ocupacaoPrincipalCodigos.put("030", "20");
        ocupacaoPrincipalCodigos.put("040", "20");
        ocupacaoPrincipalCodigos.put("050", "20");
        ocupacaoPrincipalCodigos.put("000", "21");
        tabelaECA = new TabelaDoacoesDireta();
        tabelaIdoso = new TabelaDoacoesDireta();
    }

    public static class RepositorioTabelasBasicasIRPF
    implements RepositorioTabelasBasicasIf {
        private SimpleDateFormat dtFormat = new SimpleDateFormat("yyyyMMdd");
        private Map<String, String> mapCRCs = new HashMap<String, String>();
        private Map<String, String> mapVigencias = new HashMap<String, String>();

        public Document leArquivo(String path) {
            Document tabelasDOM = null;
            InputStream in = UtilitariosArquivo.getResource((String)path, RepositorioTabelasBasicasXML.class);
            if (path != null) {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setValidating(false);
                try {
                    DocumentBuilder builder = factory.newDocumentBuilder();
                    tabelasDOM = builder.parse(in);
                    LogPPGD.debug((String)tabelasDOM.getImplementation().toString());
                }
                catch (SAXParseException e) {
                    LogPPGD.erro((String)("Erro de parsing de " + e.getSystemId() + ". linha " + e.getLineNumber() + ": " + e.getMessage()));
                }
                catch (SAXException e) {
                    Exception x = e;
                    if (e.getException() != null) {
                        x = e.getException();
                    }
                    LogPPGD.erro((String)("Erro de parsing: " + ((Throwable)x).getMessage()));
                }
                catch (ParserConfigurationException e) {
                    LogPPGD.erro((String)("Erro de configura\u00e7\u00e3o da f\u00e1brica DOM: " + e.getMessage()));
                }
                catch (IOException e) {
                    LogPPGD.erro((String)("Erro de I/O: " + e.getMessage()));
                }
            }
            return tabelasDOM;
        }

        public List<ElementoTabela> recuperarObjetosTabela(String pNomeArquivoOuTabela, boolean testarCRC) throws RepositorioException {
            ArrayList<ElementoTabela> lstElementoTabela = new ArrayList<ElementoTabela>();
            this.recuperarObjetosTabela(pNomeArquivoOuTabela, lstElementoTabela, testarCRC);
            return lstElementoTabela;
        }

        public String recuperarObjetosTabela(String pNomeArquivoOuTabela, List<ElementoTabela> lista, boolean testarCRC) throws RepositorioException {
            Element element;
            String CRCLido = null;
            Document tabelasDOM = this.leArquivo("/" + pNomeArquivoOuTabela);
            if (tabelasDOM != null && (element = tabelasDOM.getDocumentElement()).hasChildNodes()) {
                NodeList filhos = element.getChildNodes();
                String CRCCalculado = "0";
                for (int i = 0; i < filhos.getLength(); ++i) {
                    if (filhos.item(i).getNodeType() != 1) continue;
                    Element elementFilho = (Element)filhos.item(i);
                    CRCLido = elementFilho.getAttribute("CRC");
                    if (CRCLido.equals("")) {
                        String s;
                        int j = 0;
                        do {
                            if ((s = elementFilho.getAttribute("COL" + ++j)).equals("")) continue;
                            CRCCalculado = UtilitariosString.GerarCRC((String)CRCCalculado, (String)s);
                        } while (!s.equals(""));
                        ElementoTabela elementoTabela = new ElementoTabela();
                        for (int k = 1; k < j; ++k) {
                            elementoTabela.setConteudo(k - 1, elementFilho.getAttribute("COL" + k));
                        }
                        if (lista == null) continue;
                        lista.add(elementoTabela);
                        continue;
                    }
                    this.mapCRCs.put(pNomeArquivoOuTabela, CRCLido);
                    String vigencia = elementFilho.getAttribute("VIGENCIA");
                    if (vigencia != null && vigencia.length() > 0) {
                        try {
                            this.dtFormat.parse(vigencia);
                            this.mapVigencias.put(pNomeArquivoOuTabela, vigencia);
                        }
                        catch (ParseException e) {
                            throw new RepositorioXMLException("Data de Vigencia de tabela b\u00e1sica inv\u00e1lida");
                        }
                    }
                    if (CRCLido.compareTo(CRCCalculado) == 0 || !testarCRC) continue;
                    throw new RepositorioXMLException("Checksum de tabela b\u00e1sica inv\u00e1lido");
                }
            }
            if (lista != null && lista.size() == 0) {
                throw new RepositorioXMLException("Tabela b\u00e1sica inv\u00e1lida");
            }
            return CRCLido;
        }

        public void salvar(String pNomeArquivoOuTabela, List<ElementoTabela> lst) throws RepositorioException {
            this.salvar(pNomeArquivoOuTabela, lst, this.dtFormat.format(new Date()));
        }

        public void salvar(String pNomeArquivoOuTabela, List<ElementoTabela> lst, String vigencia) throws RepositorioException {
            Document idsDOM = null;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            try {
                Element node;
                DocumentBuilder builder = factory.newDocumentBuilder();
                idsDOM = builder.newDocument();
                Element root = idsDOM.createElement("TABELA");
                idsDOM.appendChild(root);
                root.setAttribute("xmlns", ConstantesGlobais.XMLNS);
                String CRCCalculado = "0";
                for (int i = 0; i < lst.size(); ++i) {
                    node = idsDOM.createElement("ITEM");
                    root.appendChild(node);
                    ElementoTabela elementoTabela = lst.get(i);
                    for (int j = 1; j < elementoTabela.size() + 1; ++j) {
                        node.setAttribute("COL" + j, elementoTabela.getConteudo(j - 1));
                        CRCCalculado = UtilitariosString.GerarCRC((String)CRCCalculado, (String)elementoTabela.getConteudo(j - 1));
                    }
                }
                node = idsDOM.createElement("ITEM");
                root.appendChild(node);
                node.setAttribute("CRC", CRCCalculado);
                node.setAttribute("VIGENCIA", vigencia);
            }
            catch (Exception e) {
                LogPPGD.erro((String)e.getMessage());
            }
            idsDOM.normalize();
            try {
                System.setProperty("javax.xml.transform.TransformerFactory", "com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl");
                URL url = RepositorioTabelasBasicasXML.class.getResource("/" + pNomeArquivoOuTabela);
                File arquivoXML = new File(url.getPath());
                FileOutputStream os = new FileOutputStream(arquivoXML);
                StreamResult result = new StreamResult(os);
                DOMSource source = new DOMSource(idsDOM);
                TransformerFactory transFactory = TransformerFactory.newInstance();
                String XMLConstants_ACCESS_EXTERNAL_DTD = "http://javax.xml.XMLConstants/property/accessExternalDTD";
                String XMLConstants_ACCESS_EXTERNAL_STYLESHEET = "http://javax.xml.XMLConstants/property/accessExternalStylesheet";
                transFactory.setAttribute(XMLConstants_ACCESS_EXTERNAL_DTD, "");
                transFactory.setAttribute(XMLConstants_ACCESS_EXTERNAL_STYLESHEET, "");
                Transformer transformer = transFactory.newTransformer();
                transformer.setOutputProperty("indent", "yes");
                transformer.transform(source, result);
            }
            catch (Exception e) {
                LogPPGD.erro((String)e.getMessage());
            }
        }

        public String getCRC(String nomeArquivo) {
            return this.mapCRCs.get(nomeArquivo);
        }

        public String getVigencia(String nomeArquivo) {
            return this.mapVigencias.get(nomeArquivo);
        }
    }

    public static enum TabelasBasicas {
        Pais("PAIS", "Pais", new CarregarTabelaIF("resources/paises.xml"){

            @Override
            public void carregarTabela() {
                CadastroTabelasIRPF.carregarPaises();
            }
        }),
        Banco("BANCO", "Banco", new CarregarTabelaIF("resources/bancos.xml"){

            @Override
            public void carregarTabela() {
                CadastroTabelasIRPF.carregarBancos();
            }
        }),
        TipoConta("TIPOCONTA", "TipoConta", new CarregarTabelaIF("resources/tipoConta.xml"){

            @Override
            public void carregarTabela() {
                CadastroTabelasIRPF.carregarTipoConta();
            }
        }),
        BancoBens("BBENS", "Banco Bens", new CarregarTabelaIF("resources/bancos_bens.xml"){

            @Override
            public void carregarTabela() {
                CadastroTabelasIRPF.carregarBancosBens();
            }
        }),
        NaturezaOcupacao("NATOC", "Natureza da Ocupacao", new CarregarTabelaIF("resources/naturezasOcupacao.xml"){

            @Override
            public void carregarTabela() {
                CadastroTabelasIRPF.carregarNaturezaOcupacao();
            }
        }),
        ECA("ECA", "Estatuto da Crianca e Adolescente", new CarregarTabelaIF("resources/eca.xml"){

            @Override
            public void carregarTabela() {
                CadastroTabelasIRPF.carregarUFsECA();
            }
        }),
        Idoso("IDOSO", "Estatuto do Idoso", new CarregarTabelaIF("resources/eidoso.xml"){

            @Override
            public void carregarTabela() {
                CadastroTabelasIRPF.carregarUFsIdoso();
            }
        }),
        TipoPagamentosDoacoes("PGTOS", "Tipo de Pagamentos/Doa\u00e7\u00f5es", new CarregarTabelaIF("resources/tipoPagamentos.xml"){

            @Override
            public void carregarTabela() {
                CadastroTabelasIRPF.carregarTipoPagamentosDoacoes();
            }
        }),
        BensDireitos("BENSD", "Bens e Direitos", new CarregarTabelaIF("resources/tipoBens.xml"){

            @Override
            public void carregarTabela() {
                CadastroTabelasIRPF.carregarTiposBens();
            }
        }),
        DividasOnus("DIVID", "D\u00edvidas e \u00d4nus", new CarregarTabelaIF("resources/tipoDividas.xml"){

            @Override
            public void carregarTabela() {
                CadastroTabelasIRPF.carregarTipoDividas();
            }
        }),
        Dependencias("DEPEN", "Depend\u00eancias", new CarregarTabelaIF("resources/dependencias.xml"){

            @Override
            public void carregarTabela() {
                CadastroTabelasIRPF.carregarDependencias();
            }
        }),
        Ocupacoes("OCPRI", "Ocupa\u00e7\u00f5es", new CarregarTabelaIF("resources/ocupacoesPrincipal.xml"){

            @Override
            public void carregarTabela() {
                CadastroTabelasIRPF.recuperarOcupacoesPrincipal();
            }
        }),
        Aliquotas("AJUST", "Aliquotas", new CarregarTabelaIF("resources/aliquotas.xml"){

            @Override
            public void carregarTabela() {
                TabelaAliquotasIRPF.carregarAliquotas();
            }

            @Override
            public String getHash() {
                return TabelaAliquotasIRPF.getHash();
            }

            @Override
            public String getVersao() {
                return TabelaAliquotasIRPF.getVersao();
            }
        }),
        DatasIRPF("CFVAL", "Datas e Prazos do IRPF", new CarregarTabelaIF("resources/datasIrpf.xml"){

            @Override
            public void carregarTabela() {
                TabelaDatasIRPF.carregarDatas();
            }

            @Override
            public String getHash() {
                return TabelaDatasIRPF.getHash();
            }

            @Override
            public String getVersao() {
                return TabelaDatasIRPF.getVersao();
            }
        }),
        Links("LINKS", "Links do IRPF", new CarregarTabelaIF("resources/links.xml"){

            @Override
            public void carregarTabela() {
                CadastroTabelasIRPF.carregarTabelaLinks();
            }
        }),
        Mensagens("MSGS", "Mensagens do IRPF", new CarregarTabelaIF("resources/mensagens.xml"){

            @Override
            public void carregarTabela() {
                CadastroTabelasIRPF.carregarTabelaMensagens();
            }
        }),
        TipoRendimentos("RENDI", "TipoRendimentos", new CarregarTabelaIF("resources/tipoRendimentos.xml"){

            @Override
            public void carregarTabela() {
                CadastroTabelasIRPF.carregarTiposRendimentos();
            }
        }),
        MunicipiosCalamidade("MUNCL", "Municipios em Calamidade", new CarregarTabelaIF("resources/municipiosCalamidade.xml"){

            @Override
            public void carregarTabela() {
                CadastroTabelasIRPF.carregarMunicipiosCalamidade();
            }
        });

        private String identificador;
        private String descricao;
        private String hash;
        private String versao;
        private CarregarTabelaIF carregadorTabela;

        private TabelasBasicas(String identificador, String descricao, CarregarTabelaIF carregadorTabela) {
            this.descricao = descricao;
            this.identificador = identificador;
            this.carregadorTabela = carregadorTabela;
        }

        public String getIdentificador() {
            return this.identificador;
        }

        public String getDescricao() {
            return this.descricao;
        }

        public void carregarTabela() {
            this.carregadorTabela.carregarTabela();
            this.setHash(this.carregadorTabela.getHash());
            this.setVersao(this.carregadorTabela.getVersao());
        }

        public String getHash() {
            if (this.hash == null) {
                this.carregarTabela();
            }
            return this.hash;
        }

        public String getVersao() {
            if (this.versao == null) {
                this.carregarTabela();
            }
            return this.versao;
        }

        private void setHash(String hash) {
            this.hash = hash;
        }

        private void setVersao(String versao) {
            this.versao = versao;
        }

        public String getNomeArquivo() {
            return this.carregadorTabela.getNomeArquivo();
        }

        private static abstract class CarregarTabelaIF {
            public String nomeArquivo;

            public CarregarTabelaIF(String nomeArquivo) {
                this.nomeArquivo = nomeArquivo;
            }

            public abstract void carregarTabela();

            public String getHash() {
                return repositorioTabelasBasicas.getCRC(this.getNomeArquivo());
            }

            public String getVersao() {
                return repositorioTabelasBasicas.getVigencia(this.getNomeArquivo());
            }

            public String getNomeArquivo() {
                return this.nomeArquivo;
            }
        }
    }

    private static class TabelaDoacoesDireta {
        private String cnpjECANacional = null;
        private List<ElementoTabela> colecaoUFsECAEstadual = null;
        private List<ElementoTabela> colecaoUFsECAMunicipal = null;
        private Map<String, List<ElementoTabela>> mapaMunicipiosECA = null;

        private TabelaDoacoesDireta() {
        }
    }
}

