/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.tabelas;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import jupar.objects.Release;
import serpro.ppgd.irpf.tabelas.CadastroTabelasIRPF;
import serpro.ppgd.irpf.util.ZipHelper;
import serpro.ppgd.negocio.ElementoTabela;
import serpro.ppgd.negocio.util.LogPPGD;

public class VerificadorTabelasDominio {
    private static String DEFAULT_PATH_TABELAS = "lib" + File.separator + "resources";
    private Release ultimaVersao;
    private File tempDir;
    private File pastaBase;

    public VerificadorTabelasDominio(Release ultimaVersao, File tempDir, File pastaBase) {
        this.ultimaVersao = ultimaVersao;
        this.tempDir = tempDir;
        this.pastaBase = pastaBase;
    }

    public boolean validarTabelasBaixadas(Collection<String> filesIds) {
        System.out.println("pastaBase: " + this.pastaBase.getAbsolutePath());
        System.out.println("tempDir: " + this.tempDir.getAbsolutePath());
        boolean valido = true;
        String[] zipFilesNames = new String[filesIds.size()];
        String[] filesPaths = new String[filesIds.size()];
        int i = 0;
        for (String string : filesIds) {
            Release.FileInfo fileInfo = (Release.FileInfo)this.ultimaVersao.getFiles().get(string);
            if (fileInfo != null) {
                zipFilesNames[i] = fileInfo.getPackName();
                filesPaths[i] = fileInfo.getPath();
            }
            ++i;
        }
        File[] zipFiles = new File[zipFilesNames.length];
        System.out.println("montando nomes dos arquivos...");
        for (i = 0; i < zipFiles.length; ++i) {
            zipFiles[i] = new File(this.tempDir.getAbsolutePath() + File.separator + zipFilesNames[i]);
        }
        System.out.println("descompactando arquivos...");
        for (File zipFile : zipFiles) {
            try {
                ZipHelper zip = new ZipHelper();
                zip.unzip(zipFile, zipFile.getParentFile());
            }
            catch (Exception e) {
                valido = false;
            }
        }
        File[] fileArray = new File[zipFilesNames.length];
        File dirXMLs = new File(this.tempDir + File.separator + DEFAULT_PATH_TABELAS);
        File[] xmls = dirXMLs.listFiles();
        System.out.println("montando nomes dos arquivos que ser\u00e3o descompactados...");
        for (i = 0; i < xmls.length; ++i) {
            fileArray[i] = new File(dirXMLs.getAbsolutePath() + File.separator + xmls[i].getName());
        }
        String destDir = "temp" + new Date().getTime();
        File dirTeste = new File(this.pastaBase.getAbsolutePath() + File.separator + "lib" + File.separator + destDir);
        File[] fileDest = new File[fileArray.length];
        System.out.println("copiar xmls para diret\u00f3rio acess\u00edvel ao pgd...");
        if (dirTeste.mkdir()) {
            for (i = 0; i < fileArray.length; ++i) {
                fileDest[i] = new File(dirTeste.getAbsolutePath() + File.separator + fileArray[i].getName());
                try {
                    System.out.println("Copiando arquivo: " + fileDest[i].toPath());
                    Files.copy(fileArray[i].toPath(), fileDest[i].toPath(), new CopyOption[0]);
                    continue;
                }
                catch (IOException e) {
                    LogPPGD.erro((String)e.getMessage());
                }
            }
        }
        System.out.println("preencher cole\u00e7\u00f5es...");
        CadastroTabelasIRPF.RepositorioTabelasBasicasIRPF repositorioTabelasBasicas = new CadastroTabelasIRPF.RepositorioTabelasBasicasIRPF();
        List<ElementoTabela> colecao = null;
        for (i = 0; i < fileDest.length; ++i) {
            try {
                System.out.println("caminho da cole\u00e7\u00e3o: " + destDir + "/" + fileDest[i].getName());
                colecao = repositorioTabelasBasicas.recuperarObjetosTabela(destDir + "/" + fileDest[i].getName(), true);
                System.out.println("cole\u00e7\u00e3o " + fileDest[i].getName() + " preenchida");
                if (colecao.size() >= 2 && colecao.get(0).getConteudo(0) != null) continue;
                System.out.println("cole\u00e7\u00e3o " + fileDest[i].getName() + " com formato inv\u00e1lido");
                valido = false;
                break;
            }
            catch (Exception e1) {
                System.out.println("erro preenchendo cole\u00e7\u00e3o " + fileDest[i].getName());
            }
        }
        System.out.println("apagar arquivos xml copiados para o diret\u00f3rio tempor\u00e1rio de teste...");
        for (i = 0; i < fileDest.length; ++i) {
            try {
                Files.delete(fileDest[i].toPath());
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        System.out.println("apagar diret\u00f3rio tempor\u00e1rio de teste...");
        try {
            Files.delete(dirTeste.toPath());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return valido;
    }
}

