/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.util;

import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import serpro.ppgd.negocio.util.FabricaUtilitarios;

public class AplicacaoPropertiesUtil {
    private static Properties propriedadesApp = FabricaUtilitarios.getProperties();
    private static String nomeVersao;

    public static List<String> getFeriados() {
        return Arrays.asList(propriedadesApp.getProperty("feriados"));
    }

    public static String getTituloVersao() {
        if (nomeVersao == null) {
            StringBuilder lSb = new StringBuilder(10);
            lSb.append(AplicacaoPropertiesUtil.getNomeAplicacao());
            lSb.append(" ");
            lSb.append(AplicacaoPropertiesUtil.getExercicio());
            lSb.append(" - Vers\u00e3o ");
            lSb.append(AplicacaoPropertiesUtil.getVersao());
            if (AplicacaoPropertiesUtil.getFase() != null) {
                lSb.append(" ");
                lSb.append(AplicacaoPropertiesUtil.getFase());
                lSb.append(" ");
                lSb.append(AplicacaoPropertiesUtil.isBeta() ? "" : AplicacaoPropertiesUtil.getVersaoTeste());
            }
            nomeVersao = lSb.toString();
        }
        return nomeVersao;
    }

    public static String getVersaoSemTitulo() {
        String strVersao = null;
        if (strVersao == null) {
            StringBuilder lSb = new StringBuilder(10);
            lSb.append(AplicacaoPropertiesUtil.getVersao());
            if (AplicacaoPropertiesUtil.getFase() != null) {
                lSb.append("-");
                lSb.append(AplicacaoPropertiesUtil.isBeta() ? "" : AplicacaoPropertiesUtil.getVersaoTeste());
            }
            strVersao = lSb.toString();
        }
        return strVersao;
    }

    public static String getExercicio() {
        return propriedadesApp.getProperty("exercicio");
    }

    public static int getExercicioAsInt() {
        return Integer.parseInt(propriedadesApp.getProperty("exercicio"));
    }

    public static String getTitulo() {
        return propriedadesApp.getProperty("titulo");
    }

    public static String getNomeAplicacao() {
        return propriedadesApp.getProperty("nomeAplicacao");
    }

    public static String getVersao() {
        return propriedadesApp.getProperty("versao");
    }

    public static String getVersaoTeste() {
        return propriedadesApp.getProperty("versao_teste");
    }

    public static String getNomeAplicacaoPorExtenso() {
        return propriedadesApp.getProperty("nomeAplicacaoExtenso");
    }

    public static String getFase() {
        return AplicacaoPropertiesUtil.isTestes() ? "Testes" : (AplicacaoPropertiesUtil.isBeta() ? "Beta" : null);
    }

    public static boolean isTestes() {
        return Boolean.valueOf(propriedadesApp.getProperty("versao_testes"));
    }

    public static boolean isBeta() {
        return false;
    }

    public static String getSiteIRPF() {
        return propriedadesApp.getProperty("aplicacao.site.irpf");
    }

    public static String getSiteCorreiosBuscaCEP() {
        return propriedadesApp.getProperty("aplicacao.site.correios");
    }

    public static boolean isPronasPronon() {
        return Boolean.valueOf(propriedadesApp.getProperty("aplicacao.pronas.pronon"));
    }
}

