/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.util.calculos;

import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import serpro.ppgd.irpf.util.calculos.CampoInformacao;
import serpro.ppgd.irpf.util.calculos.DeclaracaoMultiExercicio;
import serpro.ppgd.irpf.util.calculos.FichaInformacao;
import serpro.ppgd.irpf.util.calculos.ListaFichaInformacao;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Observador;

public class MapeadorCalculos2 {
    final Map<String, ArrayList<String>> dependenciasMap = new HashMap<String, ArrayList<String>>();
    final Map<String, ArrayList<String>> dependentesMap = new HashMap<String, ArrayList<String>>();
    final Map<String, CampoInformacao> camposDependentesMap = new HashMap<String, CampoInformacao>();
    WeakReference<?> declaracaoWR = null;
    protected ArrayList<String> dependenciasAlteradas = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean mapearInstanciasFichas(Object ficha, String prefixo) throws MapeamentoDependenciasException {
        Class<?> classFicha = ficha.getClass();
        boolean ehFicha = classFicha.isAnnotationPresent(FichaInformacao.class);
        if (prefixo == null || prefixo.isEmpty() || !prefixo.contains(".")) {
            this.declaracaoWR = new WeakReference<Object>(ficha);
        }
        if (ehFicha) {
            Field[] fields;
            String idFicha = prefixo.replaceAll("\\[\\d*\\]", "");
            for (Field field : fields = this.getFields(classFicha)) {
                if (field.getName().startsWith("this$")) continue;
                String nomeCampo = prefixo + "." + field.getName();
                if (field.isAnnotationPresent(CampoInformacao.class)) {
                    String idInformacao = idFicha + "." + field.getName();
                    if (!this.dependenciasMap.containsKey(idInformacao) || this.dependentesMap.containsKey(idInformacao)) continue;
                    ObservadorDependenciaInformacao obs = new ObservadorDependenciaInformacao(nomeCampo);
                    try {
                        boolean accessible = field.isAccessible();
                        field.setAccessible(true);
                        try {
                            Object info = field.get(ficha);
                            if (!Informacao.class.isAssignableFrom(info.getClass())) continue;
                            ((Informacao)info).addObservador((Observador)obs);
                            continue;
                        }
                        finally {
                            field.setAccessible(accessible);
                        }
                    }
                    catch (Exception e) {
                        throw new MapeamentoDependenciasException("Ocorreu um erro ao acessar Informacao (" + nomeCampo + ")", e);
                    }
                }
                if (!field.getType().isAnnotationPresent(FichaInformacao.class)) continue;
                try {
                    Object filha;
                    boolean accessible = field.isAccessible();
                    field.setAccessible(true);
                    try {
                        filha = field.get(ficha);
                    }
                    finally {
                        field.setAccessible(accessible);
                    }
                    this.mapearInstanciasFichas(filha, nomeCampo);
                }
                catch (Exception e) {
                    throw new MapeamentoDependenciasException("Ocorreu um erro ao acessar Ficha (" + nomeCampo + ")", e);
                }
            }
            ListaFichaInformacao listaFichaInfo = classFicha.getAnnotation(ListaFichaInformacao.class);
            if (listaFichaInfo != null && listaFichaInfo.classeFicha().isAnnotationPresent(FichaInformacao.class)) {
                if (Colecao.class.isAssignableFrom(ficha.getClass())) {
                    ObservadorLista obs = new ObservadorLista(prefixo);
                    ((Colecao)ficha).addObservador((Observador)obs);
                }
                String nomeLista = listaFichaInfo.lista();
                List<?> listaItens = this.obterListaFichas(ficha, nomeLista);
                for (Object item : listaItens) {
                    String nomeCampo = prefixo + "._itens[" + item.hashCode() + "]";
                    this.mapearInstanciasFichas(item, nomeCampo);
                }
            }
            System.out.println("\t" + idFicha);
        }
        return ehFicha;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<?> obterListaFichas(Object ficha, String nomeLista) throws MapeamentoDependenciasException {
        List listaItens;
        block7: {
            Class<?> classFicha = ficha.getClass();
            try {
                if (!nomeLista.isEmpty()) {
                    Field field = this.getField(classFicha, nomeLista);
                    if (field != null) {
                        boolean accessible = field.isAccessible();
                        field.setAccessible(true);
                        try {
                            listaItens = (List)field.get(ficha);
                            break block7;
                        }
                        finally {
                            field.setAccessible(accessible);
                        }
                    }
                    Method m = classFicha.getMethod(nomeLista, new Class[0]);
                    listaItens = (List)m.invoke(ficha, new Object[0]);
                    break block7;
                }
                listaItens = (List)ficha;
            }
            catch (Exception e) {
                throw new MapeamentoDependenciasException("Ocorreu um erro ao acessar lista de Fichas (" + classFicha.getName() + "." + nomeLista + ")", e);
            }
        }
        return listaItens;
    }

    public Field[] getFields(Class<?> c) {
        Field[] thisFields = c.getDeclaredFields();
        if (c.getSuperclass() != null) {
            Field[] superClassFields = this.getFields(c.getSuperclass());
            Field[] allFields = new Field[superClassFields.length + thisFields.length];
            System.arraycopy(superClassFields, 0, allFields, 0, superClassFields.length);
            System.arraycopy(thisFields, 0, allFields, superClassFields.length, thisFields.length);
            return allFields;
        }
        return thisFields;
    }

    public Field getField(Class<?> c, String name) {
        try {
            return c.getDeclaredField(name);
        }
        catch (Exception e) {
            if (c.getSuperclass() != null) {
                return this.getField(c.getSuperclass(), name);
            }
            return null;
        }
    }

    public String nomeInfoPelaReferencia(String nomeCampo, String referencia) throws MapeamentoDependenciasException {
        Object nomeInfo = "";
        int lastIndex = nomeCampo.length();
        for (int i = 0; i < referencia.length() && referencia.startsWith(".", i); ++i) {
            if ((lastIndex = nomeCampo.lastIndexOf(".", lastIndex)) >= 0) {
                nomeInfo = nomeCampo.substring(0, lastIndex) + referencia.substring(i);
                --lastIndex;
                continue;
            }
            throw new MapeamentoDependenciasException("Identificacao de campo Informacao inconsistente: \"" + referencia + "\"");
        }
        return nomeInfo;
    }

    public String referenciaPeloNomeInfo(String nomeCampo, String nomeInfo) throws MapeamentoDependenciasException {
        String prefix;
        StringBuilder sbDependente = new StringBuilder();
        int lastIndex = nomeInfo.length();
        while ((lastIndex = nomeInfo.lastIndexOf(".", lastIndex)) >= 0 && !nomeCampo.startsWith(prefix = nomeInfo.substring(0, lastIndex))) {
            sbDependente.append(".");
            --lastIndex;
        }
        sbDependente.append(nomeCampo.substring(lastIndex));
        return sbDependente.toString();
    }

    public void mapearInformacoes(Class<?> classFicha, String prefixo) throws MapeamentoDependenciasException {
        String nomeCampo = null;
        FichaInformacao fichaInfo = classFicha.getAnnotation(FichaInformacao.class);
        if (fichaInfo != null) {
            Field[] fields;
            for (Field field : fields = this.getFields(classFicha)) {
                if (field.getName().startsWith("this$")) continue;
                nomeCampo = prefixo + "." + field.getName();
                CampoInformacao campoInfo = field.getAnnotation(CampoInformacao.class);
                if (campoInfo != null) {
                    String[] dependencias = campoInfo.dependencias();
                    if (dependencias.length <= 0) continue;
                    System.out.println("\nCampo Dependente: " + (String)nomeCampo);
                    String idDependente = nomeCampo.replaceAll("\\[N?\\]", "");
                    this.camposDependentesMap.put(idDependente, campoInfo);
                    for (String dependencia : dependencias) {
                        String nomeDependencia = this.nomeInfoPelaReferencia(nomeCampo, dependencia);
                        System.out.println("\t" + nomeDependencia);
                        ArrayList<String> listDependencias = this.dependentesMap.get(idDependente);
                        if (listDependencias == null) {
                            listDependencias = new ArrayList();
                            this.dependentesMap.put(idDependente, listDependencias);
                        }
                        listDependencias.add(dependencia.replaceAll("\\[N?\\]", ""));
                        String idDependencia = nomeDependencia.replaceAll("\\[N?\\]", "");
                        ArrayList<String> listDependentes = this.dependenciasMap.get(idDependencia);
                        if (listDependentes == null) {
                            listDependentes = new ArrayList();
                            this.dependenciasMap.put(idDependencia, listDependentes);
                        }
                        String dependente = this.referenciaPeloNomeInfo(nomeCampo, nomeDependencia);
                        dependente = dependente.replaceAll("\\[N?\\]", "");
                        listDependentes.add(dependente);
                    }
                    continue;
                }
                this.mapearInformacoes(field.getType(), nomeCampo);
            }
            ListaFichaInformacao listaFicha = classFicha.getAnnotation(ListaFichaInformacao.class);
            if (listaFicha != null) {
                nomeCampo = prefixo + "._itens[N]";
                this.mapearInformacoes(listaFicha.classeFicha(), nomeCampo);
            }
        }
    }

    public List<String> obterDependentes(List<String> dependencias) throws MapeamentoDependenciasException {
        ArrayList<String> listaDependentes = new ArrayList<String>();
        LinkedHashSet<String> mapaDependentes = new LinkedHashSet<String>();
        ArrayList<String> listaDependencias = new ArrayList<String>();
        listaDependencias.addAll(dependencias);
        for (int i = 0; !listaDependencias.isEmpty() && i < 20; ++i) {
            for (String dependencia : listaDependencias) {
                String idDependencia = dependencia.replaceAll("\\[\\d*\\]", "");
                ArrayList<String> refDependentes = this.dependenciasMap.get(idDependencia);
                if (refDependentes == null) continue;
                for (String refDependente : refDependentes) {
                    String dependente = this.nomeInfoPelaReferencia(dependencia, refDependente);
                    mapaDependentes.remove(dependente);
                    mapaDependentes.add(dependente);
                    listaDependentes.add(dependente);
                }
            }
            listaDependencias.clear();
            listaDependencias.addAll(listaDependentes);
            listaDependentes.clear();
        }
        if (!listaDependencias.isEmpty()) {
            throw new MapeamentoDependenciasException("Foi detectado uma referencia circular.");
        }
        listaDependentes.addAll(mapaDependentes);
        return listaDependentes;
    }

    public void executarMetodoAtualizacao(String dependente, Integer[] listaIdItens) throws MapeamentoDependenciasException {
        Objects.requireNonNull(dependente);
        Objects.requireNonNull(listaIdItens);
        String idDependente = dependente.replaceAll("\\[\\d*\\]", "");
        CampoInformacao campo = this.camposDependentesMap.get(idDependente);
        Object[] parametros = new Object[listaIdItens.length + 2];
        Class[] tipos = new Class[parametros.length];
        parametros[0] = this.declaracaoWR.get();
        parametros[1] = idDependente;
        tipos[0] = parametros[0].getClass();
        tipos[1] = parametros[1].getClass();
        int i = 2;
        int i_ = 0;
        while (i < parametros.length) {
            parametros[i] = listaIdItens[i_];
            tipos[i] = parametros[i].getClass();
            ++i;
            ++i_;
        }
        if (campo != null) {
            if (!campo.metodoAtualizacao().isEmpty()) {
                Method metodo;
                try {
                    metodo = campo.classeAtualizacao().getMethod(campo.metodoAtualizacao(), tipos);
                }
                catch (Exception e) {
                    throw new MapeamentoDependenciasException("Erro ao acessar metodo para atualizacao: " + campo.metodoAtualizacao(), e);
                }
                try {
                    metodo.invoke(null, parametros);
                }
                catch (Exception e) {
                    throw new MapeamentoDependenciasException("Erro ao executar metodo de atualizacao \"" + metodo.getName() + "\"", e);
                }
            }
        } else {
            throw new MapeamentoDependenciasException("Campo Informacao nao mapeado: " + dependente);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Integer[] obterIndicesItens(String informacao, Object instanciaFicha) throws MapeamentoDependenciasException {
        String[] fichas;
        Object fichaAtual = instanciaFicha;
        Object fichaAnterior = null;
        ArrayList<Integer> indices = new ArrayList<Integer>();
        for (String ficha : fichas = informacao.split("\\.")) {
            if (fichaAnterior != null) {
                if (ficha.startsWith("_itens[")) {
                    int hashCode;
                    ListaFichaInformacao listaFichaInfo = fichaAnterior.getClass().getAnnotation(ListaFichaInformacao.class);
                    if (listaFichaInfo == null) throw new MapeamentoDependenciasException("");
                    List<?> lista = this.obterListaFichas(fichaAnterior, listaFichaInfo.lista());
                    int indice = 0;
                    try {
                        hashCode = Integer.parseInt(ficha.replaceAll("(_itens\\[)|(\\])", ""));
                    }
                    catch (Exception e) {
                        throw new MapeamentoDependenciasException("", e);
                    }
                    for (Object item : lista) {
                        if (item.hashCode() == hashCode) {
                            indices.add(indice);
                            fichaAtual = item;
                            break;
                        }
                        ++indice;
                    }
                    if (indice >= lista.size()) {
                        throw new MapeamentoDependenciasException("Ficha com hash (" + hashCode + ") nao encontrada na lista " + ficha);
                    }
                } else {
                    Field field = this.getField(fichaAnterior.getClass(), ficha);
                    try {
                        boolean access = field.isAccessible();
                        field.setAccessible(true);
                        try {
                            fichaAtual = field.get(fichaAnterior);
                        }
                        finally {
                            field.setAccessible(access);
                        }
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        throw new MapeamentoDependenciasException("Erro ao acessar ficha:" + field.getName(), e);
                    }
                }
            }
            fichaAnterior = fichaAtual;
        }
        return indices.toArray(new Integer[indices.size()]);
    }

    protected void executarAtualizacoes(List<String> dependencias) throws MapeamentoDependenciasException {
        List<String> dependentes = this.obterDependentes(dependencias);
        for (String dependente : dependentes) {
            try {
                this.executarMetodoAtualizacao(dependente, this.obterIndicesItens(dependente, this.declaracaoWR.get()));
            }
            catch (MapeamentoDependenciasException e) {
                throw e;
            }
            catch (Exception e) {
                throw new MapeamentoDependenciasException("Erro ao executar atualizacao do campo:" + dependente);
            }
        }
    }

    public void informarAlteracao(String informacao) {
        this.dependenciasAlteradas.add(informacao);
    }

    public void executarAtualizacoes() throws MapeamentoDependenciasException {
        if (this.dependenciasAlteradas.isEmpty()) {
            // empty if block
        }
        this.executarAtualizacoes(this.dependenciasAlteradas);
        this.dependenciasAlteradas.clear();
    }

    public static void main_(String[] args) {
        try {
            System.out.println("dec._itens[824909230].rendPJ._itens[824909231].colecaoRendPJTitular._itens[824909232]._itens[824909233].rendRecebidoPJ".replaceAll("\\][^\\[\\]]+\\[", ",").replaceAll("^.+\\[", "").replaceAll("\\].+$", ""));
            Matcher m = Pattern.compile("\\[\\d+\\]").matcher("dec.ficha1.ficha2.campoA");
            while (m.find()) {
                String s = m.group().replaceAll("\\[|\\]", "");
                System.out.println(s);
            }
            System.out.println("_itens[824909230]".replaceAll("(_itens\\[)|(\\])", ""));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        MapeadorCalculos2 mapeamento = new MapeadorCalculos2();
        try {
            System.out.println("\n--- Teste - mapearInformacoes() -----------------------------------------------");
            mapeamento.mapearInformacoes(DeclaracaoMultiExercicio.class, "dec");
            System.out.println("\ndependentesMap:");
            System.out.println("\ndependenciasMap:");
            for (String dependencia : mapeamento.dependenciasMap.keySet()) {
                System.out.println("\tdependencia : " + dependencia);
                for (String dependente : mapeamento.dependenciasMap.get(dependencia)) {
                    System.out.println("\t\tdependente : " + dependente);
                }
            }
            DeclaracaoMultiExercicio dec = new DeclaracaoMultiExercicio();
            System.out.println("\n--- Teste - mapearInstanciasFichas() -----------------------------------------------");
            dec.getRendPJ().getColecaoRendPJTitular().itens().add(dec.new DeclaracaoMultiExercicio.DetalheRendPJ());
            System.out.println("Mapeando fichas:");
            mapeamento.mapearInstanciasFichas((Object)dec, "dec");
            System.out.println("\n--- Teste - mapearInstanciasFichas() -----------------------------------------------");
            dec.getRendPJ().getColecaoRendPJTitular().itens().add(dec.new DeclaracaoMultiExercicio.DetalheRendPJ());
            dec.getRendPJ().getColecaoRendPJDependente().itens().add(dec.new DeclaracaoMultiExercicio.DetalheRendPJ());
            System.out.println("\n\n--- Teste - obterDependentes()  -----------------------------------------");
            ArrayList<String> dependencias = new ArrayList<String>();
            dependencias.add("dec.rendPJ.colecaoRendPJTitular.niMaiorFontePagadora");
            System.out.println("Dependencias => ");
            for (int i = 0; i < dependencias.size(); ++i) {
                System.out.println("\t" + dependencias.get(i));
            }
            List<String> dependentes = mapeamento.obterDependentes(dependencias);
            dependencias = null;
            System.out.println("Dependentes => ");
            for (int i = 0; i < dependentes.size(); ++i) {
                System.out.println("\t" + dependentes.get(i));
            }
            dependentes = null;
            System.out.println("\n\n--- Teste - executarAtualizacoes()  -----------------------------------------");
            ((DeclaracaoMultiExercicio.DetalheRendPJ)((Object)dec.getRendPJ().getColecaoRendPJTitular().itens().get(0))).getRendRecebidoPJ().setConteudo("120000,00");
            ((DeclaracaoMultiExercicio.DetalheRendPJ)((Object)dec.getRendPJ().getColecaoRendPJDependente().itens().get(0))).getRendRecebidoPJ().setConteudo("70000,00");
            ((DeclaracaoMultiExercicio.DetalheRendPJ)((Object)dec.getRendPJ().getColecaoRendPJTitular().itens().get(1))).getNIFontePagadora().setConteudo("00000000000191");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public class MapeamentoDependenciasException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public MapeamentoDependenciasException(String arg0, Throwable arg1) {
            super(arg0, arg1);
        }

        public MapeamentoDependenciasException(String arg0) {
            super(arg0);
        }
    }

    public class ObservadorDependenciaInformacao
    extends Observador {
        String campoInformacao;

        public ObservadorDependenciaInformacao(String campoInformacao) {
            this.campoInformacao = campoInformacao;
        }

        public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
            MapeadorCalculos2.this.informarAlteracao(this.campoInformacao);
            try {
                MapeadorCalculos2.this.executarAtualizacoes();
            }
            catch (MapeamentoDependenciasException e) {
                e.printStackTrace();
            }
        }
    }

    public class ObservadorLista
    extends Observador {
        String prefixo;

        public ObservadorLista(String prefixo) {
            this.prefixo = prefixo;
        }

        public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
            try {
                if ("ObjetoInserido".equals(nomePropriedade)) {
                    String nomeCampo = this.prefixo + "._itens[" + valorNovo.hashCode() + "]";
                    System.out.println("Mapeando fichas:");
                    MapeadorCalculos2.this.mapearInstanciasFichas(valorNovo, nomeCampo);
                    MapeadorCalculos2.this.informarAlteracao("_quantidadeItensLista");
                    MapeadorCalculos2.this.executarAtualizacoes();
                } else if ("ObjetoRemovido".equals(nomePropriedade)) {
                    MapeadorCalculos2.this.informarAlteracao("_quantidadeItensLista");
                    MapeadorCalculos2.this.executarAtualizacoes();
                }
            }
            catch (MapeamentoDependenciasException e) {
                e.printStackTrace();
            }
        }
    }
}

