/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.bens;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import serpro.ppgd.gui.xbeans.GroupPanelEvent;
import serpro.ppgd.gui.xbeans.GroupPanelListener;
import serpro.ppgd.gui.xbeans.JButtonGroupPanel;
import serpro.ppgd.gui.xbeans.JButtonMensagem;
import serpro.ppgd.gui.xbeans.JEditAlfa;
import serpro.ppgd.gui.xbeans.JEditData;
import serpro.ppgd.gui.xbeans.JEditMascara;
import serpro.ppgd.gui.xbeans.JEditMemo;
import serpro.ppgd.gui.xbeans.JEditNI;
import serpro.ppgd.gui.xbeans.JEditValor;
import serpro.ppgd.gui.xbeans.JFlipComponentes;
import serpro.ppgd.gui.xbeans.PPGDRadioItem;
import serpro.ppgd.gui.xbeans.autocomplete.JAutoCompleteComboBox;
import serpro.ppgd.gui.xbeans.autocomplete.JAutoCompleteEditCPF;
import serpro.ppgd.gui.xbeans.autocomplete.JAutoCompleteEditCodigo;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.infraestrutura.util.FontesUtil;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.bens.Bem;
import serpro.ppgd.irpf.dependentes.Dependentes;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.IRPFLabelInfo;
import serpro.ppgd.irpf.gui.NavegacaoIf;
import serpro.ppgd.irpf.gui.PainelDemonstrativoAb;
import serpro.ppgd.irpf.gui.PainelDemonstrativoIf;
import serpro.ppgd.irpf.gui.TransferFocus;
import serpro.ppgd.irpf.gui.bens.PainelBensDetalheEspolioBrasil;
import serpro.ppgd.irpf.gui.bens.PainelBensDetalheEspolioExterior;
import serpro.ppgd.irpf.gui.bens.PainelQuadroAuxiliarProprietariosUsufrutuariosLista;
import serpro.ppgd.irpf.gui.bens.PainelSelecaoCodigoBem;
import serpro.ppgd.irpf.gui.bens.PainelSelecaoGrupoCodigoBem;
import serpro.ppgd.irpf.gui.componente.JHTMLPane;
import serpro.ppgd.irpf.gui.componente.JTaskAction;
import serpro.ppgd.irpf.gui.dialogs.PainelHtmlText;
import serpro.ppgd.irpf.gui.rendIsentos.PainelAbaRendIsentosDetalhes;
import serpro.ppgd.irpf.gui.rendIsentos.PainelDadosRendIsentos;
import serpro.ppgd.irpf.gui.rendTributacaoExclusiva.PainelAbaRendTributEclusivaDetalhes;
import serpro.ppgd.irpf.gui.rendTributacaoExclusiva.PainelDadosRendTributExclusiva;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.irpf.rendIsentos.ItemQuadroAuxiliarAb;
import serpro.ppgd.irpf.rendIsentos.RendIsentos;
import serpro.ppgd.irpf.resumo.CalculoImposto;
import serpro.ppgd.irpf.tabelas.CadastroTabelasIRPF;
import serpro.ppgd.irpf.tabelas.CodigoTabelaMensagens;
import serpro.ppgd.irpf.util.IRPFUtil;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.ElementoTabela;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;

public class PainelBensDetalhe
extends PainelDemonstrativoAb {
    private static final long serialVersionUID = 1L;
    private static final String TITULO = "Bens e Direitos";
    private static final String HELP_ID = "Fichas da Declara\u00e7\u00e3o/Bens e Direitos";
    private Bem bem = null;
    private Bem itemInicial = null;
    private Integer tipoCEF = null;
    private final PainelBensDetalheEspolioBrasil painelImovelBrasil = new PainelBensDetalheEspolioBrasil();
    private final PainelBensDetalheEspolioExterior painelImovelExterior = new PainelBensDetalheEspolioExterior();
    private ActionListener listenerPais = null;
    private ActionListener listenerGrupo = null;
    private ActionListener listenerCodigo = null;
    private boolean emEdicao;
    private int indiceRollback = -1;
    private JButton btProprietarioUsufrutuario;
    private JButton btnReclassificar;
    private JButton btnRendExclusivo;
    private JButton btnRendIsento;
    private JButton btnRepetir;
    private JCheckBox chkAtualizacaoValorBem;
    private JCheckBox chkBemComUsufruto;
    private JCheckBox chkContaPagamento;
    private JAutoCompleteEditCPF cmbDependente;
    private JEditMascara edtAgencia;
    private JEditValor edtAreaTotal;
    private JEditAlfa edtBairro;
    private JAutoCompleteEditCodigo edtBanco;
    private JEditAlfa edtCodNegociacao;
    private JAutoCompleteEditCodigo edtCodigoBem;
    private JAutoCompleteEditCodigo edtCodigoCripto;
    private JEditAlfa edtComplemento;
    private JEditMascara edtConta;
    private JEditAlfa edtDV;
    private JEditData edtDataAquisicao;
    private JEditMemo edtDiscriminacao;
    private JAutoCompleteEditCodigo edtGrupo;
    private JEditValor edtImpostoExteriorIRRF;
    private JEditValor edtImpostoPagoExt;
    private JAutoCompleteEditCodigo edtLocalizacao;
    private JEditAlfa edtLogradouro;
    private JEditValor edtLucroPrejuizo;
    private JEditAlfa edtMatriculaImovel;
    private JButtonGroupPanel edtNegociadoBolsa;
    private JEditNI edtNiBem;
    private JEditAlfa edtNomeCartorio;
    private JEditAlfa edtNumero;
    private JEditMascara edtNumeroRegistroBem;
    private JButtonGroupPanel edtRegistroCartorio;
    private JButtonGroupPanel edtUnidade;
    private JEditValor edtValorAnterior;
    private JEditValor edtValorAtual;
    private JEditValor edtValorRecebido;
    private JFlipComponentes flpLocalizacao;
    private JButtonGroupPanel grpAutoCustodiante;
    private JButtonGroupPanel grpProprietarioUsufrutuario;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JLabel lbRepetir;
    private JLabel lbSituacaoAnoAnterior;
    private JLabel lbSituacaoAnoAtual;
    private JLabel lblAgencia;
    private JLabel lblAreaTotal;
    private JLabel lblAutoCustodiante;
    private JLabel lblBairro;
    private JLabel lblBanco;
    private JLabel lblCodCripto;
    private JLabel lblCodNegociacao;
    private JLabel lblComplemento;
    private JLabel lblConta;
    private JLabel lblDV;
    private JLabel lblDataAquisicao;
    private JLabel lblDependente;
    private JLabel lblImpostoExteriorIRRF;
    private JLabel lblImpostoPagoExt;
    private IRPFLabelInfo lblInfo;
    private IRPFLabelInfo lblInfoIPTU;
    private JLabel lblLogradouro;
    private JLabel lblLucroPrejuizo;
    private JLabel lblMatricula;
    private JLabel lblMsgDepositoRemunerado;
    private JLabel lblNegociacao;
    private JLabel lblNiBem;
    private JLabel lblNomeCartorio;
    private JLabel lblNumero;
    private JLabel lblNumeroRegistroBem;
    private JLabel lblProprietarioUsufrutuario;
    private JLabel lblRegistrado;
    private JLabel lblTipo;
    private JLabel lblUnidade;
    private JLabel lblValorRecebido;
    private JButtonMensagem msgNegociadoBolsa;
    private JButtonMensagem msgRegistrado;
    private JButtonMensagem msgUnidade;
    private JPanel pnlAplicacaoFinanceira;
    private JPanel pnlBeneficiario;
    private JPanel pnlDadosBancarios;
    private JPanel pnlDadosBemImovel;
    private JPanel pnlLucrosDividendos;
    private JPanel pnlNegociacaoBolsa;
    private JPanel pnlRendimentos;
    private PPGDRadioItem rdbAutoCustodianteNao;
    private PPGDRadioItem rdbAutoCustodianteSim;
    private PPGDRadioItem rdbDependente;
    private PPGDRadioItem rdbProprietario;
    private PPGDRadioItem rdbTitular;
    private PPGDRadioItem rdbUsufrutuario;
    private PPGDRadioItem rdoNegociadoBolsaNao;
    private PPGDRadioItem rdoNegociadoBolsaSim;
    private PPGDRadioItem rdoRegistroCartorioNao;
    private PPGDRadioItem rdoRegistroCartorioSim;
    private PPGDRadioItem rdoUnidadeHa;
    private PPGDRadioItem rdoUnidadeM2;
    private JButtonGroupPanel tipoGroup;

    public PainelBensDetalhe() {
        PlataformaPPGD.getPlataforma().setHelpID((JComponent)((Object)this), HELP_ID);
        this.initComponents();
        JHTMLPane pane = new JHTMLPane("<html><body style=\"background-color: white; width: 400px;\">" + CadastroTabelasIRPF.recuperarMensagemHTML((CodigoTabelaMensagens)CodigoTabelaMensagens.CODIGO_00518) + "</body></html>");
        pane.setOpaque(false);
        this.addListenerLei14754(this.edtLucroPrejuizo, CodigoTabelaMensagens.CODIGO_00520);
        this.addListenerLei14754(this.edtImpostoPagoExt, CodigoTabelaMensagens.CODIGO_00521);
        this.addListenerLei14754(this.edtValorRecebido, CodigoTabelaMensagens.CODIGO_00522);
        this.addListenerLei14754(this.edtImpostoExteriorIRRF, CodigoTabelaMensagens.CODIGO_00523);
    }

    public PainelBensDetalhe(Bem bem, boolean emEdicao) {
        this();
        this.bem = bem;
        this.emEdicao = emEdicao;
        if (emEdicao) {
            this.itemInicial = bem.obterCopia();
        }
        PPGDRadioItem radioVazio = new PPGDRadioItem();
        radioVazio.setText("Vazio");
        radioVazio.setValorSelecionadoTrue("");
        this.tipoGroup.adicionaOpcao((Component)radioVazio);
        this.associarInformacao(bem);
        this.painelImovelBrasil.associarInformacao(bem);
        this.painelImovelExterior.associaInformacao(bem);
        TransferFocus.patch((Component)this.edtDiscriminacao.getComponenteFoco());
        this.habilitarPainelBemImovel(bem.getGrupo().naoFormatado(), bem.getCodigo().naoFormatado(), this.getBem().getPais().naoFormatado());
        this.alteraPainelLocalizacaoBemImovel(bem.getGrupo().naoFormatado(), bem.getCodigo().naoFormatado(), bem.getPais().naoFormatado());
        this.habilitarPainelBeneficiario(bem.getGrupo().naoFormatado(), bem.getCodigo().naoFormatado());
        this.habilitarCamposCriptoativos(bem.getGrupo().naoFormatado(), bem.getCodigo().naoFormatado());
        this.habilitarPaineisAplicacaoFinanceiraLucrosDividendos(bem.getGrupo().naoFormatado(), bem.getCodigo().naoFormatado(), bem.getPais().naoFormatado());
        this.configurarComboGrupo();
        this.configurarComboCodigo();
        this.configurarComboPais();
        final JComboBox j = (JComboBox)this.edtBanco.getComponenteEditor();
        j.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (j.getSelectedItem() != null) {
                    PainelBensDetalhe.this.configurarExibicaoInfoConta();
                }
            }
        });
        this.atualizaGui(this.getBem().getGrupo().naoFormatado(), this.getBem().getCodigo().naoFormatado(), this.getBem().getTipo().naoFormatado());
        final Codigo banco = bem.getBanco();
        banco.addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                if (nomePropriedade.equals("Banco")) {
                    PainelBensDetalhe.this.configuraNumeroCaracteresDV(banco.naoFormatado());
                    PainelBensDetalhe.this.configurarContaCorrente(banco);
                    PainelBensDetalhe.this.configurarExibicaoInfoConta();
                }
            }
        });
        this.configurarContaCorrente(banco);
        this.configuraNumeroCaracteresDV(banco.naoFormatado());
        this.configurarExibicaoInfoConta();
        this.habilitarBotoesRendimento(this.getBem().getGrupo().naoFormatado(), this.getBem().getCodigo().naoFormatado());
        this.habilitarRadioProprietarioUsufrutuario();
        this.atualizarComboPais(this.getBem().getGrupo().naoFormatado(), this.getBem().getCodigo().naoFormatado());
        this.configurarMensagemReservaRemunerada(this.getBem().getGrupo().naoFormatado(), this.getBem().getCodigo().naoFormatado(), this.getBem().getPais().naoFormatado());
        this.edtUnidade.setButtonMensagem(this.msgUnidade);
        this.edtRegistroCartorio.setButtonMensagem(this.msgRegistrado);
        this.chkBemComUsufruto.setVisible(false);
        this.lblProprietarioUsufrutuario.setVisible(false);
        this.grpProprietarioUsufrutuario.setVisible(false);
        this.btProprietarioUsufrutuario.setVisible(false);
    }

    private void addListenerLei14754(JEditValor campoValor, final CodigoTabelaMensagens codigo) {
        campoValor.getComponenteEditor().addFocusListener(new FocusAdapter(){
            private boolean flag = true;

            @Override
            public void focusGained(FocusEvent e) {
                if (this.flag) {
                    new Thread(){

                        @Override
                        public void run() {
                            GuiUtil.exibeDialog((JComponent)new PainelHtmlText(CadastroTabelasIRPF.recuperarMensagem((CodigoTabelaMensagens)codigo)), (boolean)true, (String)"Aviso", (boolean)false);
                        }
                    }.start();
                }
                this.flag = !this.flag;
            }
        });
    }

    private void exibirMensagem524ou525(final String grupo, final String pais) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!(grupo == null || pais == null || "105".equals(pais) || "".equals(pais.trim()) || PainelBensDetalhe.this.bem.isBemApenasBrasil(grupo, PainelBensDetalhe.this.bem.getCodigo().naoFormatado()))) {
                    if ("01".equals(grupo) || "02".equals(grupo) || "04".equals(grupo) || "05".equals(grupo) || "06".equals(grupo) || "08".equals(grupo) || "99".equals(grupo)) {
                        GuiUtil.exibeDialog((JComponent)new PainelHtmlText(CadastroTabelasIRPF.recuperarMensagem((CodigoTabelaMensagens)CodigoTabelaMensagens.CODIGO_00524)), (boolean)true, (String)"Aviso", (boolean)false);
                    } else if ("03".equals(grupo) || "07".equals(grupo)) {
                        String msg525 = CadastroTabelasIRPF.recuperarMensagem((CodigoTabelaMensagens)CodigoTabelaMensagens.CODIGO_00525);
                        if ("Aviso 1".equals(msg525)) {
                            msg525 = "&lt;b&gt;Aten\u00e7\u00e3o 1&lt;/b&gt;: Dever\u00e3o ser observadas as determina\u00e7\u00f5es dos arts. 5\u00ba a 9\u00ba da Lei n\u00ba 14.754, de 2023, e dos arts. 13 a 40 da Instru\u00e7\u00e3o Normativa RFB n\u00ba 2.180, de 2024 no caso de investimentos em pessoas jur\u00eddicas ou outras entidades no exterior nas quais o contribuinte detenha o controle (por exemplo, participa\u00e7\u00e3o acima de 50%) e tais investidas:&lt;/p&gt;&lt;ul style='list-style-type:none'&gt;&lt;li&gt;(i) estejam localizadas em pa\u00eds com tributa\u00e7\u00e3o favorecida ou sejam benefici\u00e1rias de regime fiscal privilegiado; ou&lt;/li&gt;&lt;li&gt;(ii) apurem renda ativa pr\u00f3pria inferior a 60% da renda total, ainda que n\u00e3o estejam em tais localiza\u00e7\u00f5es ou n\u00e3o sejam benefici\u00e1rias de tais regimes.&lt;/li&gt;&lt;/ul&gt;&lt;b&gt;Aten\u00e7\u00e3o 2&lt;/b&gt;: As participa\u00e7\u00f5es em controladas no exterior que sejam controladas indiretas e estejam sujeitas ao regime de tributa\u00e7\u00e3o autom\u00e1tica previsto na Lei n\u00ba 14.754, de 2023, dever\u00e3o ser inclu\u00eddas como &quot;bem e direto&quot;.&lt;br&gt;&lt;br&gt;&lt;b&gt;Aten\u00e7\u00e3o 3&lt;/b&gt;: Nos casos referidos acima, devem ser informadas no campo &quot;Discrimina\u00e7\u00e3o&quot; as informa\u00e7\u00f5es relevantes do investimento no exterior para fins de aplica\u00e7\u00e3o da referida Lei, incluindo:&lt;ul style='list-style-type:none'&gt;&lt;li&gt;(i)\tpercentual de participa\u00e7\u00e3o na investida e se \u00e9 uma controlada direta ou indireta;&lt;/li&gt;&lt;li&gt;(ii)\tindicar se \u00e9 uma controlada indireta, detida por meio de uma controlada direta sujeita ao regime de transpar\u00eancia fiscal previsto nos arts. 36 a 49 da IN RFB 2.180, de 2023, ou detida por meio de um trust no exterior;&lt;/li&gt;&lt;li&gt;(iii)\to percentual de renda ativa, caso a investida n\u00e3o esteja localizada em pa\u00eds com tributa\u00e7\u00e3o favorecida, ou seja, benefici\u00e1ria de regime fiscal privilegiado;&lt;/li&gt;&lt;li&gt;(iv)\tdata de aquisi\u00e7\u00e3o;&lt;/li&gt;&lt;li&gt;(v)\to valor dos lucros ou preju\u00edzos acumulados registrados na contabilidade e apurados at\u00e9 31/12/2023;&lt;/li&gt;&lt;li&gt;(vi)\to valor dos lucros distribu\u00eddos no ano-calend\u00e1rio para o contribuinte, se houver, e indicar se correspondem ou n\u00e3o a lucros acumulados registrados na contabilidade e apurados at\u00e9 31/12/2023;&lt;/li&gt;&lt;li&gt;(vii)\to valor dos lucros recebidos pela investida de outras controladas no ano-calend\u00e1rio, se houver, indicando a raz\u00e3o social da controlada e sua localiza\u00e7\u00e3o;&lt;/li&gt;&lt;li&gt;(viii)\to valor do preju\u00edzo apurado no ano-calend\u00e1rio pela investida, se for o caso;&lt;/li&gt;&lt;li&gt;(ix)\tinformar se a investida foi submetida ou n\u00e3o ao regime de atualiza\u00e7\u00e3o previsto no art. 50 da IN RFB n\u00ba 2.180, de 2023;&lt;/li&gt;&lt;li&gt;(x)\tinformar o valor dos saldos registrados em 31 de dezembro de 2024 na conta de &quot;resultados abrangentes&quot;, fora do resultado do exerc\u00edcio. Destaca-se que o registro de valores em &quot;resultados abrangentes&quot; poder\u00e1 ser posteriormente sujeito \u00e0 fiscaliza\u00e7\u00e3o com especial rigor.&lt;/li&gt;&lt;/ul&gt;&lt;a HREF='https://www.gov.br/fazenda/pt-br/acesso-a-informacao/perguntas-frequentes/tributacao-offshore/29-4-24-perguntas-e-respostas-offshores-lei-14-754-e-in-rfb-2-180.pdf'&gt;Clique aqui&lt;/a&gt; para mais informa\u00e7\u00f5es";
                        }
                        GuiUtil.exibeDialog((JComponent)new PainelHtmlText(msg525, 800, 400), (boolean)true, (String)"Aviso", (boolean)false);
                    }
                }
            }
        });
    }

    private void trocaPais(String pais) {
        this.habilitarCamposCriptoativos(this.getBem().getGrupo().naoFormatado(), this.getBem().getCodigo().naoFormatado());
        this.habilitarBotoesRendimento(this.getBem().getGrupo().naoFormatado(), this.getBem().getCodigo().naoFormatado());
        this.alteraPainelLocalizacaoBemImovel(this.getBem().getGrupo().naoFormatado(), this.getBem().getCodigo().naoFormatado(), pais);
        this.habilitarPainelBemImovel(this.getBem().getGrupo().naoFormatado(), this.getBem().getCodigo().naoFormatado(), pais);
        this.habilitarPainelRegistroBem(this.getBem().getGrupo().naoFormatado(), this.getBem().getCodigo().naoFormatado(), pais);
        this.habilitarCampoNI(this.getBem().getGrupo().naoFormatado(), this.getBem().getCodigo().naoFormatado(), pais, this.getBem().getIndicadorAutoCustodiante().naoFormatado());
        this.habilitarPainelBeneficiario(this.getBem().getGrupo().naoFormatado(), this.getBem().getCodigo().naoFormatado());
        this.habilitarCampoBanco(pais, this.getBem().getGrupo().naoFormatado(), this.getBem().getCodigo().naoFormatado());
        this.habilitarPaineisAplicacaoFinanceiraLucrosDividendos(this.getBem().getGrupo().naoFormatado(), this.getBem().getCodigo().naoFormatado(), pais);
        this.configurarExibicaoInfoConta();
        if (!"105".equals(this.getBem().getPais().naoFormatado()) && !this.getBem().getIndicadorReclassificar().naoFormatado().equals("1")) {
            this.edtNumeroRegistroBem.setConteudo("");
            this.edtNiBem.setConteudo("");
        }
        this.configurarMensagemReservaRemunerada(this.getBem().getGrupo().naoFormatado(), this.getBem().getCodigo().naoFormatado(), pais);
    }

    public void atualizarCodigoBem(String codBem) {
        this.atualizarComboPais(this.getBem().getGrupo().naoFormatado(), codBem);
        this.habilitarCamposCriptoativos(this.getBem().getGrupo().naoFormatado(), codBem);
        this.verificarLimparNI(codBem);
        this.habilitarPainelBemImovel(this.getBem().getGrupo().naoFormatado(), codBem, this.getBem().getPais().naoFormatado());
        this.alteraPainelLocalizacaoBemImovel(this.getBem().getGrupo().naoFormatado(), codBem, this.getBem().getPais().naoFormatado());
        this.habilitarPainelRegistroBem(this.getBem().getGrupo().naoFormatado(), codBem, this.getBem().getPais().naoFormatado());
        this.habilitarCampoDataAquisicao(this.getBem().getGrupo().naoFormatado(), codBem);
        this.habilitarCampoNI(this.getBem().getGrupo().naoFormatado(), codBem, this.getBem().getPais().naoFormatado(), this.getBem().getIndicadorAutoCustodiante().naoFormatado());
        this.habilitarPainelDadosBancarios(this.getBem().getGrupo().naoFormatado(), codBem);
        this.habilitarPainelBeneficiario(this.getBem().getGrupo().naoFormatado(), codBem);
        this.habilitarPainelNegociacao(this.getBem().getGrupo().naoFormatado(), codBem);
        this.habilitarPaineisAplicacaoFinanceiraLucrosDividendos(this.getBem().getGrupo().naoFormatado(), codBem, this.getBem().getPais().naoFormatado());
        this.edtNumeroRegistroBem.setConteudo("");
        this.edtCodigoCripto.setConteudo("");
        JAutoCompleteComboBox editorBanco = (JAutoCompleteComboBox)this.edtBanco.getComponenteEditor();
        editorBanco.clearSelection();
        this.habilitarBotoesRendimento(this.getBem().getGrupo().naoFormatado(), codBem);
        this.confirmarReclassificacao(codBem);
        this.configurarMensagemReservaRemunerada(this.getBem().getGrupo().naoFormatado(), codBem, this.getBem().getPais().naoFormatado());
    }

    private void verificarLimparNI(String codBem) {
        boolean localizacaoBrasil = this.getBem().getPais().naoFormatado().equals("105");
        this.getBem();
        if (!Bem.isBemComNI((String)this.getBem().getGrupo().naoFormatado(), (String)codBem, (boolean)localizacaoBrasil, (String)this.getBem().getIndicadorAutoCustodiante().naoFormatado()) && !"-1".equals(codBem)) {
            this.edtNiBem.setConteudo("");
        }
    }

    private void configurarComboGrupo() {
        this.listenerCodigo = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JComboBox comboGrupo = (JComboBox)PainelBensDetalhe.this.edtGrupo.getComponenteEditor();
                String grupoCombo = "";
                if (comboGrupo.getSelectedIndex() != -1) {
                    grupoCombo = ((ElementoTabela)comboGrupo.getSelectedItem()).getConteudo(0);
                }
                String grupoNegocio = PainelBensDetalhe.this.getBem().getGrupo().naoFormatado();
                boolean rollback = false;
                if (!grupoCombo.equals(grupoNegocio)) {
                    PainelBensDetalhe.this.exibirMensagem524ou525(grupoCombo, PainelBensDetalhe.this.bem.getPais().naoFormatado());
                    if (!PainelBensDetalhe.this.bem.processarTrocaGrupoCodigoPais(grupoNegocio, "Grupo")) {
                        int indice = -1;
                        rollback = true;
                        for (ElementoTabela elemento : PainelBensDetalhe.this.bem.getGrupo().getColecaoElementoTabela()) {
                            ++indice;
                            if (!elemento.getConteudo(0).equals(grupoNegocio)) continue;
                            PainelBensDetalhe.this.indiceRollback = indice;
                            break;
                        }
                        comboGrupo.removeActionListener(PainelBensDetalhe.this.listenerGrupo);
                        comboGrupo.setSelectedIndex(PainelBensDetalhe.this.indiceRollback);
                        comboGrupo.addActionListener(PainelBensDetalhe.this.listenerGrupo);
                    }
                    if (!rollback) {
                        if (comboGrupo.getSelectedIndex() == -1) {
                            PainelBensDetalhe.this.getBem().getGrupo().clear();
                        } else {
                            PainelBensDetalhe.this.getBem().getGrupo().setConteudo(((ElementoTabela)comboGrupo.getSelectedItem()).getConteudo(0));
                        }
                        ((JComboBox)PainelBensDetalhe.this.edtCodigoBem.getComponenteEditor()).removeActionListener(PainelBensDetalhe.this.listenerCodigo);
                        ((JComboBox)PainelBensDetalhe.this.edtCodigoBem.getComponenteEditor()).setSelectedIndex(-1);
                        ((JComboBox)PainelBensDetalhe.this.edtCodigoBem.getComponenteEditor()).addActionListener(PainelBensDetalhe.this.listenerCodigo);
                        PainelBensDetalhe.this.getBem().getCodigo().clear();
                        PainelBensDetalhe.this.atualizarCodigoBem("-1");
                    }
                }
            }
        };
        ((JComboBox)this.edtGrupo.getComponenteEditor()).addActionListener(this.listenerCodigo);
    }

    private void configurarComboCodigo() {
        this.listenerCodigo = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String codigoNegocio;
                JComboBox comboCodigo = (JComboBox)PainelBensDetalhe.this.edtCodigoBem.getComponenteEditor();
                String codigoCombo = "";
                if (comboCodigo.getSelectedIndex() != -1) {
                    codigoCombo = ((ElementoTabela)comboCodigo.getSelectedItem()).getConteudo(0);
                }
                if (!codigoCombo.equals(codigoNegocio = PainelBensDetalhe.this.getBem().getCodigo().naoFormatado())) {
                    if (!PainelBensDetalhe.this.bem.processarTrocaGrupoCodigoPais(codigoNegocio, "C\u00f3digo")) {
                        int indice = -1;
                        for (ElementoTabela elemento : PainelBensDetalhe.this.bem.getCodigo().getColecaoElementoTabela()) {
                            ++indice;
                            if (!elemento.getConteudo(0).equals(codigoNegocio)) continue;
                            PainelBensDetalhe.this.indiceRollback = indice;
                            break;
                        }
                        comboCodigo.removeActionListener(PainelBensDetalhe.this.listenerCodigo);
                        comboCodigo.setSelectedIndex(PainelBensDetalhe.this.indiceRollback);
                        comboCodigo.addActionListener(PainelBensDetalhe.this.listenerCodigo);
                    }
                    if (comboCodigo.getSelectedItem() == null) {
                        PainelBensDetalhe.this.atualizarCodigoBem("-1");
                    } else {
                        PainelBensDetalhe.this.atualizarCodigoBem(((ElementoTabela)comboCodigo.getSelectedItem()).getConteudo(0));
                    }
                }
            }
        };
        ((JComboBox)this.edtCodigoBem.getComponenteEditor()).addActionListener(this.listenerCodigo);
    }

    private void atualizarComboPais(String grupo, String codigo) {
        String paisSelecionado = null;
        boolean soExterior = false;
        if (((JComboBox)this.edtLocalizacao.getComponenteFoco()).getSelectedIndex() != -1) {
            paisSelecionado = ((ElementoTabela)((JComboBox)this.edtLocalizacao.getComponenteFoco()).getSelectedItem()).getConteudo(0);
        }
        if (this.bem.isBemApenasBrasil(grupo, codigo)) {
            this.bem.getPais().setColecaoElementoTabela(CadastroTabelasIRPF.recuperarPaises());
            ElementoTabela elementoSelecionado = (ElementoTabela)((JComboBox)this.edtLocalizacao.getComponenteEditor()).getSelectedItem();
            if (((JComboBox)this.edtLocalizacao.getComponenteEditor()).getSelectedIndex() == -1 || !"105".equals(elementoSelecionado.getConteudo(0))) {
                for (int pos = 0; pos < ((JComboBox)this.edtLocalizacao.getComponenteEditor()).getItemCount(); ++pos) {
                    ElementoTabela elem = (ElementoTabela)((JComboBox)this.edtLocalizacao.getComponenteEditor()).getItemAt(pos);
                    if (!"105".equals(elem.getConteudo(0))) continue;
                    ((JComboBox)this.edtLocalizacao.getComponenteEditor()).setSelectedItem(elem);
                    break;
                }
            }
            this.edtLocalizacao.getComponenteFoco().setEnabled(false);
        } else if (Bem.isBemApenasExterior((String)grupo, (String)codigo)) {
            this.bem.getPais().setColecaoElementoTabela(CadastroTabelasIRPF.recuperarPaisesExterior());
            this.edtLocalizacao.getComponenteFoco().setEnabled(true);
            soExterior = true;
        } else {
            this.bem.getPais().setColecaoElementoTabela(CadastroTabelasIRPF.recuperarPaises());
            this.edtLocalizacao.getComponenteFoco().setEnabled(true);
        }
        if (!(((JComboBox)this.edtLocalizacao.getComponenteFoco()).getSelectedIndex() != -1 || paisSelecionado == null || soExterior && "105".equals(paisSelecionado))) {
            for (int i = 0; i < ((JComboBox)this.edtLocalizacao.getComponenteFoco()).getItemCount(); ++i) {
                if (!((ElementoTabela)((JComboBox)this.edtLocalizacao.getComponenteFoco()).getItemAt(i)).getConteudo(0).equals(paisSelecionado)) continue;
                ((JComboBox)this.edtLocalizacao.getComponenteFoco()).setSelectedIndex(i);
                break;
            }
        }
    }

    private void configurarMensagemReservaRemunerada(String grupo, String codigo, String pais) {
        if ("06".equals(grupo) && ("01".equals(codigo) || "99".equals(codigo)) && !"105".equals(pais)) {
            this.lblMsgDepositoRemunerado.setVisible(true);
        } else {
            this.lblMsgDepositoRemunerado.setVisible(false);
        }
    }

    private void configurarComboPais() {
        this.listenerPais = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String paisNegocio;
                JComboBox comboPais = (JComboBox)PainelBensDetalhe.this.edtLocalizacao.getComponenteEditor();
                String paisCombo = "";
                if (comboPais.getSelectedIndex() != -1) {
                    paisCombo = ((ElementoTabela)comboPais.getSelectedItem()).getConteudo(0);
                }
                if (!paisCombo.equals(paisNegocio = PainelBensDetalhe.this.getBem().getPais().naoFormatado())) {
                    ElementoTabela et;
                    PainelBensDetalhe.this.exibirMensagem524ou525(PainelBensDetalhe.this.bem.getGrupo().naoFormatado(), paisCombo);
                    if (!PainelBensDetalhe.this.bem.processarTrocaGrupoCodigoPais(paisNegocio, "Localiza\u00e7\u00e3o(Pa\u00eds)")) {
                        int indice = -1;
                        for (ElementoTabela elemento : PainelBensDetalhe.this.bem.getPais().getColecaoElementoTabela()) {
                            ++indice;
                            if (!elemento.getConteudo(0).equals(paisNegocio)) continue;
                            PainelBensDetalhe.this.indiceRollback = indice;
                            break;
                        }
                        comboPais.removeActionListener(PainelBensDetalhe.this.listenerPais);
                        comboPais.setSelectedIndex(PainelBensDetalhe.this.indiceRollback);
                        comboPais.addActionListener(PainelBensDetalhe.this.listenerPais);
                    }
                    if ((et = (ElementoTabela)comboPais.getSelectedItem()) != null) {
                        PainelBensDetalhe.this.trocaPais(et.getConteudo(0));
                    }
                }
            }
        };
        ((JComboBox)this.edtLocalizacao.getComponenteEditor()).addActionListener(this.listenerPais);
    }

    private void limpaDadosConta() {
        this.getBem().getAgencia().setConteudo("");
        this.getBem().getOperacao().setConteudo("");
        this.getBem().getConta().setConteudo("");
        this.getBem().getDVConta().setConteudo("");
    }

    private void configurarExibicaoInfoConta() {
        if (this.getBem().getBanco().isVazio()) {
            this.lblInfo.setVisible(false);
        } else if (this.lblInfo.getMensagem().isBlank()) {
            this.lblInfo.setVisible(false);
        } else {
            this.lblInfo.setVisible(true);
            this.mensagemInformacaoContaAcessivel();
        }
    }

    private void associarInformacao(Bem bem) {
        this.habilitarCamposCriptoativos(this.getBem().getGrupo().naoFormatado(), this.getBem().getCodigo().toString());
        this.habilitarPainelRegistroBem(bem.getGrupo().naoFormatado(), bem.getCodigo().toString(), bem.getPais().toString());
        this.habilitarCampoDataAquisicao(bem.getGrupo().naoFormatado(), bem.getCodigo().toString());
        this.habilitarCampoNI(this.getBem().getGrupo().naoFormatado(), bem.getCodigo().toString(), bem.getPais().toString(), this.getBem().getIndicadorAutoCustodiante().naoFormatado());
        this.habilitarPainelDadosBancarios(this.getBem().getGrupo().naoFormatado(), bem.getCodigo().toString());
        this.habilitarPainelBeneficiario(this.getBem().getGrupo().naoFormatado(), this.getBem().getCodigo().toString());
        this.habilitarPainelNegociacao(this.getBem().getGrupo().naoFormatado(), this.getBem().getCodigo().toString());
        this.habilitarPaineisAplicacaoFinanceiraLucrosDividendos(this.getBem().getGrupo().naoFormatado(), this.getBem().getCodigo().toString(), bem.getPais().toString());
        this.habilitaInformacaoCPFCNPJProprietarioUsufrutuario(this.getBem().getIndicadorProprietarioUsufrutuario().naoFormatado());
        this.edtGrupo.setInformacao((Informacao)bem.getGrupo());
        this.edtCodigoBem.setInformacao((Informacao)bem.getCodigo());
        this.edtLocalizacao.setInformacao((Informacao)bem.getPais());
        this.edtDiscriminacao.setInformacao((Informacao)bem.getDiscriminacao());
        this.edtValorAnterior.setInformacao((Informacao)bem.getValorExercicioAnterior());
        this.edtValorAtual.setInformacao((Informacao)bem.getValorExercicioAtual());
        this.edtNumeroRegistroBem.setInformacao((Informacao)bem.getRegistroBem());
        if ("00000000".equals(bem.getDataAquisicao().naoFormatado())) {
            bem.getDataAquisicao().clear();
        }
        this.edtDataAquisicao.setInformacao((Informacao)bem.getDataAquisicao());
        this.edtLogradouro.setInformacao((Informacao)bem.getLogradouro());
        this.edtNumero.setInformacao((Informacao)bem.getNumero());
        this.edtComplemento.setInformacao((Informacao)bem.getComplemento());
        this.edtBairro.setInformacao((Informacao)bem.getBairro());
        this.edtRegistroCartorio.setInformacao((Informacao)bem.getRegistrado());
        this.edtMatriculaImovel.setInformacao((Informacao)bem.getMatricula());
        this.edtAreaTotal.setInformacao((Informacao)bem.getAreaTotal());
        this.edtUnidade.setInformacao((Informacao)bem.getUnidade());
        this.edtNomeCartorio.setInformacao((Informacao)bem.getNomeCartorio());
        this.edtNiBem.setInformacao((Informacao)bem.getNiEmpresa());
        this.edtAgencia.setInformacao((Informacao)bem.getAgencia());
        this.edtConta.setInformacao((Informacao)bem.getConta());
        this.edtDV.setInformacao((Informacao)bem.getDVConta());
        this.edtBanco.setInformacao((Informacao)bem.getBanco());
        this.tipoGroup.setInformacao((Informacao)bem.getTipo());
        this.cmbDependente.setInformacao((Informacao)bem.getCPFBeneficiario());
        this.edtNegociadoBolsa.setInformacao((Informacao)bem.getNegociadoBolsa());
        this.edtCodNegociacao.setInformacao((Informacao)bem.getCodigoNegociacao());
        this.grpAutoCustodiante.setInformacao((Informacao)bem.getIndicadorAutoCustodiante());
        this.edtLucroPrejuizo.setInformacao((Informacao)bem.getLucroPrejuizo());
        this.edtImpostoPagoExt.setInformacao((Informacao)bem.getImpostoPagoExterior());
        this.edtValorRecebido.setInformacao((Informacao)bem.getValorRecebido());
        this.edtImpostoExteriorIRRF.setInformacao((Informacao)bem.getImpostoPagoExteriorIRRF());
        this.chkBemComUsufruto.setSelected(bem.getIndicadorBemComUsufruto().naoFormatado().equals("1"));
        this.grpProprietarioUsufrutuario.setInformacao((Informacao)bem.getIndicadorProprietarioUsufrutuario());
        this.chkContaPagamento.setSelected(bem.getIndicadorContaPagamento().naoFormatado().equals("1"));
    }

    protected boolean isLocalizacaoBrasil(String codPais) {
        return codPais.equals("105");
    }

    protected boolean isLocalizacaoExterior(String codPais) {
        return !codPais.equals("105");
    }

    protected void habilitarCampoNI(String grupo, String codBem, String codPais, String autoCustodiante) {
        if (Bem.isBemComNI((String)grupo, (String)codBem, (boolean)this.isLocalizacaoBrasil(codPais), (String)autoCustodiante)) {
            String nomeCampo = Bem.tituloCampoNI((String)grupo, (String)codBem);
            this.lblNiBem.setText(nomeCampo);
            this.lblNiBem.setEnabled(true);
            this.edtNiBem.setEnabled(true);
            this.lblNiBem.setVisible(true);
            this.edtNiBem.setVisible(true);
            this.edtNiBem.getAccessibleContext().setAccessibleName(nomeCampo);
            this.bem.getNiEmpresa().setNomeCampo(nomeCampo);
        } else {
            this.lblNiBem.setEnabled(false);
            this.edtNiBem.setEnabled(false);
            this.lblNiBem.setVisible(false);
            this.edtNiBem.setVisible(false);
            this.edtNiBem.getAccessibleContext().setAccessibleName("");
        }
    }

    protected void habilitarPainelRegistroBem(String grupo, String codBem, String codPais) {
        if (Bem.isBemRegistravel((String)grupo, (String)codBem, (boolean)this.isLocalizacaoBrasil(codPais))) {
            String nomeCampo = Bem.tituloCampoRegistro((String)grupo, (String)codBem, (boolean)this.isLocalizacaoBrasil(codPais));
            this.lblNumeroRegistroBem.setText(nomeCampo);
            this.lblNumeroRegistroBem.setEnabled(true);
            this.edtNumeroRegistroBem.setEnabled(true);
            this.lblNumeroRegistroBem.setVisible(true);
            this.edtNumeroRegistroBem.setVisible(true);
            this.edtNumeroRegistroBem.getAccessibleContext().setAccessibleName(nomeCampo);
            if (nomeCampo.equals("Inscri\u00e7\u00e3o Municipal (IPTU)")) {
                this.lblInfoIPTU.setVisible(true);
                this.edtNumeroRegistroBem.getAccessibleContext().setAccessibleDescription(MensagemUtil.getMensagem((String)"bem_info_iptu"));
            } else {
                this.lblInfoIPTU.setVisible(false);
                this.edtNumeroRegistroBem.getAccessibleContext().setAccessibleDescription("");
            }
            int tamanhoCampo = Bem.tamanhoCampoRegistro((String)grupo, (String)codBem, (boolean)this.isLocalizacaoBrasil(codPais));
            String mascara = "******************************".substring(0, tamanhoCampo);
            String caracteres = "AaBbCcDdEeFfGgHhIiJjKkLlMmNnOoPpQqRrSsTtUuVvWwXxYyZz0123456789$%& -,./!#*):;(+<>?@_";
            if (this.bem.isImovelImovelRuralNoBrasil(grupo, codBem, codPais)) {
                mascara = "*******-*";
                caracteres = "AaBbCcDdEeFfGgHhIiJjKkLlMmNnOoPpQqRrSsTtUuVvWwXxYyZz0123456789";
            } else if (this.bem.isImovelEmConstrucaoNoBrasil(grupo, codBem, codPais)) {
                mascara = "**.***.*****/**";
                caracteres = "0123456789";
            }
            this.edtNumeroRegistroBem.setMascara(mascara);
            this.edtNumeroRegistroBem.setCaracteresValidos(caracteres);
            this.bem.getRegistroBem().setMaximoCaracteres(tamanhoCampo);
            this.bem.getRegistroBem().setNomeCampo(nomeCampo);
        } else {
            this.lblNumeroRegistroBem.setEnabled(false);
            this.edtNumeroRegistroBem.setEnabled(false);
            this.lblNumeroRegistroBem.setVisible(false);
            this.edtNumeroRegistroBem.setVisible(false);
            this.edtNumeroRegistroBem.getAccessibleContext().setAccessibleName("");
            this.lblInfoIPTU.setVisible(false);
            this.edtNumeroRegistroBem.setConteudo("");
        }
    }

    protected void habilitarPainelDadosBancarios(String grupo, String codBem) {
        if (Bem.isBemComDadosBancarios((String)grupo, (String)codBem)) {
            this.pnlDadosBancarios.setVisible(true);
            if (grupo.equals("06") && codBem.contentEquals("01")) {
                this.chkContaPagamento.setVisible(true);
            } else {
                this.chkContaPagamento.setSelected(false);
                this.chkContaPagamento.setVisible(false);
            }
        } else {
            this.pnlDadosBancarios.setVisible(false);
            this.edtAgencia.setConteudo("");
            this.edtConta.setConteudo("");
            this.edtDV.setConteudo("");
        }
    }

    private void habilitarCampoBanco(String codPais, String grupo, String codBem) {
        if (this.isLocalizacaoBrasil(codPais)) {
            this.lblBanco.setVisible(true);
            this.edtBanco.setVisible(true);
            if (grupo.equals("06") && codBem.contentEquals("01")) {
                this.chkContaPagamento.setVisible(true);
            } else {
                this.chkContaPagamento.setSelected(false);
                this.chkContaPagamento.setVisible(false);
            }
        } else {
            this.lblBanco.setVisible(false);
            this.edtBanco.setVisible(false);
            this.edtBanco.getInformacao().clear();
            ((JComboBox)this.edtBanco.getComponenteEditor()).setSelectedIndex(-1);
            this.chkContaPagamento.setSelected(false);
            this.chkContaPagamento.setVisible(false);
            this.bem.getIndicadorContaPagamento().setConteudo("0");
        }
    }

    private void configuraNumeroCaracteresDV(String banco) {
        String dv = this.edtDV.getConteudo().toString();
        if (CalculoImposto.getBancosDebito().contains(banco)) {
            this.edtDV.setMaxChars(1);
            ((Alfa)this.edtDV.getInformacao()).setMaximoCaracteres(1);
            if (dv != null && dv.trim().length() > 1) {
                this.edtDV.getInformacao().setConteudo(dv.substring(0, 1));
            }
        } else if ("104".equals(banco)) {
            this.edtDV.setMaxChars(1);
            ((Alfa)this.edtDV.getInformacao()).setMaximoCaracteres(1);
        } else {
            this.edtDV.setMaxChars(2);
            ((Alfa)this.edtDV.getInformacao()).setMaximoCaracteres(2);
        }
    }

    private void configurarContaCorrente(Codigo banco) {
        String codBanco = banco.naoFormatado();
        try {
            this.definirMensagemConta(banco, this.definirDigitosConta(banco));
            this.edtConta.setMascara(IRPFUtil.repetirString((String)"*", (int)this.definirDigitosConta(banco)));
            JTextField t = (JTextField)this.edtConta.getComponenteEditor();
            this.edtConta.setConteudo(t.getText());
        }
        catch (Exception e) {
            this.edtConta.setMascara("*************");
        }
    }

    private void definirMensagemConta(Codigo banco, int digitos) {
        String codBanco = banco.naoFormatado();
        String mensagem = "";
        if (CalculoImposto.getBancosDebito().contains(codBanco)) {
            mensagem = "070".equals(codBanco) ? MensagemUtil.getMensagem((String)"msg_informacao_conta_caixa_brb_bem", (String[])new String[]{"cr\u00e9dito"}) : (this.getBem().possuiDadosContaPoupanca() && "001".equals(codBanco) ? MensagemUtil.getMensagem((String)"msg_informacao_conta_bb", (String[])new String[]{"cr\u00e9dito"}) : MensagemUtil.getMensagem((String)"msg_informacao_digitos_conta_bem", (String[])new String[]{String.valueOf(digitos)}));
        }
        this.lblInfo.setMensagem(mensagem);
    }

    public int definirDigitosConta(Codigo banco) {
        int digitos;
        String codBanco = banco.naoFormatado();
        try {
            digitos = Integer.parseInt(banco.getConteudoAtual(6));
        }
        catch (Exception e) {
            digitos = 13;
        }
        if ("001".equals(codBanco) && this.getBem().possuiDadosContaPoupanca()) {
            digitos = 9;
        } else if ("104".equals(codBanco)) {
            digitos = 12;
        }
        return digitos;
    }

    protected void habilitarCampoDataAquisicao(String grupo, String codBem) {
        Boolean flag = Bem.isBemImovelRegistravel((String)grupo, (String)codBem);
        this.lblDataAquisicao.setEnabled(flag);
        this.edtDataAquisicao.setEnabled(flag.booleanValue());
        this.lblDataAquisicao.setVisible(flag);
        this.edtDataAquisicao.setVisible(flag.booleanValue());
        if (!flag.booleanValue()) {
            this.edtDataAquisicao.setConteudo("");
        }
    }

    private void habilitarPainelBeneficiario(String grupo, String codBem) {
        if (Bem.isBemComBeneficiario((String)grupo, (String)codBem)) {
            this.pnlBeneficiario.setVisible(true);
        } else {
            this.pnlBeneficiario.setVisible(false);
        }
    }

    private void habilitarPainelBemImovel(String grupo, String codBem, String codPais) {
        if (Bem.isBemImovel((String)grupo, (String)codBem)) {
            this.pnlDadosBemImovel.setVisible(true);
            if (Bem.isBemImovelRegistravel((String)grupo, (String)codBem)) {
                this.lblRegistrado.setVisible(true);
                this.edtRegistroCartorio.setVisible(true);
                this.habilitaCampoBemImovelRegistrado(this.rdoRegistroCartorioSim.isSelected() ? "1" : (this.rdoRegistroCartorioNao.isSelected() ? "0" : "2"), codPais);
                this.edtRegistroCartorio.chamaValidacao();
            } else {
                this.lblRegistrado.setVisible(false);
                this.edtRegistroCartorio.setVisible(false);
                this.lblMatricula.setVisible(false);
                this.edtMatriculaImovel.setVisible(false);
                this.lblNomeCartorio.setVisible(false);
                this.edtNomeCartorio.setVisible(false);
                this.edtRegistroCartorio.setConteudo("2");
                this.edtMatriculaImovel.setConteudo("");
                this.edtNomeCartorio.setConteudo("");
            }
            this.chkAtualizacaoValorBem.setVisible(IRPFFacade.getInstancia().getBens().getExisteAtualizacaoValorBem().naoFormatado().equals(Logico.SIM));
            this.chkAtualizacaoValorBem.setSelected(this.bem.getAtualizadoValorBem().naoFormatado().equals(Logico.SIM));
        } else {
            this.pnlDadosBemImovel.setVisible(false);
            this.edtRegistroCartorio.setConteudo("2");
            this.edtMatriculaImovel.setConteudo("");
            this.edtNomeCartorio.setConteudo("");
            this.chkAtualizacaoValorBem.setSelected(false);
            this.chkAtualizacaoValorBem.setVisible(false);
        }
    }

    protected void habilitaCampoBemImovelRegistrado(String registrado, String codPais) {
        if (this.isLocalizacaoBrasil(codPais)) {
            if (registrado.equals("1")) {
                this.lblMatricula.setVisible(true);
                this.edtMatriculaImovel.setVisible(true);
                this.lblNomeCartorio.setVisible(true);
                this.edtNomeCartorio.setVisible(true);
            } else if (registrado.equals("0")) {
                this.lblMatricula.setVisible(false);
                this.edtMatriculaImovel.setVisible(false);
                this.lblNomeCartorio.setVisible(false);
                this.edtNomeCartorio.setVisible(false);
                this.edtMatriculaImovel.setConteudo("");
                this.edtNomeCartorio.setConteudo("");
            } else {
                this.lblMatricula.setVisible(false);
                this.edtMatriculaImovel.setVisible(false);
                this.lblNomeCartorio.setVisible(false);
                this.edtNomeCartorio.setVisible(false);
                this.edtMatriculaImovel.setConteudo("");
                this.edtNomeCartorio.setConteudo("");
            }
        } else {
            this.lblRegistrado.setVisible(false);
            this.edtRegistroCartorio.setVisible(false);
            this.lblMatricula.setVisible(false);
            this.edtMatriculaImovel.setVisible(false);
            this.lblNomeCartorio.setVisible(false);
            this.edtNomeCartorio.setVisible(false);
            this.edtRegistroCartorio.setConteudo("2");
            this.edtMatriculaImovel.setConteudo("");
            this.edtNomeCartorio.setConteudo("");
        }
    }

    private void alteraPainelLocalizacaoBemRegistravel(String grupo, String codBem, String codPais) {
        if (Bem.isBemRegistravel((String)grupo, (String)codBem, (boolean)this.isLocalizacaoBrasil(codPais))) {
            this.lblNumeroRegistroBem.setVisible(true);
            this.edtNumeroRegistroBem.setVisible(true);
        } else {
            this.lblNumeroRegistroBem.setVisible(false);
            this.edtNumeroRegistroBem.setVisible(false);
            this.edtNumeroRegistroBem.setConteudo("");
        }
    }

    private void alteraPainelLocalizacaoBemImovel(String grupo, String codBem, String codPais) {
        if (Bem.isBemImovel((String)grupo, (String)codBem)) {
            if (codPais.equals("105")) {
                this.flpLocalizacao.exibeComponenteA();
            } else {
                this.flpLocalizacao.exibeComponenteB();
            }
        }
    }

    private void mensagemInformacaoContaAcessivel() {
        if (!this.bem.getBanco().naoFormatado().equals("104")) {
            this.edtConta.getAccessibleContext().setAccessibleDescription(this.lblInfo.getMensagem());
        }
    }

    protected void habilitarPainelNegociacao(String grupo, String codBem) {
        if (Bem.isBemNegociadoBolsa((String)grupo, (String)codBem)) {
            this.pnlNegociacaoBolsa.setVisible(true);
            this.habilitaCampoCodigoNegociacao(this.rdoNegociadoBolsaSim.isSelected() ? "1" : (this.rdoNegociadoBolsaNao.isSelected() ? "0" : "2"));
        } else {
            this.pnlNegociacaoBolsa.setVisible(false);
        }
    }

    protected void habilitaCampoCodigoNegociacao(String negociadoBolsa) {
        if (negociadoBolsa.equals("1")) {
            this.lblCodNegociacao.setVisible(true);
            this.edtCodNegociacao.setVisible(true);
        } else {
            this.lblCodNegociacao.setVisible(false);
            this.edtCodNegociacao.setVisible(false);
            this.edtCodNegociacao.setConteudo("");
        }
    }

    private void habilitarCamposCriptoativos(String grupo, String codBem) {
        if (Bem.isCriptoativos((String)grupo, (String)codBem)) {
            this.habilitarComboCodigoCriptoativos(codBem);
            this.lblAutoCustodiante.setVisible(true);
            this.grpAutoCustodiante.setVisible(true);
        } else {
            this.lblAutoCustodiante.setVisible(false);
            this.grpAutoCustodiante.setVisible(false);
            this.lblCodCripto.setVisible(false);
            this.edtCodigoCripto.setVisible(false);
            this.bem.getIndicadorAutoCustodiante().setConteudo("0");
        }
    }

    private void habilitarComboCodigoCriptoativos(String codBem) {
        if ("02".equals(codBem) || "03".equals(codBem)) {
            this.lblCodCripto.setVisible(true);
            this.edtCodigoCripto.setVisible(true);
            if ("02".equals(codBem)) {
                this.lblCodCripto.setText("C\u00f3digo Altcoin");
                this.edtCodigoCripto.setInformacao((Informacao)this.bem.getCodigoAltcoin());
                this.edtCodigoCripto.getAccessibleContext().setAccessibleName("C\u00f3digo Altcoin");
                this.bem.getCodigoStablecoin().setConteudo("");
            } else {
                this.lblCodCripto.setText("C\u00f3digo Stablecoin");
                this.edtCodigoCripto.setInformacao((Informacao)this.bem.getCodigoStablecoin());
                this.edtCodigoCripto.getAccessibleContext().setAccessibleName("C\u00f3digo Stablecoin");
                this.bem.getCodigoAltcoin().setConteudo("");
            }
        } else {
            this.lblCodCripto.setVisible(false);
            this.edtCodigoCripto.setVisible(false);
        }
    }

    private void habilitarPaineisAplicacaoFinanceiraLucrosDividendos(String grupo, String codBem, String codPais) {
        if (Bem.isBemComAplicacaoFinanceira((String)grupo, (String)codBem, (boolean)this.isLocalizacaoExterior(codPais))) {
            this.pnlAplicacaoFinanceira.setVisible(true);
        } else {
            this.pnlAplicacaoFinanceira.setVisible(false);
            this.edtLucroPrejuizo.setConteudo("");
            this.edtImpostoPagoExt.setConteudo("");
        }
        if (Bem.isBemComLucrosDividendos((String)grupo, (String)codBem, (boolean)this.isLocalizacaoExterior(codPais))) {
            this.pnlLucrosDividendos.setVisible(true);
        } else {
            this.pnlLucrosDividendos.setVisible(false);
            this.edtValorRecebido.setConteudo("");
            this.edtImpostoExteriorIRRF.setConteudo("");
        }
    }

    private void habilitarRadioProprietarioUsufrutuario() {
    }

    protected void habilitaInformacaoCPFCNPJProprietarioUsufrutuario(String proprietarioUsufrutuario) {
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.lbSituacaoAnoAnterior = new JLabel();
        this.edtValorAnterior = new JEditValor();
        this.lbSituacaoAnoAtual = new JLabel();
        this.edtValorAtual = new JEditValor();
        this.btnRepetir = new JButton();
        this.lbRepetir = new JLabel();
        this.jPanel3 = new JPanel();
        this.jLabel2 = new JLabel();
        this.edtCodigoBem = new JAutoCompleteEditCodigo();
        this.jLabel3 = new JLabel();
        this.edtLocalizacao = new JAutoCompleteEditCodigo();
        this.jLabel4 = new JLabel();
        this.edtDiscriminacao = new JEditMemo();
        this.edtNumeroRegistroBem = new JEditMascara();
        this.lblInfoIPTU = new IRPFLabelInfo(MensagemUtil.getMensagem((String)"bem_info_iptu"));
        this.lblDataAquisicao = new JLabel();
        this.edtDataAquisicao = new JEditData();
        this.lblNiBem = new JLabel();
        this.edtNiBem = new JEditNI();
        this.pnlDadosBemImovel = new JPanel();
        this.lblComplemento = new JLabel();
        this.edtComplemento = new JEditAlfa();
        this.lblBairro = new JLabel();
        this.edtBairro = new JEditAlfa();
        this.flpLocalizacao = new JFlipComponentes();
        this.edtLogradouro = new JEditAlfa();
        this.lblLogradouro = new JLabel();
        this.lblNumero = new JLabel();
        this.edtNumero = new JEditAlfa();
        this.lblAreaTotal = new JLabel();
        this.edtAreaTotal = new JEditValor();
        this.lblUnidade = new JLabel();
        this.edtUnidade = new JButtonGroupPanel();
        this.rdoUnidadeM2 = new PPGDRadioItem();
        this.rdoUnidadeHa = new PPGDRadioItem();
        this.msgUnidade = new JButtonMensagem();
        this.lblMatricula = new JLabel();
        this.edtRegistroCartorio = new JButtonGroupPanel();
        this.rdoRegistroCartorioSim = new PPGDRadioItem();
        this.rdoRegistroCartorioNao = new PPGDRadioItem();
        this.msgRegistrado = new JButtonMensagem();
        this.lblRegistrado = new JLabel();
        this.lblNomeCartorio = new JLabel();
        this.edtMatriculaImovel = new JEditAlfa();
        this.edtNomeCartorio = new JEditAlfa();
        this.pnlDadosBancarios = new JPanel();
        this.lblAgencia = new JLabel();
        this.edtAgencia = new JEditMascara();
        this.edtBanco = new JAutoCompleteEditCodigo();
        this.lblBanco = new JLabel();
        this.lblConta = new JLabel();
        this.lblInfo = new IRPFLabelInfo(MensagemUtil.getMensagem((String)"msg_informacao_conta_caixa_debito", (String[])new String[]{"d\u00e9bito"}));
        this.edtConta = new JEditMascara();
        this.lblDV = new JLabel();
        this.edtDV = new JEditAlfa();
        this.chkContaPagamento = new JCheckBox();
        this.pnlBeneficiario = new JPanel();
        this.lblDependente = new JLabel();
        this.tipoGroup = new JButtonGroupPanel();
        this.rdbTitular = new PPGDRadioItem();
        this.rdbDependente = new PPGDRadioItem();
        this.lblTipo = new JLabel();
        this.cmbDependente = new JAutoCompleteEditCPF();
        this.jLabel5 = new JLabel();
        this.edtGrupo = new JAutoCompleteEditCodigo();
        this.lblNumeroRegistroBem = new JLabel();
        this.pnlNegociacaoBolsa = new JPanel();
        this.lblNegociacao = new JLabel();
        this.edtNegociadoBolsa = new JButtonGroupPanel();
        this.rdoNegociadoBolsaSim = new PPGDRadioItem();
        this.rdoNegociadoBolsaNao = new PPGDRadioItem();
        this.msgNegociadoBolsa = new JButtonMensagem();
        this.lblCodNegociacao = new JLabel();
        this.edtCodNegociacao = new JEditAlfa();
        this.lblCodCripto = new JLabel();
        this.edtCodigoCripto = new JAutoCompleteEditCodigo();
        this.lblAutoCustodiante = new JLabel();
        this.grpAutoCustodiante = new JButtonGroupPanel();
        this.rdbAutoCustodianteSim = new PPGDRadioItem();
        this.rdbAutoCustodianteNao = new PPGDRadioItem();
        this.grpProprietarioUsufrutuario = new JButtonGroupPanel();
        this.rdbProprietario = new PPGDRadioItem();
        this.rdbUsufrutuario = new PPGDRadioItem();
        this.lblProprietarioUsufrutuario = new JLabel();
        this.chkBemComUsufruto = new JCheckBox();
        this.btProprietarioUsufrutuario = new JButton();
        this.chkAtualizacaoValorBem = new JCheckBox();
        this.btnReclassificar = new JButton();
        this.pnlRendimentos = new JPanel();
        this.jPanel4 = new JPanel();
        this.btnRendIsento = new JButton();
        this.btnRendExclusivo = new JButton();
        this.pnlAplicacaoFinanceira = new JPanel();
        this.lblLucroPrejuizo = new JLabel();
        this.edtLucroPrejuizo = new JEditValor();
        this.lblImpostoPagoExt = new JLabel();
        this.edtImpostoPagoExt = new JEditValor();
        this.lblMsgDepositoRemunerado = new JLabel();
        this.pnlLucrosDividendos = new JPanel();
        this.edtValorRecebido = new JEditValor();
        this.lblValorRecebido = new JLabel();
        this.lblImpostoExteriorIRRF = new JLabel();
        this.edtImpostoExteriorIRRF = new JEditValor();
        this.jLabel1 = new JLabel();
        this.setBackground(new Color(241, 245, 249));
        this.setForeground(new Color(255, 255, 255));
        this.jPanel1.setBackground(new Color(255, 255, 255));
        this.jPanel1.setBorder(BorderFactory.createLineBorder(new Color(211, 222, 232)));
        this.jPanel2.setBackground(new Color(255, 255, 255));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(null, "", 0, 0, FontesUtil.FONTE_TITULO_NORMAL, new Color(0, 74, 106)));
        this.lbSituacaoAnoAnterior.setLabelFor((Component)this.edtValorAnterior);
        this.lbSituacaoAnoAnterior.setText("Situa\u00e7\u00e3o em 31/12/" + ConstantesGlobais.ANO_BASE_ANTERIOR + " (R$)");
        this.lbSituacaoAnoAtual.setLabelFor((Component)this.edtValorAtual);
        this.lbSituacaoAnoAtual.setText("Situa\u00e7\u00e3o em 31/12/" + ConstantesGlobais.ANO_BASE + " (R$)");
        this.btnRepetir.setMnemonic('R');
        this.btnRepetir.setText("Repetir");
        this.btnRepetir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelBensDetalhe.this.btnRepetirActionPerformed(evt);
            }
        });
        this.lbRepetir.setText("<HTML>Repete em 31/12/" + ConstantesGlobais.ANO_BASE + " o valor<BR>em reais de 31/12/" + ConstantesGlobais.ANO_BASE_ANTERIOR + "</HTML>");
        this.lbRepetir.setVerticalAlignment(1);
        this.lbRepetir.setVerticalTextPosition(1);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.edtValorAnterior, -2, 156, -2).addComponent(this.lbSituacaoAnoAnterior)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lbSituacaoAnoAtual).addGroup(jPanel2Layout.createSequentialGroup().addComponent((Component)this.edtValorAtual, -2, 136, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnRepetir).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lbRepetir, -2, 250, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel2Layout.linkSize(0, new Component[]{this.edtValorAnterior, this.edtValorAtual});
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.edtValorAnterior, -2, -1, -2).addComponent((Component)this.edtValorAtual, -2, -1, -2)).addComponent(this.lbRepetir, GroupLayout.Alignment.TRAILING, -2, 51, -2)).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lbSituacaoAnoAtual).addComponent(this.lbSituacaoAnoAnterior)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnRepetir).addGap(23, 23, 23))).addGap(0, 0, Short.MAX_VALUE)));
        this.edtValorAnterior.getAccessibleContext().setAccessibleName("Situa\u00e7\u00e3o em 31/12/" + ConstantesGlobais.ANO_BASE_ANTERIOR + " (R$)");
        this.lbSituacaoAnoAtual.getAccessibleContext().setAccessibleName(null);
        this.lbSituacaoAnoAtual.getAccessibleContext().setAccessibleDescription("");
        this.edtValorAtual.getAccessibleContext().setAccessibleName((String)(this.isSaida() ? "Situa\u00e7\u00e3o na data da caracteriza\u00e7\u00e3o da condi\u00e7\u00e3o de n\u00e3o residente (R$)" : "Situa\u00e7\u00e3o em 31/12/" + ConstantesGlobais.ANO_BASE + " (R$)"));
        this.edtValorAtual.getAccessibleContext().setAccessibleDescription("");
        this.btnRepetir.getAccessibleContext().setAccessibleName("<HTML>Repete em 31/12/" + ConstantesGlobais.ANO_BASE + " o valor<BR>em reais de 31/12/" + ConstantesGlobais.ANO_BASE_ANTERIOR + "</HTML>");
        this.btnRepetir.getAccessibleContext().setAccessibleDescription("");
        this.lbRepetir.getAccessibleContext().setAccessibleName(null);
        this.lbRepetir.getAccessibleContext().setAccessibleDescription("");
        this.jPanel3.setBackground(new Color(255, 255, 255));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(null, "", 0, 0, FontesUtil.FONTE_TITULO_NORMAL, new Color(0, 74, 106)));
        this.jLabel2.setFont(FontesUtil.FONTE_NORMAL);
        this.jLabel2.setLabelFor((Component)this.edtCodigoBem);
        this.jLabel2.setText("C\u00f3digo");
        this.edtCodigoBem.setToolTipText("C\u00f3digo");
        this.jLabel3.setFont(FontesUtil.FONTE_NORMAL);
        this.jLabel3.setLabelFor((Component)this.edtLocalizacao);
        this.jLabel3.setText("Localiza\u00e7\u00e3o (Pa\u00eds)");
        this.jLabel4.setFont(FontesUtil.FONTE_NORMAL);
        this.jLabel4.setLabelFor((Component)this.edtDiscriminacao);
        this.jLabel4.setText("Discrimina\u00e7\u00e3o");
        this.edtDiscriminacao.setMaxChars(512);
        this.lblDataAquisicao.setFont(FontesUtil.FONTE_NORMAL);
        this.lblDataAquisicao.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblDataAquisicao.setText("Data de Aquisi\u00e7\u00e3o");
        this.lblNiBem.setFont(FontesUtil.FONTE_NORMAL);
        this.lblNiBem.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblNiBem.setText("CNPJ");
        this.lblNiBem.setToolTipText("");
        this.edtNiBem.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                PainelBensDetalhe.this.edtNiBemFocusLost(evt);
            }
        });
        this.pnlDadosBemImovel.setBackground(new Color(255, 255, 255));
        this.lblComplemento.setFont(FontesUtil.FONTE_NORMAL);
        this.lblComplemento.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblComplemento.setText("Complemento");
        this.lblBairro.setFont(FontesUtil.FONTE_NORMAL);
        this.lblBairro.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblBairro.setText("Bairro/Distrito");
        this.flpLocalizacao.setBackground(new Color(255, 255, 255));
        this.flpLocalizacao.setBorder(null);
        this.flpLocalizacao.setComponenteA((JComponent)this.painelImovelBrasil);
        this.flpLocalizacao.setComponenteB((JComponent)this.painelImovelExterior);
        this.lblLogradouro.setFont(FontesUtil.FONTE_NORMAL);
        this.lblLogradouro.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblLogradouro.setText("Logradouro");
        this.lblNumero.setFont(FontesUtil.FONTE_NORMAL);
        this.lblNumero.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblNumero.setText("N\u00famero");
        this.lblAreaTotal.setFont(FontesUtil.FONTE_NORMAL);
        this.lblAreaTotal.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblAreaTotal.setText("\u00c1rea Total do Im\u00f3vel");
        this.lblUnidade.setFont(FontesUtil.FONTE_NORMAL);
        this.lblUnidade.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblUnidade.setText("Unidade");
        this.edtUnidade.setBorder(null);
        this.rdoUnidadeM2.setBackground(new Color(255, 255, 255));
        this.rdoUnidadeM2.setText("<html>m<sup>2</sup></html>");
        this.rdoUnidadeM2.setFont(FontesUtil.FONTE_NORMAL);
        this.rdoUnidadeM2.setName("rdoUnidadeM2");
        this.rdoUnidadeM2.setValorSelecionadoTrue("0");
        this.rdoUnidadeM2.setVerticalAlignment(1);
        this.rdoUnidadeM2.setVerticalTextPosition(1);
        this.rdoUnidadeM2.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                PainelBensDetalhe.this.rdoUnidadeM2FocusLost(evt);
            }
        });
        this.rdoUnidadeHa.setBackground(new Color(255, 255, 255));
        this.rdoUnidadeHa.setText("<html>ha<sup>&nbsp;</sup></html>");
        this.rdoUnidadeHa.setFont(FontesUtil.FONTE_NORMAL);
        this.rdoUnidadeHa.setName("rdoUnidadeHa");
        this.rdoUnidadeHa.setValorSelecionadoTrue("1");
        this.rdoUnidadeHa.setVerticalAlignment(1);
        this.rdoUnidadeHa.setVerticalTextPosition(1);
        this.rdoUnidadeHa.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                PainelBensDetalhe.this.rdoUnidadeHaFocusLost(evt);
            }
        });
        GroupLayout edtUnidadeLayout = new GroupLayout((Container)this.edtUnidade);
        this.edtUnidade.setLayout((LayoutManager)edtUnidadeLayout);
        edtUnidadeLayout.setHorizontalGroup(edtUnidadeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(edtUnidadeLayout.createSequentialGroup().addComponent((Component)this.rdoUnidadeM2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent((Component)this.rdoUnidadeHa, -2, -1, -2).addContainerGap()));
        edtUnidadeLayout.setVerticalGroup(edtUnidadeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.rdoUnidadeHa).addComponent((Component)this.rdoUnidadeM2));
        this.rdoUnidadeM2.getAccessibleContext().setAccessibleName("Unidade em metros quadrados");
        this.rdoUnidadeM2.getAccessibleContext().setAccessibleDescription("");
        this.rdoUnidadeHa.getAccessibleContext().setAccessibleName("Unidade em hectares");
        this.msgUnidade.setText("jButtonMensagem1");
        this.lblMatricula.setFont(FontesUtil.FONTE_NORMAL);
        this.lblMatricula.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblMatricula.setText("Matr\u00edcula do Im\u00f3vel");
        this.edtRegistroCartorio.setBorder(null);
        this.edtRegistroCartorio.addGroupPanelListener(new GroupPanelListener(){

            public void atualizaPainel(GroupPanelEvent evt) {
                PainelBensDetalhe.this.edtRegistroCartorioAtualizaPainel(evt);
            }
        });
        this.rdoRegistroCartorioSim.setBackground(new Color(255, 255, 255));
        this.rdoRegistroCartorioSim.setText("Sim");
        this.rdoRegistroCartorioSim.setFont(FontesUtil.FONTE_NORMAL);
        this.rdoRegistroCartorioSim.setValorSelecionadoTrue("1");
        this.rdoRegistroCartorioSim.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                PainelBensDetalhe.this.rdoRegistroCartorioSimFocusLost(evt);
            }
        });
        this.rdoRegistroCartorioNao.setBackground(new Color(255, 255, 255));
        this.rdoRegistroCartorioNao.setText("N\u00e3o");
        this.rdoRegistroCartorioNao.setFont(FontesUtil.FONTE_NORMAL);
        this.rdoRegistroCartorioNao.setValorSelecionadoTrue("0");
        this.rdoRegistroCartorioNao.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                PainelBensDetalhe.this.rdoRegistroCartorioNaoFocusLost(evt);
            }
        });
        this.msgRegistrado.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.msgRegistrado.setText("jButtonMensagem1");
        GroupLayout edtRegistroCartorioLayout = new GroupLayout((Container)this.edtRegistroCartorio);
        this.edtRegistroCartorio.setLayout((LayoutManager)edtRegistroCartorioLayout);
        edtRegistroCartorioLayout.setHorizontalGroup(edtRegistroCartorioLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(edtRegistroCartorioLayout.createSequentialGroup().addComponent((Component)this.rdoRegistroCartorioSim, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.rdoRegistroCartorioNao, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.msgRegistrado, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        edtRegistroCartorioLayout.setVerticalGroup(edtRegistroCartorioLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(edtRegistroCartorioLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.rdoRegistroCartorioSim, -2, -1, -2).addComponent((Component)this.rdoRegistroCartorioNao, -2, -1, -2)).addComponent((Component)this.msgRegistrado, -2, -1, -2));
        this.rdoRegistroCartorioSim.getAccessibleContext().setAccessibleName("Registrado no Cart\u00f3rio de Registro de Im\u00f3veis? Sim");
        this.rdoRegistroCartorioNao.getAccessibleContext().setAccessibleName("N\u00e3o Registrado no Cart\u00f3rio de Registro de Im\u00f3veis");
        this.msgRegistrado.getAccessibleContext().setAccessibleParent(this.pnlDadosBemImovel);
        this.lblRegistrado.setFont(FontesUtil.FONTE_NORMAL);
        this.lblRegistrado.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblRegistrado.setText("<html>Registrado no Cart\u00f3rio<br>de Registro de Im\u00f3veis?</html>");
        this.lblNomeCartorio.setFont(FontesUtil.FONTE_NORMAL);
        this.lblNomeCartorio.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblNomeCartorio.setText("Nome Cart\u00f3rio");
        GroupLayout pnlDadosBemImovelLayout = new GroupLayout(this.pnlDadosBemImovel);
        this.pnlDadosBemImovel.setLayout(pnlDadosBemImovelLayout);
        pnlDadosBemImovelLayout.setHorizontalGroup(pnlDadosBemImovelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlDadosBemImovelLayout.createSequentialGroup().addGroup(pnlDadosBemImovelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlDadosBemImovelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(pnlDadosBemImovelLayout.createSequentialGroup().addGroup(pnlDadosBemImovelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblComplemento).addComponent((Component)this.edtComplemento, -2, 360, -2)).addGap(18, 18, 18).addGroup(pnlDadosBemImovelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblBairro).addComponent((Component)this.edtBairro, -1, -1, Short.MAX_VALUE))).addGroup(pnlDadosBemImovelLayout.createSequentialGroup().addGroup(pnlDadosBemImovelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.edtLogradouro, -2, 516, -2).addComponent(this.lblLogradouro)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlDadosBemImovelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.edtNumero, -2, 110, -2).addComponent(this.lblNumero)))).addGroup(pnlDadosBemImovelLayout.createSequentialGroup().addGroup(pnlDadosBemImovelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblRegistrado, -2, -1, -2).addComponent((Component)this.edtRegistroCartorio, -2, -1, -2)).addGap(35, 35, 35).addGroup(pnlDadosBemImovelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.edtMatriculaImovel, -2, 217, -2).addComponent(this.lblMatricula)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlDadosBemImovelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.edtNomeCartorio, -2, 277, -2).addComponent(this.lblNomeCartorio))).addGroup(pnlDadosBemImovelLayout.createSequentialGroup().addGroup(pnlDadosBemImovelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.edtAreaTotal, -2, 163, -2).addComponent(this.lblAreaTotal)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlDadosBemImovelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.edtUnidade, -2, -1, -2).addComponent(this.lblUnidade)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.msgUnidade, -2, -1, -2)).addComponent((Component)this.flpLocalizacao, -2, 750, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        pnlDadosBemImovelLayout.setVerticalGroup(pnlDadosBemImovelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlDadosBemImovelLayout.createSequentialGroup().addGroup(pnlDadosBemImovelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(pnlDadosBemImovelLayout.createSequentialGroup().addComponent(this.lblLogradouro).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.edtLogradouro, -2, -1, -2)).addGroup(pnlDadosBemImovelLayout.createSequentialGroup().addComponent(this.lblNumero).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.edtNumero, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlDadosBemImovelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblComplemento).addComponent(this.lblBairro)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlDadosBemImovelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent((Component)this.edtComplemento, -1, -1, Short.MAX_VALUE).addComponent((Component)this.edtBairro, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.flpLocalizacao, -2, 58, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlDadosBemImovelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlDadosBemImovelLayout.createSequentialGroup().addComponent(this.lblUnidade).addGap(2, 2, 2).addGroup(pnlDadosBemImovelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.msgUnidade, -2, -1, -2).addComponent((Component)this.edtUnidade, -2, -1, -2))).addGroup(GroupLayout.Alignment.TRAILING, pnlDadosBemImovelLayout.createSequentialGroup().addComponent(this.lblAreaTotal).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.edtAreaTotal, -2, -1, -2))).addGap(18, 18, Short.MAX_VALUE).addGroup(pnlDadosBemImovelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(pnlDadosBemImovelLayout.createSequentialGroup().addComponent(this.lblNomeCartorio).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.edtNomeCartorio, -2, -1, -2)).addGroup(pnlDadosBemImovelLayout.createSequentialGroup().addComponent(this.lblMatricula).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.edtMatriculaImovel, -2, -1, -2)).addGroup(pnlDadosBemImovelLayout.createSequentialGroup().addComponent(this.lblRegistrado, -2, -1, -2).addGap(2, 2, 2).addComponent((Component)this.edtRegistroCartorio, -2, -1, -2)))));
        this.edtComplemento.getAccessibleContext().setAccessibleName("Complemento");
        this.edtComplemento.getAccessibleContext().setAccessibleDescription("");
        this.edtBairro.getAccessibleContext().setAccessibleName("Bairro/Distrito");
        this.edtBairro.getAccessibleContext().setAccessibleDescription("");
        this.edtLogradouro.getAccessibleContext().setAccessibleName("Logradouro");
        this.edtLogradouro.getAccessibleContext().setAccessibleDescription("");
        this.edtNumero.getAccessibleContext().setAccessibleName("N\u00famero");
        this.edtNumero.getAccessibleContext().setAccessibleDescription("");
        this.edtAreaTotal.getAccessibleContext().setAccessibleName("\u00c1rea Total do Im\u00f3vel");
        this.edtAreaTotal.getAccessibleContext().setAccessibleDescription("");
        this.lblMatricula.getAccessibleContext().setAccessibleParent(this.pnlDadosBemImovel);
        this.lblRegistrado.getAccessibleContext().setAccessibleParent(this.pnlDadosBemImovel);
        this.lblNomeCartorio.getAccessibleContext().setAccessibleParent(this.pnlDadosBemImovel);
        this.edtMatriculaImovel.getAccessibleContext().setAccessibleName("Matr\u00edcula do Im\u00f3vel");
        this.edtMatriculaImovel.getAccessibleContext().setAccessibleDescription("");
        this.edtMatriculaImovel.getAccessibleContext().setAccessibleParent(this.pnlDadosBemImovel);
        this.edtNomeCartorio.getAccessibleContext().setAccessibleName("Nome Cart\u00f3rio");
        this.edtNomeCartorio.getAccessibleContext().setAccessibleDescription("");
        this.edtNomeCartorio.getAccessibleContext().setAccessibleParent(this.pnlDadosBemImovel);
        this.pnlDadosBancarios.setBackground(new Color(255, 255, 255));
        this.lblAgencia.setFont(FontesUtil.FONTE_NORMAL);
        this.lblAgencia.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblAgencia.setText("Ag\u00eancia (sem DV)");
        this.edtAgencia.setCaracteresValidos("0123456789 ");
        this.edtAgencia.setMascara("****");
        this.lblBanco.setFont(FontesUtil.FONTE_NORMAL);
        this.lblBanco.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblBanco.setText("Banco");
        this.lblConta.setFont(FontesUtil.FONTE_NORMAL);
        this.lblConta.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblConta.setText("Conta");
        this.edtConta.setCaracteresValidos("0123456789 ");
        this.edtConta.setMascara("********************");
        this.lblDV.setFont(FontesUtil.FONTE_NORMAL);
        this.lblDV.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblDV.setText("DV");
        ((JTextField)this.edtDV.getComponenteEditor()).setHorizontalAlignment(0);
        this.chkContaPagamento.setBackground(new Color(255, 255, 255));
        this.chkContaPagamento.setText("Conta Pagamento? ");
        this.chkContaPagamento.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelBensDetalhe.this.chkContaPagamentoActionPerformed(evt);
            }
        });
        GroupLayout pnlDadosBancariosLayout = new GroupLayout(this.pnlDadosBancarios);
        this.pnlDadosBancarios.setLayout(pnlDadosBancariosLayout);
        pnlDadosBancariosLayout.setHorizontalGroup(pnlDadosBancariosLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlDadosBancariosLayout.createSequentialGroup().addGroup(pnlDadosBancariosLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlDadosBancariosLayout.createSequentialGroup().addGroup(pnlDadosBancariosLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblAgencia).addComponent((Component)this.edtAgencia, -2, 111, -2)).addGap(18, 18, 18).addGroup(pnlDadosBancariosLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlDadosBancariosLayout.createSequentialGroup().addComponent(this.lblConta).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent((Component)this.lblInfo, -2, -1, -2)).addComponent((Component)this.edtConta, -2, 154, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlDadosBancariosLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblDV).addComponent((Component)this.edtDV, -2, 64, -2))).addGroup(pnlDadosBancariosLayout.createSequentialGroup().addComponent((Component)this.edtBanco, -2, 450, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chkContaPagamento)).addComponent(this.lblBanco, -2, 79, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        pnlDadosBancariosLayout.setVerticalGroup(pnlDadosBancariosLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlDadosBancariosLayout.createSequentialGroup().addComponent(this.lblBanco).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(pnlDadosBancariosLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.chkContaPagamento, -1, -1, Short.MAX_VALUE).addComponent((Component)this.edtBanco, -1, -1, Short.MAX_VALUE)).addGap(10, 10, 10).addGroup(pnlDadosBancariosLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlDadosBancariosLayout.createSequentialGroup().addComponent(this.lblAgencia).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.edtAgencia, -2, -1, -2)).addGroup(pnlDadosBancariosLayout.createSequentialGroup().addGap(2, 2, 2).addGroup(pnlDadosBancariosLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(pnlDadosBancariosLayout.createSequentialGroup().addComponent(this.lblDV).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.edtDV, -2, -1, -2)).addGroup(pnlDadosBancariosLayout.createSequentialGroup().addGroup(pnlDadosBancariosLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblConta).addComponent((Component)this.lblInfo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.edtConta, -2, -1, -2))))).addGap(0, 12, Short.MAX_VALUE)));
        this.edtAgencia.getAccessibleContext().setAccessibleName("Ag\u00eancia (sem DV)");
        this.edtBanco.getAccessibleContext().setAccessibleName("Banco");
        this.edtBanco.getAccessibleContext().setAccessibleDescription("");
        this.edtConta.getAccessibleContext().setAccessibleName("Conta");
        this.edtDV.getAccessibleContext().setAccessibleName("DV");
        this.edtDV.getAccessibleContext().setAccessibleDescription("");
        this.pnlBeneficiario.setBackground(new Color(255, 255, 255));
        this.lblDependente.setFont(FontesUtil.FONTE_NORMAL);
        this.lblDependente.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblDependente.setText("Nome do Dependente");
        this.tipoGroup.setBorder(null);
        this.tipoGroup.addGroupPanelListener(new GroupPanelListener(){

            public void atualizaPainel(GroupPanelEvent evt) {
                PainelBensDetalhe.this.tipoGroupAtualizaPainel(evt);
            }
        });
        this.rdbTitular.setBackground(new Color(255, 255, 255));
        this.rdbTitular.setText("Titular");
        this.rdbTitular.setFont(FontesUtil.FONTE_NORMAL);
        this.rdbTitular.setValorSelecionadoTrue("T");
        this.rdbTitular.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                PainelBensDetalhe.this.rdbTitularKeyPressed(evt);
            }
        });
        this.rdbDependente.setBackground(new Color(255, 255, 255));
        this.rdbDependente.setText("Dependente");
        this.rdbDependente.setFont(FontesUtil.FONTE_NORMAL);
        this.rdbDependente.setValorSelecionadoTrue("D");
        this.rdbDependente.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PainelBensDetalhe.this.rdbDependentePropertyChange(evt);
            }
        });
        this.rdbDependente.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                PainelBensDetalhe.this.rdbDependenteKeyPressed(evt);
            }
        });
        GroupLayout tipoGroupLayout = new GroupLayout((Container)this.tipoGroup);
        this.tipoGroup.setLayout((LayoutManager)tipoGroupLayout);
        tipoGroupLayout.setHorizontalGroup(tipoGroupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(tipoGroupLayout.createSequentialGroup().addComponent((Component)this.rdbTitular, -2, -1, -2).addGap(18, 18, 18).addComponent((Component)this.rdbDependente, -2, -1, -2).addContainerGap(36, Short.MAX_VALUE)));
        tipoGroupLayout.setVerticalGroup(tipoGroupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, tipoGroupLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addGroup(tipoGroupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.rdbTitular, -2, -1, -2).addComponent((Component)this.rdbDependente, -2, -1, -2))));
        this.rdbTitular.getAccessibleContext().setAccessibleName("Bem ou direito pertencente ao Titular");
        this.rdbDependente.getAccessibleContext().setAccessibleName("Bem ou direito pertencente ao Dependente");
        this.lblTipo.setFont(FontesUtil.FONTE_NORMAL);
        this.lblTipo.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblTipo.setText("Bem ou direito pertencente ao");
        GroupLayout pnlBeneficiarioLayout = new GroupLayout(this.pnlBeneficiario);
        this.pnlBeneficiario.setLayout(pnlBeneficiarioLayout);
        pnlBeneficiarioLayout.setHorizontalGroup(pnlBeneficiarioLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlBeneficiarioLayout.createSequentialGroup().addGroup(pnlBeneficiarioLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblDependente).addComponent(this.lblTipo).addComponent((Component)this.tipoGroup, -2, -1, -2).addComponent((Component)this.cmbDependente, -2, 376, -2)).addGap(0, 0, Short.MAX_VALUE)));
        pnlBeneficiarioLayout.setVerticalGroup(pnlBeneficiarioLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, pnlBeneficiarioLayout.createSequentialGroup().addComponent(this.lblTipo).addGap(0, 0, 0).addComponent((Component)this.tipoGroup, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblDependente).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent((Component)this.cmbDependente, -2, -1, -2).addGap(0, 0, 0)));
        this.cmbDependente.getAccessibleContext().setAccessibleName("Nome do Dependente");
        this.cmbDependente.getAccessibleContext().setAccessibleDescription("");
        this.jLabel5.setFont(FontesUtil.FONTE_NORMAL);
        this.jLabel5.setLabelFor((Component)this.edtCodigoBem);
        this.jLabel5.setText("Grupo");
        this.edtGrupo.setToolTipText("Grupo");
        this.lblNumeroRegistroBem.setFont(FontesUtil.FONTE_NORMAL);
        this.lblNumeroRegistroBem.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblNumeroRegistroBem.setText("IPTU");
        this.pnlNegociacaoBolsa.setBackground(new Color(255, 255, 255));
        this.lblNegociacao.setFont(FontesUtil.FONTE_NORMAL);
        this.lblNegociacao.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblNegociacao.setText("Negociados em Bolsa?");
        this.edtNegociadoBolsa.setBorder(null);
        this.edtNegociadoBolsa.setButtonMensagem(this.msgNegociadoBolsa);
        this.edtNegociadoBolsa.addGroupPanelListener(new GroupPanelListener(){

            public void atualizaPainel(GroupPanelEvent evt) {
                PainelBensDetalhe.this.edtNegociadoBolsaAtualizaPainel(evt);
            }
        });
        this.rdoNegociadoBolsaSim.setBackground(new Color(255, 255, 255));
        this.rdoNegociadoBolsaSim.setText("Sim");
        this.rdoNegociadoBolsaSim.setFont(FontesUtil.FONTE_NORMAL);
        this.rdoNegociadoBolsaSim.setValorSelecionadoTrue("1");
        this.rdoNegociadoBolsaSim.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                PainelBensDetalhe.this.rdoNegociadoBolsaSimFocusLost(evt);
            }
        });
        this.rdoNegociadoBolsaNao.setBackground(new Color(255, 255, 255));
        this.rdoNegociadoBolsaNao.setText("N\u00e3o");
        this.rdoNegociadoBolsaNao.setFont(FontesUtil.FONTE_NORMAL);
        this.rdoNegociadoBolsaNao.setValorSelecionadoTrue("0");
        this.rdoNegociadoBolsaNao.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                PainelBensDetalhe.this.rdoNegociadoBolsaNaoFocusLost(evt);
            }
        });
        this.msgNegociadoBolsa.setText("jButtonMensagem1");
        GroupLayout edtNegociadoBolsaLayout = new GroupLayout((Container)this.edtNegociadoBolsa);
        this.edtNegociadoBolsa.setLayout((LayoutManager)edtNegociadoBolsaLayout);
        edtNegociadoBolsaLayout.setHorizontalGroup(edtNegociadoBolsaLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(edtNegociadoBolsaLayout.createSequentialGroup().addComponent((Component)this.rdoNegociadoBolsaSim, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent((Component)this.rdoNegociadoBolsaNao, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 28, Short.MAX_VALUE).addComponent((Component)this.msgNegociadoBolsa, -2, -1, -2).addContainerGap()));
        edtNegociadoBolsaLayout.setVerticalGroup(edtNegociadoBolsaLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(edtNegociadoBolsaLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.rdoNegociadoBolsaSim, -2, -1, -2).addComponent((Component)this.rdoNegociadoBolsaNao, -2, -1, -2)).addComponent((Component)this.msgNegociadoBolsa, -2, -1, -2));
        this.rdoNegociadoBolsaSim.getAccessibleContext().setAccessibleName("Negociados em bolsa");
        this.rdoNegociadoBolsaNao.getAccessibleContext().setAccessibleName("N\u00e3o negociados em bolsa");
        this.lblCodNegociacao.setFont(FontesUtil.FONTE_NORMAL);
        this.lblCodNegociacao.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblCodNegociacao.setText("C\u00f3digo de Negocia\u00e7\u00e3o");
        GroupLayout pnlNegociacaoBolsaLayout = new GroupLayout(this.pnlNegociacaoBolsa);
        this.pnlNegociacaoBolsa.setLayout(pnlNegociacaoBolsaLayout);
        pnlNegociacaoBolsaLayout.setHorizontalGroup(pnlNegociacaoBolsaLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlNegociacaoBolsaLayout.createSequentialGroup().addGroup(pnlNegociacaoBolsaLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblNegociacao).addComponent((Component)this.edtNegociadoBolsa, -2, -1, -2)).addGap(82, 82, 82).addGroup(pnlNegociacaoBolsaLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.edtCodNegociacao, -2, 217, -2).addComponent(this.lblCodNegociacao)).addGap(0, 0, Short.MAX_VALUE)));
        pnlNegociacaoBolsaLayout.setVerticalGroup(pnlNegociacaoBolsaLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlNegociacaoBolsaLayout.createSequentialGroup().addGroup(pnlNegociacaoBolsaLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblNegociacao).addComponent(this.lblCodNegociacao)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlNegociacaoBolsaLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.edtNegociadoBolsa, -2, -1, -2).addComponent((Component)this.edtCodNegociacao, -2, -1, -2))));
        this.edtCodNegociacao.getAccessibleContext().setAccessibleName("C\u00f3digo de negocia\u00e7\u00e3o");
        this.lblCodCripto.setFont(FontesUtil.FONTE_NORMAL);
        this.lblCodCripto.setLabelFor((Component)this.edtLocalizacao);
        this.lblCodCripto.setText("C\u00f3digo Altcoin");
        this.lblAutoCustodiante.setText("\u00c9 autocustodiante? ");
        this.grpAutoCustodiante.setBorder(null);
        this.grpAutoCustodiante.addGroupPanelListener(new GroupPanelListener(){

            public void atualizaPainel(GroupPanelEvent evt) {
                PainelBensDetalhe.this.grpAutoCustodianteAtualizaPainel(evt);
            }
        });
        this.rdbAutoCustodianteSim.setBackground(new Color(255, 255, 255));
        this.rdbAutoCustodianteSim.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rdbAutoCustodianteSim.setText("Sim");
        this.rdbAutoCustodianteSim.setValorSelecionadoTrue("1");
        this.rdbAutoCustodianteNao.setBackground(new Color(255, 255, 255));
        this.rdbAutoCustodianteNao.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rdbAutoCustodianteNao.setText("N\u00e3o");
        this.rdbAutoCustodianteNao.setValorSelecionadoTrue("0");
        GroupLayout grpAutoCustodianteLayout = new GroupLayout((Container)this.grpAutoCustodiante);
        this.grpAutoCustodiante.setLayout((LayoutManager)grpAutoCustodianteLayout);
        grpAutoCustodianteLayout.setHorizontalGroup(grpAutoCustodianteLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(grpAutoCustodianteLayout.createSequentialGroup().addComponent((Component)this.rdbAutoCustodianteSim, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent((Component)this.rdbAutoCustodianteNao, -2, -1, -2).addContainerGap(44, Short.MAX_VALUE)));
        grpAutoCustodianteLayout.setVerticalGroup(grpAutoCustodianteLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(grpAutoCustodianteLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.rdbAutoCustodianteSim, -2, -1, -2).addComponent((Component)this.rdbAutoCustodianteNao, -2, -1, -2)));
        this.grpProprietarioUsufrutuario.setBorder(null);
        this.grpProprietarioUsufrutuario.addGroupPanelListener(new GroupPanelListener(){

            public void atualizaPainel(GroupPanelEvent evt) {
                PainelBensDetalhe.this.grpProprietarioUsufrutuarioAtualizaPainel(evt);
            }
        });
        this.rdbProprietario.setBackground(new Color(255, 255, 255));
        this.rdbProprietario.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rdbProprietario.setText("Propriet\u00e1rio");
        this.rdbProprietario.setValorSelecionadoTrue("1");
        this.rdbUsufrutuario.setBackground(new Color(255, 255, 255));
        this.rdbUsufrutuario.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rdbUsufrutuario.setText("Usufrutu\u00e1rio");
        this.rdbUsufrutuario.setValorSelecionadoTrue("2");
        GroupLayout grpProprietarioUsufrutuarioLayout = new GroupLayout((Container)this.grpProprietarioUsufrutuario);
        this.grpProprietarioUsufrutuario.setLayout((LayoutManager)grpProprietarioUsufrutuarioLayout);
        grpProprietarioUsufrutuarioLayout.setHorizontalGroup(grpProprietarioUsufrutuarioLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(grpProprietarioUsufrutuarioLayout.createSequentialGroup().addComponent((Component)this.rdbProprietario, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent((Component)this.rdbUsufrutuario, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        grpProprietarioUsufrutuarioLayout.setVerticalGroup(grpProprietarioUsufrutuarioLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(grpProprietarioUsufrutuarioLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.rdbProprietario, -2, -1, -2).addComponent((Component)this.rdbUsufrutuario, -2, -1, -2)));
        this.lblProprietarioUsufrutuario.setText("Voc\u00ea \u00e9:");
        this.chkBemComUsufruto.setBackground(new Color(255, 255, 255));
        this.chkBemComUsufruto.setText("Bem com usufruto? ");
        this.chkBemComUsufruto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelBensDetalhe.this.chkBemComUsufrutoActionPerformed(evt);
            }
        });
        this.btProprietarioUsufrutuario.setText("Usufrutu\u00e1rios");
        this.btProprietarioUsufrutuario.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelBensDetalhe.this.btProprietarioUsufrutuarioActionPerformed(evt);
            }
        });
        this.chkAtualizacaoValorBem.setBackground(new Color(255, 255, 255));
        this.chkAtualizacaoValorBem.setFont(FontesUtil.FONTE_NORMAL);
        this.chkAtualizacaoValorBem.setText("Houve a op\u00e7\u00e3o pela atualiza\u00e7\u00e3o deste bem de acordo com a Lei n\u00ba 14.973/2024?");
        this.chkAtualizacaoValorBem.setPreferredSize(new Dimension(503, 30));
        this.chkAtualizacaoValorBem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelBensDetalhe.this.chkAtualizacaoValorBemActionPerformed(evt);
            }
        });
        this.btnReclassificar.setText("Reclassificar");
        this.btnReclassificar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelBensDetalhe.this.btnReclassificarActionPerformed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.pnlBeneficiario, -1, -1, Short.MAX_VALUE).addContainerGap()).addComponent(this.pnlDadosBancarios, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.pnlNegociacaoBolsa, -1, -1, Short.MAX_VALUE).addComponent(this.pnlDadosBemImovel, GroupLayout.Alignment.TRAILING, 0, -1, Short.MAX_VALUE).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5).addComponent((Component)this.edtGrupo, -2, 485, -2).addComponent(this.jLabel2).addGroup(jPanel3Layout.createSequentialGroup().addComponent((Component)this.edtCodigoBem, -2, 485, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnReclassificar)).addComponent(this.jLabel3).addComponent((Component)this.edtLocalizacao, -2, 485, -2).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.lblNumeroRegistroBem, -2, 156, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.lblInfoIPTU, -2, -1, -2)).addComponent((Component)this.edtNumeroRegistroBem, -2, 319, -2)).addGap(13, 13, 13).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.edtDataAquisicao, -2, 158, -2).addComponent(this.lblDataAquisicao, -2, 135, -2))).addComponent(this.chkAtualizacaoValorBem, -2, 612, -2).addComponent(this.jLabel4).addComponent(this.lblNiBem, -2, 338, -2).addComponent((Component)this.edtNiBem, -2, 168, -2).addComponent((Component)this.edtDiscriminacao, -2, 637, -2).addComponent(this.lblCodCripto).addComponent((Component)this.edtCodigoCripto, -2, 485, -2).addComponent(this.lblAutoCustodiante).addComponent((Component)this.grpAutoCustodiante, -2, -1, -2).addComponent(this.chkBemComUsufruto).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.lblProprietarioUsufrutuario).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.grpProprietarioUsufrutuario, -2, -1, -2).addGap(37, 37, 37).addComponent(this.btProprietarioUsufrutuario))).addGap(0, 0, Short.MAX_VALUE)))));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.edtGrupo, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent((Component)this.edtCodigoBem, -2, -1, -2).addComponent(this.btnReclassificar)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pnlBeneficiario, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.edtLocalizacao, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.lblInfoIPTU, -2, -1, -2).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.lblDataAquisicao).addComponent(this.lblNumeroRegistroBem)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.edtDataAquisicao, -2, -1, -2).addComponent((Component)this.edtNumeroRegistroBem, -2, -1, -2)))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.chkAtualizacaoValorBem, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblCodCripto).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.edtCodigoCripto, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblAutoCustodiante).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.grpAutoCustodiante, -2, -1, -2).addGap(10, 10, 10).addComponent(this.lblNiBem).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.edtNiBem, -2, -1, -2).addGap(10, 10, 10).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.edtDiscriminacao, -2, 101, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.chkBemComUsufruto).addGap(12, 12, 12).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.lblProprietarioUsufrutuario).addComponent((Component)this.grpProprietarioUsufrutuario, -2, -1, -2))).addComponent(this.btProprietarioUsufrutuario)).addGap(5, 5, 5).addComponent(this.pnlDadosBemImovel, -2, -1, -2).addGap(5, 5, 5).addComponent(this.pnlDadosBancarios, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.pnlNegociacaoBolsa, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.edtCodigoBem.getAccessibleContext().setAccessibleName("C\u00f3digo");
        this.edtLocalizacao.getAccessibleContext().setAccessibleName("Localiza\u00e7\u00e3o (Pa\u00eds)");
        this.edtDiscriminacao.getAccessibleContext().setAccessibleName("Discrimina\u00e7\u00e3o");
        this.edtNumeroRegistroBem.getAccessibleContext().setAccessibleDescription(this.bem != null ? (this.bem.isBemImovelRegistravel() ? MensagemUtil.getMensagem((String)"bem_info_iptu") : "") : "");
        this.edtDataAquisicao.getAccessibleContext().setAccessibleName("Data de Aquisi\u00e7\u00e3o");
        this.edtDataAquisicao.getAccessibleContext().setAccessibleDescription("");
        this.edtGrupo.getAccessibleContext().setAccessibleName("Grupo");
        this.pnlRendimentos.setBorder(BorderFactory.createTitledBorder(null, "Rendimentos Associados", 1, 0, FontesUtil.FONTE_TITULO_NORMAL, new Color(0, 74, 106)));
        this.pnlRendimentos.setOpaque(false);
        this.jPanel4.setOpaque(false);
        this.jPanel4.setLayout(new FlowLayout(1, 10, 5));
        this.btnRendIsento.setText("Informar Rend. Isento");
        this.btnRendIsento.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelBensDetalhe.this.btnRendIsentoActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.btnRendIsento);
        this.btnRendExclusivo.setText("Informar Rend. Exclusivo");
        this.btnRendExclusivo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelBensDetalhe.this.btnRendExclusivoActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.btnRendExclusivo);
        GroupLayout pnlRendimentosLayout = new GroupLayout(this.pnlRendimentos);
        this.pnlRendimentos.setLayout(pnlRendimentosLayout);
        pnlRendimentosLayout.setHorizontalGroup(pnlRendimentosLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlRendimentosLayout.createSequentialGroup().addComponent(this.jPanel4, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)));
        pnlRendimentosLayout.setVerticalGroup(pnlRendimentosLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel4, -2, 49, -2));
        this.pnlAplicacaoFinanceira.setBorder(BorderFactory.createTitledBorder(null, "Aplica\u00e7\u00e3o Financeira", 1, 0, FontesUtil.FONTE_TITULO_NORMAL, new Color(0, 74, 106)));
        this.pnlAplicacaoFinanceira.setOpaque(false);
        this.lblLucroPrejuizo.setFont(FontesUtil.FONTE_NORMAL);
        this.lblLucroPrejuizo.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblLucroPrejuizo.setText("Lucro ou Preju\u00edzo");
        this.edtLucroPrejuizo.setAceitaNumerosNegativos(true);
        this.lblImpostoPagoExt.setFont(FontesUtil.FONTE_NORMAL);
        this.lblImpostoPagoExt.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblImpostoPagoExt.setText("Imposto pago no Exterior ");
        this.lblMsgDepositoRemunerado.setFont(FontesUtil.FONTE_NORMAL);
        this.lblMsgDepositoRemunerado.setForeground(Color.red);
        this.lblMsgDepositoRemunerado.setText("Somente se forem remunerados");
        GroupLayout pnlAplicacaoFinanceiraLayout = new GroupLayout(this.pnlAplicacaoFinanceira);
        this.pnlAplicacaoFinanceira.setLayout(pnlAplicacaoFinanceiraLayout);
        pnlAplicacaoFinanceiraLayout.setHorizontalGroup(pnlAplicacaoFinanceiraLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlAplicacaoFinanceiraLayout.createSequentialGroup().addContainerGap().addGroup(pnlAplicacaoFinanceiraLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblLucroPrejuizo).addComponent((Component)this.edtLucroPrejuizo, -2, 156, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlAplicacaoFinanceiraLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblImpostoPagoExt).addGroup(pnlAplicacaoFinanceiraLayout.createSequentialGroup().addComponent((Component)this.edtImpostoPagoExt, -2, 156, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblMsgDepositoRemunerado))).addContainerGap(-1, Short.MAX_VALUE)));
        pnlAplicacaoFinanceiraLayout.setVerticalGroup(pnlAplicacaoFinanceiraLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlAplicacaoFinanceiraLayout.createSequentialGroup().addContainerGap().addGroup(pnlAplicacaoFinanceiraLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(pnlAplicacaoFinanceiraLayout.createSequentialGroup().addComponent(this.lblImpostoPagoExt).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlAplicacaoFinanceiraLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.edtImpostoPagoExt, -2, -1, -2).addComponent(this.lblMsgDepositoRemunerado))).addGroup(pnlAplicacaoFinanceiraLayout.createSequentialGroup().addComponent(this.lblLucroPrejuizo).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.edtLucroPrejuizo, -2, -1, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        this.pnlLucrosDividendos.setBorder(BorderFactory.createTitledBorder(null, "Lucros e Dividendos", 1, 0, FontesUtil.FONTE_TITULO_NORMAL, new Color(0, 74, 106)));
        this.pnlLucrosDividendos.setOpaque(false);
        this.lblValorRecebido.setFont(FontesUtil.FONTE_NORMAL);
        this.lblValorRecebido.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblValorRecebido.setText("Valor Recebido");
        this.lblImpostoExteriorIRRF.setFont(FontesUtil.FONTE_NORMAL);
        this.lblImpostoExteriorIRRF.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblImpostoExteriorIRRF.setText("Imposto Pago Exterior/IRRF Brasil");
        GroupLayout pnlLucrosDividendosLayout = new GroupLayout(this.pnlLucrosDividendos);
        this.pnlLucrosDividendos.setLayout(pnlLucrosDividendosLayout);
        pnlLucrosDividendosLayout.setHorizontalGroup(pnlLucrosDividendosLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlLucrosDividendosLayout.createSequentialGroup().addContainerGap().addGroup(pnlLucrosDividendosLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblValorRecebido).addComponent((Component)this.edtValorRecebido, -2, 156, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlLucrosDividendosLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblImpostoExteriorIRRF).addComponent((Component)this.edtImpostoExteriorIRRF, -2, 156, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        pnlLucrosDividendosLayout.setVerticalGroup(pnlLucrosDividendosLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlLucrosDividendosLayout.createSequentialGroup().addContainerGap().addGroup(pnlLucrosDividendosLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(pnlLucrosDividendosLayout.createSequentialGroup().addComponent(this.lblImpostoExteriorIRRF).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.edtImpostoExteriorIRRF, -2, -1, -2)).addGroup(pnlLucrosDividendosLayout.createSequentialGroup().addComponent(this.lblValorRecebido).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.edtValorRecebido, -2, -1, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pnlRendimentos, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.pnlAplicacaoFinanceira, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.pnlLucrosDividendos, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.pnlRendimentos, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.pnlAplicacaoFinanceira, -1, -1, Short.MAX_VALUE).addComponent(this.pnlLucrosDividendos, -1, -1, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jLabel1.setFont(FontesUtil.FONTE_TITULO_NORMAL);
        this.jLabel1.setForeground(new Color(0, 74, 106));
        this.jLabel1.setText("Dados do Bem");
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    private void btnRepetirActionPerformed(ActionEvent evt) {
        this.edtValorAtual.getInformacao().setConteudo(this.edtValorAnterior.getInformacao().formatado());
    }

    private void rdoUnidadeHaFocusLost(FocusEvent evt) {
        if (evt.getOppositeComponent() != this.rdoUnidadeM2) {
            this.edtUnidade.chamaValidacao();
        }
    }

    private void rdoUnidadeM2FocusLost(FocusEvent evt) {
        if (evt.getOppositeComponent() != this.rdoUnidadeHa) {
            this.edtUnidade.chamaValidacao();
        }
    }

    private void edtRegistroCartorioAtualizaPainel(GroupPanelEvent evt) {
        this.habilitaCampoBemImovelRegistrado(evt.getInformacao().naoFormatado(), this.getBem().getPais().naoFormatado());
    }

    private void rdoRegistroCartorioNaoFocusLost(FocusEvent evt) {
        if (evt.getOppositeComponent() != this.rdoRegistroCartorioSim) {
            this.edtRegistroCartorio.chamaValidacao();
        }
    }

    private void rdoRegistroCartorioSimFocusLost(FocusEvent evt) {
        if (evt.getOppositeComponent() != this.rdoRegistroCartorioNao) {
            this.edtRegistroCartorio.chamaValidacao();
        }
    }

    private void edtNiBemFocusLost(FocusEvent evt) {
        this.edtNiBem.chamaValidacao();
    }

    private void rdbTitularKeyPressed(KeyEvent evt) {
    }

    private void rdbDependenteKeyPressed(KeyEvent evt) {
    }

    private void tipoGroupAtualizaPainel(GroupPanelEvent evt) {
        this.atualizaGui(this.getBem().getGrupo().naoFormatado(), this.getBem().getCodigo().naoFormatado(), evt.getInformacao().naoFormatado());
        if (this.rdbTitular.isSelected()) {
            this.cmbDependente.getInformacao().clear();
            this.cmbDependente.setConteudo("");
            this.getBem().getCPFBeneficiario().setConteudo(ControladorGui.getDemonstrativoAberto().getCopiaIdentificador().getCpf().naoFormatado());
        }
    }

    private void rdbDependentePropertyChange(PropertyChangeEvent evt) {
    }

    private void btnRendIsentoActionPerformed(ActionEvent evt) {
        String codigoRendimento = this.bem.buscarTipoRendimentoIsento(this.bem.getGrupo().naoFormatado(), this.bem.getCodigo().naoFormatado());
        ItemQuadroAuxiliarAb rendimento = this.bem.buscarRendimentoIsentoAssociado(codigoRendimento, ControladorGui.getDemonstrativoAberto());
        boolean novoItemBem = false;
        if (rendimento == null && (rendimento = this.bem.buscarRendimentoIsentoVazio(ControladorGui.getDemonstrativoAberto())) == null) {
            rendimento = ControladorGui.getDemonstrativoAberto().getRendIsentos().criarNovoRendimentoIsento(this.bem, codigoRendimento);
            novoItemBem = true;
        }
        if (RendIsentos.TIPO_RENDISENTO_26.equals(codigoRendimento)) {
            codigoRendimento = RendIsentos.TIPO_RENDISENTO_OUTROS_TELA;
        }
        PainelDadosRendIsentos painelPai = new PainelDadosRendIsentos();
        PainelAbaRendIsentosDetalhes painelRendIsentos = new PainelAbaRendIsentosDetalhes((PainelDemonstrativoIf)painelPai, codigoRendimento, rendimento, true, novoItemBem);
        ControladorGui.acionarPainel((PainelDemonstrativoIf)painelRendIsentos);
        JTaskAction task = new JTaskAction("Rendimentos Isentos e N\u00e3o Tribut\u00e1veis", NavegacaoIf.PAINEL_REND_ISENTOS, (Icon)GuiUtil.getImage((String)"/icones/png20px/DE_rend_isent.png"), true);
        ControladorGui.getJanelaPrincipal().getAbas().setFicha("Rendimentos Isentos e N\u00e3o Tribut\u00e1veis", task, true);
    }

    private void btnRendExclusivoActionPerformed(ActionEvent evt) {
        String codigoRendimento = this.bem.buscarTipoRendimentoExclusivo(this.bem.getGrupo().naoFormatado(), this.bem.getCodigo().naoFormatado());
        ItemQuadroAuxiliarAb rendimento = this.bem.buscarRendimentoExclusivoAssociado(codigoRendimento, ControladorGui.getDemonstrativoAberto());
        boolean novoItemBem = false;
        if (rendimento == null && (rendimento = this.bem.buscarRendimentoExclusivoVazio(ControladorGui.getDemonstrativoAberto())) == null) {
            rendimento = ControladorGui.getDemonstrativoAberto().getRendTributacaoExclusiva().criarNovoRendimentoExclusivo(this.bem, codigoRendimento);
            novoItemBem = true;
        }
        PainelDadosRendTributExclusiva painelPai = new PainelDadosRendTributExclusiva();
        PainelAbaRendTributEclusivaDetalhes painelRendExclusivo = new PainelAbaRendTributEclusivaDetalhes((PainelDemonstrativoIf)painelPai, codigoRendimento, rendimento, true, novoItemBem);
        ControladorGui.acionarPainel((PainelDemonstrativoIf)painelRendExclusivo);
        JTaskAction task = new JTaskAction("Rendimentos Sujeitos \u00e0 Tributa\u00e7\u00e3o Exclusiva/Definitiva", NavegacaoIf.PAINEL_REND_SUJ_TRIB_EXCLUSIVA, (Icon)GuiUtil.getImage((String)"/icones/png20px/DE_rend_excl.png"), true);
        ControladorGui.getJanelaPrincipal().getAbas().setFicha("Rendimentos Sujeitos \u00e0 Tributa\u00e7\u00e3o Exclusiva/Definitiva", task, true);
    }

    private void rdoNegociadoBolsaSimFocusLost(FocusEvent evt) {
        this.edtNegociadoBolsa.chamaValidacao();
    }

    private void rdoNegociadoBolsaNaoFocusLost(FocusEvent evt) {
    }

    private void edtNegociadoBolsaAtualizaPainel(GroupPanelEvent evt) {
        this.habilitaCampoCodigoNegociacao(evt.getInformacao().naoFormatado());
    }

    private void grpAutoCustodianteAtualizaPainel(GroupPanelEvent evt) {
        this.habilitarCampoNI(this.getBem().getGrupo().naoFormatado(), this.getBem().getCodigo().naoFormatado(), this.getBem().getPais().naoFormatado(), evt.getInformacao().naoFormatado());
    }

    private void grpProprietarioUsufrutuarioAtualizaPainel(GroupPanelEvent evt) {
        this.habilitaInformacaoCPFCNPJProprietarioUsufrutuario(evt.getInformacao().naoFormatado());
    }

    private void chkBemComUsufrutoActionPerformed(ActionEvent evt) {
        this.bem.getIndicadorBemComUsufruto().setConteudo(this.chkBemComUsufruto.isSelected() ? "1" : "0");
        this.habilitarRadioProprietarioUsufrutuario();
    }

    private void btProprietarioUsufrutuarioActionPerformed(ActionEvent evt) {
        GuiUtil.exibeDialog((JComponent)((Object)new PainelQuadroAuxiliarProprietariosUsufrutuariosLista(this.bem.getProprietariosUsufrutuariosBem(), "Proprietarios/Usufrutuarios", this.bem.getIndice().naoFormatado())), (boolean)true, (String)"Proprietarios/Usufrutuarios", (boolean)true);
    }

    private void chkAtualizacaoValorBemActionPerformed(ActionEvent evt) {
        if (this.chkAtualizacaoValorBem.isSelected()) {
            this.bem.getAtualizadoValorBem().setConteudo(Logico.SIM);
        } else {
            this.bem.getAtualizadoValorBem().setConteudo(Logico.NAO);
        }
    }

    private void chkContaPagamentoActionPerformed(ActionEvent evt) {
        this.bem.getIndicadorContaPagamento().setConteudo(this.chkContaPagamento.isSelected() ? "1" : "0");
    }

    private void btnReclassificarActionPerformed(ActionEvent evt) {
        if ("99".equals(this.bem.getGrupo().naoFormatado()) && "99".equals(this.bem.getCodigo().naoFormatado())) {
            GuiUtil.exibeDialog((JComponent)((Object)new PainelSelecaoGrupoCodigoBem(this.bem, this)), (boolean)true, (String)"Selecione o Grupo/c\u00f3digo do bem", (boolean)false);
        } else {
            GuiUtil.exibeDialog((JComponent)((Object)new PainelSelecaoCodigoBem(this.bem, this)), (boolean)true, (String)"Selecione o c\u00f3digo do bem", (boolean)false);
        }
    }

    public ImageIcon getImagemTitulo() {
        return GuiUtil.getImage((String)"/icones/png40px/DE_bens.png");
    }

    public JComponent getDefaultFocus() {
        return this.edtGrupo;
    }

    public String getTituloPainel() {
        boolean ehTransmitida = IRPFFacade.getInstancia().getDeclaracao().getCopiaIdentificador().isTransmitida();
        if (this.emEdicao) {
            if (ehTransmitida) {
                return "Detalhe Bem e Direito";
            }
            return "Editar Bem e Direito";
        }
        return "Novo Bem e Direito";
    }

    public void executaVoltar() {
        ControladorGui.acionarPainel((String)NavegacaoIf.PAINEL_BENS_DIREITOS);
    }

    public boolean isTelaComVoltar() {
        return true;
    }

    public boolean isTelaComCancelar() {
        return true;
    }

    public void executaCancelar() {
        if (this.emEdicao) {
            int posicao = ControladorGui.getDemonstrativoAberto().getBens().itens().indexOf(this.bem);
            ControladorGui.getDemonstrativoAberto().getBens().remove((ObjetoNegocio)this.bem);
            ControladorGui.getDemonstrativoAberto().getBens().itens().add(posicao, this.itemInicial);
        } else {
            ControladorGui.getDemonstrativoAberto().getBens().remove((ObjetoNegocio)this.bem);
        }
        ControladorGui.acionarPainel((String)NavegacaoIf.PAINEL_BENS_DIREITOS);
    }

    public void preExibir() {
        this.alterarLabel();
        this.habilitarCampoBanco(this.bem.getPais().naoFormatado(), this.bem.getGrupo().naoFormatado(), this.bem.getCodigo().naoFormatado());
        this.atualizaGui(this.getBem().getGrupo().naoFormatado(), this.getBem().getCodigo().naoFormatado(), this.getBem().getTipo().naoFormatado());
        if (!this.existemDependentes()) {
            this.tipoGroup.getInformacao().setConteudo("T");
            this.tipoGroup.getInformacao().setHabilitado(false);
        } else {
            this.tipoGroup.getInformacao().setHabilitado(true);
        }
        this.corrigirCNPJRendimentos();
        this.habilitarSelecaoGrupoCodigo();
        if (this.emEdicao) {
            this.exibirMensagem524ou525(this.bem.getGrupo().naoFormatado(), this.bem.getPais().naoFormatado());
        }
    }

    private void corrigirCNPJRendimentos() {
        String codigoRendimento = this.bem.buscarTipoRendimentoIsento(this.bem.getGrupo().naoFormatado(), this.bem.getCodigo().naoFormatado());
        ItemQuadroAuxiliarAb rendimento = this.bem.buscarRendimentoIsentoAssociado(codigoRendimento, ControladorGui.getDemonstrativoAberto());
        if (rendimento != null) {
            rendimento.getNIFontePagadora().setConteudo(this.bem.getNiEmpresa());
        }
        if ((rendimento = this.bem.buscarRendimentoExclusivoAssociado(codigoRendimento = this.bem.buscarTipoRendimentoExclusivo(this.bem.getGrupo().naoFormatado(), this.bem.getCodigo().naoFormatado()), ControladorGui.getDemonstrativoAberto())) != null) {
            rendimento.getNIFontePagadora().setConteudo(this.bem.getNiEmpresa());
        }
    }

    private void alterarLabel() {
        if (this.isEspolio()) {
            this.lbSituacaoAnoAnterior.setText("Situa\u00e7\u00e3o na data da partilha (R$)");
            this.lbSituacaoAnoAtual.setText("Valor de transfer\u00eancia (R$)");
            this.lbRepetir.setText("<HTML>Se o valor de transfer\u00eancia for igual<BR>ao valor na data da partilha</HTML>");
        } else if (this.isSaida()) {
            if (ControladorGui.getDemonstrativoAberto().entrouSaiuNoMesmoAno()) {
                this.lbSituacaoAnoAnterior.setText("<HTML>Situa\u00e7\u00e3o na data da<br>caracteriza\u00e7\u00e3o da condi\u00e7\u00e3o de<br>residente (R$)</HTML>");
            } else {
                this.lbSituacaoAnoAnterior.setText("Situa\u00e7\u00e3o em 31/12/" + ConstantesGlobais.ANO_BASE_ANTERIOR + " (R$)");
            }
            this.lbSituacaoAnoAtual.setText("<HTML>Situa\u00e7\u00e3o na data da<BR>caracteriza\u00e7\u00e3o da condi\u00e7\u00e3o de<br>n\u00e3o residente (R$)</HTML>");
            this.lbRepetir.setText("<HTML>Se o valor na data da caracteriza\u00e7\u00e3o de n\u00e3o residente for igual ao valor de 31/12/" + ConstantesGlobais.ANO_BASE_ANTERIOR + "</HTML>");
        } else {
            this.lbSituacaoAnoAnterior.setText("Situa\u00e7\u00e3o em 31/12/" + ConstantesGlobais.ANO_BASE_ANTERIOR + " (R$)");
            this.lbSituacaoAnoAtual.setText("Situa\u00e7\u00e3o em 31/12/" + ConstantesGlobais.ANO_BASE + " (R$)");
            this.lbRepetir.setText("<HTML>Repete em 31/12/" + ConstantesGlobais.ANO_BASE + " o valor<BR>em reais de 31/12/" + ConstantesGlobais.ANO_BASE_ANTERIOR + "</HTML>");
        }
    }

    private boolean existemDependentes() {
        int cont = 0;
        DeclaracaoIRPF declaracaoIRPF = ControladorGui.getDemonstrativoAberto();
        Dependentes dependentes = declaracaoIRPF.getDependentes();
        for (ObjetoNegocio dependente : dependentes.itens()) {
            ++cont;
        }
        return cont > 0;
    }

    private void atualizaGui(String grupo, String codigo, String tipo) {
        if (!Bem.isBemComBeneficiario((String)grupo, (String)codigo)) {
            this.pnlBeneficiario.setVisible(false);
        }
        if (!tipo.equals("D")) {
            this.lblDependente.setVisible(false);
            this.cmbDependente.setVisible(false);
        }
        if (tipo.equals("D") && this.getBem().getCPFBeneficiario().naoFormatado().equals(ControladorGui.getDemonstrativoAberto().getIdentificadorDeclaracao().getCpf().naoFormatado())) {
            this.cmbDependente.getInformacao().clear();
            this.cmbDependente.setConteudo("");
        }
        if (tipo.equals("D")) {
            this.lblDependente.setVisible(true);
            this.cmbDependente.setDados(CadastroTabelasIRPF.recuperarDependentesCPFValido());
            this.cmbDependente.setVisible(true);
        }
        this.ajustarTipoNI(grupo, codigo);
    }

    private void habilitarBotoesRendimento(String grupo, String codBem) {
        boolean localizacaoBrasil = true;
        if (((JComboBox)this.edtLocalizacao.getComponenteEditor()).getSelectedIndex() != -1) {
            ElementoTabela elem = (ElementoTabela)((JComboBox)this.edtLocalizacao.getComponenteEditor()).getSelectedItem();
            if (!"105".equals(elem.getConteudo(0))) {
                localizacaoBrasil = false;
            }
        } else {
            localizacaoBrasil = false;
        }
        String isento = this.bem.buscarTipoRendimentoIsento(grupo, codBem);
        String exclusivo = this.bem.buscarTipoRendimentoExclusivo(grupo, codBem);
        this.pnlRendimentos.setVisible(localizacaoBrasil && (isento != null || exclusivo != null));
        this.btnRendIsento.setVisible(isento != null);
        this.btnRendExclusivo.setVisible(exclusivo != null);
    }

    private byte obterTipoNI(String grupo, String codBem) {
        int retorno = 0;
        if ("07".equals(grupo) && !codBem.isEmpty() && !codBem.equals("-1")) {
            retorno = 2;
        }
        return (byte)retorno;
    }

    private void ajustarTipoNI(String grupo, String codBem) {
        if (this.obterTipoNI(grupo, codBem) == 2 && this.edtNiBem.getInformacao().naoFormatado().length() != 14) {
            this.edtNiBem.setarMascaraCNPJ();
        } else if (this.obterTipoNI(grupo, codBem) == 1 && this.edtNiBem.getInformacao().naoFormatado().length() != 11) {
            this.edtNiBem.setarMascaraCPF();
        }
    }

    private boolean isEspolio() {
        return IRPFFacade.getInstancia().getIdDeclaracaoAberto().isEspolio();
    }

    private boolean isSaida() {
        return IRPFFacade.getInstancia().getIdDeclaracaoAberto().isSaida();
    }

    public Bem getBem() {
        return this.bem;
    }

    public String getHelpID() {
        return HELP_ID;
    }

    public boolean isTelaComFavoritos() {
        return false;
    }

    public String getMensagemTela() {
        return this.obterMensagemTela();
    }

    public boolean isTelaComMensagem() {
        return this.obterMensagemTela() != null;
    }

    private String obterMensagemTela() {
        String msg = null;
        if (this.bem.getGrupo().naoFormatado().equals("07") && this.bem.getIndicadorReclassificar().naoFormatado().equals("1") && this.bem.getCodigo().naoFormatado().equals("99")) {
            msg = MensagemUtil.getMensagem((String)"bem_07_99_reclassificar");
        }
        return msg;
    }

    private void habilitarSelecaoGrupoCodigo() {
        if (this.bem.getIndicadorReclassificar().naoFormatado().equals("1")) {
            this.edtGrupo.getComponenteFoco().setEnabled(false);
            this.edtCodigoBem.getComponenteFoco().setEnabled(false);
            this.btnReclassificar.setVisible(true);
        } else {
            this.edtGrupo.getComponenteFoco().setEnabled(true);
            this.edtCodigoBem.getComponenteFoco().setEnabled(true);
            this.btnReclassificar.setVisible(false);
        }
    }

    private void confirmarReclassificacao(String codBem) {
        if (!"-1".equals(codBem) && this.bem.getIndicadorReclassificar().naoFormatado().equals("1")) {
            this.bem.getIndicadorReclassificar().setConteudo("2");
        }
    }

    public JAutoCompleteEditCodigo getEdtGrupoBem() {
        return this.edtGrupo;
    }

    public JAutoCompleteEditCodigo getEdtCodigoBem() {
        return this.edtCodigoBem;
    }

    public JButton getBtnReclassificar() {
        return this.btnReclassificar;
    }
}

