/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.doacaodiretamentedeclaracao;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import serpro.ppgd.gui.xbeans.GroupPanelEvent;
import serpro.ppgd.gui.xbeans.GroupPanelListener;
import serpro.ppgd.gui.xbeans.JButtonGroupPanel;
import serpro.ppgd.gui.xbeans.JButtonMensagem;
import serpro.ppgd.gui.xbeans.JEditCNPJ;
import serpro.ppgd.gui.xbeans.JEditCodigo;
import serpro.ppgd.gui.xbeans.JEditValor;
import serpro.ppgd.gui.xbeans.PPGDRadioItem;
import serpro.ppgd.gui.xbeans.autocomplete.JAutoCompleteEditCodigo;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.infraestrutura.util.FontesUtil;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.doacaodeclaracao.EstatutoIdoso;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.NavegacaoIf;
import serpro.ppgd.irpf.gui.PainelDemonstrativoAb;
import serpro.ppgd.irpf.gui.componente.JEditValorTotal;
import serpro.ppgd.irpf.gui.doacaodiretamentedeclaracao.PainelMensagemDoacaoExcedidaIdoso;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.irpf.tabelas.TabelaAliquotasIRPF;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.RetornoValidacao;

public class PainelAbaEstatutoIdosoDetalhe
extends PainelDemonstrativoAb {
    private static final long serialVersionUID = 1L;
    private static final String TITULO = "<html>Doa\u00e7\u00f5es Diretamente na Declara\u00e7\u00e3o<br>Fundos Nacional, Distrital, Estaduais e Municipais da Pessoa Idosa</html>";
    private static final String HELP_ID = "Fichas da Declara\u00e7\u00e3o/Doa\u00e7\u00f5es Diretamente na Declara\u00e7\u00e3o";
    private boolean novoItem = false;
    private boolean podeAcionarExecutarVoltar = true;
    private boolean clicouEmVoltar = false;
    private EstatutoIdoso estatutoIdoso = null;
    private EstatutoIdoso itemInicial = null;
    private JButtonMensagem btnMsgTipoFundo;
    public JAutoCompleteEditCodigo edtAutoCompMunicipio;
    private JEditCNPJ edtCNPJ;
    public JEditCodigo edtUf;
    private JEditValor edtValor;
    private JEditValorTotal edtValorDisponivelDoacao;
    private JButtonGroupPanel groupTipoFundo;
    private JPanel jPanel1;
    private JLabel lblCNPJ;
    private JLabel lblDadosDoacao;
    private JLabel lblMunicipio;
    private JLabel lblTipoFundo;
    private JLabel lblUf;
    private JLabel lblValor;
    private JLabel lblValorDisponivelDoacao;
    private PPGDRadioItem rdbEstadualDistrital;
    private PPGDRadioItem rdbMunicipal;
    private PPGDRadioItem rdbNacional;

    public PainelAbaEstatutoIdosoDetalhe() {
        PlataformaPPGD.getPlataforma().setHelpID((JComponent)((Object)this), HELP_ID);
        this.initComponents();
    }

    public PainelAbaEstatutoIdosoDetalhe(EstatutoIdoso estatutoIdoso, boolean flagNovoItem) {
        this();
        this.novoItem = flagNovoItem;
        this.estatutoIdoso = estatutoIdoso;
        if (!this.novoItem) {
            this.itemInicial = estatutoIdoso.obterCopia();
        }
        PPGDRadioItem radioVazio = new PPGDRadioItem();
        radioVazio.setText("Vazio");
        radioVazio.setValorSelecionadoTrue("V");
        this.groupTipoFundo.adicionaOpcao((Component)radioVazio);
        this.groupTipoFundo.addGroupPanelListener(new GroupPanelListener(){

            public void atualizaPainel(GroupPanelEvent gpe) {
                Alfa tipoFundo = (Alfa)gpe.getInformacao();
                PainelAbaEstatutoIdosoDetalhe.this.alterarVisibilidade(tipoFundo);
            }
        });
        this.associarInformacao(estatutoIdoso);
        this.alterarVisibilidade(estatutoIdoso.getTipoFundo());
        estatutoIdoso.getCnpjFundo().setReadOnly(true);
        this.adicionarLostFocusValor();
    }

    private void adicionarLostFocusValor() {
        ((JTextField)this.edtValor.getComponenteEditor()).addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                RetornoValidacao retorno = PainelAbaEstatutoIdosoDetalhe.this.estatutoIdoso.getValor().validar().getPrimeiroRetornoValidacaoMaisSevero();
                if (retorno.getSeveridade() == 3) {
                    PainelAbaEstatutoIdosoDetalhe.this.podeAcionarExecutarVoltar = false;
                    String msgErroDARFMenor10Reais = MensagemUtil.getMensagem((String)"doacoes_diretamente_dec_limite_minimo", (String[])new String[]{TabelaAliquotasIRPF.ConstantesAliquotas.valorMinIAP.getValor().formatado()});
                    if (!msgErroDARFMenor10Reais.equals(retorno.getMensagemValidacao()) && PainelAbaEstatutoIdosoDetalhe.this.estatutoIdoso.getValor().comparacao(">", ControladorGui.getDemonstrativoAberto().getColecaoEstatutoIdoso().getValorDisponivelDoacao())) {
                        GuiUtil.exibeDialog((JComponent)new PainelMensagemDoacaoExcedidaIdoso(), (boolean)true, (String)"Erro", (boolean)false);
                        PainelAbaEstatutoIdosoDetalhe.this.estatutoIdoso.getValor().clear();
                    }
                    if (PainelAbaEstatutoIdosoDetalhe.this.clicouEmVoltar) {
                        ControladorGui.acionarPainel((String)NavegacaoIf.PAINEL_DOACOES_DIRET_DEC);
                    }
                }
                PainelAbaEstatutoIdosoDetalhe.this.podeAcionarExecutarVoltar = true;
            }
        });
    }

    protected void associarInformacao(EstatutoIdoso estatutoIdoso) {
        if (estatutoIdoso.getTipoFundo().isVazio()) {
            estatutoIdoso.getTipoFundo().setConteudo("V");
        }
        this.groupTipoFundo.setInformacao((Informacao)estatutoIdoso.getTipoFundo());
        this.edtUf.setInformacao((Informacao)estatutoIdoso.getUf());
        this.edtAutoCompMunicipio.setInformacao((Informacao)estatutoIdoso.getMunicipio());
        this.edtValor.setInformacao((Informacao)estatutoIdoso.getValor());
        this.edtCNPJ.setInformacao((Informacao)estatutoIdoso.getCnpjFundo());
    }

    private void alterarVisibilidade(Alfa tipoFundo) {
        if (tipoFundo.naoFormatado().equals("N")) {
            this.lblUf.setVisible(false);
            this.edtUf.setVisible(false);
            this.lblMunicipio.setVisible(false);
            this.edtAutoCompMunicipio.setVisible(false);
            this.lblCNPJ.setVisible(true);
            this.edtCNPJ.setVisible(true);
        } else if (tipoFundo.naoFormatado().equals("E")) {
            this.lblUf.setVisible(true);
            this.edtUf.setVisible(true);
            this.lblMunicipio.setVisible(false);
            this.edtAutoCompMunicipio.setVisible(false);
            this.lblCNPJ.setVisible(true);
            this.edtCNPJ.setVisible(true);
        } else if (tipoFundo.naoFormatado().equals("M")) {
            this.lblUf.setVisible(true);
            this.edtUf.setVisible(true);
            this.lblMunicipio.setVisible(true);
            this.edtAutoCompMunicipio.setVisible(true);
            this.lblCNPJ.setVisible(false);
            this.edtCNPJ.setVisible(false);
        } else if (tipoFundo.naoFormatado().equals("V")) {
            this.lblUf.setVisible(false);
            this.edtUf.setVisible(false);
            this.lblMunicipio.setVisible(false);
            this.edtAutoCompMunicipio.setVisible(false);
            this.lblCNPJ.setVisible(false);
            this.edtCNPJ.setVisible(false);
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.lblValor = new JLabel();
        this.edtValor = new JEditValor();
        this.lblTipoFundo = new JLabel();
        this.groupTipoFundo = new JButtonGroupPanel();
        this.rdbNacional = new PPGDRadioItem();
        this.rdbEstadualDistrital = new PPGDRadioItem();
        this.rdbMunicipal = new PPGDRadioItem();
        this.btnMsgTipoFundo = new JButtonMensagem();
        this.lblUf = new JLabel();
        this.edtUf = new JEditCodigo();
        this.lblMunicipio = new JLabel();
        this.edtAutoCompMunicipio = new JAutoCompleteEditCodigo();
        this.edtCNPJ = new JEditCNPJ();
        this.lblCNPJ = new JLabel();
        this.lblDadosDoacao = new JLabel();
        this.lblValorDisponivelDoacao = new JLabel();
        this.edtValorDisponivelDoacao = new JEditValorTotal();
        this.setBackground(new Color(241, 245, 249));
        this.setForeground(new Color(255, 255, 255));
        this.jPanel1.setBackground(new Color(255, 255, 255));
        this.jPanel1.setBorder(BorderFactory.createLineBorder(new Color(211, 222, 232)));
        this.lblValor.setFont(FontesUtil.FONTE_NORMAL);
        this.lblValor.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblValor.setText("Valor");
        this.lblTipoFundo.setFont(FontesUtil.FONTE_NORMAL);
        this.lblTipoFundo.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblTipoFundo.setText("Tipo de Fundo");
        this.groupTipoFundo.setButtonMensagem(this.btnMsgTipoFundo);
        this.groupTipoFundo.setBorder(null);
        this.rdbNacional.setBackground(new Color(255, 255, 255));
        this.rdbNacional.setText("Nacional");
        this.rdbNacional.setFont(FontesUtil.FONTE_NORMAL);
        this.rdbNacional.setValorSelecionadoTrue("N");
        this.rdbEstadualDistrital.setBackground(new Color(255, 255, 255));
        this.rdbEstadualDistrital.setText("Estadual");
        this.rdbEstadualDistrital.setFont(FontesUtil.FONTE_NORMAL);
        this.rdbEstadualDistrital.setValorSelecionadoTrue("E");
        this.rdbMunicipal.setBackground(new Color(255, 255, 255));
        this.rdbMunicipal.setText("Municipal");
        this.rdbMunicipal.setFont(FontesUtil.FONTE_NORMAL);
        this.rdbMunicipal.setValorSelecionadoTrue("M");
        this.btnMsgTipoFundo.setText("jButtonMensagem1");
        GroupLayout groupTipoFundoLayout = new GroupLayout((Container)this.groupTipoFundo);
        this.groupTipoFundo.setLayout((LayoutManager)groupTipoFundoLayout);
        groupTipoFundoLayout.setHorizontalGroup(groupTipoFundoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupTipoFundoLayout.createSequentialGroup().addComponent((Component)this.rdbNacional, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.btnMsgTipoFundo, -2, -1, -2).addGap(8, 8, 8).addComponent((Component)this.rdbEstadualDistrital, -2, -1, -2).addGap(30, 30, 30).addComponent((Component)this.rdbMunicipal, -2, -1, -2).addContainerGap(86, Short.MAX_VALUE)));
        groupTipoFundoLayout.setVerticalGroup(groupTipoFundoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupTipoFundoLayout.createSequentialGroup().addGroup(groupTipoFundoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupTipoFundoLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.rdbNacional, -2, 14, -2).addComponent((Component)this.rdbEstadualDistrital, -2, 14, -2).addComponent((Component)this.rdbMunicipal, -2, 14, -2)).addComponent((Component)this.btnMsgTipoFundo, -2, 22, -2)).addContainerGap()));
        this.lblUf.setFont(FontesUtil.FONTE_NORMAL);
        this.lblUf.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblUf.setText("UF");
        this.edtUf.setFocusable(false);
        this.edtUf.setToolTipText("Sigla da Unidade da Federa\u00e7\u00e3o.");
        this.lblMunicipio.setFont(FontesUtil.FONTE_NORMAL);
        this.lblMunicipio.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblMunicipio.setText("Munic\u00edpio");
        this.edtAutoCompMunicipio.setFocusable(false);
        this.lblCNPJ.setFont(FontesUtil.FONTE_NORMAL);
        this.lblCNPJ.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblCNPJ.setText("CNPJ");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblTipoFundo).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblUf).addComponent((Component)this.edtUf, -2, 157, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.edtAutoCompMunicipio, -2, 304, -2).addComponent(this.lblMunicipio)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblCNPJ).addComponent((Component)this.edtCNPJ, -2, 179, -2))).addComponent((Component)this.edtValor, -2, 181, -2).addComponent(this.lblValor).addComponent((Component)this.groupTipoFundo, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.lblTipoFundo).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.groupTipoFundo, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.lblUf).addGap(1, 1, 1).addComponent((Component)this.edtUf, -2, -1, -2)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblMunicipio).addComponent(this.lblCNPJ)).addGap(1, 1, 1).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.edtCNPJ, -2, -1, -2).addComponent((Component)this.edtAutoCompMunicipio, -2, -1, -2)))).addGap(10, 10, 10).addComponent(this.lblValor).addGap(2, 2, 2).addComponent((Component)this.edtValor, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.edtValor.getAccessibleContext().setAccessibleName("Valor pago");
        this.lblDadosDoacao.setFont(FontesUtil.FONTE_TITULO_NORMAL);
        this.lblDadosDoacao.setForeground(new Color(0, 74, 106));
        this.lblDadosDoacao.setText("Dados da Doa\u00e7\u00e3o aos Fundos controlados pelos Conselhos da Pessoa Idosa");
        this.lblValorDisponivelDoacao.setFont(FontesUtil.FONTE_NORMAL);
        this.lblValorDisponivelDoacao.setText("Valor dispon\u00edvel para doa\u00e7\u00e3o:");
        this.edtValorDisponivelDoacao.setInformacaoAssociada("colecaoEstatutoIdoso.valorDisponivelDoacaoExibido");
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.lblDadosDoacao).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.lblValorDisponivelDoacao).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.edtValorDisponivelDoacao, -2, 139, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.lblDadosDoacao).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.lblValorDisponivelDoacao, -1, -1, Short.MAX_VALUE).addComponent((Component)this.edtValorDisponivelDoacao, -2, -1, -2)).addContainerGap(24, Short.MAX_VALUE)));
    }

    public ImageIcon getImagemTitulo() {
        return GuiUtil.getImage((String)"/icones/png40px/DE_estatuto.png");
    }

    public JComponent getDefaultFocus() {
        return this.groupTipoFundo;
    }

    public String getTituloPainel() {
        boolean ehTransmitida = IRPFFacade.getInstancia().getDeclaracao().getCopiaIdentificador().isTransmitida();
        if (!this.novoItem) {
            if (ehTransmitida) {
                return "Detalhe Doa\u00e7\u00e3o Diretamente na Declara\u00e7\u00e3o";
            }
            return "Editar Doa\u00e7\u00e3o Diretamente na Declara\u00e7\u00e3o";
        }
        return "Novo Doa\u00e7\u00e3o Diretamente na Declara\u00e7\u00e3o";
    }

    public void executaVoltar() {
        this.clicouEmVoltar = true;
        if (this.podeAcionarExecutarVoltar) {
            ControladorGui.acionarPainel((String)NavegacaoIf.PAINEL_DOACOES_DIRET_DEC);
        }
    }

    public boolean isTelaComVoltar() {
        return true;
    }

    public boolean isTelaComCancelar() {
        return true;
    }

    public void executaCancelar() {
        if (!this.novoItem) {
            int posicao = ControladorGui.getDemonstrativoAberto().getColecaoEstatutoIdoso().itens().indexOf(this.estatutoIdoso);
            ControladorGui.getDemonstrativoAberto().getColecaoEstatutoIdoso().remove((ObjetoNegocio)this.estatutoIdoso);
            ControladorGui.getDemonstrativoAberto().getColecaoEstatutoIdoso().itens().add(posicao, this.itemInicial);
        } else {
            ControladorGui.getDemonstrativoAberto().getColecaoEstatutoIdoso().remove((ObjetoNegocio)this.estatutoIdoso);
        }
        ControladorGui.acionarPainel((String)NavegacaoIf.PAINEL_DOACOES_DIRET_DEC);
    }

    public EstatutoIdoso getEstatutoIdoso() {
        return this.estatutoIdoso;
    }

    public boolean isNovoItem() {
        return this.novoItem;
    }

    public void setNovoItem(boolean novoItem) {
        this.novoItem = novoItem;
    }

    public void setEstatutoIdoso(EstatutoIdoso estatutoIdoso) {
        this.estatutoIdoso = estatutoIdoso;
    }

    public String getHelpID() {
        return HELP_ID;
    }

    public boolean isTelaComFavoritos() {
        return false;
    }

    public boolean isTelaComMensagem() {
        return true;
    }

    public String getMensagemTela() {
        String msg = "<html><p>Se voc\u00ea optou pela doa\u00e7\u00e3o direta na Declara\u00e7\u00e3o, e sua declara\u00e7\u00e3o apresentar pend\u00eancia de malha por conta dessa doa\u00e7\u00e3o, n\u00e3o se preocupe. Assim que recebermos a informa\u00e7\u00e3o sobre o pagamento do DARF da destina\u00e7\u00e3o, a declara\u00e7\u00e3o ser\u00e1 liberada automaticamente.</p><br><p><b>Mas lembre-se!</b></p><p>De acordo com as regras que definem essa doa\u00e7\u00e3o, s\u00f3 podemos aceitar pagamentos feitos at\u00e9 o dia definido como prazo final para a entrega da declara\u00e7\u00e3o. Todo e qualquer pagamento ap\u00f3s essa data n\u00e3o ser\u00e1 aceito e a declara\u00e7\u00e3o precisar\u00e1 ser retificada, excluindo a destina\u00e7\u00e3o e apurando novo resultado.</p></html>";
        return msg;
    }
}

