/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.doacoes;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import serpro.ppgd.gui.xbeans.JEditAlfa;
import serpro.ppgd.gui.xbeans.JEditNI;
import serpro.ppgd.gui.xbeans.JEditValor;
import serpro.ppgd.gui.xbeans.autocomplete.JAutoCompleteEditCodigo;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.infraestrutura.util.FontesUtil;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.doacoes.Doacao;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.NavegacaoIf;
import serpro.ppgd.irpf.gui.PainelDemonstrativoAb;
import serpro.ppgd.irpf.gui.PainelDemonstrativoIf;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.irpf.tabelas.TabelaAliquotasIRPF;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.ElementoTabela;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Valor;

public class PainelDoacoesDetalhe
extends PainelDemonstrativoAb {
    private static final long serialVersionUID = 1L;
    private static final String TITULO = "Doa\u00e7\u00f5es Efetuadas";
    private static final String HELP_ID = "Fichas da Declara\u00e7\u00e3o/Doa\u00e7\u00f5es Efetuadas";
    private boolean novoItem = false;
    private Doacao doacao = null;
    private PainelDemonstrativoIf painelPai;
    private boolean emEdicao;
    private Doacao itemInicial = null;
    private JAutoCompleteEditCodigo edtCodigo;
    private JEditAlfa edtFakeFocus;
    private JEditNI edtNi;
    private JEditAlfa edtNomeBeneficiario;
    private JEditValor edtParcNaoDedut;
    private JEditValor edtValor;
    private JPanel jPanel1;
    private JLabel lblCodigo;
    private JLabel lblDadosDoacao;
    private JLabel lblNi;
    private JLabel lblNomeBeneficiario;
    private JLabel lblParcNaoDedut;
    private JLabel lblValor;

    public PainelDoacoesDetalhe() {
        PlataformaPPGD.getPlataforma().setHelpID((JComponent)((Object)this), HELP_ID);
        this.initComponents();
    }

    public PainelDoacoesDetalhe(PainelDemonstrativoIf painelPai, Doacao doacao, boolean flagNovoItem, boolean emEdicao) {
        this();
        this.novoItem = flagNovoItem;
        this.doacao = doacao;
        this.painelPai = painelPai;
        this.emEdicao = emEdicao;
        this.associarInformacao(doacao);
        this.alterarVisibilidadeTodosCampos(false);
        this.lblNi.setEnabled(this.edtNi.getInformacao().isHabilitado());
        this.edtNi.getComponenteEditor().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PainelDoacoesDetalhe.this.lblNi.setEnabled(PainelDoacoesDetalhe.this.edtNi.getInformacao().isHabilitado());
            }
        });
        this.getDoacao().getCodigo().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                if (valorAntigo != null && !valorAntigo.equals(valorNovo)) {
                    PainelDoacoesDetalhe.this.atualizaGui(valorNovo.toString());
                }
            }
        });
        ((JComboBox)this.edtCodigo.getComponenteFoco()).addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    String codigo = ((ElementoTabela)e.getItem()).getConteudo(0);
                    Valor limiteIncentivoMaisDesporto = new Valor();
                    limiteIncentivoMaisDesporto.setConteudo(TabelaAliquotasIRPF.ConstantesAliquotas.deducaoIncentivo.getValor());
                    limiteIncentivoMaisDesporto.append('+', TabelaAliquotasIRPF.ConstantesAliquotas.deducoesIncDesporto.getValor());
                    if (codigo.equals("40")) {
                        GuiUtil.mostrarInfo((Component)ControladorGui.getJanelaPrincipal(), (String)MensagemUtil.getMensagem((String)"doacao_popup_informativo_cod_40", (String[])new String[]{ConstantesGlobais.ANO_BASE, TabelaAliquotasIRPF.ConstantesAliquotas.deducaoIncentivo.getValor().formatado(), limiteIncentivoMaisDesporto.formatado()}));
                    } else if (codigo.equals("44")) {
                        GuiUtil.mostrarInfo((Component)ControladorGui.getJanelaPrincipal(), (String)MensagemUtil.getMensagem((String)"doacao_popup_informativo_cod_44", (String[])new String[]{ConstantesGlobais.ANO_BASE, TabelaAliquotasIRPF.ConstantesAliquotas.deducaoIncentivo.getValor().formatado(), limiteIncentivoMaisDesporto.formatado()}));
                    }
                }
            }
        });
        this.edtFakeFocus.getComponenteEditor().addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent fe) {
                if (fe.getOppositeComponent() == PainelDoacoesDetalhe.this.edtNomeBeneficiario.getComponenteFoco()) {
                    ((JComponent)fe.getSource()).transferFocusBackward();
                } else {
                    ((JComponent)fe.getSource()).transferFocus();
                }
            }
        });
        if (emEdicao) {
            this.itemInicial = doacao.obterCopia();
        }
        this.atualizaGui(this.getDoacao().getCodigo().naoFormatado());
        this.edtNomeBeneficiario.setName("edtNomeBeneficiario");
        this.edtNi.setName("edtNi");
    }

    protected void associarInformacao(Doacao doacao) {
        this.edtNi.setInformacao((Informacao)doacao.getNiBeneficiario());
        this.edtNomeBeneficiario.setInformacao((Informacao)doacao.getNomeBeneficiario());
        this.edtCodigo.setInformacao((Informacao)doacao.getCodigo());
        this.edtValor.setInformacao((Informacao)doacao.getValorPago());
        this.edtParcNaoDedut.setInformacao((Informacao)doacao.getParcelaNaoDedutivel());
        this.lblNi.setEnabled(this.edtNi.getInformacao().isHabilitado());
    }

    private void initComponents() {
        this.lblDadosDoacao = new JLabel();
        this.jPanel1 = new JPanel();
        this.edtFakeFocus = new JEditAlfa();
        this.lblNomeBeneficiario = new JLabel();
        this.edtNomeBeneficiario = new JEditAlfa();
        this.lblNi = new JLabel();
        this.edtNi = new JEditNI();
        this.lblValor = new JLabel();
        this.edtValor = new JEditValor();
        this.lblParcNaoDedut = new JLabel();
        this.edtParcNaoDedut = new JEditValor();
        this.lblCodigo = new JLabel();
        this.edtCodigo = new JAutoCompleteEditCodigo();
        this.setBackground(new Color(241, 245, 249));
        this.setForeground(new Color(255, 255, 255));
        this.lblDadosDoacao.setFont(FontesUtil.FONTE_TITULO_NORMAL);
        this.lblDadosDoacao.setForeground(new Color(0, 74, 106));
        this.lblDadosDoacao.setText("Dados da Doa\u00e7\u00e3o");
        this.jPanel1.setBackground(new Color(255, 255, 255));
        this.jPanel1.setBorder(BorderFactory.createLineBorder(new Color(211, 222, 232)));
        this.lblNomeBeneficiario.setFont(FontesUtil.FONTE_NORMAL);
        this.lblNomeBeneficiario.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblNomeBeneficiario.setText("Nome do benefici\u00e1rio");
        this.lblNi.setFont(FontesUtil.FONTE_NORMAL);
        this.lblNi.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblNi.setText("CPF/CNPJ do benefici\u00e1rio");
        this.lblValor.setFont(FontesUtil.FONTE_NORMAL);
        this.lblValor.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblValor.setText("Valor pago");
        this.lblParcNaoDedut.setFont(FontesUtil.FONTE_NORMAL);
        this.lblParcNaoDedut.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblParcNaoDedut.setText("Parcela n\u00e3o-dedut\u00edvel/valor reembolsado");
        this.lblCodigo.setFont(FontesUtil.FONTE_NORMAL);
        this.lblCodigo.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblCodigo.setText("C\u00f3digo");
        this.edtCodigo.setToolTipText("C\u00f3digo");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.edtFakeFocus, -2, 0, -2).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.edtValor, -2, 181, -2).addComponent(this.lblValor)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblParcNaoDedut).addComponent((Component)this.edtParcNaoDedut, -2, 180, -2))).addComponent((Component)this.edtNi, -2, 204, -2).addComponent(this.lblNi).addComponent((Component)this.edtNomeBeneficiario, -2, 409, -2).addComponent(this.lblNomeBeneficiario).addComponent(this.lblCodigo).addComponent((Component)this.edtCodigo, -2, 661, -2)).addContainerGap(20, Short.MAX_VALUE)));
        jPanel1Layout.linkSize(0, new Component[]{this.edtParcNaoDedut, this.edtValor});
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.lblCodigo).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.edtCodigo, -2, -1, -2).addGap(7, 7, 7).addComponent((Component)this.edtFakeFocus, -2, 0, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblNi).addGap(2, 2, 2).addComponent((Component)this.edtNi, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lblNomeBeneficiario).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.edtNomeBeneficiario, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblValor).addComponent(this.lblParcNaoDedut)).addGap(2, 2, 2).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.edtValor, -2, -1, -2).addComponent((Component)this.edtParcNaoDedut, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.edtValor.getAccessibleContext().setAccessibleName("Valor pago");
        this.edtParcNaoDedut.getAccessibleContext().setAccessibleName("Parcela n\u00e3o-dedut\u00edvel / valor reembolsado");
        this.edtCodigo.getAccessibleContext().setAccessibleName("C\u00f3digo");
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.lblDadosDoacao).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.lblDadosDoacao).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    public ImageIcon getImagemTitulo() {
        return GuiUtil.getImage((String)"/icones/png40px/DE_doacoes.png");
    }

    public JComponent getDefaultFocus() {
        return this.edtCodigo;
    }

    public String getTituloPainel() {
        boolean ehTransmitida = IRPFFacade.getInstancia().getDeclaracao().getCopiaIdentificador().isTransmitida();
        if (this.emEdicao) {
            if (ehTransmitida) {
                return "Detalhe Doa\u00e7\u00e3o Efetuada";
            }
            return "Editar Doa\u00e7\u00e3o Efetuada";
        }
        return "Novo Doa\u00e7\u00e3o Efetuada";
    }

    public void executaVoltar() {
        ControladorGui.acionarPainel((String)NavegacaoIf.PAINEL_DOACOES);
    }

    public boolean isTelaComVoltar() {
        return true;
    }

    public boolean isTelaComCancelar() {
        return true;
    }

    public void executaCancelar() {
        if (this.emEdicao) {
            int posicao = ControladorGui.getDemonstrativoAberto().getDoacoes().itens().indexOf(this.doacao);
            ControladorGui.getDemonstrativoAberto().getDoacoes().remove((ObjetoNegocio)this.doacao);
            ControladorGui.getDemonstrativoAberto().getDoacoes().itens().add(posicao, this.itemInicial);
        } else {
            ControladorGui.getDemonstrativoAberto().getDoacoes().remove((ObjetoNegocio)this.doacao);
        }
        ControladorGui.acionarPainel((PainelDemonstrativoIf)this.getPainelPai());
    }

    public PainelDemonstrativoIf getPainelPai() {
        return this.painelPai;
    }

    private void atualizaGui(String codigoDoacao) {
        this.alterarVisibilidadeTodosCampos(false);
        if (codigoDoacao.equals("40") || codigoDoacao.equals("43") || codigoDoacao.equals("44") || codigoDoacao.equals("42") || codigoDoacao.equals("80") || codigoDoacao.equals("81") || codigoDoacao.equals("45") || codigoDoacao.equals("46") || codigoDoacao.equals("47")) {
            this.edtNi.setVisible(true);
            this.edtNi.setTiposAceitos(this.obterTipoNI(codigoDoacao));
            this.lblNi.setVisible(true);
            this.lblNi.setText(MensagemUtil.getMensagem((String)("cpf_cnpj_cod_beneficiario_" + codigoDoacao)));
            this.edtNi.getAccessibleContext().setAccessibleName(MensagemUtil.getMensagem((String)("cpf_cnpj_cod_beneficiario_" + codigoDoacao)));
            this.lblNi.repaint();
            this.lblNomeBeneficiario.setVisible(true);
            this.edtNomeBeneficiario.setVisible(true);
            this.lblNomeBeneficiario.setText(MensagemUtil.getMensagem((String)("nome_cod_beneficiario_" + codigoDoacao)));
            this.edtNomeBeneficiario.getAccessibleContext().setAccessibleName(MensagemUtil.getMensagem((String)("nome_cod_beneficiario_" + codigoDoacao)));
            this.lblNomeBeneficiario.repaint();
            this.lblValor.setVisible(true);
            this.edtValor.setVisible(true);
            this.lblParcNaoDedut.setVisible(false);
            this.edtParcNaoDedut.setVisible(false);
        } else if (codigoDoacao.equals("41")) {
            this.edtNi.setVisible(true);
            this.edtNi.setTiposAceitos(this.obterTipoNI(codigoDoacao));
            this.lblNi.setVisible(true);
            this.lblNi.setText(MensagemUtil.getMensagem((String)("cpf_cnpj_cod_beneficiario_" + codigoDoacao)));
            this.edtNi.getAccessibleContext().setAccessibleName(MensagemUtil.getMensagem((String)("cpf_cnpj_cod_beneficiario_" + codigoDoacao)));
            this.lblNi.repaint();
            this.lblNomeBeneficiario.setVisible(true);
            this.edtNomeBeneficiario.setVisible(true);
            this.lblNomeBeneficiario.setText(MensagemUtil.getMensagem((String)("nome_cod_beneficiario_" + codigoDoacao)));
            this.edtNomeBeneficiario.getAccessibleContext().setAccessibleName(MensagemUtil.getMensagem((String)("nome_cod_beneficiario_" + codigoDoacao)));
            this.lblNomeBeneficiario.repaint();
            this.lblParcNaoDedut.setVisible(true);
            this.edtParcNaoDedut.setVisible(true);
            this.lblParcNaoDedut.setText("<html>Parcela n&atilde;o dedut&iacute;vel</html>");
            this.lblParcNaoDedut.repaint();
            this.lblValor.setVisible(true);
            this.edtValor.setVisible(true);
        } else if (codigoDoacao.equals("99")) {
            this.edtNi.setVisible(true);
            this.edtNi.setTiposAceitos(this.obterTipoNI(codigoDoacao));
            this.lblNi.setVisible(true);
            this.lblNi.setText(MensagemUtil.getMensagem((String)"cpf_cnpj_cod_beneficiario"));
            this.edtNi.getAccessibleContext().setAccessibleName(MensagemUtil.getMensagem((String)"cpf_cnpj_cod_beneficiario"));
            this.lblNi.repaint();
            this.lblNomeBeneficiario.setVisible(true);
            this.edtNomeBeneficiario.setVisible(true);
            this.lblNomeBeneficiario.setText(MensagemUtil.getMensagem((String)"nome_cod_beneficiario"));
            this.edtNomeBeneficiario.getAccessibleContext().setAccessibleName(MensagemUtil.getMensagem((String)"nome_cod_beneficiario"));
            this.lblNomeBeneficiario.repaint();
            this.lblParcNaoDedut.setVisible(false);
            this.edtParcNaoDedut.setVisible(false);
            this.lblValor.setVisible(true);
            this.edtValor.setVisible(true);
        } else {
            this.lblNomeBeneficiario.setVisible(false);
            this.edtNomeBeneficiario.setVisible(false);
            this.lblNi.setVisible(false);
            this.edtNi.setVisible(false);
            this.lblValor.setVisible(false);
            this.edtValor.setVisible(false);
            this.lblParcNaoDedut.setVisible(false);
            this.edtParcNaoDedut.setVisible(false);
        }
    }

    private void alterarVisibilidadeTodosCampos(boolean visivel) {
        this.lblNomeBeneficiario.setVisible(visivel);
        this.edtNomeBeneficiario.setVisible(visivel);
        this.lblNi.setVisible(visivel);
        this.edtNi.setVisible(visivel);
        this.lblValor.setVisible(visivel);
        this.edtValor.setVisible(visivel);
        this.lblParcNaoDedut.setVisible(visivel);
        this.edtParcNaoDedut.setVisible(visivel);
    }

    private byte obterTipoNI(String codigoDoacao) {
        int retorno = 0;
        if (codigoDoacao.equals("41") || codigoDoacao.equals("42") || codigoDoacao.equals("99")) {
            retorno = 0;
        } else if (codigoDoacao.equals("81") || codigoDoacao.equals("80")) {
            retorno = 1;
        } else if (codigoDoacao.equals("40") || codigoDoacao.equals("43") || codigoDoacao.equals("44") || codigoDoacao.equals("45") || codigoDoacao.equals("46")) {
            retorno = 2;
        }
        return (byte)retorno;
    }

    public Doacao getDoacao() {
        return this.doacao;
    }

    public boolean isNovoItem() {
        return this.novoItem;
    }

    public void setNovoItem(boolean novoItem) {
        this.novoItem = novoItem;
    }

    public void setDoacao(Doacao doacao) {
        this.doacao = doacao;
    }

    public String getHelpID() {
        return HELP_ID;
    }

    public boolean isTelaComFavoritos() {
        return false;
    }
}

