/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.doacoes;

import java.awt.event.ActionEvent;
import javax.swing.ImageIcon;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.doacoes.Doacao;
import serpro.ppgd.irpf.doacoes.Doacoes;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.IRPFTableModelAb;
import serpro.ppgd.irpf.gui.PainelDemonstrativoAb;
import serpro.ppgd.irpf.gui.PainelDemonstrativoIf;
import serpro.ppgd.irpf.gui.PainelListaAb;
import serpro.ppgd.irpf.gui.TableLista;
import serpro.ppgd.irpf.gui.TableListaModel;
import serpro.ppgd.irpf.gui.doacoes.PainelDoacoesDetalhe;
import serpro.ppgd.irpf.gui.doacoes.TableModelDoacoes;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.negocio.ObjetoNegocio;

public class PainelDoacoesLista
extends PainelListaAb {
    private static final long serialVersionUID = 1L;
    private static final String TITULO = "Doa\u00e7\u00f5es Efetuadas";

    protected String getButtonHelpID() {
        return "Fichas da Declara\u00e7\u00e3o/Doa\u00e7\u00f5es Efetuadas";
    }

    protected String getClassePainelNavegacao() {
        return PainelDoacoesDetalhe.class.getName();
    }

    public String getTituloPainel() {
        return TITULO;
    }

    protected int getColunaOrdenacao() {
        return 0;
    }

    protected Integer[] getColunasOrdenaveis() {
        return new Integer[]{0, 1, 3};
    }

    protected TableListaModel getTableModel() {
        return new TableModelDoacoes(IRPFFacade.getInstancia().getDoacoes());
    }

    protected TableLista instanciarTabela(TableListaModel model, int colunaOrdenacao, Integer[] colunasOrdenaveis) {
        TableLista tableLista2 = new TableLista(model, colunaOrdenacao, colunasOrdenaveis);
        tableLista2.accessibleColumnHeader = new String[]{"Item", "C\u00f3digo", "Nome do benefici\u00e1rio", "CPF/CNPJ do Benefici\u00e1rio", "Valor pago", "Parcela N\u00e3o Dedut\u00edvel<"};
        return tableLista2;
    }

    protected void configurarTamanhoColunas() {
        TableColumnModel tcm = this.getTabela().getColumnModel();
        tcm.getColumn(0).setPreferredWidth(5);
        tcm.getColumn(1).setPreferredWidth(25);
        tcm.getColumn(2).setPreferredWidth(200);
        tcm.getColumn(3).setPreferredWidth(80);
        this.getTabela().setRowHeight(40);
    }

    public PainelDemonstrativoAb getPainelEditarItem(ObjetoNegocio obj) {
        return new PainelDoacoesDetalhe((PainelDemonstrativoIf)this, (Doacao)obj, false, true);
    }

    public void onBtnAbrirClick(ActionEvent e) {
        if (this.getTabela().getSelectedRow() >= 0 && this.getTabela().getSelectedRow() < this.getTabela().getRowCount()) {
            int nLinha = this.getTabela().getSelectedRow();
            int indiceVetor = ((TableRowSorter)this.getTabela().getRowSorter()).convertRowIndexToModel(nLinha);
            IRPFTableModelAb model = (IRPFTableModelAb)this.getTabela().getModel();
            Doacoes colecao = (Doacoes)model.getObjetoNegocio();
            ControladorGui.acionarPainel((PainelDemonstrativoIf)this.getPainelEditarItem((ObjetoNegocio)colecao.itens().get(indiceVetor)));
        } else {
            GuiUtil.mostrarAviso((String)"ErroSelecioneItem");
        }
    }

    public String getMensagemExclusao() {
        return "ConfirmaExcluirItens2";
    }

    public String[] getParametrosMensagemExclusao() {
        return new String[]{"doa\u00e7\u00e3o(\u00f5es)"};
    }

    public PainelDemonstrativoAb getPainelNovoItem() {
        Doacao doacao = new Doacao(ControladorGui.getDemonstrativoAberto());
        ControladorGui.getDemonstrativoAberto().getDoacoes().itens().add(doacao);
        return new PainelDoacoesDetalhe((PainelDemonstrativoIf)this, doacao, true, false);
    }

    public void onBtnNovoClick(ActionEvent e) {
        ControladorGui.acionarPainel((PainelDemonstrativoIf)this.getPainelNovoItem());
    }

    public ImageIcon getImagemTitulo() {
        return GuiUtil.getImage((String)"/icones/png40px/DE_doacoes.png");
    }

    public String getMensagemTela() {
        String retorno = null;
        retorno = IRPFFacade.getInstancia().getDeclaracao().getIdentificadorDeclaracao().isAjuste() ? "<html>Ao preencher esta ficha, relacione as doa\u00e7\u00f5es efetuadas pelo titular e pelos dependentes relacionados na ficha Dependentes, sem preju\u00edzo da op\u00e7\u00e3o pela forma de tributa\u00e7\u00e3o utilizada (por dedu\u00e7\u00f5es legais ou por desconto simplificado).</html>" : "<html>Ao preencher esta ficha, o contribuinte deve informar as doa\u00e7\u00f5es efetuadas pelo titular e pelos dependentes relacionados na ficha Dependentes.</html>";
        return retorno;
    }

    public boolean isTelaComMensagem() {
        return true;
    }

    public boolean isTelaComFavoritos() {
        return true;
    }
}

