/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.eleicoes;

import java.awt.event.ActionEvent;
import javax.swing.ImageIcon;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.eleicoes.DoacaoEleitoral;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.IRPFTableModelAb;
import serpro.ppgd.irpf.gui.PainelDemonstrativoIf;
import serpro.ppgd.irpf.gui.PainelListaAb;
import serpro.ppgd.irpf.gui.TableLista;
import serpro.ppgd.irpf.gui.TableListaModel;
import serpro.ppgd.irpf.gui.TableListaSumario;
import serpro.ppgd.irpf.gui.eleicoes.PainelDoacoesCampanhasDetalhe;
import serpro.ppgd.irpf.gui.eleicoes.TableModelDoacoesCampanhas;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.negocio.Colecao;

public class PainelDoacoesCampanhasLista
extends PainelListaAb {
    private static final long serialVersionUID = 1L;
    private static final String TITULO = "Doa\u00e7\u00f5es a Partidos Pol\u00edticos e Candidatos a Cargos Eletivos";

    protected String getButtonHelpID() {
        return "Fichas da Declara\u00e7\u00e3o/Doa\u00e7\u00f5es a Partidos Pol\u00edticos e Candidatos a Cargos Eletivos";
    }

    protected String getClassePainelNavegacao() {
        return PainelDoacoesCampanhasDetalhe.class.getName();
    }

    public String getTituloPainel() {
        return TITULO;
    }

    protected int getColunaOrdenacao() {
        return 1;
    }

    protected Integer[] getColunasOrdenaveis() {
        return new Integer[]{0, 1};
    }

    protected TableListaModel getTableModel() {
        return new TableModelDoacoesCampanhas(IRPFFacade.getInstancia().getDoacoesEleitorais());
    }

    protected void configurarTamanhoColunas() {
        TableColumnModel tcm = this.getTabela().getColumnModel();
        tcm.getColumn(0).setPreferredWidth(5);
        tcm.getColumn(1).setPreferredWidth(25);
        tcm.getColumn(2).setPreferredWidth(250);
        tcm.getColumn(3).setPreferredWidth(75);
    }

    protected TableLista instanciarTabela(TableListaModel model, int colunaOrdenacao, Integer[] colunasOrdenaveis) {
        TableListaSumario tableListaSumario2 = new TableListaSumario(model, colunaOrdenacao, colunasOrdenaveis);
        tableListaSumario2.accessibleColumnHeader = new String[]{"Item", "CNPJ", "Nome do candidato, partido pol\u00edtico<br>ou comit\u00ea financeiro", "Valor"};
        return tableListaSumario2;
    }

    public void onBtnAbrirClick(ActionEvent e) {
        if (this.getTabela().getSelectedRow() >= 0 && this.getTabela().getSelectedRow() < this.getTabela().getRowCount() - 1) {
            int nLinha = this.getTabela().getSelectedRow();
            int indiceVetor = ((TableRowSorter)this.getTabela().getRowSorter()).convertRowIndexToModel(nLinha);
            IRPFTableModelAb model = (IRPFTableModelAb)this.getTabela().getModel();
            Colecao colecao = (Colecao)model.getObjetoNegocio();
            DoacaoEleitoral doacao = (DoacaoEleitoral)colecao.itens().get(indiceVetor);
            ControladorGui.acionarPainel((PainelDemonstrativoIf)new PainelDoacoesCampanhasDetalhe(doacao, true));
        } else {
            GuiUtil.mostrarAviso((String)"ErroSelecioneItem");
        }
    }

    public String getMensagemExclusao() {
        return "ConfirmaExcluirItens2";
    }

    public String[] getParametrosMensagemExclusao() {
        return new String[]{"doa\u00e7\u00e3o(\u00f5es)"};
    }

    public void onBtnNovoClick(ActionEvent e) {
        DoacaoEleitoral doacao = new DoacaoEleitoral();
        IRPFFacade.getInstancia().getDoacoesEleitorais().itens().add(doacao);
        ControladorGui.acionarPainel((PainelDemonstrativoIf)new PainelDoacoesCampanhasDetalhe(doacao, false));
    }

    public ImageIcon getImagemTitulo() {
        return GuiUtil.getImage((String)"/icones/png40px/DE_doacoes_politicos.png");
    }

    public boolean isTelaComFavoritos() {
        return true;
    }
}

