/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.herdeiros;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jdesktop.layout.GroupLayout;
import serpro.ppgd.gui.xbeans.JEditAlfa;
import serpro.ppgd.gui.xbeans.JEditNI;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.infraestrutura.util.FontesUtil;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.NavegacaoIf;
import serpro.ppgd.irpf.gui.PainelDemonstrativoAb;
import serpro.ppgd.irpf.gui.PainelDemonstrativoIf;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.irpf.herdeiros.Herdeiro;
import serpro.ppgd.irpf.herdeiros.Herdeiros;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.NI;
import serpro.ppgd.negocio.ObjetoNegocio;

public class PainelHerdeirosDetalhe
extends PainelDemonstrativoAb {
    private PainelDemonstrativoIf painelPai;
    private static final long serialVersionUID = 1L;
    private static final String TITULO = "Herdeiros/Meeiro";
    private static final String HELP_ID = "Declara\u00e7\u00e3o de Final de Esp\u00f3lio/Preenchimento da Declara\u00e7\u00e3o Final de Esp\u00f3lio/Ficha Herdeiros//Meeiro";
    private Herdeiro herdeiro = null;
    private Herdeiro itemInicial = null;
    private String strNiHerdeiro = null;
    private boolean emEdicao;
    private JEditNI edtNi;
    private JEditAlfa edtNome;
    private JPanel jPanel2;
    private JLabel lblNi;
    private JLabel lblNome;
    private JLabel lblTitulo;

    public PainelHerdeirosDetalhe(PainelDemonstrativoIf painelPai, Herdeiro herdeiro, boolean emEdicao) {
        this.painelPai = painelPai;
        this.herdeiro = herdeiro;
        this.emEdicao = emEdicao;
        PlataformaPPGD.getPlataforma().setHelpID((JComponent)((Object)this), HELP_ID);
        this.initComponents();
        if (emEdicao) {
            this.itemInicial = herdeiro.obterCopia();
        }
        this.associarInformacao();
        this.strNiHerdeiro = this.edtNi.getInformacao().naoFormatado();
        this.edtNi.getComponenteEditor().addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!PainelHerdeirosDetalhe.this.strNiHerdeiro.equals(PainelHerdeirosDetalhe.this.edtNi.getInformacao().naoFormatado())) {
                    Herdeiros herdeiros = IRPFFacade.getInstancia().getHerdeiros();
                    if (!herdeiros.isExisteNi(PainelHerdeirosDetalhe.this.strNiHerdeiro) && IRPFFacade.getInstancia().getBens().existeBensComHerdeiro(PainelHerdeirosDetalhe.this.strNiHerdeiro)) {
                        if (PainelHerdeirosDetalhe.this.confirmaExcluirNiHerdeiroOutrasFichas(PainelHerdeirosDetalhe.this.strNiHerdeiro)) {
                            PainelHerdeirosDetalhe.this.atualizaNiHerdeiroOutrasFichas(PainelHerdeirosDetalhe.this.strNiHerdeiro);
                            PainelHerdeirosDetalhe.this.strNiHerdeiro = PainelHerdeirosDetalhe.this.edtNi.getInformacao().naoFormatado();
                        } else {
                            PainelHerdeirosDetalhe.this.edtNi.getInformacao().setConteudo(PainelHerdeirosDetalhe.this.strNiHerdeiro);
                            if (PainelHerdeirosDetalhe.this.strNiHerdeiro != null && PainelHerdeirosDetalhe.this.strNiHerdeiro.length() <= 11) {
                                PainelHerdeirosDetalhe.this.edtNi.setarMascaraCPF();
                            } else {
                                PainelHerdeirosDetalhe.this.edtNi.setarMascaraCNPJ();
                            }
                        }
                    } else {
                        PainelHerdeirosDetalhe.this.strNiHerdeiro = PainelHerdeirosDetalhe.this.edtNi.getInformacao().naoFormatado();
                    }
                }
            }
        });
    }

    protected boolean confirmaExcluirNiHerdeiroOutrasFichas(String niHerdeiro) {
        NI ni = new NI();
        ni.setConteudo(niHerdeiro);
        return GuiUtil.mostrarConfirma((String)"herdeiro_confirma_edicao", (String[])new String[]{niHerdeiro.length() == 11 ? "CPF" : "CNPJ", ni.formatado()});
    }

    protected void atualizaNiHerdeiroOutrasFichas(String niHerdeiro) {
        IRPFFacade facade = IRPFFacade.getInstancia();
        facade.getBens().excluirBensComHerdeiro(niHerdeiro);
    }

    private void associarInformacao() {
        this.edtNi.setInformacao((Informacao)this.herdeiro.getNiHerdeiro());
        this.edtNome.setInformacao((Informacao)this.herdeiro.getNome());
    }

    private void initComponents() {
        this.lblTitulo = new JLabel();
        this.jPanel2 = new JPanel();
        this.lblNome = new JLabel();
        this.edtNome = new JEditAlfa();
        this.lblNi = new JLabel();
        this.edtNi = new JEditNI();
        this.setBackground(new Color(241, 245, 249));
        this.setForeground(new Color(255, 255, 255));
        this.lblTitulo.setFont(FontesUtil.FONTE_TITULO_NORMAL);
        this.lblTitulo.setForeground(new Color(0, 74, 106));
        this.lblTitulo.setText("Dados do Herdeiro/Meeiro");
        this.jPanel2.setBackground(new Color(255, 255, 255));
        this.jPanel2.setBorder(BorderFactory.createLineBorder(new Color(211, 222, 232)));
        this.lblNome.setFont(FontesUtil.FONTE_NORMAL);
        this.lblNome.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblNome.setLabelFor((Component)this.edtNome);
        this.lblNome.setText("Nome");
        this.lblNi.setFont(FontesUtil.FONTE_NORMAL);
        this.lblNi.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblNi.setText("CPF/CNPJ");
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.lblNi).add((Component)this.edtNi, -2, 179, -2).add((Component)this.lblNome).add((Component)this.edtNome, -2, 706, -2))));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((Component)this.lblNi).addPreferredGap(0).add((Component)this.edtNi, -2, -1, -2).addPreferredGap(0).add((Component)this.lblNome).addPreferredGap(0).add((Component)this.edtNome, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.edtNome.getAccessibleContext().setAccessibleName("Nome do herdeiro");
        this.edtNi.getAccessibleContext().setAccessibleName("CPF ou CNPJ do herdeiro");
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel2, -2, -1, -2).add((Component)this.lblTitulo)).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.lblTitulo).addPreferredGap(0).add((Component)this.jPanel2, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    public JComponent getDefaultFocus() {
        return this.edtNi;
    }

    public String getTituloPainel() {
        return TITULO;
    }

    public void executaVoltar() {
        ControladorGui.acionarPainel((String)NavegacaoIf.PAINEL_HERDEIROS);
    }

    public boolean isTelaComVoltar() {
        return true;
    }

    public boolean isTelaComCancelar() {
        return true;
    }

    public void executaCancelar() {
        if (this.emEdicao) {
            ControladorGui.getDemonstrativoAberto().getHerdeiros().remove((ObjetoNegocio)this.herdeiro);
            ControladorGui.getDemonstrativoAberto().getHerdeiros().add((ObjetoNegocio)this.itemInicial);
        } else {
            ControladorGui.getDemonstrativoAberto().getHerdeiros().remove((ObjetoNegocio)this.herdeiro);
        }
        ControladorGui.acionarPainel((PainelDemonstrativoIf)this.getPainelPai());
    }

    public ImageIcon getImagemTitulo() {
        return GuiUtil.getImage((String)"/icones/png40px/DE_herdeiros.png");
    }

    public String getHelpID() {
        return HELP_ID;
    }

    public boolean isTelaComFavoritos() {
        return false;
    }

    public PainelDemonstrativoIf getPainelPai() {
        return this.painelPai;
    }
}

