/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.herdeiros;

import java.awt.event.ActionEvent;
import javax.swing.ImageIcon;
import javax.swing.table.TableRowSorter;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.IRPFTableModelAb;
import serpro.ppgd.irpf.gui.PainelDemonstrativoIf;
import serpro.ppgd.irpf.gui.PainelListaAb;
import serpro.ppgd.irpf.gui.TableLista;
import serpro.ppgd.irpf.gui.TableListaModel;
import serpro.ppgd.irpf.gui.herdeiros.PainelHerdeirosDetalhe;
import serpro.ppgd.irpf.gui.herdeiros.TableModelHerdeiros;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.irpf.herdeiros.Herdeiro;
import serpro.ppgd.irpf.herdeiros.Herdeiros;
import serpro.ppgd.negocio.ObjetoNegocio;

public class PainelHerdeirosLista
extends PainelListaAb {
    private static final long serialVersionUID = 1L;
    private static final String TITULO = "Herdeiros/Meeiro";

    protected String getButtonHelpID() {
        return "Declara\u00e7\u00e3o de Final de Esp\u00f3lio/Preenchimento da Declara\u00e7\u00e3o Final de Esp\u00f3lio/Ficha Herdeiros//Meeiro";
    }

    protected String getClassePainelNavegacao() {
        return PainelHerdeirosDetalhe.class.getName();
    }

    public String getTituloPainel() {
        return TITULO;
    }

    protected int getColunaOrdenacao() {
        return 1;
    }

    protected Integer[] getColunasOrdenaveis() {
        return new Integer[]{0, 1};
    }

    protected TableListaModel getTableModel() {
        return new TableModelHerdeiros(IRPFFacade.getInstancia().getHerdeiros());
    }

    protected TableLista instanciarTabela(TableListaModel model, int colunaOrdenacao, Integer[] colunasOrdenaveis) {
        return new TableLista(model, colunaOrdenacao, colunasOrdenaveis);
    }

    protected void configurarTamanhoColunas() {
    }

    public void onBtnNovoClick(ActionEvent e) {
        TableModelHerdeiros lModel = (TableModelHerdeiros)((Object)this.getTabela().getModel());
        Herdeiro lItem = new Herdeiro(IRPFFacade.getInstancia().getDeclaracao().getIdentificadorDeclaracao());
        IRPFFacade.getInstancia().getHerdeiros().itens().add(lItem);
        ControladorGui.acionarPainel((PainelDemonstrativoIf)new PainelHerdeirosDetalhe((PainelDemonstrativoIf)this, lItem, false));
        lModel.refresh();
    }

    public void onBtnAbrirClick(ActionEvent e) {
        if (this.getTabela().getSelectedRow() >= 0) {
            int nLinha = this.getTabela().getSelectedRow();
            int indiceVetor = ((TableRowSorter)this.getTabela().getRowSorter()).convertRowIndexToModel(nLinha);
            IRPFTableModelAb model = (IRPFTableModelAb)this.getTabela().getModel();
            Herdeiros colHerdeiros = (Herdeiros)model.getObjetoNegocio();
            Herdeiro herdeiro = (Herdeiro)colHerdeiros.itens().get(indiceVetor);
            ControladorGui.acionarPainel((PainelDemonstrativoIf)new PainelHerdeirosDetalhe((PainelDemonstrativoIf)this, herdeiro, true));
        } else {
            GuiUtil.mostrarAviso((String)"ErroSelecioneItem");
        }
    }

    public boolean isTelaComFavoritos() {
        return true;
    }

    public boolean validarExclusao(ObjetoNegocio objetoNegocio) {
        Herdeiro herdeiro = (Herdeiro)objetoNegocio;
        return IRPFFacade.getInstancia().getHerdeiros().isNiDuplicado(herdeiro.getNiHerdeiro().naoFormatado()) || this.verificaNiHerdeiroOutrasFichas(herdeiro);
    }

    public String getMensagemExclusao() {
        return "ConfirmaExcluirItens1";
    }

    public String[] getParametrosMensagemExclusao() {
        return new String[]{"herdeiro(s)"};
    }

    public ImageIcon getImagemTitulo() {
        return GuiUtil.getImage((String)"/icones/png40px/DE_herdeiros.png");
    }

    private boolean verificaNiHerdeiroOutrasFichas(Herdeiro herdeiro) {
        IRPFFacade facade = IRPFFacade.getInstancia();
        if (facade.getBens().existeBensComHerdeiro(herdeiro.getNiHerdeiro().naoFormatado())) {
            if (GuiUtil.mostrarConfirma((String)"herdeiro_confirma_exclusao", (String[])new String[]{herdeiro.getNiHerdeiro().naoFormatado().length() == 11 ? "CPF" : "CNPJ", herdeiro.getNiHerdeiro().formatado()})) {
                IRPFFacade.getInstancia().getBens().excluirBensComHerdeiro(herdeiro.getNiHerdeiro().naoFormatado());
            } else {
                return false;
            }
        }
        return true;
    }
}

