/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.pagamentos;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import serpro.ppgd.gui.xbeans.GroupPanelEvent;
import serpro.ppgd.gui.xbeans.GroupPanelListener;
import serpro.ppgd.gui.xbeans.JButtonGroupPanel;
import serpro.ppgd.gui.xbeans.JEditAlfa;
import serpro.ppgd.gui.xbeans.JEditMascara;
import serpro.ppgd.gui.xbeans.JEditMemo;
import serpro.ppgd.gui.xbeans.JEditNI;
import serpro.ppgd.gui.xbeans.JEditValor;
import serpro.ppgd.gui.xbeans.PPGDRadioItem;
import serpro.ppgd.gui.xbeans.autocomplete.JAutoCompleteEditAlfa;
import serpro.ppgd.gui.xbeans.autocomplete.JAutoCompleteEditCodigo;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.infraestrutura.util.FontesUtil;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.IRPFLabelInfo;
import serpro.ppgd.irpf.gui.NavegacaoIf;
import serpro.ppgd.irpf.gui.PainelDemonstrativoAb;
import serpro.ppgd.irpf.gui.PainelDemonstrativoIf;
import serpro.ppgd.irpf.gui.TransferFocus;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.irpf.pagamentos.Pagamento;
import serpro.ppgd.irpf.tabelas.CadastroTabelasIRPF;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.negocio.ElementoTabela;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoNegocio;

public class PainelPagamentosDetalhe
extends PainelDemonstrativoAb {
    private static final long serialVersionUID = 1L;
    private static final String TITULO = "Pagamentos Efetuados";
    private static final String HELP_ID = "Fichas da Declara\u00e7\u00e3o/Pagamentos Efetuados";
    private boolean novoItem = false;
    private Pagamento pagamento = null;
    private PainelDemonstrativoIf painelPai;
    private boolean emEdicao;
    private Pagamento itemInicial = null;
    private ActionListener listenerCodigo = null;
    private JAutoCompleteEditAlfa cmbDependenteAlimentando;
    private JAutoCompleteEditCodigo edtCodigo;
    private JEditValor edtContribPatrocinador;
    private JEditMemo edtDescricao;
    private JAutoCompleteEditCodigo edtLocalizacao;
    private JEditNI edtNi;
    private JEditMascara edtNit;
    private JEditAlfa edtNomeBeneficiario;
    private JEditValor edtParcNaoDedut;
    private JEditValor edtValorPago;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private IRPFLabelInfo lblAvisoDependenteAlimentandoVazio;
    private JLabel lblContribPatrocinador;
    private JLabel lblDependenteAlimentando;
    private JLabel lblDescricao;
    private JLabel lblLocalizacao;
    private JLabel lblNi;
    private JLabel lblNit;
    private JLabel lblNomeBeneficiario;
    private JLabel lblParcNaoDedut;
    private JLabel lblTipo;
    private JLabel lblValorPago;
    private PPGDRadioItem rdbAlimentando;
    private PPGDRadioItem rdbDependente;
    private PPGDRadioItem rdbTitular;
    private JButtonGroupPanel tipoGroup;

    public PainelPagamentosDetalhe() {
        PlataformaPPGD.getPlataforma().setHelpID((JComponent)((Object)this), HELP_ID);
        this.initComponents();
    }

    public PainelPagamentosDetalhe(PainelDemonstrativoIf painelPai, Pagamento pagamento, boolean flagNovoItem, boolean emEdicao) {
        this();
        this.novoItem = flagNovoItem;
        this.pagamento = pagamento;
        this.painelPai = painelPai;
        this.emEdicao = emEdicao;
        PPGDRadioItem radioVazio = new PPGDRadioItem();
        radioVazio.setText("Vazio");
        radioVazio.setValorSelecionadoTrue("V");
        this.tipoGroup.adicionaOpcao((Component)radioVazio);
        radioVazio.setVisible(false);
        this.associarInformacao(pagamento);
        this.tratarPagamentosAlimentandos();
        TransferFocus.patch((Component)this.edtDescricao.getComponenteFoco());
        this.lblNi.setEnabled(this.edtNi.getInformacao().isHabilitado());
        this.lblNit.setEnabled(this.edtNit.getInformacao().isHabilitado());
        this.edtNi.getComponenteEditor().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PainelPagamentosDetalhe.this.lblNi.setEnabled(PainelPagamentosDetalhe.this.edtNi.getInformacao().isHabilitado());
            }
        });
        this.edtNit.getComponenteEditor().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PainelPagamentosDetalhe.this.lblNit.setEnabled(PainelPagamentosDetalhe.this.edtNit.getInformacao().isHabilitado());
            }
        });
        ((JComboBox)this.edtCodigo.getComponenteEditor()).addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    PainelPagamentosDetalhe.this.atualizaGui(e.getItem().toString(), PainelPagamentosDetalhe.this.getPagamento().getTipo().naoFormatado());
                }
            }
        });
        ((JComboBox)this.cmbDependenteAlimentando.getComponenteEditor()).addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    String cpf = ((ElementoTabela)e.getItem()).getConteudo(2);
                    PainelPagamentosDetalhe.this.atualizaCPFAlimentadoOuDependente(cpf);
                }
            }
        });
        this.lblAvisoDependenteAlimentandoVazio.setVisible(false);
        if (emEdicao) {
            this.itemInicial = pagamento.obterCopia();
        }
        this.atualizaGui(this.getPagamento().getCodigo().naoFormatado(), this.getPagamento().getTipo().naoFormatado());
    }

    protected void atualizaCPFAlimentadoOuDependente(String cpf) {
        String codigoPagamento = this.getPagamento().getCodigo().naoFormatado();
        if (codigoPagamento.equals("30") || codigoPagamento.equals("31") || codigoPagamento.equals("33") || codigoPagamento.equals("34")) {
            this.getPagamento().getNiBeneficiario().setConteudo(cpf);
            this.edtNi.setarMascaraCPF();
        } else if (this.rdbDependente.isSelected()) {
            this.getPagamento().getCPFDependente().setConteudo(cpf);
        } else if (this.rdbAlimentando.isSelected()) {
            this.getPagamento().getCPFAlimentando().setConteudo(cpf);
        }
    }

    private void tratarPagamentosAlimentandos() {
        this.listenerCodigo = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String codigoNegocio;
                JComboBox comboCodigo = (JComboBox)PainelPagamentosDetalhe.this.edtCodigo.getComponenteEditor();
                String codigoCombo = "";
                if (comboCodigo.getSelectedIndex() != -1) {
                    codigoCombo = ((ElementoTabela)comboCodigo.getSelectedItem()).getConteudo(0);
                }
                if (!codigoCombo.equals(codigoNegocio = PainelPagamentosDetalhe.this.getPagamento().getCodigo().naoFormatado()) && (codigoNegocio.equals("30") && !codigoCombo.equals("33") || codigoNegocio.equals("33") && !codigoCombo.equals("30") || codigoNegocio.equals("31") && !codigoCombo.equals("34") || codigoNegocio.equals("34") && !codigoCombo.equals("31") || !codigoNegocio.equals("30") && codigoCombo.equals("33") || !codigoNegocio.equals("33") && codigoCombo.equals("30") || !codigoNegocio.equals("31") && codigoCombo.equals("34") || !codigoNegocio.equals("34") && codigoCombo.equals("31"))) {
                    ((JComboBox)PainelPagamentosDetalhe.this.cmbDependenteAlimentando.getComponenteEditor()).setSelectedIndex(-1);
                    PainelPagamentosDetalhe.this.edtNi.getInformacao().clear();
                }
            }
        };
        ((JComboBox)this.edtCodigo.getComponenteEditor()).addActionListener(this.listenerCodigo);
    }

    protected void associarInformacao(Pagamento pagamento) {
        this.tipoGroup.setInformacao((Informacao)pagamento.getTipo());
        this.edtNi.setInformacao((Informacao)pagamento.getNiBeneficiario());
        this.edtNomeBeneficiario.setInformacao((Informacao)pagamento.getNomeBeneficiario());
        this.edtCodigo.setInformacao((Informacao)pagamento.getCodigo());
        this.cmbDependenteAlimentando.setInformacao((Informacao)pagamento.getDependenteOuAlimentando());
        this.edtValorPago.setInformacao((Informacao)pagamento.getValorPago());
        this.edtParcNaoDedut.setInformacao((Informacao)pagamento.getParcelaNaoDedutivel());
        this.edtContribPatrocinador.setInformacao((Informacao)pagamento.getContribuicaoEntePatrocinador());
        this.edtNit.setInformacao((Informacao)pagamento.getNitEmpregadoDomestico());
        this.edtDescricao.setInformacao((Informacao)pagamento.getDescricao());
        this.edtLocalizacao.setInformacao((Informacao)pagamento.getPais());
        this.lblNi.setEnabled(this.edtNi.getInformacao().isHabilitado());
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel2 = new JLabel();
        this.edtCodigo = new JAutoCompleteEditCodigo();
        this.lblTipo = new JLabel();
        this.tipoGroup = new JButtonGroupPanel();
        this.rdbTitular = new PPGDRadioItem();
        this.rdbDependente = new PPGDRadioItem();
        this.rdbAlimentando = new PPGDRadioItem();
        this.lblDependenteAlimentando = new JLabel();
        this.lblNi = new JLabel();
        this.edtNi = new JEditNI();
        this.lblNit = new JLabel();
        this.edtNit = new JEditMascara();
        this.lblValorPago = new JLabel();
        this.edtValorPago = new JEditValor();
        this.lblParcNaoDedut = new JLabel();
        this.edtParcNaoDedut = new JEditValor();
        this.lblAvisoDependenteAlimentandoVazio = new IRPFLabelInfo();
        this.lblContribPatrocinador = new JLabel();
        this.edtContribPatrocinador = new JEditValor();
        this.lblNomeBeneficiario = new JLabel();
        this.cmbDependenteAlimentando = new JAutoCompleteEditAlfa();
        this.edtNomeBeneficiario = new JEditAlfa();
        this.lblDescricao = new JLabel();
        this.edtDescricao = new JEditMemo();
        this.edtLocalizacao = new JAutoCompleteEditCodigo();
        this.lblLocalizacao = new JLabel();
        this.jLabel1 = new JLabel();
        this.setBackground(new Color(241, 245, 249));
        this.setForeground(new Color(255, 255, 255));
        this.jPanel1.setBackground(new Color(255, 255, 255));
        this.jPanel1.setBorder(BorderFactory.createLineBorder(new Color(211, 222, 232)));
        this.jLabel2.setFont(FontesUtil.FONTE_NORMAL);
        this.jLabel2.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.jLabel2.setText("C\u00f3digo");
        this.edtCodigo.setToolTipText("C\u00f3digo");
        this.lblTipo.setFont(FontesUtil.FONTE_NORMAL);
        this.lblTipo.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblTipo.setText("Despesa realizada com");
        this.tipoGroup.setBorder(null);
        this.tipoGroup.addGroupPanelListener(new GroupPanelListener(){

            public void atualizaPainel(GroupPanelEvent evt) {
                PainelPagamentosDetalhe.this.tipoGroupAtualizaPainel(evt);
            }
        });
        this.rdbTitular.setBackground(new Color(255, 255, 255));
        this.rdbTitular.setText("Titular");
        this.rdbTitular.setFont(FontesUtil.FONTE_NORMAL);
        this.rdbTitular.setValorSelecionadoTrue("T");
        this.rdbTitular.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                PainelPagamentosDetalhe.this.rdbTitularKeyPressed(evt);
            }
        });
        this.rdbDependente.setBackground(new Color(255, 255, 255));
        this.rdbDependente.setText("Dependente");
        this.rdbDependente.setFont(FontesUtil.FONTE_NORMAL);
        this.rdbDependente.setValorSelecionadoTrue("D");
        this.rdbDependente.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                PainelPagamentosDetalhe.this.rdbDependenteKeyPressed(evt);
            }
        });
        this.rdbAlimentando.setBackground(new Color(255, 255, 255));
        this.rdbAlimentando.setText("Alimentando");
        this.rdbAlimentando.setFont(FontesUtil.FONTE_NORMAL);
        this.rdbAlimentando.setValorSelecionadoTrue("A");
        this.rdbAlimentando.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelPagamentosDetalhe.this.rdbAlimentandoActionPerformed(evt);
            }
        });
        GroupLayout tipoGroupLayout = new GroupLayout((Container)this.tipoGroup);
        this.tipoGroup.setLayout((LayoutManager)tipoGroupLayout);
        tipoGroupLayout.setHorizontalGroup(tipoGroupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(tipoGroupLayout.createSequentialGroup().addComponent((Component)this.rdbTitular, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.rdbDependente, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.rdbAlimentando, -2, -1, -2).addContainerGap(36, Short.MAX_VALUE)));
        tipoGroupLayout.setVerticalGroup(tipoGroupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(tipoGroupLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent((Component)this.rdbTitular, -2, -1, -2).addComponent((Component)this.rdbDependente, -2, -1, -2).addComponent((Component)this.rdbAlimentando, -2, -1, -2)));
        this.rdbTitular.getAccessibleContext().setAccessibleName("Despesa realizada com Titular");
        this.rdbDependente.getAccessibleContext().setAccessibleName("Despesa realizada com Dependente");
        this.rdbAlimentando.getAccessibleContext().setAccessibleName("Despesa realizada com Alimentando");
        this.lblDependenteAlimentando.setFont(FontesUtil.FONTE_NORMAL);
        this.lblDependenteAlimentando.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblDependenteAlimentando.setText("Nome do dependente");
        this.lblDependenteAlimentando.setVerticalAlignment(3);
        this.lblNi.setFont(FontesUtil.FONTE_NORMAL);
        this.lblNi.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblNi.setText("CPF/CNPJ do benefici\u00e1rio");
        this.lblNit.setFont(FontesUtil.FONTE_NORMAL);
        this.lblNit.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblNit.setText("NIT do empregado dom\u00e9stico");
        this.edtNit.setCaracteresInvalidos("");
        this.edtNit.setCaracteresValidos("0123456789 ");
        this.edtNit.setMascara("***.*****.**-*");
        this.lblValorPago.setFont(FontesUtil.FONTE_NORMAL);
        this.lblValorPago.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblValorPago.setText("Valor pago");
        this.lblParcNaoDedut.setFont(FontesUtil.FONTE_NORMAL);
        this.lblParcNaoDedut.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblParcNaoDedut.setText("Parcela n\u00e3o-dedut\u00edvel/valor reembolsado");
        this.lblContribPatrocinador.setFont(FontesUtil.FONTE_NORMAL);
        this.lblContribPatrocinador.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblContribPatrocinador.setText("Contribui\u00e7\u00e3o do ente p\u00fablico patrocinador");
        this.lblNomeBeneficiario.setFont(FontesUtil.FONTE_NORMAL);
        this.lblNomeBeneficiario.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblNomeBeneficiario.setText("Nome do benefici\u00e1rio");
        this.lblDescricao.setFont(FontesUtil.FONTE_NORMAL);
        this.lblDescricao.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblDescricao.setText("Descri\u00e7\u00e3o");
        this.edtDescricao.setMaxChars(512);
        this.lblLocalizacao.setFont(FontesUtil.FONTE_NORMAL);
        this.lblLocalizacao.setText("Localiza\u00e7\u00e3o (Pa\u00eds)");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent((Component)this.tipoGroup, -2, -1, -2).addComponent(this.lblTipo).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.edtNi, -2, 204, -2).addComponent(this.lblNi)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblNit).addComponent((Component)this.edtNit, -2, 169, -2))).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.edtValorPago, -2, 181, -2).addComponent(this.lblValorPago)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.edtParcNaoDedut, -2, 180, -2).addComponent(this.lblParcNaoDedut)).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblContribPatrocinador).addComponent((Component)this.edtContribPatrocinador, -2, 180, -2))).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.lblDependenteAlimentando).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.lblAvisoDependenteAlimentandoVazio, -2, -1, -2)).addComponent(this.lblNomeBeneficiario).addComponent(this.lblDescricao).addComponent((Component)this.edtDescricao, -2, 589, -2).addComponent((Component)this.cmbDependenteAlimentando, -2, 493, -2).addComponent((Component)this.edtCodigo, -2, 660, -2).addComponent((Component)this.edtNomeBeneficiario, -2, 555, -2).addComponent(this.lblLocalizacao).addComponent((Component)this.edtLocalizacao, -2, 485, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.linkSize(0, new Component[]{this.edtParcNaoDedut, this.edtValorPago});
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel2).addGap(3, 3, 3).addComponent((Component)this.edtCodigo, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lblLocalizacao).addGap(2, 2, 2).addComponent((Component)this.edtLocalizacao, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lblTipo).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.tipoGroup, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.lblDependenteAlimentando, -2, 22, -2).addComponent((Component)this.lblAvisoDependenteAlimentandoVazio, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.cmbDependenteAlimentando, -2, -1, -2).addGap(2, 2, 2).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblNi).addComponent(this.lblNit, -2, 14, -2)).addGap(2, 2, 2).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent((Component)this.edtNi, -2, -1, -2).addComponent((Component)this.edtNit, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblNomeBeneficiario).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.edtNomeBeneficiario, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblDescricao).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.edtDescricao, -2, 101, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblValorPago).addComponent(this.lblParcNaoDedut)).addGap(2, 2, 2).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.edtValorPago, -2, -1, -2).addComponent((Component)this.edtParcNaoDedut, -2, -1, -2))).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.lblContribPatrocinador).addGap(2, 2, 2).addComponent((Component)this.edtContribPatrocinador, -2, -1, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        this.edtCodigo.getAccessibleContext().setAccessibleName("C\u00f3digo");
        this.edtNi.getAccessibleContext().setAccessibleName("CPF ou CNPJ do benefici\u00e1rio");
        this.edtNit.getAccessibleContext().setAccessibleName("NIT do empregado dom\u00e9stico");
        this.edtValorPago.getAccessibleContext().setAccessibleName("Valor pago");
        this.edtParcNaoDedut.getAccessibleContext().setAccessibleName("Parcela n\u00e3o-dedut\u00edvel / valor reembolsado");
        this.edtContribPatrocinador.getAccessibleContext().setAccessibleName("Contribui\u00e7\u00e3o do ente p\u00fablico patrocinador");
        this.cmbDependenteAlimentando.getAccessibleContext().setAccessibleDescription("");
        this.edtNomeBeneficiario.getAccessibleContext().setAccessibleName("Nome do benefici\u00e1rio");
        this.edtDescricao.getAccessibleContext().setAccessibleName("Descri\u00e7\u00e3o");
        this.jLabel1.setFont(FontesUtil.FONTE_TITULO_NORMAL);
        this.jLabel1.setForeground(new Color(0, 74, 106));
        this.jLabel1.setText("Dados do Pagamento");
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    private void tipoGroupAtualizaPainel(GroupPanelEvent e) {
        this.atualizaGui(this.getPagamento().getCodigo().naoFormatado(), e.getInformacao().naoFormatado());
        if (!this.rdbDependente.isSelected()) {
            this.getPagamento().getCPFDependente().setConteudo("");
            this.lblAvisoDependenteAlimentandoVazio.setMensagem(MensagemUtil.getMensagem((String)"info_listagem", (String[])new String[]{"Alimentandos"}));
        } else if (!this.rdbAlimentando.isSelected()) {
            this.getPagamento().getCPFAlimentando().setConteudo("");
            this.lblAvisoDependenteAlimentandoVazio.setMensagem(MensagemUtil.getMensagem((String)"info_listagem", (String[])new String[]{"Dependentes"}));
        }
    }

    private void rdbAlimentandoActionPerformed(ActionEvent evt) {
        if (((PPGDRadioItem)evt.getSource()).isSelected()) {
            String codigoPagamento = this.pagamento.getCodigo().naoFormatado();
            if (codigoPagamento.equals("01") || codigoPagamento.equals("02")) {
                GuiUtil.mostrarInfo((String)"pagamento_aviso_alimentando_despesa_instrucao");
            } else if (codigoPagamento.equals("09") || codigoPagamento.equals("10") || codigoPagamento.equals("11") || codigoPagamento.equals("12") || codigoPagamento.equals("13") || codigoPagamento.equals("14") || codigoPagamento.equals("15") || codigoPagamento.equals("16") || codigoPagamento.equals("17") || codigoPagamento.equals("18") || codigoPagamento.equals("19") || codigoPagamento.equals("20") || codigoPagamento.equals("21") || codigoPagamento.equals("22") || codigoPagamento.equals("26")) {
                GuiUtil.mostrarInfo((String)"pagamento_aviso_alimentando_despesa_medica");
            }
        }
    }

    private void rdbDependenteKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 9 && this.cmbDependenteAlimentando.isVisible()) {
            this.cmbDependenteAlimentando.requestFocusInWindow();
        }
    }

    private void rdbTitularKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 9 && this.edtNi.isVisible()) {
            this.edtNi.requestFocusInWindow();
        } else if (evt.getKeyCode() == 9) {
            this.edtNomeBeneficiario.requestFocusInWindow();
        }
    }

    public ImageIcon getImagemTitulo() {
        return GuiUtil.getImage((String)"/icones/png40px/DE_pagamentos.png");
    }

    public JComponent getDefaultFocus() {
        return this.edtCodigo;
    }

    public String getTituloPainel() {
        boolean ehTransmitida = IRPFFacade.getInstancia().getDeclaracao().getCopiaIdentificador().isTransmitida();
        if (this.emEdicao) {
            if (ehTransmitida) {
                return "Detalhe Pagamento Efetuado";
            }
            return "Editar Pagamento Efetuado";
        }
        return "Novo Pagamento Efetuado";
    }

    public void executaVoltar() {
        ControladorGui.acionarPainel((String)NavegacaoIf.PAINEL_PAGAMENTOS);
    }

    public boolean isTelaComVoltar() {
        return true;
    }

    public boolean isTelaComCancelar() {
        return true;
    }

    public void executaCancelar() {
        if (this.emEdicao) {
            int posicao = ControladorGui.getDemonstrativoAberto().getPagamentos().itens().indexOf(this.pagamento);
            ControladorGui.getDemonstrativoAberto().getPagamentos().remove((ObjetoNegocio)this.pagamento);
            ControladorGui.getDemonstrativoAberto().getPagamentos().itens().add(posicao, this.itemInicial);
        } else {
            ControladorGui.getDemonstrativoAberto().getPagamentos().remove((ObjetoNegocio)this.pagamento);
        }
        ControladorGui.acionarPainel((PainelDemonstrativoIf)this.getPainelPai());
    }

    public PainelDemonstrativoIf getPainelPai() {
        return this.painelPai;
    }

    private void atualizaGui(String codigoPagamento, String tipoPagamento) {
        if (codigoPagamento.equals("01") || codigoPagamento.equals("09") || codigoPagamento.equals("10") || codigoPagamento.equals("11") || codigoPagamento.equals("12") || codigoPagamento.equals("13") || codigoPagamento.equals("14") || codigoPagamento.equals("21") || codigoPagamento.equals("26")) {
            this.lblTipo.setVisible(true);
            this.rdbTitular.setVisible(true);
            this.rdbDependente.setVisible(true);
            this.rdbAlimentando.setVisible(true);
            if (!tipoPagamento.equals("V")) {
                if (tipoPagamento.equals("T")) {
                    this.lblDependenteAlimentando.setVisible(false);
                    this.cmbDependenteAlimentando.setVisible(false);
                    this.lblAvisoDependenteAlimentandoVazio.setVisible(false);
                } else if (tipoPagamento.equals("A")) {
                    this.lblDependenteAlimentando.setVisible(true);
                    this.lblDependenteAlimentando.setText("Nome do alimentando");
                    List alimentandos = CadastroTabelasIRPF.recuperarNomesAlimentandos((String)"2");
                    this.cmbDependenteAlimentando.setDados(alimentandos);
                    this.cmbDependenteAlimentando.setVisible(true);
                    this.cmbDependenteAlimentando.getAccessibleContext().setAccessibleName("Nome do alimentando");
                    this.lblAvisoDependenteAlimentandoVazio.setVisible(true);
                } else if (tipoPagamento.equals("D")) {
                    this.lblDependenteAlimentando.setVisible(true);
                    this.lblDependenteAlimentando.setText("Nome do dependente");
                    List dependentes = CadastroTabelasIRPF.recuperarNomesDependentes();
                    this.cmbDependenteAlimentando.setDados(dependentes);
                    this.cmbDependenteAlimentando.setVisible(true);
                    this.cmbDependenteAlimentando.getAccessibleContext().setAccessibleName("Nome do dependente");
                    this.lblAvisoDependenteAlimentandoVazio.setVisible(true);
                }
            }
            this.edtNi.setVisible(true);
            this.edtNi.setTiposAceitos(this.obterTipoNI(codigoPagamento));
            this.ajustarTipoNI(codigoPagamento);
            this.lblNi.setVisible(true);
            this.lblNi.setText(MensagemUtil.getMensagem((String)("cpf_cnpj_cod_beneficiario_" + codigoPagamento)));
            this.edtNi.getAccessibleContext().setAccessibleName(MensagemUtil.getMensagem((String)("cpf_cnpj_cod_beneficiario_" + codigoPagamento)));
            this.lblNomeBeneficiario.setVisible(true);
            this.edtNomeBeneficiario.setVisible(true);
            this.lblNomeBeneficiario.setText(MensagemUtil.getMensagem((String)("nome_cod_beneficiario_" + codigoPagamento)));
            this.edtNomeBeneficiario.getAccessibleContext().setAccessibleName(MensagemUtil.getMensagem((String)("nome_cod_beneficiario_" + codigoPagamento)));
            this.lblNomeBeneficiario.repaint();
            this.lblParcNaoDedut.setVisible(true);
            this.edtParcNaoDedut.setVisible(true);
            this.lblParcNaoDedut.setText("<html>Parcela n&atilde;o dedut&iacute;vel/valor reembolsado</html>");
            this.lblParcNaoDedut.repaint();
            this.lblValorPago.setVisible(true);
            this.edtValorPago.setVisible(true);
            this.lblNit.setVisible(false);
            this.edtNit.setVisible(false);
            this.lblContribPatrocinador.setVisible(false);
            this.edtContribPatrocinador.setVisible(false);
            this.edtContribPatrocinador.getInformacao().clear();
        } else if (codigoPagamento.equals("02") || codigoPagamento.equals("15") || codigoPagamento.equals("16") || codigoPagamento.equals("17") || codigoPagamento.equals("18") || codigoPagamento.equals("19") || codigoPagamento.equals("20") || codigoPagamento.equals("22")) {
            this.lblTipo.setVisible(true);
            this.rdbTitular.setVisible(true);
            this.rdbDependente.setVisible(true);
            this.rdbAlimentando.setVisible(true);
            if (!tipoPagamento.equals("V")) {
                if (tipoPagamento.equals("T") || tipoPagamento.equals("V")) {
                    this.lblDependenteAlimentando.setVisible(false);
                    this.cmbDependenteAlimentando.setVisible(false);
                    this.lblAvisoDependenteAlimentandoVazio.setVisible(false);
                } else if (tipoPagamento.equals("A")) {
                    this.lblDependenteAlimentando.setVisible(true);
                    this.lblDependenteAlimentando.setText("Nome do alimentando");
                    List alimentandos = CadastroTabelasIRPF.recuperarNomesAlimentandos((String)"2");
                    this.cmbDependenteAlimentando.setVisible(true);
                    this.cmbDependenteAlimentando.getAccessibleContext().setAccessibleName("Nome do alimentando");
                    this.cmbDependenteAlimentando.setDados(alimentandos);
                    this.lblAvisoDependenteAlimentandoVazio.setVisible(true);
                } else if (tipoPagamento.equals("D")) {
                    this.lblDependenteAlimentando.setVisible(true);
                    this.lblDependenteAlimentando.setText("Nome do dependente");
                    List dependentes = CadastroTabelasIRPF.recuperarNomesDependentes();
                    this.cmbDependenteAlimentando.setVisible(true);
                    this.cmbDependenteAlimentando.getAccessibleContext().setAccessibleName("Nome do dependente");
                    this.cmbDependenteAlimentando.setDados(dependentes);
                    this.lblAvisoDependenteAlimentandoVazio.setVisible(true);
                }
            }
            this.edtNi.setVisible(false);
            this.lblNi.setVisible(false);
            this.edtNi.getInformacao().clear();
            this.lblNomeBeneficiario.setVisible(true);
            this.edtNomeBeneficiario.setVisible(true);
            this.lblNomeBeneficiario.setText(MensagemUtil.getMensagem((String)("nome_cod_beneficiario_" + codigoPagamento)));
            this.edtNomeBeneficiario.getAccessibleContext().setAccessibleName(MensagemUtil.getMensagem((String)("nome_cod_beneficiario_" + codigoPagamento)));
            this.lblNomeBeneficiario.repaint();
            this.lblParcNaoDedut.setVisible(true);
            this.edtParcNaoDedut.setVisible(true);
            this.lblParcNaoDedut.setText("<html>Parcela n&atilde;o dedut&iacute;vel/valor reembolsado</html>");
            this.lblParcNaoDedut.repaint();
            this.lblValorPago.setVisible(true);
            this.edtValorPago.setVisible(true);
            this.lblNit.setVisible(false);
            this.edtNit.setVisible(false);
            this.lblContribPatrocinador.setVisible(false);
            this.edtContribPatrocinador.setVisible(false);
            this.edtContribPatrocinador.getInformacao().clear();
        } else if (codigoPagamento.equals("30") || codigoPagamento.equals("31") || codigoPagamento.equals("33") || codigoPagamento.equals("34")) {
            this.lblTipo.setVisible(false);
            this.rdbTitular.setVisible(false);
            this.rdbDependente.setVisible(false);
            this.rdbAlimentando.setVisible(false);
            this.lblDependenteAlimentando.setVisible(true);
            this.lblDependenteAlimentando.setText("Nome do alimentando");
            this.cmbDependenteAlimentando.setVisible(true);
            this.cmbDependenteAlimentando.getAccessibleContext().setAccessibleName("Nome do alimentando");
            this.lblAvisoDependenteAlimentandoVazio.setVisible(true);
            this.lblAvisoDependenteAlimentandoVazio.setMensagem(MensagemUtil.getMensagem((String)"info_listagem", (String[])new String[]{"Alimentandos"}));
            if (codigoPagamento.equals("30") || codigoPagamento.equals("33")) {
                List alimentandos = CadastroTabelasIRPF.recuperarNomesAlimentandos((String)"0");
                this.cmbDependenteAlimentando.setDados(alimentandos);
            } else {
                List alimentandos = CadastroTabelasIRPF.recuperarNomesAlimentandos((String)"1");
                this.cmbDependenteAlimentando.setDados(alimentandos);
            }
            this.edtNi.setVisible(true);
            this.edtNi.setTiposAceitos(this.obterTipoNI(codigoPagamento));
            this.ajustarTipoNI(codigoPagamento);
            this.lblNi.setVisible(true);
            this.lblNi.setText(MensagemUtil.getMensagem((String)("cpf_cnpj_cod_beneficiario_" + codigoPagamento)));
            this.edtNi.getAccessibleContext().setAccessibleName(MensagemUtil.getMensagem((String)("cpf_cnpj_cod_beneficiario_" + codigoPagamento)));
            this.edtNi.setDisableButtonMensagem(false);
            this.lblNomeBeneficiario.setVisible(false);
            this.edtNomeBeneficiario.setVisible(false);
            this.lblParcNaoDedut.setVisible(true);
            this.edtParcNaoDedut.setVisible(true);
            this.lblParcNaoDedut.setText("<html>Parcela n&atilde;o dedut&iacute;vel/valor reembolsado</html>");
            this.lblParcNaoDedut.repaint();
            this.lblValorPago.setVisible(true);
            this.edtValorPago.setVisible(true);
            this.lblNit.setVisible(false);
            this.edtNit.setVisible(false);
            this.lblContribPatrocinador.setVisible(false);
            this.edtContribPatrocinador.setVisible(false);
            this.edtContribPatrocinador.getInformacao().clear();
        } else if (codigoPagamento.equals("36") || codigoPagamento.equals("37")) {
            this.lblTipo.setVisible(true);
            this.rdbTitular.setVisible(true);
            this.rdbDependente.setVisible(true);
            this.rdbAlimentando.setVisible(false);
            if (!tipoPagamento.equals("V")) {
                if (tipoPagamento.equals("A")) {
                    this.lblDependenteAlimentando.setText("Nome");
                    ArrayList listaVazia = new ArrayList();
                    this.cmbDependenteAlimentando.setDados(listaVazia);
                }
                if (tipoPagamento.equals("T")) {
                    this.lblDependenteAlimentando.setVisible(false);
                    this.cmbDependenteAlimentando.setVisible(false);
                    this.lblAvisoDependenteAlimentandoVazio.setVisible(false);
                } else if (tipoPagamento.equals("D")) {
                    this.lblDependenteAlimentando.setVisible(true);
                    this.lblDependenteAlimentando.setText("Nome do dependente");
                    List dependentes = CadastroTabelasIRPF.recuperarNomesDependentes();
                    this.cmbDependenteAlimentando.setVisible(true);
                    this.cmbDependenteAlimentando.getAccessibleContext().setAccessibleName("Nome do dependente");
                    this.cmbDependenteAlimentando.setDados(dependentes);
                    this.lblAvisoDependenteAlimentandoVazio.setVisible(true);
                }
            }
            this.edtNi.setVisible(true);
            this.edtNi.setTiposAceitos(this.obterTipoNI(codigoPagamento));
            this.ajustarTipoNI(codigoPagamento);
            this.lblNi.setVisible(true);
            this.lblNi.setText(MensagemUtil.getMensagem((String)("cpf_cnpj_cod_beneficiario_" + codigoPagamento)));
            this.edtNi.getAccessibleContext().setAccessibleName(MensagemUtil.getMensagem((String)("cpf_cnpj_cod_beneficiario_" + codigoPagamento)));
            this.lblNi.repaint();
            this.lblNomeBeneficiario.setVisible(true);
            this.edtNomeBeneficiario.setVisible(true);
            this.lblNomeBeneficiario.setText(MensagemUtil.getMensagem((String)("nome_cod_beneficiario_" + codigoPagamento)));
            this.edtNomeBeneficiario.getAccessibleContext().setAccessibleName(MensagemUtil.getMensagem((String)("nome_cod_beneficiario_" + codigoPagamento)));
            this.lblNomeBeneficiario.repaint();
            this.lblNit.setVisible(false);
            this.edtNit.setVisible(false);
            this.lblValorPago.setVisible(true);
            this.edtValorPago.setVisible(true);
            if (codigoPagamento.equals("36")) {
                this.lblParcNaoDedut.setVisible(true);
                this.edtParcNaoDedut.setVisible(true);
                this.lblParcNaoDedut.setText("<html>Parcela n&atilde;o dedut&iacute;vel</html>");
                this.lblParcNaoDedut.repaint();
                this.pagamento.getContribuicaoEntePatrocinador().clear();
            } else {
                this.lblParcNaoDedut.setVisible(false);
                this.edtParcNaoDedut.setVisible(false);
                this.edtParcNaoDedut.getInformacao().clear();
            }
            this.lblContribPatrocinador.setVisible(codigoPagamento.equals("37"));
            this.edtContribPatrocinador.setVisible(codigoPagamento.equals("37"));
        } else if (codigoPagamento.equals("50")) {
            this.lblTipo.setVisible(false);
            this.rdbTitular.setVisible(false);
            this.rdbDependente.setVisible(false);
            this.rdbAlimentando.setVisible(false);
            this.lblDependenteAlimentando.setVisible(false);
            this.cmbDependenteAlimentando.setVisible(false);
            this.lblAvisoDependenteAlimentandoVazio.setVisible(false);
            this.edtNi.setVisible(true);
            this.edtNi.setTiposAceitos(this.obterTipoNI(codigoPagamento));
            this.ajustarTipoNI(codigoPagamento);
            this.lblNi.setVisible(true);
            this.lblNi.setText(MensagemUtil.getMensagem((String)("cpf_cnpj_cod_beneficiario_" + codigoPagamento)));
            this.edtNi.getAccessibleContext().setAccessibleName(MensagemUtil.getMensagem((String)("cpf_cnpj_cod_beneficiario_" + codigoPagamento)));
            this.lblNi.repaint();
            this.lblNomeBeneficiario.setVisible(true);
            this.edtNomeBeneficiario.setVisible(true);
            this.lblNomeBeneficiario.setText(MensagemUtil.getMensagem((String)("nome_cod_beneficiario_" + codigoPagamento)));
            this.edtNomeBeneficiario.getAccessibleContext().setAccessibleName(MensagemUtil.getMensagem((String)("nome_cod_beneficiario_" + codigoPagamento)));
            this.lblNomeBeneficiario.repaint();
            this.lblParcNaoDedut.setVisible(true);
            this.edtParcNaoDedut.setVisible(true);
            this.lblParcNaoDedut.setText("<html>Parcela n&atilde;o dedut&iacute;vel</html>");
            this.lblParcNaoDedut.repaint();
            this.lblNit.setVisible(true);
            this.edtNit.setVisible(true);
            this.lblValorPago.setVisible(true);
            this.edtValorPago.setVisible(true);
            this.lblContribPatrocinador.setVisible(false);
            this.edtContribPatrocinador.setVisible(false);
            this.edtContribPatrocinador.getInformacao().clear();
        } else if (codigoPagamento.equals("60") || codigoPagamento.equals("61") || codigoPagamento.equals("62")) {
            this.lblTipo.setVisible(false);
            this.rdbTitular.setVisible(false);
            this.rdbDependente.setVisible(false);
            this.rdbAlimentando.setVisible(false);
            this.lblDependenteAlimentando.setVisible(false);
            this.cmbDependenteAlimentando.setVisible(false);
            this.lblAvisoDependenteAlimentandoVazio.setVisible(false);
            this.edtNi.setVisible(true);
            this.edtNi.setTiposAceitos(this.obterTipoNI(codigoPagamento));
            this.ajustarTipoNI(codigoPagamento);
            this.lblNi.setVisible(true);
            this.lblNi.setText(MensagemUtil.getMensagem((String)("cpf_cnpj_cod_beneficiario_" + codigoPagamento)));
            this.edtNi.getAccessibleContext().setAccessibleName(MensagemUtil.getMensagem((String)("cpf_cnpj_cod_beneficiario_" + codigoPagamento)));
            this.lblNi.repaint();
            this.lblNomeBeneficiario.setVisible(true);
            this.edtNomeBeneficiario.setVisible(true);
            this.lblNomeBeneficiario.setText(MensagemUtil.getMensagem((String)("nome_cod_beneficiario_" + codigoPagamento)));
            this.edtNomeBeneficiario.getAccessibleContext().setAccessibleName(MensagemUtil.getMensagem((String)("nome_cod_beneficiario_" + codigoPagamento)));
            this.lblNomeBeneficiario.repaint();
            this.lblParcNaoDedut.setText("<html>Parcela n&atilde;o dedut&iacute;vel/valor reembolsado</html>");
            this.lblParcNaoDedut.repaint();
            this.lblNit.setVisible(false);
            this.edtNit.setVisible(false);
            this.lblValorPago.setVisible(true);
            this.edtValorPago.setVisible(true);
            this.lblParcNaoDedut.setVisible(false);
            this.edtParcNaoDedut.setVisible(false);
            this.edtParcNaoDedut.getInformacao().clear();
            this.lblContribPatrocinador.setVisible(false);
            this.edtContribPatrocinador.setVisible(false);
            this.edtContribPatrocinador.getInformacao().clear();
        } else if (codigoPagamento.equals("66")) {
            this.lblTipo.setVisible(false);
            this.rdbTitular.setVisible(false);
            this.rdbDependente.setVisible(false);
            this.rdbAlimentando.setVisible(false);
            this.lblDependenteAlimentando.setVisible(false);
            this.cmbDependenteAlimentando.setVisible(false);
            this.lblAvisoDependenteAlimentandoVazio.setVisible(false);
            this.edtNi.setVisible(true);
            this.edtNi.setTiposAceitos(this.obterTipoNI(codigoPagamento));
            this.ajustarTipoNI(codigoPagamento);
            this.lblNi.setVisible(true);
            this.lblNi.setText(MensagemUtil.getMensagem((String)("cpf_cnpj_cod_beneficiario_" + codigoPagamento)));
            this.edtNi.getAccessibleContext().setAccessibleName(MensagemUtil.getMensagem((String)("cpf_cnpj_cod_beneficiario_" + codigoPagamento)));
            this.lblNi.repaint();
            this.lblNomeBeneficiario.setVisible(true);
            this.edtNomeBeneficiario.setVisible(true);
            this.lblNomeBeneficiario.setText(MensagemUtil.getMensagem((String)("nome_cod_beneficiario_" + codigoPagamento)));
            this.edtNomeBeneficiario.getAccessibleContext().setAccessibleName(MensagemUtil.getMensagem((String)("nome_cod_beneficiario_" + codigoPagamento)));
            this.lblNomeBeneficiario.repaint();
            this.lblNit.setVisible(false);
            this.edtNit.setVisible(false);
            this.lblValorPago.setVisible(true);
            this.edtValorPago.setVisible(true);
            this.lblParcNaoDedut.setVisible(false);
            this.edtParcNaoDedut.setVisible(false);
            this.edtParcNaoDedut.getInformacao().clear();
            this.lblContribPatrocinador.setVisible(false);
            this.edtContribPatrocinador.setVisible(false);
            this.edtContribPatrocinador.getInformacao().clear();
        } else if (codigoPagamento.equals("76")) {
            this.lblTipo.setVisible(false);
            this.rdbTitular.setVisible(false);
            this.rdbDependente.setVisible(false);
            this.rdbAlimentando.setVisible(false);
            this.lblDependenteAlimentando.setVisible(false);
            this.cmbDependenteAlimentando.setVisible(false);
            this.lblAvisoDependenteAlimentandoVazio.setVisible(false);
            this.edtNi.setVisible(true);
            this.edtNi.setTiposAceitos(this.obterTipoNI(codigoPagamento));
            this.ajustarTipoNI(codigoPagamento);
            this.lblNi.setVisible(true);
            this.lblNi.setText(MensagemUtil.getMensagem((String)("cpf_cnpj_cod_beneficiario_" + codigoPagamento)));
            this.edtNi.getAccessibleContext().setAccessibleName(MensagemUtil.getMensagem((String)("cpf_cnpj_cod_beneficiario_" + codigoPagamento)));
            this.lblNi.repaint();
            this.lblNomeBeneficiario.setVisible(true);
            this.edtNomeBeneficiario.setVisible(true);
            this.lblNomeBeneficiario.setText(MensagemUtil.getMensagem((String)("nome_cod_beneficiario_" + codigoPagamento)));
            this.edtNomeBeneficiario.getAccessibleContext().setAccessibleName(MensagemUtil.getMensagem((String)("nome_cod_beneficiario_" + codigoPagamento)));
            this.lblNomeBeneficiario.repaint();
            this.lblNit.setVisible(false);
            this.edtNit.setVisible(false);
            this.lblValorPago.setVisible(true);
            this.edtValorPago.setVisible(true);
            this.lblParcNaoDedut.setVisible(false);
            this.edtParcNaoDedut.setVisible(false);
            this.edtParcNaoDedut.getInformacao().clear();
            this.lblContribPatrocinador.setVisible(false);
            this.edtContribPatrocinador.setVisible(false);
            this.edtContribPatrocinador.getInformacao().clear();
        } else if (codigoPagamento.equals("70") || codigoPagamento.equals("71") || codigoPagamento.equals("72")) {
            this.lblTipo.setVisible(false);
            this.rdbTitular.setVisible(false);
            this.rdbDependente.setVisible(false);
            this.rdbAlimentando.setVisible(false);
            this.lblDependenteAlimentando.setVisible(false);
            this.cmbDependenteAlimentando.setVisible(false);
            this.lblAvisoDependenteAlimentandoVazio.setVisible(false);
            this.edtNi.setVisible(true);
            this.edtNi.setTiposAceitos(this.obterTipoNI(codigoPagamento));
            this.ajustarTipoNI(codigoPagamento);
            this.lblNi.setVisible(true);
            this.lblNi.setText(MensagemUtil.getMensagem((String)("cpf_cnpj_cod_beneficiario_" + codigoPagamento)));
            this.edtNi.getAccessibleContext().setAccessibleName(MensagemUtil.getMensagem((String)("cpf_cnpj_cod_beneficiario_" + codigoPagamento)));
            this.lblNi.repaint();
            this.lblNomeBeneficiario.setVisible(true);
            this.edtNomeBeneficiario.setVisible(true);
            this.lblNomeBeneficiario.setText(MensagemUtil.getMensagem((String)("nome_cod_beneficiario_" + codigoPagamento)));
            this.edtNomeBeneficiario.getAccessibleContext().setAccessibleName(MensagemUtil.getMensagem((String)("nome_cod_beneficiario_" + codigoPagamento)));
            this.lblNomeBeneficiario.repaint();
            this.lblNit.setVisible(false);
            this.edtNit.setVisible(false);
            this.lblValorPago.setVisible(true);
            this.edtValorPago.setVisible(true);
            this.lblParcNaoDedut.setVisible(false);
            this.edtParcNaoDedut.setVisible(false);
            this.edtParcNaoDedut.getInformacao().clear();
            this.lblContribPatrocinador.setVisible(false);
            this.edtContribPatrocinador.setVisible(false);
            this.edtContribPatrocinador.getInformacao().clear();
        } else if (codigoPagamento.equals("99")) {
            this.lblTipo.setVisible(true);
            this.rdbTitular.setVisible(true);
            this.rdbDependente.setVisible(true);
            this.rdbAlimentando.setVisible(false);
            if (!tipoPagamento.equals("V")) {
                if (tipoPagamento.equals("A")) {
                    this.lblDependenteAlimentando.setText("Nome");
                    ArrayList listaVazia = new ArrayList();
                    this.cmbDependenteAlimentando.setDados(listaVazia);
                }
                if (tipoPagamento.equals("T")) {
                    this.lblDependenteAlimentando.setVisible(false);
                    this.cmbDependenteAlimentando.setVisible(false);
                    this.lblAvisoDependenteAlimentandoVazio.setVisible(false);
                } else if (tipoPagamento.equals("D")) {
                    this.lblDependenteAlimentando.setVisible(true);
                    this.lblDependenteAlimentando.setText("Nome do dependente");
                    List dependentes = CadastroTabelasIRPF.recuperarNomesDependentes();
                    this.cmbDependenteAlimentando.setVisible(true);
                    this.cmbDependenteAlimentando.getAccessibleContext().setAccessibleName("Nome do dependente");
                    this.cmbDependenteAlimentando.setDados(dependentes);
                    this.lblAvisoDependenteAlimentandoVazio.setVisible(true);
                }
            }
            this.edtNi.setVisible(true);
            this.edtNi.setTiposAceitos(this.obterTipoNI(codigoPagamento));
            this.ajustarTipoNI(codigoPagamento);
            this.lblNi.setVisible(true);
            this.lblNi.setText(MensagemUtil.getMensagem((String)"cpf_cnpj_cod_beneficiario"));
            this.edtNi.getAccessibleContext().setAccessibleName(MensagemUtil.getMensagem((String)"cpf_cnpj_cod_beneficiario"));
            this.lblNi.repaint();
            this.lblNomeBeneficiario.setVisible(true);
            this.edtNomeBeneficiario.setVisible(true);
            this.lblNomeBeneficiario.setText(MensagemUtil.getMensagem((String)"nome_cod_beneficiario"));
            this.edtNomeBeneficiario.getAccessibleContext().setAccessibleName(MensagemUtil.getMensagem((String)"nome_cod_beneficiario"));
            this.lblNomeBeneficiario.repaint();
            this.lblNit.setVisible(false);
            this.edtNit.setVisible(false);
            this.lblValorPago.setVisible(true);
            this.edtValorPago.setVisible(true);
            this.lblParcNaoDedut.setVisible(false);
            this.edtParcNaoDedut.setVisible(false);
            this.edtParcNaoDedut.getInformacao().clear();
            this.lblContribPatrocinador.setVisible(false);
            this.edtContribPatrocinador.setVisible(false);
            this.edtContribPatrocinador.getInformacao().clear();
        } else {
            this.lblTipo.setVisible(false);
            this.rdbTitular.setVisible(false);
            this.rdbDependente.setVisible(false);
            this.rdbAlimentando.setVisible(false);
            this.lblDependenteAlimentando.setVisible(false);
            this.cmbDependenteAlimentando.setVisible(false);
            this.lblAvisoDependenteAlimentandoVazio.setVisible(false);
            this.lblNomeBeneficiario.setVisible(false);
            this.edtNomeBeneficiario.setVisible(false);
            this.lblNi.setVisible(false);
            this.edtNi.setVisible(false);
            this.lblNit.setVisible(false);
            this.edtNit.setVisible(false);
            this.lblValorPago.setVisible(false);
            this.edtValorPago.setVisible(false);
            this.lblParcNaoDedut.setVisible(false);
            this.edtParcNaoDedut.setVisible(false);
            this.lblContribPatrocinador.setVisible(false);
            this.edtContribPatrocinador.setVisible(false);
        }
        this.ajustarVisibilidadePais(codigoPagamento);
    }

    private void ajustarVisibilidadePais(String codigoPagamento) {
        if (this.pagamento.isPagamentoExterior(codigoPagamento)) {
            this.lblLocalizacao.setVisible(true);
            this.edtLocalizacao.setVisible(true);
        } else {
            this.edtLocalizacao.getInformacao().clear();
            this.lblLocalizacao.setVisible(false);
            this.edtLocalizacao.setVisible(false);
        }
    }

    private void alterarVisibilidadeTodosCampos(boolean visivel) {
        this.lblTipo.setVisible(false);
        this.rdbTitular.setVisible(false);
        this.rdbDependente.setVisible(false);
        this.rdbAlimentando.setVisible(false);
        this.lblDependenteAlimentando.setVisible(visivel);
        this.cmbDependenteAlimentando.setVisible(visivel);
        this.lblAvisoDependenteAlimentandoVazio.setVisible(visivel);
        this.lblNomeBeneficiario.setVisible(visivel);
        this.edtNomeBeneficiario.setVisible(visivel);
        this.lblNi.setVisible(visivel);
        this.edtNi.setVisible(visivel);
        this.lblNit.setVisible(visivel);
        this.edtNit.setVisible(visivel);
        this.lblValorPago.setVisible(visivel);
        this.edtValorPago.setVisible(visivel);
        this.lblParcNaoDedut.setVisible(visivel);
        this.edtParcNaoDedut.setVisible(visivel);
    }

    private byte obterTipoNI(String codigoPagamento) {
        int retorno = 0;
        if (codigoPagamento.equals("60") || codigoPagamento.equals("62") || codigoPagamento.equals("61") || codigoPagamento.equals("70") || codigoPagamento.equals("71") || codigoPagamento.equals("72") || codigoPagamento.equals("76") || codigoPagamento.equals("99")) {
            retorno = 0;
        } else if (codigoPagamento.equals("09") || codigoPagamento.equals("10") || codigoPagamento.equals("11") || codigoPagamento.equals("12") || codigoPagamento.equals("13") || codigoPagamento.equals("14") || codigoPagamento.equals("30") || codigoPagamento.equals("31") || codigoPagamento.equals("33") || codigoPagamento.equals("34") || codigoPagamento.equals("50") || codigoPagamento.equals("66") || codigoPagamento.equals("76")) {
            retorno = 1;
        } else if (codigoPagamento.equals("01") || codigoPagamento.equals("21") || codigoPagamento.equals("26") || codigoPagamento.equals("36") || codigoPagamento.equals("37")) {
            retorno = 2;
        }
        return (byte)retorno;
    }

    private void ajustarTipoNI(String codigoPagamento) {
        if (this.obterTipoNI(codigoPagamento) == 2 && this.edtNi.getInformacao().naoFormatado().length() != 14) {
            this.edtNi.getInformacao().clear();
            this.edtNi.setarMascaraCNPJ();
        } else if (this.obterTipoNI(codigoPagamento) == 1 && this.edtNi.getInformacao().naoFormatado().length() != 11) {
            this.edtNi.getInformacao().clear();
            this.edtNi.setarMascaraCPF();
        }
    }

    public Pagamento getPagamento() {
        return this.pagamento;
    }

    public boolean isNovoItem() {
        return this.novoItem;
    }

    public void setNovoItem(boolean novoItem) {
        this.novoItem = novoItem;
    }

    public void setPagamento(Pagamento pagamento) {
        this.pagamento = pagamento;
    }

    public void preExibir() {
        if (this.pagamento.getTipo().isVazio()) {
            this.pagamento.getTipo().setConteudo("V");
        }
    }

    public String getHelpID() {
        return HELP_ID;
    }

    public boolean isTelaComFavoritos() {
        return false;
    }

    public boolean isPodeSair() {
        String msg = this.pagamento.obterMensagemExcedeuLimiteDeducaoPrevPrivadaFunpresp();
        if (msg != null) {
            GuiUtil.mostrarInfo((Component)ControladorGui.getJanelaPrincipal(), (String)msg);
        }
        return true;
    }
}

