/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.pagamentos;

import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import serpro.ppgd.app.acoes.ImportarInformePlanoSaudeAction;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.IRPFTableModelAb;
import serpro.ppgd.irpf.gui.PainelDemonstrativoAb;
import serpro.ppgd.irpf.gui.PainelDemonstrativoIf;
import serpro.ppgd.irpf.gui.PainelListaAb;
import serpro.ppgd.irpf.gui.TableLista;
import serpro.ppgd.irpf.gui.TableListaModel;
import serpro.ppgd.irpf.gui.pagamentos.PainelPagamentosDetalhe;
import serpro.ppgd.irpf.gui.pagamentos.TableModelPagamentos;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.irpf.pagamentos.Pagamento;
import serpro.ppgd.irpf.pagamentos.Pagamentos;
import serpro.ppgd.negocio.ObjetoNegocio;

public class PainelPagamentosLista
extends PainelListaAb {
    private static final long serialVersionUID = 1L;
    private static final String TITULO = "Pagamentos Efetuados";
    private static final Integer COLUNA_DESPESA_REALIZADA_COM = 4;

    protected String getButtonHelpID() {
        return "Fichas da Declara\u00e7\u00e3o/Pagamentos Efetuados";
    }

    protected String getClassePainelNavegacao() {
        return PainelPagamentosDetalhe.class.getName();
    }

    public String getTituloPainel() {
        return TITULO;
    }

    protected int getColunaOrdenacao() {
        return 0;
    }

    protected Integer[] getColunasOrdenaveis() {
        return new Integer[]{0, 1, 3};
    }

    protected TableListaModel getTableModel() {
        return new TableModelPagamentos(IRPFFacade.getInstancia().getPagamentos());
    }

    protected TableLista instanciarTabela(TableListaModel model, int colunaOrdenacao, Integer[] colunasOrdenaveis) {
        TableLista tableLista2 = new TableLista(model, colunaOrdenacao, colunasOrdenaveis);
        tableLista2.accessibleColumnHeader = new String[]{"Item", "C\u00f3digo", "Nome do benefici\u00e1rio", "CPF/CNPJ do Benefici\u00e1rio", "Despesa Realizada Com (Titular/Dependente/Alimentando)", "Valor pago", "Parcela N\u00e3o Dedut\u00edvel<"};
        return tableLista2;
    }

    protected void configurarTamanhoColunas() {
        TableColumnModel tcm = this.getTabela().getColumnModel();
        tcm.getColumn(0).setPreferredWidth(50);
        tcm.getColumn(1).setPreferredWidth(50);
        tcm.getColumn(2).setPreferredWidth(300);
        tcm.getColumn(3).setPreferredWidth(160);
        tcm.getColumn(4).setPreferredWidth(200);
        tcm.getColumn(5).setPreferredWidth(120);
        tcm.getColumn(6).setPreferredWidth(120);
        this.updateRowHeights();
    }

    private void updateRowHeights() {
        this.getTabela().setRowHeight(30);
    }

    public PainelDemonstrativoAb getPainelEditarItem(ObjetoNegocio obj) {
        return new PainelPagamentosDetalhe((PainelDemonstrativoIf)this, (Pagamento)obj, false, true);
    }

    public void onBtnAbrirClick(ActionEvent e) {
        if (this.getTabela().getSelectedRow() >= 0 && this.getTabela().getSelectedRow() < this.getTabela().getRowCount()) {
            int nLinha = this.getTabela().getSelectedRow();
            int indiceVetor = ((TableRowSorter)this.getTabela().getRowSorter()).convertRowIndexToModel(nLinha);
            IRPFTableModelAb model = (IRPFTableModelAb)this.getTabela().getModel();
            Pagamentos colecao = (Pagamentos)model.getObjetoNegocio();
            ControladorGui.acionarPainel((PainelDemonstrativoIf)this.getPainelEditarItem((ObjetoNegocio)colecao.itens().get(indiceVetor)));
        } else {
            GuiUtil.mostrarAviso((String)"ErroSelecioneItem");
        }
    }

    public String getMensagemExclusao() {
        return "ConfirmaExcluirItens1";
    }

    public String[] getParametrosMensagemExclusao() {
        return new String[]{"pagamento(s)"};
    }

    public PainelDemonstrativoAb getPainelNovoItem() {
        Pagamento pagamento = new Pagamento(ControladorGui.getDemonstrativoAberto());
        ControladorGui.getDemonstrativoAberto().getPagamentos().itens().add(pagamento);
        return new PainelPagamentosDetalhe((PainelDemonstrativoIf)this, pagamento, true, false);
    }

    public void onBtnNovoClick(ActionEvent e) {
        ControladorGui.acionarPainel((PainelDemonstrativoIf)this.getPainelNovoItem());
    }

    public ImageIcon getImagemTitulo() {
        return GuiUtil.getImage((String)"/icones/png40px/DE_pagamentos.png");
    }

    public String getMensagemTela() {
        String retorno = null;
        retorno = IRPFFacade.getInstancia().getDeclaracao().getIdentificadorDeclaracao().isAjuste() ? "<html>Ao preencher esta ficha, relacione os pagamentos efetuados pelo titular e pelos dependentes relacionados na ficha Dependentes, sem preju\u00edzo da op\u00e7\u00e3o pela forma de tributa\u00e7\u00e3o utilizada (por dedu\u00e7\u00f5es legais ou por desconto simplificado).</html>" : "<html>Ao preencher esta ficha, o contribuinte deve informar os pagamentos efetuados pelo titular e pelos dependentes relacionados na ficha Dependentes.</html>";
        return retorno;
    }

    public boolean isTelaComMensagem() {
        return true;
    }

    public boolean isTelaComImportacao() {
        return true;
    }

    public String getLabelImportacao() {
        return "Importar arquivo do plano de sa\u00fade";
    }

    public Action obterImportacaoAction() {
        return new ImportarInformePlanoSaudeAction();
    }

    public void preExibir() {
        IRPFFacade.getInstancia().getPagamentos().reordenaPorCodigo();
        super.preExibir();
    }

    public boolean isTelaComFavoritos() {
        return true;
    }
}

