/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.rendIsentos;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import serpro.ppgd.cacheni.CacheNI;
import serpro.ppgd.gui.xbeans.JEditAlfa;
import serpro.ppgd.gui.xbeans.JEditCampo;
import serpro.ppgd.gui.xbeans.JEditCodigo;
import serpro.ppgd.gui.xbeans.JEditNI;
import serpro.ppgd.gui.xbeans.JEditValor;
import serpro.ppgd.gui.xbeans.autocomplete.JAutoCompleteEditCPF;
import serpro.ppgd.infraestrutura.util.FontesUtil;
import serpro.ppgd.irpf.bens.Bem;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.NavegacaoIf;
import serpro.ppgd.irpf.gui.PainelAbaAb;
import serpro.ppgd.irpf.gui.PainelDemonstrativoAb;
import serpro.ppgd.irpf.gui.PainelDemonstrativoIf;
import serpro.ppgd.irpf.gui.bens.PainelBensDetalhe;
import serpro.ppgd.irpf.gui.bens.PainelBensDetalheEspolio;
import serpro.ppgd.irpf.gui.componente.JTaskAction;
import serpro.ppgd.irpf.gui.rendIsentos.PainelAbaRendIsentosLista;
import serpro.ppgd.irpf.gui.rendIsentos.PainelMensagemRendimento65;
import serpro.ppgd.irpf.gui.rendIsentos.TableModelRendIsentos;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.irpf.rendIsentos.ItemQuadroAuxiliarAb;
import serpro.ppgd.irpf.rendIsentos.ItemQuadroPensaoAlimenticiaRendIsentos;
import serpro.ppgd.irpf.rendIsentos.RendIsentos;
import serpro.ppgd.irpf.tabelas.CadastroTabelasIRPF;
import serpro.ppgd.irpf.tabelas.CodigoTabelaMensagens;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.negocio.ElementoTabela;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Observador;

public class PainelAbaDetalhes03X
extends PainelAbaAb {
    private PainelDemonstrativoIf painelPai;
    private ItemQuadroAuxiliarAb item;
    private boolean novoItem;
    private String codTipo;
    private Bem bem = null;
    private JButton btnBemAssociado;
    private JAutoCompleteEditCPF cmbBeneficiario;
    private JEditValor edt13Salario;
    private JEditNI edtNi;
    private JEditAlfa edtNome;
    private JEditCodigo edtTipoBeneficiario;
    private JEditAlfa edtTitular;
    private JEditValor edtValor;
    private JPanel jPanel1;
    private JLabel lbl13Salario;
    private JLabel lblAjuda;
    private JLabel lblBemAssociado;
    private JLabel lblBeneficiario;
    private JLabel lblNIFontePagadora;
    private JLabel lblNomeFontePagadora;
    private JLabel lblTipoBeneficiario;
    private JLabel lblTipoRendIsento;
    private JLabel lblValor;

    public PainelAbaDetalhes03X(PainelDemonstrativoIf painelPai, String codTipo, String descricaoCompleta, ItemQuadroAuxiliarAb item, boolean novoItem) {
        super(painelPai);
        this.painelPai = painelPai;
        this.codTipo = codTipo;
        this.item = item;
        this.novoItem = novoItem;
        if (!item.getCodBem().isVazio()) {
            this.bem = ControladorGui.getDemonstrativoAberto().getBens().obterBemPorIndice(item.getCodBem().naoFormatado());
        }
        this.initComponents();
        this.lblTipoRendIsento.setText("<html><b><font color='#004a6a'>" + codTipo + ". </font></b>" + descricaoCompleta + "</html>");
        this.associarInformacao();
        this.adicionarObservadores();
        this.atualizaGui();
        this.atualizarLabels(codTipo);
        this.verificarExibicaoPensao65Anos(codTipo);
        this.configurarUIBemVinculado();
        this.listenerAcessoBemAssociado();
        this.lblAjuda.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                GuiUtil.exibeDialog((JComponent)new PainelMensagemRendimento65(), (boolean)true, (String)"Aviso", (boolean)false);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                PainelAbaDetalhes03X.this.lblAjuda.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                PainelAbaDetalhes03X.this.lblAjuda.setCursor(new Cursor(0));
            }
        });
    }

    private void verificarExibicaoPensao65Anos(String codTipo) {
        if (RendIsentos.TIPO_RENDISENTO_10.equals(codTipo)) {
            this.lbl13Salario.setVisible(true);
            this.edt13Salario.setVisible(true);
            this.lblAjuda.setVisible(true);
        } else {
            this.lbl13Salario.setVisible(false);
            this.edt13Salario.setVisible(false);
            this.lblAjuda.setVisible(false);
        }
    }

    private void atualizarLabels(String codTipo) {
        if ("04".equals(codTipo) || "16".equals(codTipo)) {
            this.lblNIFontePagadora.setText("CPF/CNPJ da Fonte Pagadora");
        } else if ("14".equals(codTipo)) {
            this.lblNIFontePagadora.setText("CPF/CNPJ do Doador/Esp\u00f3lio");
            this.lblNomeFontePagadora.setText("Nome do Doador/Esp\u00f3lio");
        } else if (RendIsentos.TIPO_RENDISENTO_28.equals(codTipo)) {
            this.lblNIFontePagadora.setText("CPF do Alimentante");
        }
    }

    private void associarInformacao() {
        this.edtTipoBeneficiario.setInformacao((Informacao)this.item.getTipoBeneficiario());
        this.cmbBeneficiario.setInformacao((Informacao)this.item.getCpfBeneficiario());
        this.edtValor.setInformacao((Informacao)this.item.getValor());
        this.edt13Salario.setInformacao((Informacao)this.item.getValor13Salario());
        if (RendIsentos.TIPO_RENDISENTO_28.equals(this.codTipo)) {
            this.edtNi.setInformacao((Informacao)((ItemQuadroPensaoAlimenticiaRendIsentos)this.item).getCpfAlimentante());
        } else {
            this.edtNi.setInformacao((Informacao)this.item.getNIFontePagadora());
            this.edtNome.setInformacao((Informacao)this.item.getNomeFontePagadora());
        }
        CacheNI.getInstancia().bindEditCampoNI((JEditCampo)this.edtNi);
        CacheNI.getInstancia().bindEditCampoAlfa((JEditCampo)this.edtNome);
    }

    public void ajustaTipoDependenteNVDA() {
        JComboBox j = (JComboBox)this.edtTipoBeneficiario.getComponenteEditor();
        int indice = j.getSelectedIndex();
        int total = j.getItemCount();
        if (indice == 0 && total == 2) {
            j.setSelectedIndex(1);
            j.validate();
            j.setSelectedIndex(indice);
            j.validate();
        }
    }

    private void adicionarObservadores() {
        this.edtTipoBeneficiario.getInformacao().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                if (PainelAbaDetalhes03X.this.edtTipoBeneficiario.getInformacao().getNomeCampo().equals(nomePropriedade) && valorAntigo != null && !valorAntigo.equals(valorNovo)) {
                    PainelAbaDetalhes03X.this.atualizaGui();
                }
            }
        });
    }

    private void atualizaGui() {
        String tipoBeneficiario = this.edtTipoBeneficiario.getInformacao().naoFormatado();
        if (tipoBeneficiario.equals("Titular")) {
            this.cmbBeneficiario.setDados(CadastroTabelasIRPF.recuperarTitular());
            this.cmbBeneficiario.getComponenteEditor().setEnabled(false);
            this.cmbBeneficiario.setVisible(false);
            this.edtTitular.setVisible(true);
            ElementoTabela elemento = (ElementoTabela)CadastroTabelasIRPF.recuperarTitular().get(0);
            this.edtTitular.getInformacao().setConteudo(elemento.getConteudo(1));
            this.edtTitular.getInformacao().setReadOnly(true);
        } else if (tipoBeneficiario.equals("Dependente")) {
            this.cmbBeneficiario.setDados(CadastroTabelasIRPF.recuperarDependentes());
            this.cmbBeneficiario.getComponenteEditor().setEnabled(true);
            this.cmbBeneficiario.getInformacao().sinalizaValidoEdit();
            this.cmbBeneficiario.setVisible(true);
            this.edtTitular.setVisible(false);
        } else {
            this.cmbBeneficiario.getComponenteEditor().setEnabled(false);
            this.cmbBeneficiario.setVisible(true);
            this.edtTitular.setVisible(false);
        }
        if (this.codTipo.equals(RendIsentos.TIPO_RENDISENTO_28)) {
            this.edtNome.setVisible(false);
            this.lblNomeFontePagadora.setVisible(false);
        }
    }

    private void configurarUIBemVinculado() {
        boolean temBemAssociado = false;
        if (this.bem != null && this.bem.buscarRendimentoIsentoAssociado(this.codTipo, ControladorGui.getDemonstrativoAberto()) != null) {
            temBemAssociado = true;
        }
        this.item.getTipoBeneficiario().setReadOnly(temBemAssociado);
        this.item.getTipoBeneficiario().setHabilitado(!temBemAssociado);
        this.item.getCpfBeneficiario().setReadOnly(temBemAssociado);
        this.item.getCpfBeneficiario().setHabilitado(!temBemAssociado);
        if (!RendIsentos.TIPO_RENDISENTO_28.equals(this.codTipo)) {
            this.item.getNIFontePagadora().setReadOnly(temBemAssociado);
        }
        this.btnBemAssociado.setVisible(temBemAssociado);
        this.lblBemAssociado.setVisible(temBemAssociado);
        try {
            this.lblBemAssociado.setText("<html>" + CadastroTabelasIRPF.recuperarMensagem((CodigoTabelaMensagens)CodigoTabelaMensagens.CODIGO_00509) + "</html>");
        }
        catch (Exception ex) {
            this.lblBemAssociado.setText("<html>O bot\u00e3o ao lado permite altera\u00e7\u00e3o dos campos Benefici\u00e1rio e CNPJ da Fonte Pagadora do bem associado a este rendimento.</html>");
        }
    }

    private void listenerAcessoBemAssociado() {
        this.btnBemAssociado.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PainelDemonstrativoAb telaBens;
                if (ControladorGui.getDemonstrativoAberto().getIdentificadorDeclaracao().isEspolio()) {
                    telaBens = new PainelBensDetalheEspolio(PainelAbaDetalhes03X.this.bem, true);
                    ControladorGui.acionarPainel((PainelDemonstrativoIf)telaBens);
                } else {
                    telaBens = new PainelBensDetalhe(PainelAbaDetalhes03X.this.bem, true);
                    ControladorGui.acionarPainel((PainelDemonstrativoIf)telaBens);
                }
                JTaskAction task = new JTaskAction("Bens e Direitos", NavegacaoIf.PAINEL_BENS_DIREITOS, (Icon)GuiUtil.getImage((String)"/icones/png20px/DE_bens.png"), true);
                ControladorGui.getJanelaPrincipal().getAbas().setFicha("Bens e Direitos", task, true);
            }
        });
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.lblTipoRendIsento = new JLabel();
        this.lblTipoBeneficiario = new JLabel();
        this.edtTipoBeneficiario = new JEditCodigo();
        this.lblBeneficiario = new JLabel();
        this.cmbBeneficiario = new JAutoCompleteEditCPF();
        this.lblValor = new JLabel();
        this.edtValor = new JEditValor();
        this.lblNIFontePagadora = new JLabel();
        this.lblNomeFontePagadora = new JLabel();
        this.edtNome = new JEditAlfa();
        this.edtNi = new JEditNI();
        this.lbl13Salario = new JLabel();
        this.edt13Salario = new JEditValor();
        this.lblAjuda = new JLabel();
        this.edtTitular = new JEditAlfa();
        this.btnBemAssociado = new JButton();
        this.lblBemAssociado = new JLabel();
        this.setBackground(new Color(241, 245, 249));
        this.jPanel1.setBackground(new Color(255, 255, 255));
        this.lblTipoRendIsento.setFont(FontesUtil.FONTE_NORMAL);
        this.lblTipoRendIsento.setText("Descri\u00e7\u00e3o completa  de tipo de rendimento informado em tempo de execu\u00e7\u00e3o");
        this.lblTipoRendIsento.setHorizontalTextPosition(10);
        this.lblTipoBeneficiario.setFont(FontesUtil.FONTE_NORMAL);
        this.lblTipoBeneficiario.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblTipoBeneficiario.setText("Tipo de Benefici\u00e1rio");
        this.lblBeneficiario.setFont(FontesUtil.FONTE_NORMAL);
        this.lblBeneficiario.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblBeneficiario.setText("Benefici\u00e1rio");
        this.lblValor.setFont(FontesUtil.FONTE_NORMAL);
        this.lblValor.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblValor.setText("Valor");
        this.lblNIFontePagadora.setFont(FontesUtil.FONTE_NORMAL);
        this.lblNIFontePagadora.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblNIFontePagadora.setText("CNPJ da Fonte Pagadora");
        this.lblNomeFontePagadora.setFont(FontesUtil.FONTE_NORMAL);
        this.lblNomeFontePagadora.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblNomeFontePagadora.setText("Nome da Fonte Pagadora");
        this.edtNome.setMaxChars(60);
        this.lbl13Salario.setFont(FontesUtil.FONTE_NORMAL);
        this.lbl13Salario.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lbl13Salario.setText("13\u00ba sal\u00e1rio");
        this.lblAjuda.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icones/png10px/info.png")));
        this.btnBemAssociado.setText("Visualizar Bem/Direito Associado");
        this.lblBemAssociado.setFont(FontesUtil.FONTE_NORMAL);
        this.lblBemAssociado.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblBemAssociado.setText("<html>O bot\u00e3o ao lado permite altera\u00e7\u00e3o dos campos Benefici\u00e1rio e CNPJ da Fonte Pagadora do bem associado a este rendimento.</html>");
        this.lblBemAssociado.setVerticalAlignment(1);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblTipoRendIsento, -2, 699, -2).addComponent(this.lblTipoBeneficiario).addComponent((Component)this.edtTipoBeneficiario, -2, 241, -2)).addContainerGap(-1, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblBeneficiario).addComponent((Component)this.cmbBeneficiario, -2, 376, -2).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.lblValor).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblAjuda)).addComponent((Component)this.edtValor, -2, 190, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lbl13Salario).addComponent((Component)this.edt13Salario, -2, 171, -2))).addComponent((Component)this.edtTitular, -2, 392, -2).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.edtNi, -2, 204, -2).addComponent(this.lblNIFontePagadora, -2, 189, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblNomeFontePagadora).addComponent((Component)this.edtNome, -2, 376, -2))).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.btnBemAssociado).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblBemAssociado, -2, 402, -2))).addGap(0, 0, Short.MAX_VALUE)))));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.lblTipoRendIsento).addGap(18, 18, 18).addComponent(this.lblTipoBeneficiario).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.edtTipoBeneficiario, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblBeneficiario).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel1Layout.createSequentialGroup().addComponent((Component)this.cmbBeneficiario, -2, -1, -2).addGap(5, 5, 5).addComponent((Component)this.edtTitular, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblNIFontePagadora).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.edtNi, -2, -1, -2)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.lblNomeFontePagadora).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.edtNome, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblValor).addComponent(this.lblAjuda)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.edtValor, -2, -1, -2)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.lbl13Salario).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.edt13Salario, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnBemAssociado).addComponent(this.lblBemAssociado, -2, 48, -2))));
        this.edtTipoBeneficiario.getAccessibleContext().setAccessibleName("Tipo de benefici\u00e1rio");
        this.edtTipoBeneficiario.getAccessibleContext().setAccessibleDescription("");
        this.cmbBeneficiario.getAccessibleContext().setAccessibleName("Benefici\u00e1rio");
        this.cmbBeneficiario.getAccessibleContext().setAccessibleDescription("");
        this.edtValor.getAccessibleContext().setAccessibleName("Valor");
        this.edtValor.getAccessibleContext().setAccessibleDescription(MensagemUtil.getMensagem((String)"msg_valor_acessivel"));
        this.edtNome.getAccessibleContext().setAccessibleName("Nome da Fonte Pagadora");
        this.edtNome.getAccessibleContext().setAccessibleDescription("");
        this.edtNi.getAccessibleContext().setAccessibleName("CNPJ da Fonte Pagadora");
        this.edtNi.getAccessibleContext().setAccessibleDescription("");
        this.edt13Salario.getAccessibleContext().setAccessibleName("13\u00ba sal\u00e1rio");
        this.edt13Salario.getAccessibleContext().setAccessibleDescription(MensagemUtil.getMensagem((String)"msg_13_salario_acessivel"));
        this.edtTitular.getAccessibleContext().setAccessibleName("Benefici\u00e1rio");
        this.edtTitular.getAccessibleContext().setAccessibleDescription("");
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
    }

    public String getNomeAba() {
        return "Rendimentos";
    }

    public boolean isTelaComAjuda() {
        return true;
    }

    public boolean isTelaComVoltar() {
        return true;
    }

    public void executaVoltar() {
        ControladorGui.acionarPainel((PainelDemonstrativoIf)this.getPainelPai());
    }

    public JComponent getDefaultFocus() {
        return this.edtTipoBeneficiario;
    }

    public String getTituloPainel() {
        return "Rendimentos Isentos e N\u00e3o Tribut\u00e1veis";
    }

    public boolean isTelaComCancelar() {
        return this.novoItem;
    }

    public void executaCancelar() {
        PainelAbaRendIsentosLista painelLista = (PainelAbaRendIsentosLista)this.getPainelPai().getAbas()[0];
        TableModelRendIsentos tableModel = (TableModelRendIsentos)((Object)painelLista.getTabela().getModel());
        tableModel.removerItem(this.item, this.codTipo);
        ControladorGui.acionarPainel((PainelDemonstrativoIf)this.getPainelPai());
    }
}

