/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.rendIsentos;

import java.awt.event.ActionEvent;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.IRPFTableModelAb;
import serpro.ppgd.irpf.gui.PainelAbaIf;
import serpro.ppgd.irpf.gui.PainelDemonstrativoIf;
import serpro.ppgd.irpf.gui.PainelListaAb;
import serpro.ppgd.irpf.gui.TableLista;
import serpro.ppgd.irpf.gui.TableListaModel;
import serpro.ppgd.irpf.gui.rendIsentos.PainelAbaRendIsentosDetalhes;
import serpro.ppgd.irpf.gui.rendIsentos.TableModelRendIsentos;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.irpf.rendIsentos.ItemQuadroAuxiliarAb;
import serpro.ppgd.negocio.ElementoTabela;

public class PainelAbaRendIsentosLista
extends PainelListaAb
implements PainelAbaIf {
    private static final long serialVersionUID = 1L;
    public static final String NOME_ABA = "Rendimentos";
    public static final String TITULO = "Rendimentos Isentos e N\u00e3o Tribut\u00e1veis";
    public static final String HELP_ID = "Fichas da Declara\u00e7\u00e3o/Rendimentos Isentos e N\u00e3o Tribut\u00e1veis";
    private PainelDemonstrativoIf painelPai;

    public PainelAbaRendIsentosLista(PainelDemonstrativoIf painelPai) {
        this.painelPai = painelPai;
    }

    protected String getButtonHelpID() {
        return HELP_ID;
    }

    protected String getClassePainelNavegacao() {
        return null;
    }

    protected int getColunaOrdenacao() {
        return 1;
    }

    protected Integer[] getColunasOrdenaveis() {
        return new Integer[]{1};
    }

    protected TableListaModel getTableModel() {
        return new TableModelRendIsentos(IRPFFacade.getInstancia().getRendIsentos());
    }

    protected TableLista instanciarTabela(TableListaModel model, int colunaOrdenacao, Integer[] colunasOrdenaveis) {
        TableLista table = new TableLista(model, colunaOrdenacao, colunasOrdenaveis);
        table.accessibleColumnHeader = new String[]{"Item", "Tipo de Rendimento", "CPF/CNPJ da Fonte Pagadora", "Benefici\u00e1rio", "Valor do rendimento"};
        return table;
    }

    protected void configurarTamanhoColunas() {
        TableColumnModel tcm = this.getTabela().getColumnModel();
        tcm.getColumn(0).setPreferredWidth(15);
        tcm.getColumn(1).setPreferredWidth(430);
        tcm.getColumn(2).setPreferredWidth(150);
        tcm.getColumn(3).setPreferredWidth(60);
        tcm.getColumn(4).setPreferredWidth(75);
    }

    public void onBtnNovoClick(ActionEvent e) {
        PainelAbaRendIsentosDetalhes painel = new PainelAbaRendIsentosDetalhes(this.painelPai, null, null, false, false);
        ControladorGui.acionarPainel((PainelDemonstrativoIf)painel);
    }

    public void onBtnAbrirClick(ActionEvent e) {
        if (this.getTabela().getSelectedRow() >= 0) {
            int nLinha = this.getTabela().getSelectedRow();
            int indiceVetor = ((TableRowSorter)this.getTabela().getRowSorter()).convertRowIndexToModel(nLinha);
            TableModelRendIsentos model = (TableModelRendIsentos)((Object)this.getTabela().getModel());
            ItemQuadroAuxiliarAb item = (ItemQuadroAuxiliarAb)model.getObjetoNegocio(indiceVetor);
            ElementoTabela tipoRendimento = model.obterTipoRendimento(indiceVetor);
            String codTipoRendimento = tipoRendimento.getConteudo(0);
            String descricaoCurta = tipoRendimento.getConteudo(1);
            PainelAbaRendIsentosDetalhes painel = new PainelAbaRendIsentosDetalhes(this.painelPai, codTipoRendimento, item, true, false);
            ControladorGui.acionarPainel((PainelDemonstrativoIf)painel);
        } else {
            GuiUtil.mostrarAviso((String)"ErroSelecioneItem");
        }
    }

    public String getMensagemExclusao() {
        return "ConfirmaExcluirItens1";
    }

    public String[] getParametrosMensagemExclusao() {
        return new String[]{"rendimento(s)"};
    }

    public void aposCriarAbas() {
    }

    public String getNomeAba() {
        return NOME_ABA;
    }

    public PainelDemonstrativoIf getPainelPai() {
        return this.painelPai;
    }

    public void preExibir() {
        super.preExibir();
        ((TableModelRendIsentos)((Object)this.getTabela().getModel())).limparRegistrosEmBranco();
        ((IRPFTableModelAb)this.getTabela().getModel()).refresh();
    }
}

