/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.rendTributacaoExclusiva;

import java.awt.event.ActionEvent;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.IRPFTableModelAb;
import serpro.ppgd.irpf.gui.PainelAbaIf;
import serpro.ppgd.irpf.gui.PainelDemonstrativoIf;
import serpro.ppgd.irpf.gui.PainelListaAb;
import serpro.ppgd.irpf.gui.TableLista;
import serpro.ppgd.irpf.gui.TableListaModel;
import serpro.ppgd.irpf.gui.rendTributacaoExclusiva.PainelAbaRendTributEclusivaDetalhes;
import serpro.ppgd.irpf.gui.rendTributacaoExclusiva.TableModelRendTributExclusiva;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.irpf.rendIsentos.ItemQuadroAuxiliarAb;
import serpro.ppgd.negocio.ElementoTabela;

public class PainelAbaRendTributExclusivaLista
extends PainelListaAb
implements PainelAbaIf {
    private static final long serialVersionUID = 1L;
    public static final String NOME_ABA = "Rendimentos";
    public static final String TITULO = "Rendimentos Sujeitos \u00e0 Tributa\u00e7\u00e3o Exclusiva/Definitiva";
    public static final String HELP_ID = "Fichas da Declara\u00e7\u00e3o/Rendimentos Sujeitos \u00e0 Tributa\u00e7\u00e3o Exclusiva//Definitiva";
    private PainelDemonstrativoIf painelPai;

    public PainelAbaRendTributExclusivaLista(PainelDemonstrativoIf painelPai) {
        this.painelPai = painelPai;
    }

    protected String getButtonHelpID() {
        return HELP_ID;
    }

    protected String getClassePainelNavegacao() {
        return null;
    }

    protected int getColunaOrdenacao() {
        return 1;
    }

    protected Integer[] getColunasOrdenaveis() {
        return new Integer[]{1};
    }

    protected TableListaModel getTableModel() {
        return new TableModelRendTributExclusiva(IRPFFacade.getInstancia().getRendTributacaoExclusiva());
    }

    protected TableLista instanciarTabela(TableListaModel model, int colunaOrdenacao, Integer[] colunasOrdenaveis) {
        TableLista table = new TableLista(model, colunaOrdenacao, colunasOrdenaveis);
        table.accessibleColumnHeader = new String[]{"Item", "Tipo de Rendimento", "CPF/CNPJ da Fonte Pagadora", "Benefici\u00e1rio", "Valor do rendimento"};
        return table;
    }

    protected void configurarTamanhoColunas() {
        TableColumnModel tcm = this.getTabela().getColumnModel();
        tcm.getColumn(0).setPreferredWidth(30);
        tcm.getColumn(1).setPreferredWidth(400);
        tcm.getColumn(2).setPreferredWidth(150);
        tcm.getColumn(3).setPreferredWidth(75);
        tcm.getColumn(4).setPreferredWidth(75);
    }

    public void onBtnNovoClick(ActionEvent e) {
        PainelAbaRendTributEclusivaDetalhes painel = new PainelAbaRendTributEclusivaDetalhes(this.painelPai, null, null, false, false);
        ControladorGui.acionarPainel((PainelDemonstrativoIf)painel);
    }

    public void onBtnAbrirClick(ActionEvent e) {
        if (this.getTabela().getSelectedRow() >= 0) {
            int nLinha = this.getTabela().getSelectedRow();
            int indiceVetor = ((TableRowSorter)this.getTabela().getRowSorter()).convertRowIndexToModel(nLinha);
            TableModelRendTributExclusiva model = (TableModelRendTributExclusiva)((Object)this.getTabela().getModel());
            ItemQuadroAuxiliarAb item = (ItemQuadroAuxiliarAb)model.getObjetoNegocio(indiceVetor);
            ElementoTabela tipoRendimento = model.obterTipoRendimento(indiceVetor);
            String codTipoRendimento = tipoRendimento.getConteudo(0);
            String descricaoCurta = tipoRendimento.getConteudo(1);
            PainelAbaRendTributEclusivaDetalhes painel = new PainelAbaRendTributEclusivaDetalhes(this.painelPai, codTipoRendimento, item, true, false);
            ControladorGui.acionarPainel((PainelDemonstrativoIf)painel);
        } else {
            GuiUtil.mostrarAviso((String)"ErroSelecioneItem");
        }
    }

    public String getMensagemExclusao() {
        return "ConfirmaExcluirItens1";
    }

    public String[] getParametrosMensagemExclusao() {
        return new String[]{"rendimento(s)"};
    }

    public void aposCriarAbas() {
    }

    public String getNomeAba() {
        return NOME_ABA;
    }

    public PainelDemonstrativoIf getPainelPai() {
        return this.painelPai;
    }

    public void preExibir() {
        super.preExibir();
        ((TableModelRendTributExclusiva)((Object)this.getTabela().getModel())).limparRegistrosEmBranco();
        ((IRPFTableModelAb)this.getTabela().getModel()).refresh();
    }
}

