/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.rendpj;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.jdesktop.layout.GroupLayout;
import serpro.ppgd.gui.xbeans.JEditAlfa;
import serpro.ppgd.gui.xbeans.JEditData;
import serpro.ppgd.gui.xbeans.JEditNI;
import serpro.ppgd.gui.xbeans.JEditValor;
import serpro.ppgd.gui.xbeans.autocomplete.JAutoCompleteEditCPF;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.infraestrutura.util.FontesUtil;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.dependentes.Dependente;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.IRPFLabelInfo;
import serpro.ppgd.irpf.gui.NavegacaoIf;
import serpro.ppgd.irpf.gui.PainelDemonstrativoAb;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.irpf.rendpj.RendPJDependente;
import serpro.ppgd.irpf.tabelas.CadastroTabelasIRPF;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.irpf.util.TipoDeclaracaoAES;
import serpro.ppgd.negocio.ElementoTabela;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoNegocio;

public class PainelAbaRendPJDependentesDetalhe
extends PainelDemonstrativoAb {
    private static final long serialVersionUID = 1L;
    private static final String HELP_ID = "Fichas da Declara\u00e7\u00e3o/Rendimentos Tribut\u00e1veis Recebidos de PJ pelos Dependentes";
    private RendPJDependente rendPJDependente = null;
    private RendPJDependente itemInicial = null;
    private boolean isSaida = false;
    private boolean emEdicao;
    private boolean isCancelar = false;
    private JAutoCompleteEditCPF cmbDependente;
    private JEditValor edt13Salario;
    private JEditValor edtContribPrevOficial;
    private JEditData edtDataComunicacaoSaida;
    private JEditValor edtIRRFDecimoTerceiro;
    private JEditValor edtImpostoRetidoFonte;
    private JEditNI edtNIFontePagadora;
    private JEditAlfa edtNomeFontePagadora;
    private JEditValor edtRendRecebidosPJ;
    private JLabel jLabel11;
    private JPanel jPanel1;
    private JLabel lbl13Salario;
    private IRPFLabelInfo lblAvisoDependenteAlimentandoVazio;
    private JLabel lblContribPrevOficial;
    private JLabel lblDataComunicacaoSaida;
    private JLabel lblDependente;
    private JLabel lblImpostoRetidoFonte;
    private JLabel lblNIFontePagadora;
    private JLabel lblNomeFontePagadora;
    private JLabel lblRendRecebidosPJ;
    private JLabel lblTitulo;

    public PainelAbaRendPJDependentesDetalhe(RendPJDependente rendPJDependente, boolean emEdicao) {
        this.rendPJDependente = rendPJDependente;
        this.emEdicao = emEdicao;
        if (emEdicao) {
            this.itemInicial = rendPJDependente.obterCopia();
        }
        PlataformaPPGD.getPlataforma().setHelpID((JComponent)((Object)this), HELP_ID);
        this.initComponents();
        final JComboBox j = (JComboBox)this.cmbDependente.getComponenteEditor();
        j.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (j.getSelectedItem() != null) {
                    ElementoTabela et = (ElementoTabela)j.getSelectedItem();
                    String cpf = et.getConteudo(0);
                    cpf = cpf.replaceAll("\\.", "").replaceAll("-", "");
                    Dependente d = ControladorGui.getDemonstrativoAberto().getDependentes().getDependenteByCpf(cpf);
                    PainelAbaRendPJDependentesDetalhe.this.configuraVisibilidadeDataComunicacaoSaida(d);
                }
            }
        });
        this.rendPJDependente = rendPJDependente;
        this.isSaida = IRPFFacade.getInstancia().getIdDeclaracaoAberto().getTipoDeclaracaoAES().formatado().equals(TipoDeclaracaoAES.SAIDA.getTipo());
        this.configuraVisibilidadeDataComunicacaoSaida();
        this.associarInformacao();
    }

    private void initComponents() {
        this.lblTitulo = new JLabel();
        this.jPanel1 = new JPanel();
        this.lblDependente = new JLabel();
        this.cmbDependente = new JAutoCompleteEditCPF();
        this.lblNomeFontePagadora = new JLabel();
        this.edtNomeFontePagadora = new JEditAlfa();
        this.lblNIFontePagadora = new JLabel();
        this.edtNIFontePagadora = new JEditNI();
        this.lblRendRecebidosPJ = new JLabel();
        this.edtRendRecebidosPJ = new JEditValor();
        this.lblContribPrevOficial = new JLabel();
        this.edtContribPrevOficial = new JEditValor();
        this.lblImpostoRetidoFonte = new JLabel();
        this.edtImpostoRetidoFonte = new JEditValor();
        this.lbl13Salario = new JLabel();
        this.edt13Salario = new JEditValor();
        this.lblDataComunicacaoSaida = new JLabel();
        this.edtDataComunicacaoSaida = new JEditData();
        this.lblAvisoDependenteAlimentandoVazio = new IRPFLabelInfo(MensagemUtil.getMensagem((String)"info_listagem", (String[])new String[]{"Dependentes"}));
        this.jLabel11 = new JLabel();
        this.edtIRRFDecimoTerceiro = new JEditValor();
        this.setBackground(new Color(241, 245, 249));
        this.setPreferredSize(new Dimension(647, 582));
        this.lblTitulo.setFont(FontesUtil.FONTE_TITULO_NORMAL);
        this.lblTitulo.setForeground(new Color(0, 74, 106));
        this.lblTitulo.setText("Dados da Fonte Pagadora");
        this.jPanel1.setBackground(new Color(255, 255, 255));
        this.jPanel1.setBorder(BorderFactory.createLineBorder(new Color(211, 222, 232)));
        this.lblDependente.setFont(FontesUtil.FONTE_NORMAL);
        this.lblDependente.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblDependente.setLabelFor((Component)this.cmbDependente);
        this.lblDependente.setText("Dependente");
        this.lblDependente.setVerticalAlignment(3);
        this.cmbDependente.setDados(CadastroTabelasIRPF.recuperarDependentes());
        this.cmbDependente.setToolTipText(MensagemUtil.getMensagem((String)"info_listagem_acessibilidade_dependente", (String[])new String[]{"Dependentes"}));
        this.lblNomeFontePagadora.setFont(FontesUtil.FONTE_NORMAL);
        this.lblNomeFontePagadora.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblNomeFontePagadora.setLabelFor((Component)this.edtNomeFontePagadora);
        this.lblNomeFontePagadora.setText("Nome da fonte pagadora");
        this.edtNomeFontePagadora.setMaxChars(60);
        this.lblNIFontePagadora.setFont(FontesUtil.FONTE_NORMAL);
        this.lblNIFontePagadora.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblNIFontePagadora.setLabelFor((Component)this.edtNIFontePagadora);
        this.lblNIFontePagadora.setText("CPF/CNPJ da fonte pagadora");
        this.lblRendRecebidosPJ.setFont(FontesUtil.FONTE_NORMAL);
        this.lblRendRecebidosPJ.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblRendRecebidosPJ.setLabelFor((Component)this.edtRendRecebidosPJ);
        this.lblRendRecebidosPJ.setText("<HTML>Rendimentos recebidos de pessoa jur\u00eddica</HTML>");
        this.lblContribPrevOficial.setFont(FontesUtil.FONTE_NORMAL);
        this.lblContribPrevOficial.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblContribPrevOficial.setLabelFor((Component)this.edtContribPrevOficial);
        this.lblContribPrevOficial.setText("Contribui\u00e7\u00e3o previdenci\u00e1ria oficial");
        this.lblImpostoRetidoFonte.setFont(FontesUtil.FONTE_NORMAL);
        this.lblImpostoRetidoFonte.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblImpostoRetidoFonte.setLabelFor((Component)this.edtImpostoRetidoFonte);
        this.lblImpostoRetidoFonte.setText("Imposto retido na fonte");
        this.lbl13Salario.setFont(FontesUtil.FONTE_NORMAL);
        this.lbl13Salario.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lbl13Salario.setLabelFor((Component)this.edt13Salario);
        this.lbl13Salario.setText("13\u00ba sal\u00e1rio");
        this.lblDataComunicacaoSaida.setFont(FontesUtil.FONTE_NORMAL);
        this.lblDataComunicacaoSaida.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblDataComunicacaoSaida.setText("Data da comunica\u00e7\u00e3o da condi\u00e7\u00e3o de n\u00e3o residente \u00e0 fonte pagadora");
        this.jLabel11.setFont(FontesUtil.FONTE_NORMAL);
        this.jLabel11.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.jLabel11.setText("IRRF sobre o 13\u00ba sal\u00e1rio");
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.lblNomeFontePagadora).add((Component)this.lblRendRecebidosPJ, -2, -1, -2).add((Component)this.lblContribPrevOficial).add((Component)this.lblImpostoRetidoFonte).add((Component)this.lbl13Salario).add((Component)this.cmbDependente, -2, 363, -2).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.lblDependente).addPreferredGap(0).add((Component)this.lblAvisoDependenteAlimentandoVazio, -2, -1, -2)).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(2, false).add(1, (Component)this.edtRendRecebidosPJ, -1, 171, Short.MAX_VALUE).add(1, (Component)this.edtContribPrevOficial, -1, -1, Short.MAX_VALUE).add(1, (Component)this.edtImpostoRetidoFonte, -1, -1, Short.MAX_VALUE).add(1, (Component)this.edt13Salario, -1, -1, Short.MAX_VALUE)).add((Component)this.lblDataComunicacaoSaida).add((Component)this.edtDataComunicacaoSaida, -2, 114, -2).add((Component)this.jLabel11).add((Component)this.edtIRRFDecimoTerceiro, -2, 171, -2).add((Component)this.edtNIFontePagadora, -2, 169, -2).add((Component)this.lblNIFontePagadora).add((Component)this.edtNomeFontePagadora, -2, 395, -2)).addContainerGap(140, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.lblDependente, -2, 21, -2).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add(4, 4, 4).add((Component)this.lblAvisoDependenteAlimentandoVazio, -2, -1, -2))).addPreferredGap(0).add((Component)this.cmbDependente, -2, -1, -2).addPreferredGap(0).add((Component)this.lblNIFontePagadora).add(1, 1, 1).add((Component)this.edtNIFontePagadora, -2, -1, -2).addPreferredGap(0).add((Component)this.lblNomeFontePagadora).add(1, 1, 1).add((Component)this.edtNomeFontePagadora, -2, -1, -2).addPreferredGap(0).add((Component)this.lblRendRecebidosPJ, -2, -1, -2).add(2, 2, 2).add((Component)this.edtRendRecebidosPJ, -2, -1, -2).addPreferredGap(0).add((Component)this.lblContribPrevOficial).add(1, 1, 1).add((Component)this.edtContribPrevOficial, -2, -1, -2).addPreferredGap(0).add((Component)this.lblImpostoRetidoFonte).add(1, 1, 1).add((Component)this.edtImpostoRetidoFonte, -2, -1, -2).addPreferredGap(0).add((Component)this.lbl13Salario).add(1, 1, 1).add((Component)this.edt13Salario, -2, -1, -2).addPreferredGap(0).add((Component)this.jLabel11).addPreferredGap(0).add((Component)this.edtIRRFDecimoTerceiro, -2, -1, -2).addPreferredGap(0).add((Component)this.lblDataComunicacaoSaida).addPreferredGap(0).add((Component)this.edtDataComunicacaoSaida, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.linkSize(new Component[]{this.edt13Salario, this.edtContribPrevOficial, this.edtImpostoRetidoFonte, this.edtRendRecebidosPJ}, 2);
        this.cmbDependente.getAccessibleContext().setAccessibleName("Dependente");
        this.edtNomeFontePagadora.getAccessibleContext().setAccessibleName("Nome da fonte pagadora");
        this.edtNIFontePagadora.getAccessibleContext().setAccessibleName("CPF ou CNPJ da fonte pagadora");
        this.edtRendRecebidosPJ.getAccessibleContext().setAccessibleName("Rendimentos recebidos de pessoa jur\u00eddica");
        this.edtContribPrevOficial.getAccessibleContext().setAccessibleName("Contribui\u00e7\u00e3o previdenci\u00e1ria oficial");
        this.edtImpostoRetidoFonte.getAccessibleContext().setAccessibleName("Imposto retido na fonte");
        this.edt13Salario.getAccessibleContext().setAccessibleName("D\u00e9cimo terceiro sal\u00e1rio");
        this.edtDataComunicacaoSaida.getAccessibleContext().setAccessibleName("Data da comunica\u00e7\u00e3o da condi\u00e7\u00e3o de n\u00e3o residente \u00e0 fonte pagadora");
        this.edtDataComunicacaoSaida.getAccessibleContext().setAccessibleDescription("");
        this.edtIRRFDecimoTerceiro.getAccessibleContext().setAccessibleName("IRRF sobre o d\u00e9cimo terceiro sal\u00e1rio");
        this.edtIRRFDecimoTerceiro.getAccessibleContext().setAccessibleDescription("");
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE).add((Component)this.lblTitulo)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.lblTitulo).addPreferredGap(0).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    public String getTituloPainel() {
        boolean ehTransmitida = IRPFFacade.getInstancia().getDeclaracao().getCopiaIdentificador().isTransmitida();
        if (this.emEdicao) {
            if (ehTransmitida) {
                return "Detalhe Rendimento Tribut\u00e1vel Recebido de Pessoa Jur\u00eddica";
            }
            return "Editar Rendimento Tribut\u00e1vel Recebido de Pessoa Jur\u00eddica";
        }
        return "Novo Rendimento Tribut\u00e1vel Recebido de Pessoa Jur\u00eddica";
    }

    public ImageIcon getImagemTitulo() {
        return GuiUtil.getImage((String)"/icones/png40px/DE_rend_pj.png");
    }

    public void executaVoltar() {
        ControladorGui.acionarPainel((String)NavegacaoIf.PAINEL_REND_TRIB_RECEB_PJ);
        int posicao = ControladorGui.getDemonstrativoAberto().getColecaoRendPJDependente().itens().indexOf(this.rendPJDependente);
        ControladorGui.getDemonstrativoAberto().getRendPJ().getColecaoRendPJDependente().remove((ObjetoNegocio)this.rendPJDependente);
        ControladorGui.getDemonstrativoAberto().getColecaoRendPJDependente().itens().add(posicao, this.rendPJDependente);
    }

    public boolean isTelaComVoltar() {
        return true;
    }

    public boolean isTelaComCancelar() {
        return true;
    }

    public void executaCancelar() {
        this.isCancelar = true;
        if (this.emEdicao) {
            int posicao = ControladorGui.getDemonstrativoAberto().getColecaoRendPJDependente().itens().indexOf(this.rendPJDependente);
            ControladorGui.getDemonstrativoAberto().getRendPJ().getColecaoRendPJDependente().remove((ObjetoNegocio)this.rendPJDependente);
            ControladorGui.getDemonstrativoAberto().getColecaoRendPJDependente().itens().add(posicao, this.itemInicial);
        } else {
            ControladorGui.getDemonstrativoAberto().getRendPJ().getColecaoRendPJDependente().remove((ObjetoNegocio)this.rendPJDependente);
        }
        ControladorGui.acionarPainel((String)NavegacaoIf.PAINEL_REND_TRIB_RECEB_PJ);
    }

    private boolean verificaImposto() {
        boolean confirmou = true;
        if (this.edtRendRecebidosPJ.getInformacao().isVazio() && !this.edtImpostoRetidoFonte.getInformacao().isVazio()) {
            boolean bl = confirmou = JOptionPane.showConfirmDialog(this.getParent(), MensagemUtil.getMensagem((String)"rendpj_semvalor"), "Confirma\u00e7\u00e3o", 0) == 0;
            if (!confirmou) {
                this.edtRendRecebidosPJ.getComponenteFoco().requestFocusInWindow();
            }
        }
        return confirmou;
    }

    public JComponent getDefaultFocus() {
        return this.cmbDependente;
    }

    private void configuraVisibilidadeDataComunicacaoSaida() {
        boolean visivel = this.isSaida;
        this.lblDataComunicacaoSaida.setVisible(visivel);
        this.edtDataComunicacaoSaida.setVisible(visivel);
    }

    private void configuraVisibilidadeDataComunicacaoSaida(Dependente d) {
        boolean visivel = this.isSaida;
        String ind = d.getIndSaidaPaisMesmaData().naoFormatado();
        visivel = visivel && ind.equals("1");
        this.lblDataComunicacaoSaida.setVisible(visivel);
        this.edtDataComunicacaoSaida.setVisible(visivel);
    }

    private void associarInformacao() {
        this.edtNIFontePagadora.setInformacao((Informacao)this.rendPJDependente.getNIFontePagadora());
        this.cmbDependente.setInformacao((Informacao)this.rendPJDependente.getCpfDependente());
        this.edtNomeFontePagadora.setInformacao((Informacao)this.rendPJDependente.getNomeFontePagadora());
        this.edtContribPrevOficial.setInformacao((Informacao)this.rendPJDependente.getContribuicaoPrevOficial());
        this.edtImpostoRetidoFonte.setInformacao((Informacao)this.rendPJDependente.getImpostoRetidoFonte());
        this.edtRendRecebidosPJ.setInformacao((Informacao)this.rendPJDependente.getRendRecebidoPJ());
        this.edt13Salario.setInformacao((Informacao)this.rendPJDependente.getDecimoTerceiro());
        this.edtDataComunicacaoSaida.setInformacao((Informacao)this.rendPJDependente.getDataComunicacaoSaida());
        this.edtIRRFDecimoTerceiro.setInformacao((Informacao)this.rendPJDependente.getIRRFDecimoTerceiro());
    }

    public boolean isPodeSair() {
        if (this.isCancelar) {
            this.isCancelar = false;
            return true;
        }
        return this.verificaImposto();
    }

    public String getHelpID() {
        return HELP_ID;
    }

    public boolean isTelaComFavoritos() {
        return false;
    }
}

