/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.impressao;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import serpro.ppgd.formatosexternos.RelatorioMultiploXML;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.dependentes.Dependente;
import serpro.ppgd.irpf.exception.BarramentoException;
import serpro.ppgd.irpf.impressao.ImpressaoDeclaracao;
import serpro.ppgd.irpf.nuvem.RetornoDarf;
import serpro.ppgd.irpf.tabelas.TabelaDatasIRPF;
import serpro.ppgd.irpf.util.IRPFUtil;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.Valor;

public class ImpressaoDarfAuxilioEmergencial {
    private String titulo;
    private String relatorioJasper;
    private String xml;
    private String raiz;
    private RelatorioMultiploXML relatorio;
    private String xmlDados;
    private String cpf = "";
    private String nome = "";
    private Map<String, String> mapAuxilio;
    private ArrayList<RetornoDarf> listaDarfAuxilio;
    private DeclaracaoIRPF dec;
    private int tipoOperacao = 1;

    public ImpressaoDarfAuxilioEmergencial(String aTitulo, String aRelatorioJasper, String aXml, String aRaiz, String cpf, String nome, int tipoOperacao, Map<String, String> mapAuxilio, ArrayList<RetornoDarf> listaDarfAuxilio, DeclaracaoIRPF dec) {
        String jasper = aRelatorioJasper;
        this.cpf = cpf;
        this.nome = nome;
        this.mapAuxilio = mapAuxilio;
        this.listaDarfAuxilio = listaDarfAuxilio;
        this.xmlDados = aXml;
        this.titulo = aTitulo;
        this.relatorioJasper = jasper;
        this.raiz = aRaiz;
        this.setTipoOperacao(tipoOperacao);
        this.relatorio = new RelatorioMultiploXML(this.titulo, this.relatorioJasper, this.xmlDados, this.raiz, IRPFUtil.getNomeArquivo());
        IRPFUtil.setNomeArquivo(null);
        this.dec = dec;
    }

    public ImpressaoDarfAuxilioEmergencial() {
    }

    public void vizualizarDarf(Map<String, String> mapDevolucaoAuxilio) throws BarramentoException {
        this.adicionarParametrosAuxilioEmergencial(this.dec, null, mapDevolucaoAuxilio);
        if (IRPFUtil.isAccessibleMode()) {
            this.relatorio.imprimir();
        } else {
            this.executar();
        }
    }

    private void executar() {
        switch (this.getTipoOperacao()) {
            case 1: {
                this.relatorio.visualizar();
                break;
            }
            case 2: {
                this.relatorio.visualizar();
                break;
            }
            case 3: {
                this.relatorio.imprimir();
            }
        }
    }

    private String formataNumero(BigDecimal valor) {
        DecimalFormat df = new DecimalFormat("#,##0.00", new DecimalFormatSymbols(new Locale("pt", "BR")));
        Valor valorFormatado = new Valor(df.format(valor));
        return valorFormatado.formatado();
    }

    public int getTipoOperacao() {
        return this.tipoOperacao;
    }

    public void setTipoOperacao(int tipoOperacao) {
        this.tipoOperacao = tipoOperacao;
    }

    private String obterNomePorCPF(DeclaracaoIRPF dec, String cpf) {
        String nome = dec.getIdentificadorDeclaracao().getNome().naoFormatado();
        if (!dec.getIdentificadorDeclaracao().getCpf().formatado().equals(cpf)) {
            for (Dependente dependente : dec.getDependentes().itens()) {
                if (!dependente.getCpfDependente().formatado().equals(cpf)) continue;
                nome = dependente.getNome().formatado();
                break;
            }
        }
        return nome;
    }

    public void adicionarParametrosAuxilioEmergencial(DeclaracaoIRPF dec, ImpressaoDeclaracao impressao, Map<String, String> mapDevolucaoAuxilio) throws BarramentoException {
        String dataVencimentoAuxilio;
        String[] vencimentoQuotas = TabelaDatasIRPF.obterVencimentosQuotas((boolean)dec.getEmCalamidade());
        String dataValidadeAuxilio = dataVencimentoAuxilio = vencimentoQuotas[0];
        Data periodoApuracao = new Data();
        if (dec.getIdentificadorDeclaracao().isEspolio()) {
            periodoApuracao = dec.getEspolio().obterDataLimiteParaCalculos();
        } else if (dec.getIdentificadorDeclaracao().isSaida()) {
            Date dtCondicaoNaoResidente = dec.getSaida().getDtCondicaoNaoResidente().asDate();
            if (dtCondicaoNaoResidente != null) {
                Calendar c = Calendar.getInstance(new Locale("pt", "BR"));
                c.setTime(dtCondicaoNaoResidente);
                c.add(5, -1);
                Data diaAnterior = new Data();
                diaAnterior.setConteudo(c.getTime());
                periodoApuracao.setConteudo(diaAnterior);
            }
        } else {
            periodoApuracao.setConteudo("31/12/" + ConstantesGlobais.ANO_BASE);
        }
        ArrayList listaDarfAuxilio = new ArrayList();
        if (impressao != null) {
            impressao.addParametro("icone", ClassLoader.getSystemClassLoader().getResource("icones/brasao.jpg").toString());
            impressao.addParametro("dataVencimentoAuxilio", dataVencimentoAuxilio);
            impressao.addParametro("dataValidadeAuxilio", dataValidadeAuxilio);
            impressao.addParametro("exercicio", ConstantesGlobais.EXERCICIO);
            impressao.addParametro("periodoApuracao", periodoApuracao.formatado());
            int i = 1;
            for (RetornoDarf darfAuxilio : listaDarfAuxilio) {
                DecimalFormat dfValor = new DecimalFormat("#,##0.00", new DecimalFormatSymbols(new Locale("pt", "BR")));
                Valor valorPrincipal = new Valor(dfValor.format(darfAuxilio.getPrincipal()));
                Valor valorJuros = new Valor(dfValor.format(darfAuxilio.getSaldoDevedorJuros()));
                Valor valorMulta = new Valor(dfValor.format(darfAuxilio.getSaldoDevedorMulta()));
                Valor valorTotal = new Valor();
                valorTotal.append('+', valorPrincipal);
                valorTotal.append('+', valorJuros);
                valorTotal.append('+', valorMulta);
                BigDecimal total = new BigDecimal(darfAuxilio.getPrincipal().doubleValue());
                total.add(darfAuxilio.getSaldoDevedorMulta());
                total.add(darfAuxilio.getSaldoDevedorJuros());
                impressao.addParametro("nome" + i, this.obterNomePorCPF(dec, darfAuxilio.getCpf()));
                impressao.addParametro("cpf" + i, darfAuxilio.getCpf());
                impressao.addParametro("valor" + i, this.formataNumero(darfAuxilio.getPrincipal()));
                impressao.addParametro("multa" + i, this.formataNumero(darfAuxilio.getSaldoDevedorMulta()));
                impressao.addParametro("juros" + i, this.formataNumero(darfAuxilio.getSaldoDevedorJuros()));
                impressao.addParametro("total" + i, valorTotal.formatado());
                ++i;
            }
        } else {
            this.relatorio.addParametro("icone", ClassLoader.getSystemClassLoader().getResource("icones/brasao.jpg").toString());
            this.relatorio.addParametro("dataVencimentoAuxilio", dataVencimentoAuxilio);
            this.relatorio.addParametro("dataValidadeAuxilio", dataValidadeAuxilio);
            this.relatorio.addParametro("exercicio", ConstantesGlobais.EXERCICIO);
            this.relatorio.addParametro("periodoApuracao", periodoApuracao.formatado());
            int i = 1;
            for (RetornoDarf darfAuxilio : listaDarfAuxilio) {
                DecimalFormat dfValor = new DecimalFormat("#,##0.00", new DecimalFormatSymbols(new Locale("pt", "BR")));
                Valor valorPrincipal = new Valor(dfValor.format(darfAuxilio.getPrincipal()));
                Valor valorJuros = new Valor(dfValor.format(darfAuxilio.getSaldoDevedorJuros()));
                Valor valorMulta = new Valor(dfValor.format(darfAuxilio.getSaldoDevedorMulta()));
                Valor valorTotal = new Valor();
                valorTotal.append('+', valorPrincipal);
                valorTotal.append('+', valorJuros);
                valorTotal.append('+', valorMulta);
                this.relatorio.addParametro("nome" + i, this.obterNomePorCPF(dec, darfAuxilio.getCpf()));
                this.relatorio.addParametro("cpf" + i, darfAuxilio.getCpf());
                this.relatorio.addParametro("valor" + i, this.formataNumero(darfAuxilio.getPrincipal()));
                this.relatorio.addParametro("multa" + i, this.formataNumero(darfAuxilio.getSaldoDevedorMulta()));
                this.relatorio.addParametro("juros" + i, this.formataNumero(darfAuxilio.getSaldoDevedorJuros()));
                this.relatorio.addParametro("total" + i, valorTotal.formatado());
                ++i;
            }
        }
    }
}

