/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.impressao;

import br.gov.serpro.midas.negocio.MidasReportElementBuilder;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.print.PrinterException;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperPrintManager;
import net.sf.jasperreports.engine.data.JRXmlDataSource;
import serpro.ppgd.formatosexternos.PPGDJasperViewer;
import serpro.ppgd.formatosexternos.RelatorioIf;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.irpf.impressao.RelatorioUtil;
import serpro.ppgd.irpf.util.AplicacaoPropertiesUtil;
import serpro.ppgd.irpf.util.IRPFUtil;
import serpro.ppgd.negocio.util.LogPPGD;

public class Relatorio
implements RelatorioIf {
    private String xml;
    private String raiz;
    private String relatorioJasper;
    private String titulo;
    private String nomeArquivo;
    private boolean habilitado = true;
    private Map<String, Object> parametros = new HashMap<String, Object>();
    private int tipoOperacao = 1;
    private boolean impressaoMidas = false;

    public Relatorio(String aTitulo, String aRelatorioJasper, String aXml, String aRaiz, int tipoOperacao, String nomeArquivo, boolean isMidas) {
        this.setTitulo(aTitulo);
        this.setRelatorioJasper(aRelatorioJasper.replaceAll("%20", " "));
        this.setXml(aXml);
        this.setRaiz(aRaiz);
        this.setTipoOperacao(tipoOperacao);
        this.setNomeArquivo(nomeArquivo);
        this.setImpressaoMidas(isMidas);
    }

    public Relatorio(String aTitulo, String aRelatorioJasper, int tipoOperacao, boolean isMidas) {
        this.setTitulo(aTitulo);
        this.setRelatorioJasper(aRelatorioJasper.replaceAll("%20", " "));
        this.setTipoOperacao(tipoOperacao);
        this.setImpressaoMidas(isMidas);
    }

    public void visualizar() {
        switch (this.getTipoOperacao()) {
            case 1: {
                this.visualizarRelatorio();
                break;
            }
            case 2: {
                this.visualizarRelatorio();
                break;
            }
            case 3: {
                this.imprimir();
            }
        }
    }

    private void visualizarRelatorio() {
        if (IRPFUtil.isAccessibleMode()) {
            this.imprimir();
            return;
        }
        try {
            JREmptyDataSource xmlDataSource;
            JasperPrint print;
            if (this.getXml() != null && !this.getXml().equals("")) {
                if (this.isImpressaoMidas()) {
                    BufferedInputStream in = new BufferedInputStream(new FileInputStream(this.getXml()));
                    MidasReportElementBuilder midasBuilder = new MidasReportElementBuilder((InputStream)in);
                    br.gov.serpro.midas.jasperreports.JRXmlDataSource xmlDataSource2 = new br.gov.serpro.midas.jasperreports.JRXmlDataSource(midasBuilder.build(), this.getRaiz());
                    xmlDataSource2.setLocale(new Locale("pt", "BR"));
                    xmlDataSource2.setNumberPattern("##0.00");
                    InputStream streamRel = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.getRelatorioJasper());
                    print = JasperFillManager.fillReport((InputStream)streamRel, this.parametros, (JRDataSource)xmlDataSource2);
                } else {
                    xmlDataSource = new JRXmlDataSource(this.getXml(), this.getRaiz());
                    xmlDataSource.setLocale(new Locale("pt", "BR"));
                    xmlDataSource.setNumberPattern("##0.00");
                    InputStream streamRel = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.getRelatorioJasper());
                    print = JasperFillManager.fillReport((InputStream)streamRel, this.parametros, (JRDataSource)xmlDataSource);
                }
            } else {
                xmlDataSource = new JREmptyDataSource();
                InputStream streamRel = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.getRelatorioJasper());
                print = JasperFillManager.fillReport((InputStream)streamRel, this.parametros, (JRDataSource)xmlDataSource);
            }
            print.setName(this.nomeArquivo);
            RelatorioUtil.removerPaginasEmBranco(print);
            PPGDJasperViewer viewer = new PPGDJasperViewer(print, false, new Locale("pt", "BR"));
            viewer.setTitle(this.getTitulo());
            viewer.setIconImage(Frame.getFrames()[1].getIconImage());
            if (print.getPages().size() > 0) {
                viewer.setVisible(true);
            }
            viewer.addWindowFocusListener(new WindowFocusListener(){
                private boolean firstLost = true;

                @Override
                public void windowLostFocus(WindowEvent e) {
                    if (this.firstLost) {
                        e.getWindow().toFront();
                        this.firstLost = false;
                    }
                }

                @Override
                public void windowGainedFocus(WindowEvent e) {
                }
            });
        }
        catch (Exception e) {
            LogPPGD.erro((String)e.getMessage());
        }
    }

    public void gerarPDF() {
        try {
            JREmptyDataSource xmlDataSource;
            JasperPrint print;
            if (this.getXml() != null && !this.getXml().equals("")) {
                if (this.isImpressaoMidas()) {
                    BufferedInputStream in = new BufferedInputStream(new FileInputStream(this.getXml()));
                    MidasReportElementBuilder midasBuilder = new MidasReportElementBuilder((InputStream)in);
                    br.gov.serpro.midas.jasperreports.JRXmlDataSource xmlDataSource2 = new br.gov.serpro.midas.jasperreports.JRXmlDataSource(midasBuilder.build(), this.getRaiz());
                    InputStream streamRel = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.getRelatorioJasper());
                    print = JasperFillManager.fillReport((InputStream)streamRel, this.parametros, (JRDataSource)xmlDataSource2);
                } else {
                    xmlDataSource = new JRXmlDataSource(this.getXml(), this.getRaiz());
                    InputStream streamRel = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.getRelatorioJasper());
                    print = JasperFillManager.fillReport((InputStream)streamRel, this.parametros, (JRDataSource)xmlDataSource);
                }
            } else {
                xmlDataSource = new JREmptyDataSource();
                InputStream streamRel = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.getRelatorioJasper());
                print = JasperFillManager.fillReport((InputStream)streamRel, this.parametros, (JRDataSource)xmlDataSource);
            }
            RelatorioUtil.removerPaginasEmBranco(print);
            byte[] bytes = JasperExportManager.exportReportToPdf((JasperPrint)print);
            if (this.nomeArquivo != null && !this.nomeArquivo.isEmpty()) {
                IRPFUtil.setNomeArquivo((String)this.nomeArquivo);
            }
            IRPFUtil.exibirArquivoNavegador((byte[])bytes, (String)this.nomeArquivo);
        }
        catch (Exception e) {
            LogPPGD.erro((String)e.getMessage());
        }
    }

    public void addParametro(String nome, String valor) {
        this.parametros.put(nome, valor);
    }

    public void addParametro(String nome, Object valor) {
        this.parametros.put(nome, valor);
    }

    public Map<String, Object> getAllParametro() {
        return this.parametros;
    }

    public void imprimir() {
        try {
            JasperPrint print;
            if (this.getXml() != null && !this.getXml().equals("")) {
                if (this.isImpressaoMidas()) {
                    BufferedInputStream in = new BufferedInputStream(new FileInputStream(this.getXml()));
                    MidasReportElementBuilder midasBuilder = new MidasReportElementBuilder((InputStream)in);
                    br.gov.serpro.midas.jasperreports.JRXmlDataSource xmlDataSource = new br.gov.serpro.midas.jasperreports.JRXmlDataSource(midasBuilder.build(), this.getRaiz());
                    InputStream streamRel = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.getRelatorioJasper());
                    print = JasperFillManager.fillReport((InputStream)streamRel, this.parametros, (JRDataSource)xmlDataSource);
                } else {
                    JRXmlDataSource xmlDataSource = new JRXmlDataSource(this.getXml(), this.getRaiz());
                    InputStream streamRel = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.getRelatorioJasper());
                    print = JasperFillManager.fillReport((InputStream)streamRel, this.parametros, (JRDataSource)xmlDataSource);
                }
            } else {
                JREmptyDataSource xmlDataSource = new JREmptyDataSource();
                InputStream streamRel = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.getRelatorioJasper());
                print = JasperFillManager.fillReport((InputStream)streamRel, this.parametros, (JRDataSource)xmlDataSource);
            }
            RelatorioUtil.removerPaginasEmBranco(print);
            print.setName("DIRPF" + AplicacaoPropertiesUtil.getExercicio());
            JasperPrintManager.printReport((JasperPrint)print, (boolean)false);
        }
        catch (Exception e) {
            if (e.getCause() instanceof PrinterException) {
                GuiUtil.mostrarErro((Component)PlataformaPPGD.getPlataforma().getJanelaPrincipal(), (String)"Ocorreu um erro ao tentar imprimir. Por favor, verifique se:\n\t1. a impressora est\u00e1 ligada e conectada ao computador;\n\t2. a impressora est\u00e1 acess\u00edvel via rede (caso n\u00e3o seja local);\n\t3. a impressora possui papel;\n\t4. a impressora possui tinta.");
            }
            LogPPGD.erro((String)e.getMessage());
        }
    }

    public JasperPrint obterPaginas() {
        try {
            JasperPrint print;
            if (this.getXml() != null && !this.getXml().equals("")) {
                if (this.isImpressaoMidas()) {
                    BufferedInputStream in = new BufferedInputStream(new FileInputStream(this.getXml()));
                    MidasReportElementBuilder midasBuilder = new MidasReportElementBuilder((InputStream)in);
                    br.gov.serpro.midas.jasperreports.JRXmlDataSource xmlDataSource = new br.gov.serpro.midas.jasperreports.JRXmlDataSource(midasBuilder.build(), this.getRaiz());
                    InputStream streamRel = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.getRelatorioJasper());
                    print = JasperFillManager.fillReport((InputStream)streamRel, this.parametros, (JRDataSource)xmlDataSource);
                } else {
                    JRXmlDataSource xmlDataSource = new JRXmlDataSource(this.getXml(), this.getRaiz());
                    InputStream streamRel = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.getRelatorioJasper());
                    print = JasperFillManager.fillReport((InputStream)streamRel, this.parametros, (JRDataSource)xmlDataSource);
                }
            } else {
                JREmptyDataSource xmlDataSource = new JREmptyDataSource();
                InputStream streamRel = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.getRelatorioJasper());
                print = JasperFillManager.fillReport((InputStream)streamRel, this.parametros, (JRDataSource)xmlDataSource);
            }
            return print;
        }
        catch (Exception e) {
            LogPPGD.erro((String)e.getMessage());
            return null;
        }
    }

    public void setHabilitado(boolean habilitado) {
        this.habilitado = habilitado;
    }

    public boolean isHabilitado() {
        return this.habilitado;
    }

    public void setXml(String xml) {
        this.xml = xml;
    }

    public String getXml() {
        return this.xml;
    }

    private void setRaiz(String raiz) {
        this.raiz = raiz;
    }

    private String getRaiz() {
        return this.raiz;
    }

    private void setRelatorioJasper(String relatorioJasper) {
        this.relatorioJasper = relatorioJasper;
    }

    private String getRelatorioJasper() {
        return this.relatorioJasper;
    }

    public void setTitulo(String titulo) {
        this.titulo = titulo;
    }

    public String getTitulo() {
        return this.titulo;
    }

    public void prepara() {
    }

    public boolean isPreparado() {
        return false;
    }

    public int getTipoOperacao() {
        return this.tipoOperacao;
    }

    public void setTipoOperacao(int tipoOperacao) {
        this.tipoOperacao = tipoOperacao;
    }

    public void setNomeArquivo(String nomeArquivo) {
        this.nomeArquivo = nomeArquivo;
    }

    public boolean isImpressaoMidas() {
        return this.impressaoMidas;
    }

    public void setImpressaoMidas(boolean impressaoMidas) {
        this.impressaoMidas = impressaoMidas;
    }
}

