/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.impressao;

import java.awt.Frame;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperPrintManager;
import net.sf.jasperreports.engine.fill.JRTemplatePrintText;
import net.sf.jasperreports.engine.util.JRDataUtils;
import serpro.ppgd.formatosexternos.PPGDJasperViewer;
import serpro.ppgd.formatosexternos.RelatorioIf;
import serpro.ppgd.formatosexternos.RelatorioXML;
import serpro.ppgd.irpf.util.IRPFUtil;
import serpro.ppgd.negocio.util.LogPPGD;

public class RelatorioDeclaracao
implements RelatorioIf {
    private List<RelatorioXML> rels = new ArrayList<RelatorioXML>();
    private List<DuplaParam> parametros = new ArrayList<DuplaParam>();
    private String titulo;
    private String nomeArquivo;
    private JasperPrint jasperPrint;
    private boolean preparado = false;
    private String PARAM_PAG_INICIAL = "pagInicial";
    private int tipoOperacao = 1;

    public RelatorioDeclaracao(String aTitulo, String aRelatorioJasper, String aXml, String aRaiz, int tipoOperacao, String nomeArquivo) {
        this.titulo = aTitulo;
        this.rels.add(new RelatorioXML(aTitulo, aRelatorioJasper, aXml, aRaiz));
        this.setTipoOperacao(tipoOperacao);
        this.setNomeArquivo(nomeArquivo);
    }

    public RelatorioDeclaracao(String aTitulo, String aRelatorioJasper, int tipoOperacao) {
        this.titulo = aTitulo;
        this.rels.add(new RelatorioXML(aTitulo, aRelatorioJasper));
        this.setTipoOperacao(tipoOperacao);
    }

    public void addRelatorioXML(String aTitulo, String aRelatorioJasper, String aXml, String aRaiz) {
        RelatorioXML novoRelatorio = new RelatorioXML(aTitulo, aRelatorioJasper, aXml, aRaiz);
        for (int x = 0; x < this.parametros.size(); ++x) {
            String nome = this.parametros.get(x).getNome();
            String valor = this.parametros.get(x).getValor();
            novoRelatorio.addParametro(nome, valor);
        }
        this.rels.add(novoRelatorio);
    }

    public void addRelatorioXML(String aTitulo, String aRelatorioJasper) {
        RelatorioXML novoRelatorio = new RelatorioXML(aTitulo, aRelatorioJasper);
        for (int x = 0; x < this.parametros.size(); ++x) {
            String nome = this.parametros.get(x).getNome();
            String valor = this.parametros.get(x).getValor();
            novoRelatorio.addParametro(nome, valor);
        }
        this.rels.add(novoRelatorio);
    }

    public void imprimir() {
        try {
            this.prepara();
            JasperPrintManager.printReport((JasperPrint)this.jasperPrint, (boolean)false);
        }
        catch (JRException e) {
            LogPPGD.erro((String)e.getMessage());
        }
    }

    public void prepara() {
        if (!this.isPreparado()) {
            int pageCount = 1;
            this.jasperPrint = new JasperPrint();
            this.jasperPrint.setLocaleCode(JRDataUtils.getLocaleCode((Locale)new Locale("pt", "BR")));
            int y = this.rels.size();
            for (int x = 0; x < y; ++x) {
                this.addParametro(this.PARAM_PAG_INICIAL, String.valueOf(pageCount), x);
                JasperPrint printTmp = this.rels.get(x).obterPaginas();
                List lista = printTmp.getPages();
                pageCount += lista.size();
                if (x == 0) {
                    this.jasperPrint = printTmp;
                    continue;
                }
                for (int i = 0; i < lista.size(); ++i) {
                    this.jasperPrint.addPage((JRPrintPage)lista.get(i));
                }
            }
            this.preparado = true;
        }
    }

    public void visualizar() {
        switch (this.getTipoOperacao()) {
            case 1: {
                this.visualizarRelatorio();
                break;
            }
            case 2: {
                this.gerarPDF();
                break;
            }
            case 3: {
                this.imprimir();
            }
        }
    }

    public void visualizarRelatorio() {
        try {
            this.prepara();
            this.jasperPrint.setName(this.nomeArquivo);
            PPGDJasperViewer viewer = new PPGDJasperViewer(this.jasperPrint, false, new Locale("pt", "BR"));
            viewer.setTitle(this.getTitulo());
            viewer.setLocale(new Locale("pt", "BR"));
            viewer.setIconImage(Frame.getFrames()[0].getIconImage());
            viewer.setVisible(true);
        }
        catch (Exception e) {
            LogPPGD.erro((String)e.getMessage());
        }
    }

    public void gerarPDF() {
        try {
            this.prepara();
            byte[] bytes = JasperExportManager.exportReportToPdf((JasperPrint)this.jasperPrint);
            IRPFUtil.exibirArquivoNavegador((byte[])bytes, (String)this.nomeArquivo);
        }
        catch (Exception e) {
            LogPPGD.erro((String)e.getMessage());
        }
    }

    public void addParametro(String nome, String valor) {
        for (int x = 0; x < this.rels.size(); ++x) {
            this.rels.get(x).addParametro(nome, valor);
        }
        this.parametros.add(new DuplaParam(nome, valor));
    }

    public void addParametro(String nome, String valor, int indice) {
        this.rels.get(indice).addParametro(nome, valor);
    }

    public void addParametroUltimo(String nome, String valor) {
        this.rels.get(this.rels.size() - 1).addParametro(nome, valor);
    }

    public List<DuplaParam> getAllParametro() {
        return this.parametros;
    }

    public String getTitulo() {
        return this.titulo;
    }

    public void setTitulo(String aTitulo) {
        this.titulo = aTitulo;
    }

    public void setNomeArquivo(String nomeArquivo) {
        this.nomeArquivo = nomeArquivo;
    }

    public boolean isHabilitado() {
        return false;
    }

    public void setHabilitado(boolean aHabilitado) {
    }

    public boolean isPreparado() {
        return this.preparado;
    }

    public int getQtdPaginas() {
        int qtd = -1;
        if (this.isPreparado()) {
            qtd = this.jasperPrint.getPages().size();
        }
        return qtd;
    }

    public int getTipoOperacao() {
        return this.tipoOperacao;
    }

    public void setTipoOperacao(int tipoOperacao) {
        this.tipoOperacao = tipoOperacao;
    }

    public void renumeraPaginas(JasperPrint impressao) {
        List lista = impressao.getPages();
        int qtdPags = lista.size();
        for (int pag = 0; pag < qtdPags; ++pag) {
            JRPrintPage pagina = (JRPrintPage)lista.get(pag);
            List elementos = pagina.getElements();
            JRTemplatePrintText numeroDaPagina = (JRTemplatePrintText)elementos.get(elementos.size() - 1);
            numeroDaPagina.setText("P\u00e1gina: " + (pag + 1));
        }
    }

    private class DuplaParam {
        String nome;
        String valor;

        public DuplaParam(String nome, String valor) {
            this.nome = nome;
            this.valor = valor;
        }

        public String getNome() {
            return this.nome;
        }

        public String getValor() {
            return this.valor;
        }
    }
}

