/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.txt.gravacaorestauracao;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.logging.Logger;
import serpro.ppgd.formatosexternos.txt.excecao.GeracaoTxtException;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.txt.gravacaorestauracao.RepositorioDeclaracaoCentralTxt;
import serpro.ppgd.irpf.util.IRPFUtil;
import serpro.ppgd.negocio.ConstantesGlobais;

public class GravadorTXT {
    private static final Logger logger = Logger.getLogger("srf.irpf.importacaoGravacao.ImportarDeclaracao.ImportadorTxt");
    private static IdentificadorDeclaracao objIdDeclGerar;

    public static void gravarDeclaracao(IdentificadorDeclaracao idDecl, String path) throws GeracaoTxtException, IOException {
        objIdDeclGerar = idDecl;
        RepositorioDeclaracaoCentralTxt repositorio = new RepositorioDeclaracaoCentralTxt("ARQ_IRPF", new File(GravadorTXT.montaNome((byte)0, path, idDecl)));
        repositorio.gravarDeclaracao(idDecl);
    }

    public static void gravarDeclaracaoAberta(String path) throws GeracaoTxtException, IOException {
        objIdDeclGerar = IRPFFacade.getInstancia().getIdDeclaracaoAberto();
        RepositorioDeclaracaoCentralTxt repositorio = new RepositorioDeclaracaoCentralTxt("ARQ_IRPF", new File(GravadorTXT.montaNome((byte)0, path, objIdDeclGerar)));
        repositorio.gravarDeclaracaoAberta();
    }

    public static void copiarDeclaracao(IdentificadorDeclaracao idDecl, String path) throws GeracaoTxtException, IOException {
        objIdDeclGerar = idDecl;
        RepositorioDeclaracaoCentralTxt repositorio = new RepositorioDeclaracaoCentralTxt("ARQ_IRPF", new File(GravadorTXT.montaNome((byte)1, path, idDecl)));
        repositorio.salvarDeclaracao(idDecl);
        IRPFFacade.limpaCacheDeclaracoes();
    }

    public static void copiarDeclaracaoParaImpressaoMidas(IdentificadorDeclaracao idDecl, String path, Charset aCharset) throws GeracaoTxtException, IOException {
        objIdDeclGerar = idDecl;
        RepositorioDeclaracaoCentralTxt repositorio = new RepositorioDeclaracaoCentralTxt("ARQ_IRPF", new File(GravadorTXT.montaNome((byte)1, path, idDecl)), true, aCharset);
        repositorio.salvarDeclaracao(idDecl);
    }

    @Deprecated
    private static File montaNome(byte tipo, String path) {
        return new File(GravadorTXT.montaNome(tipo, path, objIdDeclGerar));
    }

    public static String montaNome(byte tipo, String path, IdentificadorDeclaracao idDec) {
        StringBuffer nomeArqGerado = new StringBuffer(new File(path).getAbsolutePath());
        nomeArqGerado.append(System.getProperty("file.separator"));
        nomeArqGerado.append(GravadorTXT.montaNomeArquivoTXT(tipo, idDec));
        return nomeArqGerado.toString();
    }

    public static String montaNomeArquivoTXT(byte tipo, IdentificadorDeclaracao id) {
        StringBuffer nomeArqGerado = new StringBuffer();
        nomeArqGerado.append(id.getCpf().naoFormatado() + "-IRPF-" + (id.isSaida() ? "S" : (id.isEspolio() ? "E" : "A")) + "-" + ConstantesGlobais.EXERCICIO + "-" + ConstantesGlobais.ANO_BASE + "-");
        nomeArqGerado.append(id.isRetificadora() ? "RETIF." : "ORIGI.");
        nomeArqGerado.append(tipo == 0 ? "DEC" : (tipo == 1 ? "DBK" : "BKP"));
        return nomeArqGerado.toString();
    }

    public static boolean fileExists(IdentificadorDeclaracao idDecl, String path, byte tipo) {
        objIdDeclGerar = idDecl;
        return new File(GravadorTXT.montaNome(tipo, path, idDecl)).exists();
    }

    public static InputStream criarArquivoPersistenciaOnline(DeclaracaoIRPF dec) throws GeracaoTxtException, IOException {
        objIdDeclGerar = dec.getIdentificadorDeclaracao();
        String nomeArq = "IRPF" + ConstantesGlobais.EXERCICIO + "-" + new Date().getTime() + ".TMP";
        File filePathTmp = new File(IRPFUtil.DIR_TMP);
        filePathTmp.mkdirs();
        String strArq = IRPFUtil.DIR_TMP + System.getProperty("file.separator") + nomeArq;
        File arquivo = new File(strArq);
        RepositorioDeclaracaoCentralTxt repositorio = new RepositorioDeclaracaoCentralTxt("ARQ_IRPF", arquivo);
        repositorio.gravarDeclaracaoPersistenciaOnline(dec);
        return new FileInputStream(arquivo);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static File salvarArquivoTemporario(String conteudo) throws GeracaoTxtException {
        try (ByteArrayInputStream is = new ByteArrayInputStream(conteudo.getBytes(Charset.forName("ISO-8859-1")));){
            File file;
            try {
                file = GravadorTXT.salvarArquivoTemporario(is);
            }
            catch (Throwable throwable) {
                ((InputStream)is).close();
                throw throwable;
            }
            ((InputStream)is).close();
            return file;
        }
        catch (IOException e) {
            throw new GeracaoTxtException("Ocorreu um erro durante leitura do conte\u00fado do arquivo tempor\u00e1rio.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File salvarArquivoTemporario(InputStream is) throws GeracaoTxtException {
        String nomeArq = "IRPF" + ConstantesGlobais.EXERCICIO + "-" + new Date().getTime() + ".TMP";
        File filePathTmp = new File(IRPFUtil.DIR_TMP);
        filePathTmp.mkdirs();
        File arquivo = new File(filePathTmp, nomeArq);
        try (FileOutputStream fos = new FileOutputStream(arquivo);){
            try {
                int inByte;
                while ((inByte = is.read()) != -1) {
                    fos.write(inByte);
                }
            }
            finally {
                fos.close();
            }
        }
        catch (IOException e) {
            throw new GeracaoTxtException("Ocorreu um erro durante grava\u00e7\u00e3o do arquivo tempor\u00e1rio (" + arquivo + ").", (Throwable)e);
        }
        return arquivo;
    }
}

