/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.txt.importacao.carneleao;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import serpro.ppgd.formatosexternos.txt.excecao.GeracaoTxtException;
import serpro.ppgd.gui.filechooser.FileChooser;
import serpro.ppgd.gui.filechooser.FileChooserFactory;
import serpro.ppgd.gui.filechooser.FileChooserResponse;
import serpro.ppgd.gui.filechooser.FileFilter;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.rendpf.PainelAbaEscrituracaoDependente;
import serpro.ppgd.irpf.gui.rendpf.PainelDadosEscrituracao;
import serpro.ppgd.irpf.gui.rendpf.PainelDadosEscrituracaoDependente;
import serpro.ppgd.irpf.gui.rendpf.PainelDadosEscrituracaoTitular;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.irpf.gui.util.ProcessoSwing;
import serpro.ppgd.irpf.gui.util.Tarefa;
import serpro.ppgd.irpf.rendpf.ItemRendPFDependente;
import serpro.ppgd.irpf.rendpf.RendPF;
import serpro.ppgd.irpf.txt.importacao.VersaoDecInvalidaException;
import serpro.ppgd.irpf.txt.importacao.carneleao.FiltroCPFCarneLeao;
import serpro.ppgd.irpf.txt.importacao.carneleao.FiltroDemonstrativoCarneLeao;
import serpro.ppgd.irpf.txt.importacao.carneleao.RepositorioTxtDadosCarneLeao;
import serpro.ppgd.irpf.util.IRPFUtil;
import serpro.ppgd.negocio.util.LogPPGD;

public class ProcessoImportacaoCarneLeao {
    private boolean titular;
    private ItemRendPFDependente dependente;
    private boolean recuparCPFTitularDependentes = false;
    private File[] arquivosImportacao = null;
    private int quantidadeSucessos;
    private int quantidadeErros;
    private boolean suprimirMensagens = false;
    private boolean importacaoCombinada = false;
    private boolean exibirContabilizarSucessosErros;
    public ArrayList<String> listaErros = new ArrayList();

    public ProcessoImportacaoCarneLeao() {
        this.recuparCPFTitularDependentes = true;
    }

    public ProcessoImportacaoCarneLeao(ItemRendPFDependente aDependente) {
        this.titular = aDependente == null;
        this.dependente = aDependente;
        this.setExibirContabilizarSucessosErros(false);
    }

    public void setExibirContabilizarSucessosErros(boolean exibir) {
        this.exibirContabilizarSucessosErros = exibir;
    }

    public boolean isExibirContabilizarSucessosErros() {
        return this.exibirContabilizarSucessosErros;
    }

    public void setArquivosImportacao(File[] arquivosImportacao) {
        this.arquivosImportacao = arquivosImportacao;
        this.setExibirContabilizarSucessosErros(true);
    }

    public void importar() {
        boolean importacaoOK;
        block29: {
            importacaoOK = false;
            if (this.recuparCPFTitularDependentes) {
                if (this.arquivosImportacao == null) {
                    FileChooser fc = FileChooserFactory.getInstance().createFileChooser();
                    fc.setDialogTitle("Importa\u00e7\u00e3o de dados do Carn\u00ea-Le\u00e3o");
                    fc.setApproveButtonText("OK");
                    fc.setApproveButtonToolTipText("Importar dados do Carn\u00ea-Le\u00e3o");
                    fc.setAcceptAllFileFilterUsed(false);
                    fc.setFileFilter((FileFilter)new FiltroDemonstrativoCarneLeao());
                    fc.setMultiSelectionEnabled(true);
                    FileChooserResponse retorno = fc.showOpenDialog((Component)PlataformaPPGD.getPlataforma().getJanelaPrincipal());
                    if (retorno == FileChooserResponse.APPROVE_OPTION) {
                        for (File f : fc.getSelectedFiles()) {
                            if (IRPFUtil.validarArquivoCarneLeao((File)f)) continue;
                            GuiUtil.mostrarErro((String)"importacao_carneleao_cpf_invalido");
                            return;
                        }
                        this.arquivosImportacao = fc.getSelectedFiles();
                    }
                }
                if (this.arquivosImportacao != null) {
                    try {
                        RepositorioTxtDadosCarneLeao repositorioTxtDadosCarneLeao = new RepositorioTxtDadosCarneLeao(this.arquivosImportacao);
                        repositorioTxtDadosCarneLeao.setContabilizarSucessosErros(this.isExibirContabilizarSucessosErros());
                        boolean podeImportar = false;
                        if (this.importacaoCombinada) {
                            podeImportar = true;
                        } else {
                            boolean jatemImportacao = repositorioTxtDadosCarneLeao.temCarneLeaoJaImportado(this.arquivosImportacao);
                            if (!jatemImportacao) {
                                podeImportar = true;
                            } else if (GuiUtil.mostrarConfirma((String)"confirmacao_importacao")) {
                                podeImportar = true;
                            }
                        }
                        if (podeImportar) {
                            this.listaErros.addAll(repositorioTxtDadosCarneLeao.importaDados());
                            this.setQuantidadeSucessos(repositorioTxtDadosCarneLeao.getQuantidadeSucessos());
                            this.setQuantidadeErros(repositorioTxtDadosCarneLeao.getQuantidadeErros());
                            if (!this.suprimirMensagens) {
                                GuiUtil.mostrarInfo((String)"importacao_carneleao_sucesso");
                                importacaoOK = true;
                            }
                        }
                    }
                    catch (Exception ex) {
                        if (this.isImportacaoCombinada()) break block29;
                        if (ex instanceof VersaoDecInvalidaException) {
                            GuiUtil.mostrarErro((Component)PlataformaPPGD.getPlataforma().getJanelaPrincipal(), (String)ex.getMessage());
                            break block29;
                        }
                        LogPPGD.erro((String)ex.getMessage());
                        GuiUtil.mostrarErro((Component)PlataformaPPGD.getPlataforma().getJanelaPrincipal(), (String)"Arquivo corrompido. Verifique se o arquivo de exporta\u00e7\u00e3o do Carn\u00ea Le\u00e3o foi gerado na vers\u00e3o mais atual do aplicativo.");
                    }
                }
            } else {
                String cpf;
                RendPF rendPF;
                if (this.titular) {
                    rendPF = IRPFFacade.getInstancia().getRendPFTitular();
                    cpf = IRPFFacade.getInstancia().getIdDeclaracaoAberto().getCpf().naoFormatado();
                } else {
                    rendPF = this.dependente.getRendimentos();
                    cpf = this.dependente.getCpf().naoFormatado();
                }
                if (cpf == null || cpf.length() == 0) {
                    GuiUtil.mostrarAviso((String)"rendpf_importar_dependente_nao_preenchido");
                    return;
                }
                if (!rendPF.isVazio() && !GuiUtil.mostrarConfirma((String)"confirmacao_importacao")) {
                    return;
                }
                FileChooser fc = FileChooserFactory.getInstance().createFileChooser();
                fc.setDialogTitle("Importa\u00e7\u00e3o de dados do Carn\u00ea-Le\u00e3o");
                fc.setApproveButtonText("OK");
                fc.setApproveButtonToolTipText("Importar dados do Carn\u00ea-Le\u00e3o");
                fc.setAcceptAllFileFilterUsed(false);
                fc.setFileFilter((FileFilter)new FiltroCPFCarneLeao(cpf));
                fc.setMultiSelectionEnabled(true);
                FileChooserResponse retorno = fc.showOpenDialog((Component)PlataformaPPGD.getPlataforma().getJanelaPrincipal());
                if (retorno == FileChooserResponse.APPROVE_OPTION) {
                    final RepositorioTxtDadosCarneLeao repositorioTxtDadosCarneLeao = new RepositorioTxtDadosCarneLeao(fc.getSelectedFile().getPath());
                    try {
                        repositorioTxtDadosCarneLeao.validarVersaoCarneLeao(0);
                    }
                    catch (Exception ex) {
                        GuiUtil.mostrarErro((String)ex.getMessage());
                        return;
                    }
                    rendPF.clear();
                    Object retornoImport = ProcessoSwing.executarTarefa((Tarefa)new Tarefa(){

                        public Object definirTarefa() {
                            try {
                                if (ProcessoImportacaoCarneLeao.this.titular) {
                                    repositorioTxtDadosCarneLeao.importaIdentificacao(ControladorGui.getDemonstrativoAberto(), 0);
                                    repositorioTxtDadosCarneLeao.importaDados(rendPF, 0, IRPFFacade.getInstancia().getIdDeclaracaoAberto().getCpf());
                                } else {
                                    repositorioTxtDadosCarneLeao.importaDados(rendPF, 0, ProcessoImportacaoCarneLeao.this.dependente.getCpf());
                                }
                            }
                            catch (GeracaoTxtException e) {
                                LogPPGD.erro((String)e.getMessage());
                                ProcessoImportacaoCarneLeao.this.arquivosImportacao = null;
                                return "Arquivo corrompido.";
                            }
                            catch (IOException e) {
                                LogPPGD.erro((String)e.getMessage());
                                ProcessoImportacaoCarneLeao.this.arquivosImportacao = null;
                                return "Ocorreu um erro de IO:" + e.getMessage();
                            }
                            return null;
                        }
                    });
                    if (retornoImport != null) {
                        GuiUtil.mostrarErro((Component)PlataformaPPGD.getPlataforma().getJanelaPrincipal(), (String)((String)retornoImport));
                        return;
                    }
                    GuiUtil.mostrarInfo((String)"importacao_carneleao_sucesso");
                    importacaoOK = true;
                }
            }
        }
        this.arquivosImportacao = null;
        if (importacaoOK) {
            PainelAbaEscrituracaoDependente painelAbaDependente;
            PainelDadosEscrituracaoDependente painelDependente;
            if (ControladorGui.getPainelAtualmenteExibido() instanceof PainelDadosEscrituracao) {
                PainelDadosEscrituracaoTitular painelTitular;
                PainelDadosEscrituracao painel = (PainelDadosEscrituracao)ControladorGui.getPainelAtualmenteExibido();
                if (painel.getTabbedPane().getSelectedIndex() == 0 && (painelTitular = (PainelDadosEscrituracaoTitular)painel.getAbas()[0]).getTabbedPane().getSelectedIndex() == 1) {
                    painelTitular.getTabbedPane().setSelectedIndex(0);
                    painelTitular.getTabbedPane().setSelectedIndex(1);
                }
            } else if (ControladorGui.getPainelAtualmenteExibido() instanceof PainelAbaEscrituracaoDependente && (painelDependente = (painelAbaDependente = (PainelAbaEscrituracaoDependente)ControladorGui.getPainelAtualmenteExibido()).getPainelDadosEscrituracaoDependente()).getTabbedPane().getSelectedIndex() == 1) {
                painelDependente.getTabbedPane().setSelectedIndex(0);
                painelDependente.getTabbedPane().setSelectedIndex(1);
            }
        }
    }

    public static FileChooser obterFileChooserFiltradoCarneLeao() {
        FileChooser fc = FileChooserFactory.getInstance().createFileChooser();
        fc.setDialogTitle("Importa\u00e7\u00e3o de dados do Carn\u00ea-Le\u00e3o");
        fc.setApproveButtonText("OK");
        fc.setApproveButtonToolTipText("Importar dados do Carn\u00ea-Le\u00e3o");
        fc.setAcceptAllFileFilterUsed(false);
        FiltroDemonstrativoCarneLeao dec = new FiltroDemonstrativoCarneLeao();
        fc.setFileFilter((FileFilter)dec);
        fc.setMultiSelectionEnabled(true);
        return fc;
    }

    public int getQuantidadeSucessos() {
        return this.quantidadeSucessos;
    }

    public void setQuantidadeSucessos(int quantidadeSucessos) {
        this.quantidadeSucessos = quantidadeSucessos;
    }

    public int getQuantidadeErros() {
        return this.quantidadeErros;
    }

    private void setQuantidadeErros(int quantidadeErros) {
        this.quantidadeErros = quantidadeErros;
    }

    public boolean isSuprimirMensagens() {
        return this.suprimirMensagens;
    }

    public void setSuprimirMensagens(boolean suprimirMensagensSucesso) {
        this.suprimirMensagens = suprimirMensagensSucesso;
    }

    public boolean isImportacaoCombinada() {
        return this.importacaoCombinada;
    }

    public void setImportacaoCombinada(boolean importacaoCombinada) {
        this.importacaoCombinada = importacaoCombinada;
    }
}

