/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.atividaderural;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import org.jdesktop.layout.GroupLayout;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.atividaderural.BemAR;
import serpro.ppgd.irpf.atividaderural.BensAR;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.IRPFTableAb;
import serpro.ppgd.irpf.gui.IRPFTableModelAb;
import serpro.ppgd.irpf.gui.PainelDemonstrativoIf;
import serpro.ppgd.irpf.gui.PainelPrincipalAb;
import serpro.ppgd.irpf.gui.TableLista;
import serpro.ppgd.irpf.gui.TableListaModel;
import serpro.ppgd.irpf.gui.TableListaSumario;
import serpro.ppgd.irpf.gui.TableListaSumarioModel;
import serpro.ppgd.irpf.gui.atividaderural.PainelBensARDetalhe;
import serpro.ppgd.irpf.gui.atividaderural.TableModelBensAR;
import serpro.ppgd.irpf.gui.bens.BensToolBarListener;
import serpro.ppgd.irpf.gui.bens.JIRPFToolbarBens;
import serpro.ppgd.irpf.gui.listener.ToolBarListener;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.irpf.gui.util.IRPFTableDecorator;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.Valor;

public class PainelBensARLista
extends PainelPrincipalAb
implements BensToolBarListener {
    private static final long serialVersionUID = 1L;
    public static final String TITULO = "Bens da Atividade Rural";
    protected BensAR colecao;
    private JIRPFToolbarBens irpfToolbarBens;
    private JScrollPane jScrollPane1;
    private TableLista tableLista;

    public PainelBensARLista() {
        this.colecao = null;
        PlataformaPPGD.getPlataforma().setHelpID((JComponent)((Object)this), this.getButtonHelpID());
        this.initComponents();
        this.getTabela().setRowHeight(30);
        this.configurarTamanhoColunas();
        IRPFTableDecorator.decorate((IRPFTableAb)this.getTabela(), (ToolBarListener)this);
        this.getTabela().getSelectionModel().addListSelectionListener((ListSelectionListener)this.irpfToolbarBens);
    }

    public PainelBensARLista(BensAR colecao) {
        this.colecao = colecao;
        PlataformaPPGD.getPlataforma().setHelpID((JComponent)((Object)this), this.getButtonHelpID());
        this.initComponents();
        this.getTabela().setRowHeight(30);
        this.configurarTamanhoColunas();
        IRPFTableDecorator.decorate((IRPFTableAb)this.getTabela(), (ToolBarListener)this);
        this.getTabela().getSelectionModel().addListSelectionListener((ListSelectionListener)this.irpfToolbarBens);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.tableLista = this.instanciarTabela(this.getTableModel(), this.getColunaOrdenacao(), this.getColunasOrdenaveis());
        this.irpfToolbarBens = new JIRPFToolbarBens();
        this.setBackground(new Color(241, 245, 249));
        this.jScrollPane1.setViewportView((Component)this.tableLista);
        this.irpfToolbarBens.addToolBarListener((BensToolBarListener)this);
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 578, Short.MAX_VALUE).add((Component)this.irpfToolbarBens, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -1, 285, Short.MAX_VALUE).add(6, 6, 6).add((Component)this.irpfToolbarBens, -2, -1, -2)));
    }

    public IRPFTableAb getTabela() {
        return this.tableLista;
    }

    protected void configurarTamanhoColunas() {
        TableColumnModel tcm = this.getTabela().getColumnModel();
        tcm.getColumn(0).setPreferredWidth(5);
        tcm.getColumn(1).setPreferredWidth(5);
        tcm.getColumn(2).setPreferredWidth(100);
        tcm.getColumn(3).setPreferredWidth(200);
        tcm.getColumn(4).setPreferredWidth(50);
        tcm.getColumn(5).setPreferredWidth(50);
    }

    protected TableLista instanciarTabela(TableListaModel model, int colunaOrdenacao, Integer[] colunasOrdenaveis) {
        TableListaSumario tableListaSumario2 = new TableListaSumario(model, colunaOrdenacao, colunasOrdenaveis);
        tableListaSumario2.accessibleColumnHeader = new String[]{"Item", "C\u00f3digo", "Pais", "Discrimina\u00e7\u00e3o", this.getTableModel().getColumnName(4).replace("<html><center>", "").replace("R$</center></html>", "").replace("<br>", " "), this.getTableModel().getColumnName(5).replace("<html><center>", "").replace("R$</center></html>", "").replace("<br>", " ")};
        return tableListaSumario2;
    }

    protected String getClassePainelNavegacao() {
        return PainelBensARDetalhe.class.getName();
    }

    protected String getButtonHelpID() {
        return "Demonstrativo da Atividade Rural/Atividade Rural - Fichas/Bens da Atividade Rural";
    }

    protected TableListaModel getTableModel() {
        return new TableModelBensAR((Colecao)IRPFFacade.getInstancia().getAtividadeRural().getBens(), true);
    }

    protected int getColunaOrdenacao() {
        return 1;
    }

    protected Integer[] getColunasOrdenaveis() {
        return new Integer[]{0, 1};
    }

    public void onBtnAbrirClick(ActionEvent e) {
        if (this.getTabela().getSelectedRow() >= 0 && this.getTabela().getSelectedRow() < this.getTabela().getRowCount() - 1) {
            int nLinha = this.getTabela().getSelectedRow();
            int indiceVetor = ((TableRowSorter)this.getTabela().getRowSorter()).convertRowIndexToModel(nLinha);
            IRPFTableModelAb model = (IRPFTableModelAb)this.getTabela().getModel();
            BensAR colecao = (BensAR)model.getObjetoNegocio();
            BemAR bemAR = (BemAR)colecao.itens().get(indiceVetor);
            ControladorGui.acionarPainel((PainelDemonstrativoIf)new PainelBensARDetalhe(bemAR, true));
        } else {
            GuiUtil.mostrarAviso((String)"ErroSelecioneItem");
        }
    }

    public void onBtnExcluirClick(ActionEvent e) {
        IRPFTableAb tabela = this.getTabela();
        if (tabela.getSelectedRowCount() > 0 && tabela.getSelectedRow() < tabela.getRowCount() - 1) {
            int[] linhasTabela = tabela.getSelectedRows();
            String msgConfirmaExclusao = null;
            msgConfirmaExclusao = MensagemUtil.getMensagem((String)"ConfirmaExcluirItens1", (String[])new String[]{"bem(ns)"});
            if (GuiUtil.mostrarConfirma((Component)((Object)this), (String)msgConfirmaExclusao)) {
                ArrayList<BemAR> listaRemocao = new ArrayList<BemAR>(linhasTabela.length);
                BensAR colecao = new BensAR();
                for (int linhaTabela : linhasTabela) {
                    int indiceVetor = ((TableRowSorter)tabela.getRowSorter()).convertRowIndexToModel(linhaTabela);
                    IRPFTableModelAb model = (IRPFTableModelAb)tabela.getModel();
                    colecao = (BensAR)model.getObjetoNegocio();
                    listaRemocao.add((BemAR)colecao.itens().get(indiceVetor));
                }
                colecao.itens().removeAll(listaRemocao);
            }
        } else {
            GuiUtil.mostrarAviso((String)"ErroSelecioneItem");
        }
    }

    public void onBtnNovoClick(ActionEvent e) {
        BemAR bemAR = ControladorGui.getDemonstrativoAberto().getAtividadeRural().getBens().instanciaNovoObjeto();
        IRPFFacade.getInstancia().getAtividadeRural().getBens().itens().add(bemAR);
        ControladorGui.acionarPainel((PainelDemonstrativoIf)new PainelBensARDetalhe(bemAR, false));
    }

    public void onBtnRepetirClick(ActionEvent e) {
        IRPFTableAb tabela = this.getTabela();
        if (tabela.getSelectedRowCount() >= 0 && tabela.getSelectedRow() < tabela.getRowCount() - 1) {
            int[] linhasTabela = tabela.getSelectedRows();
            IRPFTableModelAb model = (IRPFTableModelAb)tabela.getModel();
            for (int linhaTabela : linhasTabela) {
                int indiceVetor = ((TableRowSorter)tabela.getRowSorter()).convertRowIndexToModel(linhaTabela);
                BensAR colecao = (BensAR)model.getObjetoNegocio();
                BemAR bemAR = (BemAR)colecao.itens().get(indiceVetor);
                bemAR.getValorExercicioAtual().setConteudo((Valor)bemAR.getValorExercicioAnterior());
            }
            model.refresh();
        } else {
            GuiUtil.mostrarAviso((String)"ErroSelecioneItem");
        }
    }

    public ImageIcon getImagemTitulo() {
        return GuiUtil.getImage((String)"/icones/png40px/AR_bens.png");
    }

    public void preExibir() {
        ((BensAR)((IRPFTableModelAb)this.getTabela().getModel()).getObjetoNegocio()).excluirRegistrosEmBranco();
        ((IRPFTableModelAb)this.getTabela().getModel()).refresh();
    }

    public JComponent getDefaultFocus() {
        if (!(this.getTabela().getModel().getRowCount() <= 0 || TableListaSumarioModel.class.isAssignableFrom(this.getTabela().getModel().getClass()) && this.getTabela().getModel().getRowCount() <= 1)) {
            return this.getTabela();
        }
        return this.getIrpfToolbar().getBtnNovo();
    }

    public boolean isTelaComMensagem() {
        return false;
    }

    public JIRPFToolbarBens getIrpfToolbar() {
        return this.irpfToolbarBens;
    }

    public BensAR getColecao() {
        return this.colecao;
    }

    public String getHelpID() {
        return this.getButtonHelpID();
    }

    public String getTituloPainel() {
        return TITULO;
    }

    public boolean isTelaComFavoritos() {
        return true;
    }
}

