/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.atividaderural;

import serpro.ppgd.irpf.atividaderural.ImovelAR;
import serpro.ppgd.irpf.atividaderural.brasil.ImovelARBrasil;
import serpro.ppgd.irpf.gui.TableListaModel;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoNegocio;

public class TableModelDadosImovel
extends TableListaModel {
    private static final long serialVersionUID = 1L;
    boolean isBrasil = false;

    public TableModelDadosImovel(Colecao pObj, boolean isBrasil) {
        super((ObjetoNegocio)pObj);
        this.isBrasil = isBrasil;
    }

    public int getColumnCount() {
        return this.isBrasil ? 5 : 4;
    }

    public Informacao getInformacaoAt(int row, int col) {
        Colecao imoveis = (Colecao)this.getObjetoNegocio();
        ImovelAR item = (ImovelAR)imoveis.itens().get(row);
        switch (col) {
            case 0: {
                return super.getInformacaoAt(row, col);
            }
            case 1: {
                return item.getCodigo();
            }
            case 2: {
                return item.getNome();
            }
            case 3: {
                return item.getLocalizacao();
            }
            case 4: {
                return this.isBrasil ? ((ImovelARBrasil)item).getCIB() : null;
            }
        }
        return null;
    }

    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return super.getColumnName(column);
            }
            case 1: {
                return "<html><center>C\u00f3d.</center></html>";
            }
            case 2: {
                return "<html><center>Nome</center></html>";
            }
            case 3: {
                return "<html><center>Localiza\u00e7\u00e3o</center></html>";
            }
            case 4: {
                return this.isBrasil ? "<html><center>CIB (Nirf)</center></html>" : null;
            }
        }
        return "";
    }
}

