/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.atividaderural;

import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.atividaderural.DividaAR;
import serpro.ppgd.irpf.atividaderural.brasil.ColecaoDividasARBrasil;
import serpro.ppgd.irpf.atividaderural.exterior.ColecaoDividasARExterior;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.TableListaSumarioModel;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Informacao;

public class TableModelDividasAR
extends TableListaSumarioModel {
    private static final long serialVersionUID = 1L;

    public TableModelDividasAR(Colecao pObj) {
        super(pObj);
    }

    public int getColumnCount() {
        return 5;
    }

    public Informacao getInformacaoAt(int row, int col) {
        boolean ultimaLinha;
        Colecao dividas = (Colecao)this.getObjetoNegocio();
        DividaAR item = null;
        boolean bl = ultimaLinha = row == this.getRowCount() - 1;
        if (!ultimaLinha) {
            item = (DividaAR)dividas.itens().get(row);
        }
        switch (col) {
            case 0: {
                return ultimaLinha ? this.labelTotal : super.getInformacaoAt(row, col);
            }
            case 1: {
                return ultimaLinha ? null : item.getDiscriminacao();
            }
            case 2: {
                if (dividas instanceof ColecaoDividasARBrasil) {
                    return ultimaLinha ? ((ColecaoDividasARBrasil)dividas).getTotalAnterior() : item.getContraidasAteExercicioAnterior();
                }
                return ultimaLinha ? ((ColecaoDividasARExterior)dividas).getTotalAnterior() : item.getContraidasAteExercicioAnterior();
            }
            case 3: {
                if (dividas instanceof ColecaoDividasARBrasil) {
                    return ultimaLinha ? ((ColecaoDividasARBrasil)dividas).getTotalAtual() : item.getContraidasAteExercicioAtual();
                }
                return ultimaLinha ? ((ColecaoDividasARExterior)dividas).getTotalAtual() : item.getContraidasAteExercicioAtual();
            }
            case 4: {
                if (dividas instanceof ColecaoDividasARBrasil) {
                    return ultimaLinha ? ((ColecaoDividasARBrasil)dividas).getValorPagamentoAnual() : item.getValorPagamentoAnual();
                }
                return ultimaLinha ? ((ColecaoDividasARExterior)dividas).getValorPagamentoAnual() : item.getValorPagamentoAnual();
            }
        }
        return null;
    }

    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return super.getColumnName(column);
            }
            case 1: {
                return "<html><center>Discrimina\u00e7\u00e3o</center></html>";
            }
            case 2: {
                if (IRPFFacade.getInstancia().getIdDeclaracaoAberto().isSaida()) {
                    if (ControladorGui.getDemonstrativoAberto().entrouSaiuNoMesmoAno()) {
                        return "<html><center>Situa\u00e7\u00e3o na data da<br>caracteriza\u00e7\u00e3o da<br>condi\u00e7\u00e3o de<br>residente<br>R$</center></html>";
                    }
                    return "<html><center>Situa\u00e7\u00e3o em<br>31/12/" + ConstantesGlobais.ANO_BASE_ANTERIOR + "<br>R$</center></html>";
                }
                return "<html><center>Situa\u00e7\u00e3o em<br>31/12/" + ConstantesGlobais.ANO_BASE_ANTERIOR + "<br>R$</center></html>";
            }
            case 3: {
                StringBuilder tituloColuna3 = new StringBuilder();
                tituloColuna3.append("<html><center>");
                if (IRPFFacade.getInstancia().getIdDeclaracaoAberto().isEspolio()) {
                    tituloColuna3.append("Situa\u00e7\u00e3o na data<br>da partilha<br>R$</center></html>");
                } else if (IRPFFacade.getInstancia().getIdDeclaracaoAberto().isSaida()) {
                    tituloColuna3.append("Situa\u00e7\u00e3o na data da<br>caracteriza\u00e7\u00e3o da<br>condi\u00e7\u00e3o de<br>n\u00e3o residente<br>R$</center></html>");
                } else {
                    tituloColuna3.append("Situa\u00e7\u00e3o em<br>31/12/" + ConstantesGlobais.ANO_BASE + "<br>R$</center></html>");
                }
                return tituloColuna3.toString();
            }
            case 4: {
                return "<html><center>Valor Pago em<br>" + ConstantesGlobais.ANO_BASE + "<br>R$</center></html>";
            }
        }
        return "";
    }
}

