/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.atividaderural;

import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.atividaderural.ItemMovimentacaoRebanho;
import serpro.ppgd.irpf.atividaderural.MovimentacaoRebanho;
import serpro.ppgd.irpf.gui.IRPFTableModelAb;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoNegocio;

public class TableModelMovimentacaoRebanho
extends IRPFTableModelAb {
    private static final long serialVersionUID = 1L;
    private static final String TIT_COD = "<html><center>C\u00f3d.</center></html>";
    private static final String TIT_ESPECIE = "<html><center>Esp\u00e9cie</center></html>";
    private static final String TIT_ESTOQUE_INICIAL = "<html><center>Estoque <br>inicial</center></html>";
    private static final String TIT_AQUISICOES_ANO = "<html><center>Aquisi\u00e7\u00f5es</center></html>";
    private static final String TIT_NASCIDOS_ANO = "<html><center>Nascimentos</center></html>";
    private static final String TIT_CONSUMO_PERDAS = "<html><center>Consumo e <br>perdas</center></html>";
    private static final String TIT_VENDAS_ANO = "<html><center>Vendas</center></html>";
    private static final String TIT_ESTOQUE_FINAL = "<html><center>Estoque <br>final</center></html>";
    private static final String[] titulos = new String[]{"<html><center>C\u00f3d.</center></html>", "<html><center>Esp\u00e9cie</center></html>", "<html><center>Estoque <br>inicial</center></html>", "<html><center>Aquisi\u00e7\u00f5es</center></html>", "<html><center>Nascimentos</center></html>", "<html><center>Consumo e <br>perdas</center></html>", "<html><center>Vendas</center></html>", "<html><center>Estoque <br>final</center></html>"};
    private MovimentacaoRebanho movimentacao = null;

    public TableModelMovimentacaoRebanho(MovimentacaoRebanho pObj) {
        super((ObjetoNegocio)pObj);
        this.movimentacao = pObj;
    }

    public MovimentacaoRebanho getMovimentacao() {
        return this.movimentacao;
    }

    public void setMovimentacao(MovimentacaoRebanho pMovimentacao) {
        this.movimentacao = pMovimentacao;
    }

    public Informacao getInformacaoAt(int row, int col) {
        ItemMovimentacaoRebanho item = null;
        switch (row) {
            case 0: {
                item = this.movimentacao.getBovinos();
                break;
            }
            case 1: {
                item = this.movimentacao.getSuinos();
                break;
            }
            case 2: {
                item = this.movimentacao.getCaprinos();
                break;
            }
            case 3: {
                item = this.movimentacao.getAsininos();
                break;
            }
            case 4: {
                item = this.movimentacao.getOutros();
            }
        }
        switch (col) {
            case 2: {
                return item.getEstoqueInicial();
            }
            case 3: {
                return item.getAquisicoesAno();
            }
            case 4: {
                return item.getNascidosAno();
            }
            case 5: {
                return item.getConsumo();
            }
            case 6: {
                return item.getVendas();
            }
            case 7: {
                return item.getEstoqueFinal();
            }
        }
        return null;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (columnIndex > 1 && columnIndex < this.getColumnCount() - 1) {
            DeclaracaoIRPF dec = IRPFFacade.getInstancia().getDeclaracao();
            return dec != null && !dec.getIdentificadorDeclaracao().isTransmitida();
        }
        return false;
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex > 1 && columnIndex < this.getColumnCount() - 1) {
            Informacao val = this.getInformacaoAt(rowIndex, columnIndex);
            val.setConteudo((String)aValue);
        }
    }

    public String getColumnName(int column) {
        return titulos[column];
    }

    public int getColumnCount() {
        return titulos.length;
    }

    public int getRowCount() {
        return 5;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        String label = null;
        if (columnIndex == 0) {
            return "" + (rowIndex + 1);
        }
        if (columnIndex == 1) {
            switch (rowIndex) {
                case 0: {
                    label = "Bovinos e bufalinos";
                    break;
                }
                case 1: {
                    label = "Su\u00ednos";
                    break;
                }
                case 2: {
                    label = "Caprinos e ovinos";
                    break;
                }
                case 3: {
                    label = "Asininos, equinos e muares";
                    break;
                }
                case 4: {
                    label = "Outros";
                }
            }
            return label;
        }
        return this.getInformacaoAt(rowIndex, columnIndex);
    }
}

