/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.rendavariavel;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jdesktop.layout.GroupLayout;
import serpro.ppgd.gui.xbeans.autocomplete.JAutoCompleteEditCPF;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.infraestrutura.util.PainelCacher;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.IRPFLabelInfo;
import serpro.ppgd.irpf.gui.PainelDemonstrativoAb;
import serpro.ppgd.irpf.gui.PainelDemonstrativoIf;
import serpro.ppgd.irpf.gui.rendavariavel.PainelDadosRendaVariavel;
import serpro.ppgd.irpf.gui.rendavariavel.PainelDadosRendaVariavelOpComunsDayTrade;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.irpf.rendavariavel.ItemRendaVariavelDependente;
import serpro.ppgd.irpf.tabelas.CadastroTabelasIRPF;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoNegocio;

public class PainelRendaVariavelDependentesDetalhe
extends PainelDemonstrativoAb {
    private static final long serialVersionUID = 1L;
    private static final String HELP_ID = "Demonstrativo de Apura\u00e7\u00e3o de Ganhos - Renda Vari\u00e1vel - Opera\u00e7\u00f5es Comuns e Day-Trade";
    private ItemRendaVariavelDependente itemRendaVariavelDependente;
    private ItemRendaVariavelDependente itemInicial;
    private PainelDadosRendaVariavel painelDadosRendaVariavel;
    private boolean emEdicao;
    private JAutoCompleteEditCPF cmbDependente;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private IRPFLabelInfo lblAvisoDependenteAlimentandoVazio;
    private JLabel lblDependente;
    private JScrollPane pnlPrincipal;

    public PainelRendaVariavelDependentesDetalhe(ItemRendaVariavelDependente itemRendaVariavelDependente, boolean emEdicao) {
        this.itemRendaVariavelDependente = itemRendaVariavelDependente;
        this.emEdicao = emEdicao;
        if (emEdicao) {
            this.itemInicial = itemRendaVariavelDependente.obterCopia();
        }
        PlataformaPPGD.getPlataforma().setHelpID((JComponent)((Object)this), HELP_ID);
        this.initComponents();
        this.painelDadosRendaVariavel = PainelDadosRendaVariavel.getInstancia((PainelDemonstrativoIf)this, itemRendaVariavelDependente);
        this.pnlPrincipal.getViewport().removeAll();
        this.pnlPrincipal.getViewport().add((Component)((Object)this.painelDadosRendaVariavel));
        this.associarInformacao();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.lblDependente = new JLabel();
        this.cmbDependente = new JAutoCompleteEditCPF();
        this.pnlPrincipal = new JScrollPane();
        this.lblAvisoDependenteAlimentandoVazio = new IRPFLabelInfo(MensagemUtil.getMensagem((String)"info_listagem", (String[])new String[]{"Dependentes"}));
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add(0, 100, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add(0, 100, Short.MAX_VALUE));
        this.setBackground(new Color(241, 245, 249));
        this.jPanel2.setBackground(new Color(255, 255, 255));
        this.jPanel2.setBorder(BorderFactory.createLineBorder(new Color(211, 222, 232)));
        this.lblDependente.setText("Dependente:");
        this.lblDependente.setVerticalAlignment(3);
        this.cmbDependente.setDados(CadastroTabelasIRPF.recuperarDependentes());
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.pnlPrincipal, -1, 594, Short.MAX_VALUE).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.cmbDependente, -2, 424, -2).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.lblDependente).addPreferredGap(0).add((Component)this.lblAvisoDependenteAlimentandoVazio, -2, -1, -2))).add(0, 0, Short.MAX_VALUE))).addContainerGap()));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.lblDependente, -2, 29, -2).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((Component)this.lblAvisoDependenteAlimentandoVazio, -2, -1, -2))).addPreferredGap(0).add((Component)this.cmbDependente, -2, -1, -2).addPreferredGap(0).add((Component)this.pnlPrincipal, -1, 307, Short.MAX_VALUE).addContainerGap()));
        this.cmbDependente.getAccessibleContext().setAccessibleName("Dependente");
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jPanel2, -1, -1, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jPanel2, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    private void associarInformacao() {
        this.cmbDependente.setInformacao((Informacao)this.itemRendaVariavelDependente.getCpf());
    }

    public JScrollPane getPnlPrincipal() {
        return this.pnlPrincipal;
    }

    public void executaVoltar() {
        PainelDadosRendaVariavelOpComunsDayTrade painel = (PainelDadosRendaVariavelOpComunsDayTrade)((Object)PainelCacher.getInstancia().obtemUrgentemente(PainelDadosRendaVariavelOpComunsDayTrade.class.getName()));
        if (painel == null) {
            painel = new PainelDadosRendaVariavelOpComunsDayTrade("Dependentes");
        } else {
            painel.acionarAba("Dependentes", true);
        }
        ControladorGui.acionarPainel((PainelDemonstrativoIf)painel);
    }

    public JComponent getDefaultFocus() {
        return this.cmbDependente;
    }

    public void preExibir() {
        if (this.painelDadosRendaVariavel != null) {
            this.painelDadosRendaVariavel.preExibir();
        }
    }

    public ImageIcon getImagemTitulo() {
        return GuiUtil.getImage((String)"/icones/png40px/RV_daytrade.png");
    }

    public String getTituloPainel() {
        boolean ehTransmitida = IRPFFacade.getInstancia().getDeclaracao().getCopiaIdentificador().isTransmitida();
        if (this.emEdicao) {
            if (ehTransmitida) {
                return "Detalhe Renda Vari\u00e1vel - Ganho L\u00edquido ou Perda em Opera\u00e7\u00f5es Comuns/Day-Trade";
            }
            return "Editar Renda Vari\u00e1vel - Ganho L\u00edquido ou Perda em Opera\u00e7\u00f5es Comuns/Day-Trade";
        }
        return "Novo Renda Vari\u00e1vel - Ganho L\u00edquido ou Perda em Opera\u00e7\u00f5es Comuns/Day-Trade";
    }

    public boolean isTelaComVoltar() {
        return true;
    }

    public boolean isTelaComCancelar() {
        return true;
    }

    public void executaCancelar() {
        if (this.emEdicao) {
            ControladorGui.getDemonstrativoAberto().getRendaVariavelDependente().remove((ObjetoNegocio)this.itemRendaVariavelDependente);
            ControladorGui.getDemonstrativoAberto().getRendaVariavelDependente().add((ObjetoNegocio)this.itemInicial);
        } else {
            ControladorGui.getDemonstrativoAberto().getRendaVariavelDependente().remove((ObjetoNegocio)this.itemRendaVariavelDependente);
        }
        PainelDadosRendaVariavelOpComunsDayTrade painel = (PainelDadosRendaVariavelOpComunsDayTrade)((Object)PainelCacher.getInstancia().obtemUrgentemente(PainelDadosRendaVariavelOpComunsDayTrade.class.getName()));
        if (painel == null) {
            painel = new PainelDadosRendaVariavelOpComunsDayTrade("Dependentes");
        } else {
            painel.acionarAba("Dependentes", true);
        }
        ControladorGui.acionarPainel((PainelDemonstrativoIf)painel);
    }

    public String getHelpID() {
        return HELP_ID;
    }

    public void setItem(ItemRendaVariavelDependente item) {
        this.itemRendaVariavelDependente = item;
        this.painelDadosRendaVariavel.setItem(item);
        this.cmbDependente.setDados(CadastroTabelasIRPF.recuperarDependentes());
        this.associarInformacao();
    }

    public boolean isTelaComFavoritos() {
        return false;
    }
}

