/*
 * Promise SuperTrak device driver for Linux, version 1.34
 * Copyright (c) 2001  Promise Technology, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 *
 * Copyright (c) 1999-2001 Promise Technology, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: pti_st.c,v 1.1 2001/06/27 15:37:18 Jack Hu Email: jackhu@sohu.com$
 */

/*
 * 2004-01-13:	Removed legacy code for Linux 2.0 and Linux 2.2,
 * 		Daniel Baumann (daniel.baumann@panthera-systems.net)
 */


/**************************************************************************
 * File: pti_stdev.h       Device Declaraitons for pti_st.c. 
 **************************************************************************/
#include <linux/ioctl.h>

#if !defined(PTI_STDEV_H)
#define	PTI_STDEV_H

#if !defined(__KERNEL__)
#if 0
#include "i2omsg.h"
#else /* 0 */
#include "i2odef.h"
#endif /* 0 */
#endif /* __KERNEL__ */

#if !defined(ULOG)
#define	ULONG	unsigned long
#endif

#if !defined(USHORT)
#define	USHORT	unsigned short
#endif

#if !defined(UCHAR)
#define UCHAR	unsigned char
#endif

/*
 * I2O IOP Descriptor
 */

typedef struct  _I2O_IOP_DESCRIPTOR {
    ULONG        IOPNumber;
    ULONG        IOPCapabilities;
    ULONG        IOPState;
    ULONG        I2OVersion;
    ULONG        MessengerType;
    ULONG        MaxMessageFrameSize;
    ULONG        ExpectedLCTSize;
    ULONG        MaxInboundMFrames;
    ULONG        InitialInboundMFrames;
    ULONG        Reserved;
} I2O_IOP_DESCRIPTOR, *PI2O_IOP_DESCRIPTOR;

/*
 * I2O IOP and LCT Configuration data
 */

typedef struct _I2O_DEVICE_DESCRIPTOR {
    ULONG                   ChangeIndicator;
    I2O_LCT_ENTRY           LCT;
    I2O_IOP_DESCRIPTOR      IOP;
} I2O_DEVICE_DESCRIPTOR, *PI2O_DEVICE_DESCRIPTOR;

/*
 *      I2O Query Configuration Record structure
 */

#define I2O_CLASS_MATCH_ANY_BITS  (((1<<I2O_CLASS_ID_SZ)-1) & I2O_CLASS_MATCH_ANYCLASS)

typedef struct _I2O_CONFIG_QUERY {
    ULONG          IOPNumber;
    I2O_CLASS_ID   ClassID;
    ULONG          SubClassID;
    ULONG          Index;
} I2O_CONFIG_QUERY, *PI2O_CONFIG_QUERY;

typedef struct _I2O_IOCTL_GET_CONFIG {
	I2O_CONFIG_QUERY	config_query;
	I2O_DEVICE_DESCRIPTOR	device_descriptor;
} I2O_IOCTL_GET_CONFIG, *PI2O_IOCTL_GET_CONFIG;

/*
 * Useful define in get/set operations
 */

typedef struct _I2O_PARAM_SCALAR_OPERATION {
    I2O_PARAM_OPERATIONS_LIST_HEADER      OpList;
    I2O_PARAM_OPERATION_SPECIFIC_TEMPLATE OpBlock;
} I2O_PARAM_SCALAR_OPERATION, *PI2O_PARAM_SCALAR_OPERATION;

/*
 * Defines for the interface to the I2OExec driver.
 */

#if 0
#define I2O_GET_CONFIG_INFO        0xBA0
#define I2O_PRIVATE_MESSAGE_CODE   0xBB0
#define I2O_EXEC_REQUEST           0xBC0
#define I2O_PARAMS_GET_REQUEST     0xBD0
#define I2O_PARAMS_SET_REQUEST     0xBE0
#define I2O_GET_LCT                0xBF0
#define I2O_GET_IOPCOUNT           0xC00
#define I2O_GET_CONFIGDIALOG       0xC10
#else
#define I2O_GET_CONFIG_INFO        0xBA
#define I2O_PRIVATE_MESSAGE_CODE   0xBB
#define I2O_EXEC_REQUEST           0xBC
#define I2O_PARAMS_GET_REQUEST     0xBD
#define I2O_PARAMS_SET_REQUEST     0xBE
#define I2O_GET_LCT                0xBF
#define I2O_GET_IOPCOUNT           0xC0
#define I2O_GET_CONFIGDIALOG       0xC1
#define	I2O_FLUSH_CACHE_REQ        0xFE
#endif

/**************************************************
 *        THe following are for IOCTL             *
 **************************************************/

#define SUPERTRAK_GETVERSION       0x01

/*
 *
 */
#define SUPERTRAK_SIGNATURE             "SUPRTRAK"
#define SUPERTRAK_SIG_LEN               0x8

/*
 * The following are for IOCTL data buffer
 */
typedef struct _SRB_IO_CONTROL {
        ULONG HeaderLength;
        UCHAR Signature[8];
        ULONG TimeOut;
        ULONG ControlCode;
        ULONG ReturnCode;
        ULONG Length; 
} SRB_IO_CONTROL, *PSRB_IO_CONTROL;

/*
 * Parameter structure for Get/Set Parameters call.
 */

typedef struct _I2O_PARAM_BLOCK {
    ULONG           IOP;
    USHORT          TargetTID;
    UCHAR           ParamData[1];
} I2O_PARAM_BLOCK, *PI2O_PARAM_BLOCK;

/*
 * The structure is for IOCTL_GET_CONFIG_INFO
 */
typedef struct _PTI_STDEV_GET_CONFIG_BUFFER {
    SRB_IO_CONTROL buf;
    char payload[sizeof(I2O_CONFIG_QUERY)+sizeof(I2O_DEVICE_DESCRIPTOR)];
} PTI_STDEV_GET_CONFIG_BUFFER;

/*
 * The stucture is for IOCTL_PARAMS_GET_REQUEST and IOCTL_PRIVATE_MESSAGE
 */
typedef struct _PTI_STDEV_INBUFFER {
    SRB_IO_CONTROL srb;
    I2O_PARAM_BLOCK block;
    char payload[4096-1];
} PTI_STDEV_INBUFFER;

#if !defined(MAX_ADAPTORS)
#define MAX_ADAPTORS	 4
#endif

/*
 * The following are the definition of ioctl command
 */
#define	PTI_ST_MAGIC	's'

#define IOCTL_SUPERTRAK_GETVERSION _IOR(PTI_ST_MAGIC, SUPERTRAK_GETVERSION, SRB_IO_CONTROL)

#define IOCTL_GET_CONFIG_INFO	_IOR(PTI_ST_MAGIC, I2O_GET_CONFIG_INFO, PTI_STDEV_GET_CONFIG_BUFFER)

#define IOCTL_PRIVATE_MESSAGE_CODE _IOWR(PTI_ST_MAGIC, I2O_PRIVATE_MESSAGE_CODE, PTI_STDEV_INBUFFER)

#define IOCTL_PARAMS_GET_REQUEST _IOWR(PTI_ST_MAGIC, I2O_PARAMS_GET_REQUEST, PTI_STDEV_INBUFFER)

#define IOCTL_FLUSH_CACHE_REQUEST _IOWR(PTI_ST_MAGIC, I2O_FLUSH_CACHE_REQ, SRB_IO_CONTROL)

#if defined(__KERNEL__)

#define	PTCNTL_DEV_NAME		"pti_st"

int pti_stdev_open(struct inode *, struct file *);
int pti_stdev_release(struct inode *, struct file *);
int pti_stdev_ioctl(struct inode *, struct file *, unsigned int, unsigned long);

struct file_operations pti_st_fops={
	open:		pti_stdev_open, 
	release:	pti_stdev_release, 
	ioctl:		pti_stdev_ioctl,
};

struct block_device_operations pti_stdev_fops = {
	open:		pti_stdev_open, 
	release:	pti_stdev_release, 
	ioctl:		pti_stdev_ioctl,
};

#endif	/* __KERNEL__ */

#endif          /* PTI_STDEV_H */

