/******************************************************************************
 *
 * Name:	sktypes.h
 * Project:	SysKonnect SK-9Dxx Gigabit Ethernet
 * Version:	$Revision: 1.4 $
 * Date:	$Date: 2001/10/05 13:44:28 $
 * Purpose:	Define data types for SysKonnect drivers
 *
 ******************************************************************************/

/******************************************************************************
 *
 *	(C)Copyright 2001 SysKonnect GmbH
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	The information in this file is provided "AS IS" without warranty.
 *
 ******************************************************************************/

 /*****************************************************************************
 *
 * History:
 *
 *	$Log: sktypes.h,v $
 *	Revision 1.4  2001/10/05 13:44:28  rschmidt
 *	Added defines SK_CONSTU64 and various SK_STATUS
 *	
 *	Revision 1.3  2001/08/14 14:23:35  rschmidt
 *	New defines: SK_PHYS_ADDR, SK_SPINLOCK
 *	
 *	Revision 1.2  2001/08/08 13:12:54  rschmidt
 *	Added defines for OK, NOT_OK
 *	
 *	Revision 1.1  2001/06/05 08:28:24  rassmann
 *	First public version.
 *	
 *
 *****************************************************************************/

/******************************************************************************
 *
 * Description:
 *
 * In this file, all data types that are needed by the common modules
 * are mapped to Linux data types.
 *
 *
 * Include File Hierarchy:
 *
 *
 ******************************************************************************/

#ifndef __INC_SKTYPES_H
#define __INC_SKTYPES_H

/*
 * Data types with a specific size. 'I' = signed, 'U' = unsigned.
 */
#define SK_I8	s8
#define SK_U8	u8
#define SK_I16	s16
#define SK_U16	u16
#define SK_I32	s32
#define SK_U32	u32
#define SK_I64	s64
#define SK_U64	u64

#define SK_UPTR	ulong		/* casting pointer <-> integral */

#define SK_CONSTU64(x)	(x)

/*
 * Boolean type.
 */
#define SK_BOOL		SK_U8
#define SK_FALSE	0
#define SK_TRUE		(!SK_FALSE)

/* Return values */

#define SK_OK	 	0
#define SK_NOT_OK	-1

#define SK_STATUS	SK_I32

#define SK_STATUS_OK		SK_OK
#define SK_STATUS_FAILED	SK_NOT_OK

#define SK_STATUS_UNKNOWN		-2
#define SK_STATUS_WORKING		-3
#define SK_STATUS_TIMER_ENABLED	-4
#define SK_STATUS_TOO_EARLY		-5
#define SK_STATUS_RUNNING		-6
#define SK_STATUS_EXPIRED		-7

#define SK_PHYS_ADDR	dma_addr_t
#define SK_SPINLOCK		spinlock_t



/******************************************************************************
 *
 * The registers of the AC1000
 *
 * They are in big endian format
 *
 ******************************************************************************/
typedef volatile SK_U8  SK_8BIT_REGISTER;
typedef volatile SK_U16 SK_16BIT_REGISTER;
typedef volatile SK_U32 SK_32BIT_REGISTER;

typedef struct {
#ifdef SK_REGISTER_LITTLE_ENDIAN
	SK_32BIT_REGISTER Low;
	SK_32BIT_REGISTER High;
#else /* SK_REGISTER_LITTLE_ENDIAN */
	SK_32BIT_REGISTER High;
	SK_32BIT_REGISTER Low;
#endif 	/* SK_REGISTER_LITTLE_ENDIAN */
} SK_64BIT_REGISTER;

#endif	/* __INC_SKTYPES_H */
